/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.netlist.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import ro.amiq.dvt.diagrams.DProgressMonitor;
import ro.amiq.dvt.diagrams.design.editor.actions.menu.DMenuActionKind;
import ro.amiq.dvt.diagrams.exceptions.DCanceledException;
import ro.amiq.dvt.diagrams.klay.KLayDiagramDebug;
import ro.amiq.dvt.diagrams.netlist.model.NLAbstractBase;
import ro.amiq.dvt.diagrams.netlist.model.NLBundleGate;
import ro.amiq.dvt.diagrams.netlist.model.NLConnection;
import ro.amiq.dvt.diagrams.netlist.model.NLELInstanceGate;
import ro.amiq.dvt.diagrams.netlist.model.NLFactory;
import ro.amiq.dvt.diagrams.netlist.model.NLFlowSequentialLogicGate;
import ro.amiq.dvt.diagrams.netlist.model.NLGate;
import ro.amiq.dvt.diagrams.netlist.model.NLGateKind;
import ro.amiq.dvt.diagrams.netlist.model.NLInstanceGate;
import ro.amiq.dvt.diagrams.netlist.model.NLInstanceGateExpandState;
import ro.amiq.dvt.diagrams.netlist.model.NLLogicGate;
import ro.amiq.dvt.diagrams.netlist.model.NLLogicStatement;
import ro.amiq.dvt.diagrams.netlist.model.NLParameters;
import ro.amiq.dvt.diagrams.netlist.model.NLPort;
import ro.amiq.dvt.diagrams.netlist.model.NLPortGate;
import ro.amiq.dvt.diagrams.netlist.utils.NLAdvancedFiltersProcessors;
import ro.amiq.dvt.diagrams.netlist.utils.NLBusUtils;
import ro.amiq.dvt.diagrams.netlist.utils.NLConfig;
import ro.amiq.dvt.diagrams.netlist.utils.NLConfiguration;
import ro.amiq.dvt.diagrams.netlist.utils.NLFiltersProcessors;
import ro.amiq.dvt.diagrams.netlist.utils.NLUtils;
import ro.amiq.dvt.elaboration.model.DiagramInstanceWrapper;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.ui.waveviewer.DVTWaveViewIDEFactory;

public class NLProcessors {
    public static final BiConsumer<NLAbstractBase, NLAbstractBase> IDENTITY = (o, c) -> {};
    private static final Comparator<NLPort> PORT_ORDER_COMPARATOR = new Comparator<NLPort>(){

        @Override
        public int compare(NLPort o1, NLPort o2) {
            return o1.getLabel().compareTo(o2.getLabel());
        }
    };

    private NLProcessors() {
    }

    public static final void expandToDepth(NLInstanceGate topInstance, int depth, Set<Object> visited, DProgressMonitor monitor) throws DCanceledException {
        NLUtils.checkCanceled(monitor);
        if (depth < 1 || !NLUtils.isVisible(topInstance)) {
            return;
        }
        topInstance.expand(visited);
        int nextDepth = depth - 1;
        if (nextDepth < 1) {
            return;
        }
        for (NLGate nLGate : topInstance.getSubGates()) {
            NLUtils.checkCanceled(monitor);
            if (!(nLGate instanceof NLInstanceGate)) continue;
            NLProcessors.addGateToVisited(topInstance, visited);
            NLProcessors.expandToDepth((NLInstanceGate)nLGate, nextDepth, visited, monitor);
            NLProcessors.removeGateFromVisited(topInstance, visited);
        }
    }

    public static final void removeGateFromVisited(NLInstanceGate gate, Set<Object> visited) {
        if (gate == null || visited == null) {
            return;
        }
        IRfDesignElement design = gate.getDesign();
        if (design == null) {
            return;
        }
        visited.remove(design);
    }

    public static final void addGateToVisited(NLInstanceGate gate, Set<Object> visited) {
        if (gate == null || visited == null) {
            return;
        }
        IRfDesignElement design = gate.getDesign();
        if (design == null) {
            return;
        }
        visited.add(design);
    }

    public static final void transformToFlowDiagram(NLInstanceGate topInstance, NLConfig config, DProgressMonitor monitor) throws DCanceledException {
        NLUtils.checkCanceled(monitor);
        if (topInstance == null) {
            return;
        }
        boolean reduceLogicGates = config.getFlags().contains((Object)NLConfiguration.FLOW_REDUCE_COMBINATIONAL_LOGIC_GATES);
        topInstance.addFlag(NLParameters.NLParametersFlag.IS_GATE_WITH_FLOW_CONNECTION);
        if (topInstance.hasSignals()) {
            for (NLConnection nLConnection : new ArrayList<NLConnection>(topInstance.getSignals())) {
                NLUtils.checkCanceled(monitor);
                if (!nLConnection.isSignal() || !NLUtils.isVisible(nLConnection)) continue;
                NLUtils.makeInvisible(nLConnection);
                KLayDiagramDebug.debugInfo(KLayDiagramDebug.DebugRegion.FLOW_DIAGRAM_CONSTRUCTION, "\nTransforming signal", nLConnection);
                Set<NLGate> sourceGates = NLProcessors.collectUniqueGates(NLProcessors.filterSignalPorts((Collection<NLPort>)(reduceLogicGates ? NLUtils.getSourcePortsSkippingLogic(nLConnection, false, monitor) : nLConnection.getSourcePorts())));
                Set<NLGate> destinationGates = NLProcessors.collectUniqueGates(NLProcessors.filterSignalPorts((Collection<NLPort>)(reduceLogicGates ? NLUtils.getDestinationPortsSkippingLogic(nLConnection, false, monitor) : nLConnection.getDestinationPorts())));
                boolean sourceIsTop = sourceGates.contains(topInstance);
                boolean destinationIsTop = destinationGates.contains(topInstance);
                sourceGates.remove(topInstance);
                destinationGates.remove(topInstance);
                ArrayList<NLGate> sourceGatesWithSeq = new ArrayList<NLGate>();
                ArrayList<NLGate> destinationGatesWithSeq = new ArrayList<NLGate>();
                for (NLGate gate : sourceGates) {
                    NLUtils.checkCanceled(monitor);
                    if (gate.isSequentialAlwaysBlock()) {
                        sourceGatesWithSeq.add(NLProcessors.createOrGetFlowSeqGate(gate));
                        continue;
                    }
                    sourceGatesWithSeq.add(gate);
                }
                for (NLGate gate : destinationGates) {
                    NLUtils.checkCanceled(monitor);
                    if (gate.isSequentialAlwaysBlock()) {
                        destinationGatesWithSeq.add(NLProcessors.createOrGetFlowSeqGate(gate));
                        continue;
                    }
                    destinationGatesWithSeq.add(gate);
                }
                if (sourceIsTop && config.configFlowShowBoundaryConnections()) {
                    NLProcessors.connectGates(config, Collections.singletonList(topInstance), destinationGatesWithSeq, nLConnection, topInstance);
                }
                if (destinationIsTop && config.configFlowShowBoundaryConnections()) {
                    NLProcessors.connectGates(config, sourceGatesWithSeq, Collections.singletonList(topInstance), nLConnection, topInstance);
                }
                if (sourceGatesWithSeq.isEmpty() || destinationGatesWithSeq.isEmpty()) continue;
                NLProcessors.connectGates(config, sourceGatesWithSeq, destinationGatesWithSeq, nLConnection, null);
            }
        }
        for (NLGate nLGate : topInstance.getSubGates()) {
            NLUtils.checkCanceled(monitor);
            nLGate.addFlag(NLParameters.NLParametersFlag.IS_GATE_WITH_FLOW_CONNECTION);
            if (NLUtils.isExpanded(nLGate) && !NLUtils.isLogicGate(nLGate)) {
                NLProcessors.transformToFlowDiagram((NLInstanceGate)nLGate, config, monitor);
            }
            NLProcessors.hideGateInFlowDiagram(nLGate, config, monitor);
        }
        if (topInstance.getKind() == NLGateKind.BLOCK && !NLProcessors.checkIsVisibleGate(topInstance)) {
            NLUtils.makeInvisible(topInstance);
        }
    }

    private static void bypassBundleGate(NLBundleGate bundleGate, NLConfig config, DProgressMonitor monitor) throws DCanceledException {
        NLUtils.checkCanceled(monitor);
        Set<Object> sourceGates = new LinkedHashSet();
        Set<Object> destinationGates = new LinkedHashSet();
        for (NLPort bundlePort : bundleGate.getPorts()) {
            NLUtils.checkCanceled(monitor);
            if (!bundlePort.hasConnections() || bundlePort.getDirection() != NLPort.NLPortDirection.DIR_IN) continue;
            for (NLConnection sourceConnection : bundlePort.getConnections()) {
                NLUtils.checkCanceled(monitor);
                NLConnection destinationConnection = bundleGate.getEnclosingGate().getSignal(NLBusUtils.getOutputPortOrConnectionName(sourceConnection));
                if (destinationConnection == null) continue;
                sourceGates = NLProcessors.collectUniqueGates(NLProcessors.filterSignalPorts(sourceConnection.getSourcePorts()));
                destinationGates = NLProcessors.collectUniqueGates(NLProcessors.filterSignalPorts(destinationConnection.getDestinationPorts()));
                sourceGates.remove(bundleGate);
                destinationGates.remove(bundleGate);
                if (sourceGates.isEmpty() || destinationGates.isEmpty()) continue;
                NLProcessors.connectGates(config, sourceGates, destinationGates, sourceConnection, null);
            }
        }
        NLUtils.makeInvisible(bundleGate);
    }

    public static final void applyAction(NLInstanceGate gate, NLConfig config, DProgressMonitor monitor, boolean isFlowDiagram) throws DCanceledException {
        NLUtils.checkCanceled(monitor);
        DMenuActionKind actionKind = config.getActionKind();
        if (actionKind == DMenuActionKind.EXPAND) {
            NLProcessors.findAndExpandGates(gate, config, monitor);
        } else if (actionKind == DMenuActionKind.COLLAPSE) {
            NLProcessors.findAndCollapseGates(gate, config, monitor);
        } else if (actionKind == DMenuActionKind.DELETE) {
            NLProcessors.findAndFocusAfterDelete(gate, monitor);
        } else if (actionKind == DMenuActionKind.SHOW_SOURCES || actionKind == DMenuActionKind.SHOW_DESTINATIONS) {
            NLProcessors.showSourcesAndDestinations(gate, config, monitor);
        } else if (actionKind == DMenuActionKind.SHOW_CONNECTIONS || actionKind == DMenuActionKind.SHOW_CONNECTIONS_BETWEEN || actionKind == DMenuActionKind.SHOW_CONNECTIONS_BETWEEN_FLOW_TO_SCHEMATIC) {
            NLProcessors.findAndShowConnections(gate, config, monitor, actionKind, isFlowDiagram);
        }
    }

    private static void findAndExpandGates(NLInstanceGate gate, NLConfig config, DProgressMonitor monitor) throws DCanceledException {
        NLUtils.checkCanceled(monitor);
        if (gate.hasFlag(NLParameters.NLParametersFlag.TO_EXPAND)) {
            gate.addFlag(NLParameters.NLParametersFlag.IS_FOCUSED);
            if (gate.getExpandState() == NLInstanceGateExpandState.PARTIALLY_EXPANDED || gate.getExpandState() == NLInstanceGateExpandState.INVISIBLE) {
                Collection<NLConnection> collection = gate.getSignals();
                for (NLConnection signal : collection) {
                    NLUtils.checkCanceled(monitor);
                    NLUtils.makeVisible(signal);
                }
                Collection<? extends NLGate> subGates = gate.getSubGates();
                for (NLGate nLGate : subGates) {
                    NLUtils.checkCanceled(monitor);
                    NLUtils.makeGateAndPortsVisible(nLGate);
                    for (NLPort port : nLGate.getPorts()) {
                        port.addFlag(NLParameters.NLParametersFlag.OUTER_VISIBLE);
                    }
                }
                for (NLPort nLPort : gate.getPorts()) {
                    NLUtils.makeVisible(nLPort);
                    nLPort.addFlag(NLParameters.NLParametersFlag.INNER_VISIBLE);
                }
            } else if (gate.getExpandState() == NLInstanceGateExpandState.COLLAPSED) {
                for (NLPort nLPort : gate.getPorts()) {
                    NLUtils.checkCanceled(monitor);
                    NLUtils.makeVisible(nLPort);
                }
                NLProcessors.expandToDepth(gate, 1, new HashSet<Object>(), monitor);
            }
            for (NLGate nLGate : gate.getSubGates()) {
                NLUtils.checkCanceled(monitor);
                if (nLGate.getKind() != NLGateKind.BLOCK || ((NLInstanceGate)nLGate).getExpandState() == NLInstanceGateExpandState.EXPANDED) continue;
                NLProcessors.expandToDepth((NLInstanceGate)nLGate, 1, new HashSet<Object>(), monitor);
            }
            gate.removeFlag(NLParameters.NLParametersFlag.TO_EXPAND);
        }
        for (NLGate nLGate : gate.getSubGates()) {
            NLUtils.checkCanceled(monitor);
            if (!(nLGate instanceof NLInstanceGate)) continue;
            NLProcessors.findAndExpandGates((NLInstanceGate)nLGate, config, monitor);
        }
    }

    private static void findAndFocusAfterDelete(NLInstanceGate gate, DProgressMonitor monitor) throws DCanceledException {
        NLUtils.checkCanceled(monitor);
        if (gate.hasFlag(NLParameters.NLParametersFlag.IS_ACTION_SELECTED)) {
            gate.addFlag(NLParameters.NLParametersFlag.IS_FOCUSED);
            gate.removeFlag(NLParameters.NLParametersFlag.IS_ACTION_SELECTED);
        }
        for (NLGate nLGate : gate.getSubGates()) {
            if (!(nLGate instanceof NLInstanceGate)) continue;
            NLProcessors.findAndFocusAfterDelete((NLInstanceGate)nLGate, monitor);
        }
    }

    private static void findAndCollapseGates(NLInstanceGate gate, NLConfig config, DProgressMonitor monitor) throws DCanceledException {
        NLUtils.checkCanceled(monitor);
        for (NLGate nLGate : gate.getSubGates()) {
            NLUtils.checkCanceled(monitor);
            if (nLGate.hasFlag(NLParameters.NLParametersFlag.TO_COLLAPSE) && nLGate instanceof NLInstanceGate) {
                nLGate.addFlag(NLParameters.NLParametersFlag.IS_FOCUSED);
                ((NLInstanceGate)nLGate).setSubGates(null);
                ((NLInstanceGate)nLGate).setSignals(null);
                nLGate.removeFlag(NLParameters.NLParametersFlag.TO_COLLAPSE);
            }
            if (!(nLGate instanceof NLInstanceGate)) continue;
            NLProcessors.findAndCollapseGates((NLInstanceGate)nLGate, config, monitor);
        }
    }

    private static void showSourcesAndDestinations(NLInstanceGate gate, NLConfig config, DProgressMonitor monitor) throws DCanceledException {
        NLUtils.checkCanceled(monitor);
        for (NLPort nLPort : gate.getPorts()) {
            NLUtils.checkCanceled(monitor);
            if (gate.isTopGate()) {
                NLUtils.makeVisible(nLPort);
                nLPort.addFlag(NLParameters.NLParametersFlag.IS_RELEVANT);
            }
            if (!nLPort.hasFlags(NLParameters.NLParametersFlag.SHOW_DESTINATIONS.value() | NLParameters.NLParametersFlag.SHOW_SOURCES.value())) continue;
            NLProcessors.expandDownward(nLPort.getEnclosingGate(), monitor);
            if (nLPort.hasFlag(NLParameters.NLParametersFlag.SHOW_DESTINATIONS)) {
                NLProcessors.showDestinations(nLPort, monitor);
            }
            if (!nLPort.hasFlag(NLParameters.NLParametersFlag.SHOW_SOURCES)) continue;
            NLProcessors.showSources(nLPort, monitor);
        }
        for (NLGate nLGate : gate.getSubGates()) {
            NLUtils.checkCanceled(monitor);
            if (!(nLGate instanceof NLInstanceGate)) continue;
            NLProcessors.showSourcesAndDestinations((NLInstanceGate)nLGate, config, monitor);
        }
    }

    private static void showSources(NLPort port, DProgressMonitor monitor) throws DCanceledException {
        NLUtils.checkCanceled(monitor);
        port.addFlag(NLParameters.NLParametersFlag.IS_FOCUSED);
        Collection<NLConnection> connections = port.getConnections();
        for (NLConnection connection : connections) {
            Collection sourcePorts;
            NLUtils.checkCanceled(monitor);
            if (port.getDirection() == NLPort.NLPortDirection.DIR_OUT && connection.getEnclosingGate() != port.getEnclosingGate() || port.getDirection() != NLPort.NLPortDirection.DIR_OUT && connection.getEnclosingGate() == port.getEnclosingGate() || (sourcePorts = connection.getSourcePorts()).isEmpty()) continue;
            for (NLPort sourcePort : sourcePorts) {
                NLUtils.checkCanceled(monitor);
                NLUtils.makeGateAndGenerateBlocksVisible(sourcePort.getEnclosingGate());
                sourcePort.addFlag(NLParameters.NLParametersFlag.IS_VISIBLE);
                switch (sourcePort.getDirection()) {
                    case DIR_INOUT: {
                        sourcePort.addFlag(NLParameters.NLParametersFlag.OUTER_VISIBLE);
                        sourcePort.addFlag(NLParameters.NLParametersFlag.INNER_VISIBLE);
                        break;
                    }
                    case DIR_OUT: {
                        sourcePort.addFlag(NLParameters.NLParametersFlag.OUTER_VISIBLE);
                        break;
                    }
                    default: {
                        sourcePort.addFlag(NLParameters.NLParametersFlag.INNER_VISIBLE);
                    }
                }
            }
            NLUtils.makeVisible(connection);
            port.addFlag(NLParameters.NLParametersFlag.IS_VISIBLE);
            switch (port.getDirection()) {
                case DIR_INOUT: {
                    port.addFlag(NLParameters.NLParametersFlag.OUTER_VISIBLE);
                    port.addFlag(NLParameters.NLParametersFlag.INNER_VISIBLE);
                    break;
                }
                case DIR_OUT: {
                    port.addFlag(NLParameters.NLParametersFlag.INNER_VISIBLE);
                    break;
                }
                default: {
                    port.addFlag(NLParameters.NLParametersFlag.OUTER_VISIBLE);
                }
            }
        }
        port.removeFlag(NLParameters.NLParametersFlag.SHOW_SOURCES);
    }

    private static void showDestinations(NLPort port, DProgressMonitor monitor) throws DCanceledException {
        NLUtils.checkCanceled(monitor);
        port.addFlag(NLParameters.NLParametersFlag.IS_FOCUSED);
        Collection<NLConnection> connections = port.getConnections();
        for (NLConnection connection : connections) {
            Collection destinationPorts;
            NLUtils.checkCanceled(monitor);
            if (port.getDirection() != NLPort.NLPortDirection.DIR_OUT && connection.getEnclosingGate() != port.getEnclosingGate() || port.getDirection() == NLPort.NLPortDirection.DIR_OUT && connection.getEnclosingGate() == port.getEnclosingGate() || (destinationPorts = connection.getDestinationPorts()).isEmpty()) continue;
            for (NLPort gatePort : destinationPorts) {
                NLUtils.checkCanceled(monitor);
                NLUtils.makeGateAndGenerateBlocksVisible(gatePort.getEnclosingGate());
                gatePort.addFlag(NLParameters.NLParametersFlag.IS_VISIBLE);
                switch (gatePort.getDirection()) {
                    case DIR_INOUT: {
                        gatePort.addFlag(NLParameters.NLParametersFlag.OUTER_VISIBLE);
                        gatePort.addFlag(NLParameters.NLParametersFlag.INNER_VISIBLE);
                        break;
                    }
                    case DIR_OUT: {
                        gatePort.addFlag(NLParameters.NLParametersFlag.INNER_VISIBLE);
                        break;
                    }
                    default: {
                        gatePort.addFlag(NLParameters.NLParametersFlag.OUTER_VISIBLE);
                    }
                }
            }
            NLUtils.makeVisible(connection);
            port.addFlag(NLParameters.NLParametersFlag.IS_VISIBLE);
            switch (port.getDirection()) {
                case DIR_INOUT: {
                    port.addFlag(NLParameters.NLParametersFlag.OUTER_VISIBLE);
                    port.addFlag(NLParameters.NLParametersFlag.INNER_VISIBLE);
                    break;
                }
                case DIR_OUT: {
                    port.addFlag(NLParameters.NLParametersFlag.OUTER_VISIBLE);
                    break;
                }
                default: {
                    port.addFlag(NLParameters.NLParametersFlag.INNER_VISIBLE);
                }
            }
        }
        port.removeFlag(NLParameters.NLParametersFlag.SHOW_DESTINATIONS);
    }

    /*
     * WARNING - void declaration
     */
    private static void expandDownward(NLGate gate, DProgressMonitor monitor) throws DCanceledException {
        void instanceGate;
        void var3_2;
        NLInstanceGate nLInstanceGate;
        NLUtils.checkCanceled(monitor);
        NLGate nLGate = gate;
        if (nLGate instanceof NLInstanceGate && (nLInstanceGate = (NLInstanceGate)nLGate) == (NLInstanceGate)var3_2 && instanceGate.getExpandState() == NLInstanceGateExpandState.COLLAPSED) {
            NLProcessors.expandToDepth((NLInstanceGate)instanceGate, 1, new HashSet<Object>(), monitor);
            NLBusUtils.adjustBusBundleGates((NLInstanceGate)instanceGate, monitor);
            for (NLConnection nLConnection : ((NLInstanceGate)gate).getSignals()) {
                NLUtils.makeInvisible(nLConnection);
            }
            for (NLGate nLGate2 : ((NLInstanceGate)gate).getSubGates()) {
                NLUtils.makeInvisible(nLGate2);
                for (NLPort subGatePort : nLGate2.getPorts()) {
                    NLUtils.makeInvisible(subGatePort);
                }
            }
        }
    }

    private static void findAndShowConnections(NLInstanceGate gate, NLConfig config, DProgressMonitor monitor, DMenuActionKind actionKind, boolean isFlowDiagram) throws DCanceledException {
        NLUtils.checkCanceled(monitor);
        LinkedHashSet<NLInstanceGate> selectedGates = new LinkedHashSet<NLInstanceGate>();
        NLFiltersProcessors.hideEverything(gate, monitor);
        NLProcessors.showConnectionsRecursive(gate, config, selectedGates, monitor, actionKind);
        NLProcessors.showSourcesAndDestinations(gate, config, monitor);
        if (actionKind == DMenuActionKind.SHOW_CONNECTIONS_BETWEEN || actionKind == DMenuActionKind.SHOW_CONNECTIONS_BETWEEN_FLOW_TO_SCHEMATIC) {
            NLAdvancedFiltersProcessors.showConnectiosBetweenGates(selectedGates, config, monitor);
        } else {
            boolean showInternalLogic = config.getFlags().contains((Object)NLConfiguration.DETAILED_ALWAYS_BLOCK_LOGIC);
            for (NLInstanceGate selected : selectedGates) {
                NLUtils.checkCanceled(monitor);
                NLAdvancedFiltersProcessors.showConnectionsOfGate(selected, config, showInternalLogic, monitor, isFlowDiagram);
            }
        }
    }

    private static void showConnectionsRecursive(NLInstanceGate gate, NLConfig config, Set<NLInstanceGate> selectedGates, DProgressMonitor monitor, DMenuActionKind actionKind) throws DCanceledException {
        NLUtils.checkCanceled(monitor);
        if (actionKind == DMenuActionKind.SHOW_CONNECTIONS_BETWEEN_FLOW_TO_SCHEMATIC) {
            NLProcessors.reverseFlowTransformation(gate);
        }
        if (gate.hasFlag(NLParameters.NLParametersFlag.IS_ACTION_SELECTED)) {
            selectedGates.add(gate);
            gate.removeFlag(NLParameters.NLParametersFlag.IS_ACTION_SELECTED);
            gate.addFlag(NLParameters.NLParametersFlag.IS_FOCUSED);
        }
        for (NLGate nLGate : gate.getSubGates()) {
            NLUtils.checkCanceled(monitor);
            if (!(nLGate instanceof NLInstanceGate)) continue;
            NLProcessors.showConnectionsRecursive((NLInstanceGate)nLGate, config, selectedGates, monitor, actionKind);
        }
        for (NLPort nLPort : gate.getPorts()) {
            NLUtils.checkCanceled(monitor);
            if (!nLPort.hasFlag(NLParameters.NLParametersFlag.IS_ACTION_SELECTED)) continue;
            NLUtils.makeGateAndGenerateBlocksVisible(gate);
            nLPort.addFlag(NLParameters.NLParametersFlag.SHOW_SOURCES);
            nLPort.addFlag(NLParameters.NLParametersFlag.SHOW_DESTINATIONS);
            nLPort.removeFlag(NLParameters.NLParametersFlag.IS_ACTION_SELECTED);
            nLPort.addFlag(NLParameters.NLParametersFlag.IS_FOCUSED);
        }
        for (NLConnection nLConnection : gate.getSignals()) {
            NLUtils.checkCanceled(monitor);
            if (!nLConnection.hasFlag(NLParameters.NLParametersFlag.IS_ACTION_SELECTED)) continue;
            NLProcessors.showAroundConnection(nLConnection);
            nLConnection.removeFlag(NLParameters.NLParametersFlag.IS_ACTION_SELECTED);
            nLConnection.addFlag(NLParameters.NLParametersFlag.IS_FOCUSED);
        }
    }

    private static void showAroundConnection(NLConnection connection) {
        NLUtils.makeVisible(connection);
        for (NLPort port : connection.getTargets()) {
            NLGate enclosingGate = port.getEnclosingGate();
            NLUtils.makeGateAndPortsVisible(enclosingGate);
            if (port.getEnclosingGate().equals(connection.getEnclosingGate())) {
                port.addFlag(NLParameters.NLParametersFlag.INNER_VISIBLE);
            } else {
                port.addFlag(NLParameters.NLParametersFlag.OUTER_VISIBLE);
            }
            enclosingGate = enclosingGate.getEnclosingGate();
            while (enclosingGate != null) {
                NLUtils.makeGateAndPortsVisible(enclosingGate);
                enclosingGate = enclosingGate.getEnclosingGate();
            }
        }
    }

    public static final void cleanModel(NLGate gate, NLConfig config, DProgressMonitor monitor) throws DCanceledException {
        NLUtils.checkCanceled(monitor);
        boolean clearIsRelevant = config.getActionKind() == DMenuActionKind.SHOW_CONNECTIONS || config.getActionKind() == DMenuActionKind.SHOW_CONNECTIONS_BETWEEN || config.getActionKind() == DMenuActionKind.SHOW_CONNECTIONS_BETWEEN_FLOW_TO_SCHEMATIC;
        NLProcessors.cleanElement(gate, clearIsRelevant);
        for (NLPort nLPort : gate.getPorts()) {
            NLUtils.checkCanceled(monitor);
            NLProcessors.cleanElement(nLPort, clearIsRelevant);
        }
        if (!(gate instanceof NLInstanceGate)) {
            return;
        }
        for (NLConnection nLConnection : ((NLInstanceGate)gate).getSignals()) {
            NLUtils.checkCanceled(monitor);
            NLProcessors.cleanElement(nLConnection, clearIsRelevant);
        }
        for (NLGate nLGate : ((NLInstanceGate)gate).getSubGates()) {
            NLUtils.checkCanceled(monitor);
            NLProcessors.cleanModel(nLGate, config, monitor);
        }
    }

    private static void cleanElement(NLAbstractBase element, boolean clearIsRelevant) {
        if (element.hasFlag(NLParameters.NLParametersFlag.IS_FILTERED)) {
            element.addFlag(NLParameters.NLParametersFlag.IS_VISIBLE);
            element.removeFlag(NLParameters.NLParametersFlag.IS_FILTERED);
        }
        element.removeFlag(NLParameters.NLParametersFlag.IS_FOCUSED);
        if (element instanceof NLPort) {
            ((NLPort)element).setCachedKPort(null);
        }
        if (element instanceof NLConnection) {
            ((NLConnection)element).setCachedKEdges(null);
            if (((NLConnection)element).isEdge()) {
                ((NLConnection)element).setGoToInfo(null);
            }
        }
        if (clearIsRelevant) {
            element.removeFlag(NLParameters.NLParametersFlag.IS_RELEVANT);
            if (!element.hasFlag(NLParameters.NLParametersFlag.IS_DELETED)) {
                element.addFlag(NLParameters.NLParametersFlag.IS_VISIBLE);
            }
        }
    }

    public static final void showInternalLogicGates(NLGate gate, NLConfig config, DProgressMonitor monitor) throws DCanceledException {
        NLUtils.checkCanceled(monitor);
        if (!config.getFlags().contains((Object)NLConfiguration.DETAILED_ALWAYS_BLOCK_LOGIC)) {
            return;
        }
        if (NLUtils.isLogicGate(gate.getEnclosingGate())) {
            for (NLPort nLPort : gate.getPorts()) {
                NLUtils.checkCanceled(monitor);
                nLPort.addFlag(NLParameters.NLParametersFlag.OUTER_VISIBLE);
            }
        } else if (NLUtils.isLogicGate(gate)) {
            for (NLPort nLPort : gate.getPorts()) {
                NLUtils.checkCanceled(monitor);
                if (!NLUtils.isVisible(nLPort)) continue;
                nLPort.addFlag(NLParameters.NLParametersFlag.INNER_VISIBLE);
            }
            for (NLConnection nLConnection : ((NLInstanceGate)gate).getSignals()) {
                NLUtils.checkCanceled(monitor);
                NLUtils.makeVisible(nLConnection);
            }
            for (NLGate nLGate : ((NLInstanceGate)gate).getSubGates()) {
                NLUtils.makeGateAndPortsVisible(nLGate);
            }
        }
        for (NLGate nLGate : ((NLInstanceGate)gate).getSubGates()) {
            NLUtils.checkCanceled(monitor);
            NLProcessors.showInternalLogicGates(nLGate, config, monitor);
        }
    }

    public static final void makeAllVisibleRelevant(NLGate gate, NLConfig config, DProgressMonitor monitor) throws DCanceledException {
        NLUtils.checkCanceled(monitor);
        if (NLUtils.isVisible(gate)) {
            gate.addFlag(NLParameters.NLParametersFlag.IS_RELEVANT);
        }
        for (NLPort nLPort : gate.getPorts()) {
            NLUtils.checkCanceled(monitor);
            if (!NLUtils.isVisible(nLPort)) continue;
            nLPort.addFlag(NLParameters.NLParametersFlag.IS_RELEVANT);
        }
        if (!(gate instanceof NLInstanceGate)) {
            return;
        }
        for (NLConnection nLConnection : ((NLInstanceGate)gate).getSignals()) {
            NLUtils.checkCanceled(monitor);
            if (!NLUtils.isVisible(nLConnection)) continue;
            nLConnection.addFlag(NLParameters.NLParametersFlag.IS_RELEVANT);
        }
        for (NLGate nLGate : ((NLInstanceGate)gate).getSubGates()) {
            NLUtils.checkCanceled(monitor);
            NLProcessors.makeAllVisibleRelevant(nLGate, config, monitor);
        }
    }

    public static final void applyFilters(NLInstanceGate gate, NLConfig config, DProgressMonitor monitor) throws DCanceledException {
        NLUtils.checkCanceled(monitor);
        NLFiltersProcessors.applyFilters(gate, config, monitor);
    }

    public static final void cleanActionSelectedElements(NLInstanceGate gate, NLConfig config, DProgressMonitor monitor) throws DCanceledException {
        NLUtils.checkCanceled(monitor);
        gate.removeFlag(NLParameters.NLParametersFlag.IS_FOCUSED);
        for (NLPort nLPort : gate.getPorts()) {
            NLUtils.checkCanceled(monitor);
            nLPort.removeFlag(NLParameters.NLParametersFlag.IS_FOCUSED);
        }
        for (NLConnection nLConnection : gate.getSignals()) {
            NLUtils.checkCanceled(monitor);
            nLConnection.removeFlag(NLParameters.NLParametersFlag.IS_FOCUSED);
        }
        for (NLGate nLGate : gate.getSubGates()) {
            NLUtils.checkCanceled(monitor);
            if (nLGate instanceof NLInstanceGate) {
                NLProcessors.cleanActionSelectedElements((NLInstanceGate)nLGate, config, monitor);
                continue;
            }
            nLGate.removeFlag(NLParameters.NLParametersFlag.IS_FOCUSED);
        }
    }

    protected static boolean canMakeVisible(NLAbstractBase element) {
        return !element.hasFlags(NLParameters.NLParametersFlag.IS_PLAIN_ASSIGN.value() | NLParameters.NLParametersFlag.IS_DELETED.value());
    }

    protected static boolean canMakeInvisible(NLGate gate) {
        return !gate.hasFlags(NLParameters.NLParametersFlag.IS_FOCUSED.value() | NLParameters.NLParametersFlag.IS_ENCLOSING_ACTION_SELECTED.value());
    }

    public static NLInstanceGate copyModel(NLInstanceGate top, BiConsumer<NLAbstractBase, NLAbstractBase> biConsumer) {
        if (top == null) {
            return null;
        }
        LinkedHashMap<NLGate, NLGate> gatesMap = new LinkedHashMap<NLGate, NLGate>();
        LinkedHashMap<NLPort, NLPort> portsMap = new LinkedHashMap<NLPort, NLPort>();
        NLInstanceGate newTop = (NLInstanceGate)NLProcessors.copyGatesAndPorts(top, null, gatesMap, portsMap, biConsumer);
        NLProcessors.copySignals(top, gatesMap, portsMap, biConsumer);
        gatesMap = null;
        portsMap = null;
        return newTop;
    }

    private static NLGate copyGatesAndPorts(NLGate gate, NLInstanceGate enclosingGate, Map<NLGate, NLGate> gatesMap, Map<NLPort, NLPort> portsMap, BiConsumer<NLAbstractBase, NLAbstractBase> biConsumer) {
        NLGate gateCopy = gate.getCopy(enclosingGate);
        gatesMap.put(gate, gateCopy);
        if (enclosingGate != null) {
            enclosingGate.addSubGate(gateCopy);
        }
        for (NLPort nLPort : gate.getPorts()) {
            NLPort portCopy = nLPort.getCopy(gateCopy);
            biConsumer.accept(nLPort, portCopy);
            portsMap.put(nLPort, portCopy);
            gateCopy.addPort(portCopy);
        }
        biConsumer.accept(gate, gateCopy);
        if (gate instanceof NLInstanceGate) {
            for (NLGate nLGate : ((NLInstanceGate)gate).getSubGates()) {
                NLProcessors.copyGatesAndPorts(nLGate, (NLInstanceGate)gateCopy, gatesMap, portsMap, biConsumer);
            }
        }
        return gateCopy;
    }

    private static void copySignals(NLInstanceGate gate, Map<NLGate, NLGate> gatesMap, Map<NLPort, NLPort> portsMap, BiConsumer<NLAbstractBase, NLAbstractBase> biConsumer) {
        for (NLConnection nLConnection : gate.getSignals()) {
            NLInstanceGate gateCopy = (NLInstanceGate)gatesMap.get(gate);
            NLConnection connectionCopy = nLConnection.getCopy(gateCopy);
            gateCopy.addSignal(connectionCopy);
            for (NLPort port : nLConnection.getTargets()) {
                NLPort portCopy = portsMap.get(port);
                if (portCopy == null) continue;
                connectionCopy.addTarget(portCopy);
                portCopy.addConnection(connectionCopy);
            }
            biConsumer.accept(nLConnection, connectionCopy);
        }
        for (NLGate nLGate : gate.getSubGates()) {
            if (!(nLGate instanceof NLInstanceGate)) continue;
            NLProcessors.copySignals((NLInstanceGate)nLGate, gatesMap, portsMap, biConsumer);
        }
    }

    public static void reduceUnconnectedPorts(NLGate gate, NLConfig config, DProgressMonitor monitor) throws DCanceledException {
        NLUtils.checkCanceled(monitor);
        if (!config.reducePorts()) {
            return;
        }
        if (!NLUtils.isVisible(gate)) {
            return;
        }
        boolean showInternalLogic = config.getFlags().contains((Object)NLConfiguration.DETAILED_ALWAYS_BLOCK_LOGIC);
        Collection<NLPort> ports = gate.getPorts();
        for (NLPort nLPort : ports) {
            NLUtils.checkCanceled(monitor);
            Collection<NLConnection> connections = nLPort.getConnections();
            boolean hasVisibleConnections = false;
            for (NLConnection connection : connections) {
                NLUtils.checkCanceled(monitor);
                boolean isRelevant = showInternalLogic || connection.getEnclosingGate().getKind() != NLGateKind.LOGIC;
                ArrayList<NLPort> targets = new ArrayList<NLPort>(connection.getTargets());
                if (isRelevant && NLUtils.isVisible(connection) && targets.size() > 1) {
                    for (NLPort target : targets) {
                        NLUtils.checkCanceled(monitor);
                        if (nLPort.equals(target) || !NLUtils.isVisible(target) || !NLUtils.isVisible(target.getEnclosingGate())) continue;
                        hasVisibleConnections = true;
                        break;
                    }
                }
                if (hasVisibleConnections) break;
            }
            if (hasVisibleConnections) continue;
            NLUtils.makeInvisible(true, nLPort);
        }
        if (gate instanceof NLInstanceGate) {
            for (NLGate nLGate : ((NLInstanceGate)gate).getSubGates()) {
                NLUtils.checkCanceled(monitor);
                NLProcessors.reduceUnconnectedPorts(nLGate, config, monitor);
            }
        }
    }

    public static void reduceUnconnectedGates(NLGate gate, NLConfig config, boolean isFlowDiagram) {
        boolean bl;
        if (!NLUtils.isVisible(gate) || !config.reduceGates()) {
            return;
        }
        if (gate instanceof NLInstanceGate) {
            for (NLGate nLGate : ((NLInstanceGate)gate).getSubGates()) {
                NLProcessors.reduceUnconnectedGates(nLGate, config, isFlowDiagram);
            }
        }
        if (gate.isTopGate() || !NLProcessors.canMakeInvisible(gate)) {
            return;
        }
        boolean bl2 = false;
        for (NLPort port : gate.getPorts()) {
            if (!NLUtils.isVisible(port) || isFlowDiagram ^ port.isEdgePort()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            if (gate instanceof NLInstanceGate) {
                boolean keepVisible = false;
                if (gate instanceof NLInstanceGate) {
                    for (NLGate nLGate : ((NLInstanceGate)gate).getSubGates()) {
                        keepVisible |= NLUtils.isVisible(nLGate);
                    }
                }
                if (!keepVisible) {
                    NLUtils.makeInvisible(true, gate);
                }
            } else {
                NLUtils.makeInvisible(true, gate);
            }
        }
    }

    public static void reducePlainAssigns(NLInstanceGate gate, NLConfig config, DProgressMonitor monitor) throws DCanceledException {
        NLUtils.checkCanceled(monitor);
        if (!config.hidePlainAssigns()) {
            return;
        }
        for (NLGate nLGate : gate.getSubGates()) {
            NLUtils.checkCanceled(monitor);
            if (nLGate.getKind() == NLGateKind.INSTANCE || nLGate.getKind() == NLGateKind.BLOCK) {
                NLProcessors.reducePlainAssigns((NLInstanceGate)nLGate, config, monitor);
            }
            if (!nLGate.hasFlag(NLParameters.NLParametersFlag.IS_PLAIN_ASSIGN)) continue;
            NLUtils.makeInvisible(true, nLGate);
            NLPort inPort = null;
            NLPort outPort = null;
            for (NLPort port : nLGate.getPorts()) {
                NLUtils.checkCanceled(monitor);
                if (port.getDirection() == NLPort.NLPortDirection.DIR_IN) {
                    inPort = port;
                    continue;
                }
                outPort = port;
            }
            if (inPort == null || outPort == null) continue;
            for (NLConnection connection : inPort.getConnections()) {
                NLUtils.checkCanceled(monitor);
                if (nLGate.equals(connection.getEnclosingGate())) continue;
                LinkedHashSet<GoToInfo> markers = new LinkedHashSet<GoToInfo>(nLGate.getGoToSource());
                connection.removeTarget(inPort);
                for (NLConnection connection2 : outPort.getConnections()) {
                    NLUtils.checkCanceled(monitor);
                    if (connection2.getEnclosingGate().equals(nLGate)) continue;
                    connection2.removeTarget(outPort);
                    for (GoToInfo marker : connection.getGoToSource()) {
                        NLUtils.checkCanceled(monitor);
                        if (markers.contains(marker)) continue;
                        markers.add(marker);
                    }
                    for (GoToInfo marker : connection2.getGoToSource()) {
                        NLUtils.checkCanceled(monitor);
                        if (markers.contains(marker)) continue;
                        markers.add(marker);
                    }
                    connection.setGoToInfo(markers);
                    Iterator<NLPort> iterator = connection2.getTargets().iterator();
                    while (iterator.hasNext()) {
                        NLUtils.checkCanceled(monitor);
                        NLPort target = iterator.next();
                        connection.addTarget(target);
                        target.addConnection(connection);
                        target.removeConnection(connection2);
                        iterator.remove();
                    }
                }
            }
        }
    }

    private static void connectGates(NLConfig config, Collection<NLGate> sourceGates, Collection<NLGate> destinationGates, NLConnection signal, NLInstanceGate topGate) {
        LinkedHashSet<NLGate> exDestinationGates = new LinkedHashSet<NLGate>(destinationGates);
        exDestinationGates.removeAll(sourceGates);
        if (!exDestinationGates.isEmpty()) {
            for (NLGate sourceGate : sourceGates) {
                sourceGate.makeFlowEdgeConnection(exDestinationGates, config.getFlags(), signal, false, topGate);
            }
        }
        LinkedHashSet<NLGate> retDestinationGates = new LinkedHashSet<NLGate>(destinationGates);
        retDestinationGates.retainAll(sourceGates);
        if (!retDestinationGates.isEmpty()) {
            NLGate chosenSourceGate = sourceGates.iterator().next();
            retDestinationGates.remove(chosenSourceGate);
            chosenSourceGate.makeFlowEdgeConnection(retDestinationGates, config.getFlags(), signal, true, topGate);
        }
    }

    private static NLGate createOrGetFlowSeqGate(NLGate gate) {
        if (gate == null) {
            return gate;
        }
        NLInstanceGate enclosingGate = gate.getEnclosingGate();
        if (enclosingGate == null) {
            return gate;
        }
        NLGate subGate = enclosingGate.getSubGate(NLUtils.getSeqNLName(enclosingGate));
        if (subGate instanceof NLFlowSequentialLogicGate) {
            ((NLFlowSequentialLogicGate)subGate).addGoToInfo(gate.getGoToSource());
            return subGate;
        }
        NLFlowSequentialLogicGate newSeqGate = (NLFlowSequentialLogicGate)enclosingGate.addSubGate(NLFactory.createGate(NLLogicStatement.FLOW_SEQ, enclosingGate));
        newSeqGate.addGoToInfo(gate.getGoToSource());
        return newSeqGate;
    }

    private static final void hideGateInFlowDiagram(NLGate subGate, NLConfig config, DProgressMonitor monitor) throws DCanceledException {
        if (subGate instanceof NLBundleGate var3_4) {
            NLProcessors.bypassBundleGate((NLBundleGate)bundleGate, config, monitor);
            return;
        }
        Set<NLConfiguration> flags = config.getFlags();
        if (!(subGate instanceof NLFlowSequentialLogicGate) && subGate instanceof NLLogicGate && flags.contains((Object)NLConfiguration.FLOW_REDUCE_COMBINATIONAL_LOGIC_GATES)) {
            NLUtils.makeInvisible(subGate);
        }
        for (NLPort port : subGate.getPorts()) {
            if (!port.hasConnections() || !port.isEdgePort() && !(port.getEnclosingGate() instanceof NLPortGate)) continue;
            return;
        }
        if (subGate.isSequentialAlwaysBlock() || flags.contains((Object)NLConfiguration.FLOW_REDUCE_UNCONNECTED_GATES) && subGate.getKind() != NLGateKind.BLOCK || NLUtils.isImplicitGate(subGate)) {
            NLUtils.makeInvisible(subGate);
            KLayDiagramDebug.debugInfo(KLayDiagramDebug.DebugRegion.FLOW_DIAGRAM_CONSTRUCTION, "Gate made invisible", subGate);
        }
    }

    private static void reverseFlowTransformation(NLInstanceGate gate) {
        gate.removeFlag(NLParameters.NLParametersFlag.IS_GATE_WITH_FLOW_CONNECTION);
        Iterator<NLConnection> signals_iterator = gate.getSignals().iterator();
        while (signals_iterator.hasNext()) {
            NLConnection signal = signals_iterator.next();
            if (signal.getKind() != NLConnection.NLConnectionKind.BUNDLE_EDGE && signal.getKind() != NLConnection.NLConnectionKind.COMMON_EDGE) continue;
            signals_iterator.remove();
        }
        Iterator<NLPort> ports_iterator = gate.getPorts().iterator();
        while (ports_iterator.hasNext()) {
            NLPort signal = ports_iterator.next();
            if (signal.getKind() != NLConnection.NLConnectionKind.BUNDLE_EDGE && signal.getKind() != NLConnection.NLConnectionKind.COMMON_EDGE) continue;
            ports_iterator.remove();
        }
    }

    private static final List<NLPort> filterSignalPorts(Collection<NLPort> signalOrEdgePorts) {
        if (signalOrEdgePorts == null || signalOrEdgePorts.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<NLPort> signals = new ArrayList<NLPort>(signalOrEdgePorts.size());
        for (NLPort signalOrEdge : signalOrEdgePorts) {
            if (!signalOrEdge.isSignalPort() || !NLUtils.isVisible(signalOrEdge)) continue;
            signals.add(signalOrEdge);
        }
        return signals;
    }

    @NotNull
    private static final Set<NLGate> collectUniqueGates(Collection<? extends NLAbstractBase> objects) {
        if (objects == null || objects.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<NLGate> uniqueGates = new LinkedHashSet<NLGate>(objects.size());
        for (NLAbstractBase nLAbstractBase : objects) {
            uniqueGates.add(nLAbstractBase.getEnclosingGate());
        }
        return uniqueGates;
    }

    /*
     * WARNING - void declaration
     */
    public static final void reduceInterfaceBundles(NLInstanceGate gate, NLConfig config, boolean isSchematicDiagram, DProgressMonitor monitor) throws DCanceledException {
        NLUtils.checkCanceled(monitor);
        if (gate == null || !config.getFlags().contains((Object)NLConfiguration.REDUCE_INTERFACES)) {
            return;
        }
        if (gate.getKind() == NLGateKind.BUNDLE) {
            NLInstanceGate nLInstanceGate;
            NLAbstractBase enclosingGatePort;
            boolean displayFullConnections;
            KLayDiagramDebug.debugInfo(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Reducing bundle interface gate", gate);
            NLInstanceGate nLInstanceGate2 = gate.getEnclosingGate();
            if (nLInstanceGate2 == null) {
                return;
            }
            IRfNamedElement interfaceElement = null;
            interfaceElement = gate instanceof NLELInstanceGate ? gate.getMapping(DiagramInstanceWrapper.class).getDescription() : gate.getMapping(IRfNamedElement.class);
            boolean isGateReducible = false;
            boolean displayAllSignals = false;
            boolean bl = displayFullConnections = gate.hasFlag(NLParameters.NLParametersFlag.IS_VISIBLE) && isSchematicDiagram && config.getActionKind() == DMenuActionKind.SHOW_CONNECTIONS;
            if (DesignUtils.isInterfaceInstance(interfaceElement)) {
                isGateReducible = true;
                LinkedHashSet<NLPort> passedPartial = new LinkedHashSet<NLPort>();
                NLAbstractBase fullConnectionSignal = null;
                fullConnectionPort = gate.getSameNamedPort();
                if (fullConnectionPort == null) {
                    KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Could not find full connection port of bundle interface gate", new Object[0]);
                    return;
                }
                if (!NLProcessors.shouldReduceInterface(gate, isSchematicDiagram, fullConnectionPort, monitor)) {
                    return;
                }
                for (NLPort port : gate.getPorts()) {
                    NLUtils.checkCanceled(monitor);
                    boolean isFullConnection = port == fullConnectionPort;
                    boolean isPortConnection = port.hasFlag(NLParameters.NLParametersFlag.IS_PORT_IN_PORT_CONNECTION);
                    boolean isPortReducible = true;
                    for (NLConnection externalConn : port.getExternalConnections()) {
                        NLUtils.checkCanceled(monitor);
                        isPortReducible &= NLFactory.removeSignalToPortConnection(port, externalConn);
                        if (isFullConnection) {
                            fullConnectionSignal = fullConnectionSignal == null ? externalConn : fullConnectionSignal;
                            displayAllSignals = fullConnectionSignal.hasFlag(NLParameters.NLParametersFlag.IS_VISIBLE) && displayFullConnections;
                            continue;
                        }
                        if (isPortConnection) {
                            KLayDiagramDebug.debugInfo(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Bundle interface gate port connection lost", port, gate);
                            continue;
                        }
                        for (NLPort externalConnTarget : new LinkedHashSet<NLPort>(externalConn.getTargets())) {
                            NLUtils.checkCanceled(monitor);
                            isPortReducible &= NLFactory.removeSignalToPortConnection(externalConnTarget, externalConn);
                            passedPartial.add(externalConnTarget);
                        }
                    }
                    if (isPortReducible) {
                        NLUtils.makeInvisible(port);
                    }
                    isGateReducible &= isPortReducible;
                }
                if (fullConnectionSignal != null) {
                    if (displayFullConnections) {
                        fullConnectionSignal.addFlag(NLParameters.NLParametersFlag.IS_VISIBLE);
                        for (NLPort port : new LinkedHashSet<NLPort>(((NLConnection)fullConnectionSignal).getTargets())) {
                            NLUtils.checkCanceled(monitor);
                            if (port.equals(fullConnectionPort)) continue;
                            NLProcessors.makePortInInterfaceConnVisible(port, fullConnectionPort.getEnclosingGate());
                        }
                    }
                    for (NLPort partial : passedPartial) {
                        NLUtils.checkCanceled(monitor);
                        isGateReducible &= NLFactory.createCommonSignalToPortConnection(partial, (NLConnection)fullConnectionSignal);
                        if (!displayAllSignals) continue;
                        NLProcessors.makePortInInterfaceConnVisible(partial, fullConnectionPort.getEnclosingGate());
                    }
                } else {
                    KLayDiagramDebug.debugInfo(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Bundle interface gate doesn't have a full connection", gate);
                }
            } else if (DesignUtils.isInterfacePort(interfaceElement)) {
                NLConnection enclosingGateSignal;
                isGateReducible = true;
                enclosingGatePort = nLInstanceGate2.getPort(interfaceElement);
                if (enclosingGatePort == null) {
                    KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Could not find interface port in enclosing scope", nLInstanceGate2);
                }
                if ((enclosingGateSignal = nLInstanceGate2.getSignal(interfaceElement)) == null) {
                    KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Could not find signal for interface port in enclosing scope", nLInstanceGate2);
                    return;
                }
                fullConnectionPort = gate.getSameNamedPort();
                if (!(enclosingGateSignal.getEnclosingGate() instanceof NLLogicGate) && !NLProcessors.shouldReduceInterface(gate, isSchematicDiagram, fullConnectionPort, monitor)) {
                    return;
                }
                displayFullConnections = displayFullConnections && !(enclosingGateSignal.getEnclosingGate() instanceof NLLogicGate);
                displayAllSignals = displayFullConnections && enclosingGateSignal.hasFlag(NLParameters.NLParametersFlag.IS_VISIBLE);
                for (NLPort bundlePort : gate.getPorts()) {
                    NLUtils.checkCanceled(monitor);
                    boolean isPortReducible = true;
                    for (NLConnection externalConn : bundlePort.getExternalConnections()) {
                        isPortReducible &= NLFactory.removeSignalToPortConnection(bundlePort, externalConn);
                        if (enclosingGateSignal == externalConn) {
                            if (!displayFullConnections) continue;
                            enclosingGateSignal.addFlag(NLParameters.NLParametersFlag.IS_VISIBLE);
                            for (NLPort port : new LinkedHashSet<NLPort>(externalConn.getTargets())) {
                                NLUtils.checkCanceled(monitor);
                                NLProcessors.makePortInInterfaceConnVisible(port, gate.getEnclosingGate());
                            }
                            continue;
                        }
                        for (NLPort externalConnTarget : new LinkedHashSet<NLPort>(externalConn.getTargets())) {
                            NLUtils.checkCanceled(monitor);
                            isPortReducible &= NLFactory.removeSignalToPortConnection(externalConnTarget, externalConn);
                            isPortReducible &= NLFactory.createCommonSignalToPortConnection(externalConnTarget, enclosingGateSignal);
                            if (!displayAllSignals && (!DesignUtils.isCompositeSignal(interfaceElement) || !bundlePort.hasFlag(NLParameters.NLParametersFlag.IS_VISIBLE))) continue;
                            NLUtils.makeGateAndPortsVisible(externalConnTarget.getEnclosingGate());
                            NLProcessors.makePortInInterfaceConnVisible(externalConnTarget, gate.getEnclosingGate());
                        }
                    }
                    if (isPortReducible) {
                        NLUtils.makeInvisible(bundlePort);
                    }
                    isGateReducible &= isPortReducible;
                }
            } else if (DesignUtils.isCompositeSignal(interfaceElement) && (nLInstanceGate = gate) instanceof NLBundleGate && (enclosingGatePort = (NLBundleGate)nLInstanceGate) == (NLBundleGate)nLInstanceGate) {
                void bundleGate;
                NLBusUtils.adjustBundleGate((NLBundleGate)bundleGate, monitor);
            }
            if (isGateReducible) {
                KLayDiagramDebug.debugInfo(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Bundle interface gate reduced", gate);
                NLUtils.makeInvisible(gate);
            } else {
                KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Bundle interface gate could not be reduced", gate);
            }
        }
        for (NLGate nLGate : gate.getSubGates()) {
            NLUtils.checkCanceled(monitor);
            if (!(nLGate instanceof NLInstanceGate)) continue;
            NLProcessors.reduceInterfaceBundles((NLInstanceGate)nLGate, config, isSchematicDiagram, monitor);
        }
    }

    private static void makePortInInterfaceConnVisible(NLPort port, NLGate connectionEnclosingGate) {
        NLGate portEnclosingGate = port.getEnclosingGate();
        if (portEnclosingGate == null) {
            return;
        }
        if (portEnclosingGate.equals(connectionEnclosingGate)) {
            port.addFlag(NLParameters.NLParametersFlag.INNER_VISIBLE);
        } else {
            port.addFlag(NLParameters.NLParametersFlag.OUTER_VISIBLE);
        }
        port.addFlag(NLParameters.NLParametersFlag.IS_VISIBLE);
        portEnclosingGate.addFlag(NLParameters.NLParametersFlag.IS_VISIBLE);
    }

    private static boolean shouldReduceInterface(NLInstanceGate gate, boolean isSchematicDiagram, NLPort fullConnectionPort, DProgressMonitor monitor) throws DCanceledException {
        if (fullConnectionPort == null) {
            return true;
        }
        if (!isSchematicDiagram) {
            return true;
        }
        if (gate.isUnconnectedGate()) {
            return true;
        }
        for (NLConnection externalConn : fullConnectionPort.getExternalConnections()) {
            NLUtils.checkCanceled(monitor);
            if (externalConn.getTargets().size() <= 1) continue;
            return gate.getPorts().size() > 1;
        }
        if (gate.getPorts().size() > 1) {
            fullConnectionPort.removeFlag(NLParameters.NLParametersFlag.IS_VISIBLE);
            return false;
        }
        return true;
    }

    public static final boolean checkIsVisibleGate(NLGate gate) {
        if (gate != null && gate.isTopGate()) {
            return NLUtils.isVisible(gate);
        }
        if (gate != null && gate.getKind() == NLGateKind.BLOCK) {
            for (NLGate nLGate : ((NLInstanceGate)gate).getSubGates()) {
                if (!NLProcessors.checkIsVisibleGate(nLGate)) continue;
                return true;
            }
            return false;
        }
        return NLUtils.isVisible(gate);
    }

    public static final void reduceEmptyGenerateBlocks(NLInstanceGate gate, NLConfig config, DProgressMonitor monitor) throws DCanceledException {
        NLUtils.checkCanceled(monitor);
        if (gate == null || !config.getFlags().contains((Object)NLConfiguration.REDUCE_EMPTY_BLOCKS)) {
            return;
        }
        if (gate.getKind() == NLGateKind.BLOCK && !NLProcessors.checkIsVisibleGate(gate)) {
            NLUtils.makeInvisible(gate);
        }
        for (NLGate nLGate : gate.getSubGates()) {
            NLUtils.checkCanceled(monitor);
            if (!(nLGate instanceof NLInstanceGate)) continue;
            NLProcessors.reduceEmptyGenerateBlocks((NLInstanceGate)nLGate, config, monitor);
        }
    }

    public static final void hideLogicGates(NLInstanceGate gate, NLConfig config, DProgressMonitor monitor) throws DCanceledException {
        NLUtils.checkCanceled(monitor);
        if (gate == null || !config.getFlags().contains((Object)NLConfiguration.SCHEMATIC_HIDE_LOGIC_GATES)) {
            return;
        }
        if (gate.getKind() == NLGateKind.LOGIC || config.getFlags().contains((Object)NLConfiguration.FOR_SPECADOR) && gate instanceof NLBundleGate var3_4 && bundleGate.isBusGate()) {
            if (config.getFlags().contains((Object)NLConfiguration.FOR_SPECADOR)) {
                Collection collection = gate.getSourcePorts();
                collection.addAll(gate.getDestinationPorts());
                for (NLPort port : collection) {
                    if (port.getEnclosingGate().getKind() == NLGateKind.LOGIC) continue;
                    gates = port.getConnections().stream().flatMap(c -> c.getSourceGates().stream()).collect(Collectors.toList());
                    gates.addAll(port.getConnections().stream().flatMap(c -> c.getDestinationGates().stream()).collect(Collectors.toList()));
                    if (gates.stream().filter(g -> g.getKind() != NLGateKind.LOGIC && !g.equals(port.getEnclosingGate())).findAny().isPresent()) continue;
                    NLUtils.makeInvisible(port);
                }
            }
            Collection collection = gate.getSourcePorts();
            for (NLPort port : collection) {
                gates = port.getConnections().stream().flatMap(c -> c.getSourceGates().stream()).collect(Collectors.toList());
                gates.forEach(connectedGate -> {
                    if (NLUtils.isImplicitGate(connectedGate)) {
                        NLUtils.makeInvisible(connectedGate);
                    }
                });
            }
            NLUtils.makeInvisible(gate);
        }
        for (NLGate nLGate : gate.getSubGates()) {
            NLUtils.checkCanceled(monitor);
            NLProcessors.hideLogicGates((NLInstanceGate)nLGate, config, monitor);
        }
    }

    public static final void orderBlockDiagramPorts(NLInstanceGate gate, Set<NLConfiguration> config, DProgressMonitor monitor) throws DCanceledException {
        NLUtils.checkCanceled(monitor);
        if (gate == null || !gate.hasFlag(NLParameters.NLParametersFlag.IS_GATE_AS_BLOCK)) {
            return;
        }
        Collection<NLPort> ports = gate.getPorts();
        if (ports == null || ports.isEmpty()) {
            return;
        }
        List wsp = ports.stream().filter(port -> port.getDirection() != NLPort.NLPortDirection.DIR_OUT).collect(Collectors.toList());
        List esp = ports.stream().filter(port -> port.getDirection() == NLPort.NLPortDirection.DIR_OUT).collect(Collectors.toList());
        if (config.contains((Object)NLConfiguration.ORDER_BLOCK_PORTS_ALPHABETICALLY)) {
            Collections.sort(wsp, PORT_ORDER_COMPARATOR);
            Collections.sort(esp, PORT_ORDER_COMPARATOR);
        }
        Collections.reverse(wsp);
        gate.getPorts().clear();
        for (NLPort port2 : esp) {
            NLUtils.checkCanceled(monitor);
            gate.addPort(port2);
        }
        for (NLPort port2 : wsp) {
            NLUtils.checkCanceled(monitor);
            gate.addPort(port2);
        }
    }

    public static final void makePortInvisibleInDiagram(NLGate startGate, Predicate<NLGate> gatePred, Predicate<NLPort> portPred, DProgressMonitor monitor) throws DCanceledException {
        NLUtils.checkCanceled(monitor);
        if (startGate == null || gatePred == null || portPred == null) {
            return;
        }
        if (!gatePred.test(startGate)) {
            return;
        }
        startGate.getPorts().stream().filter(portPred).forEach(port -> NLUtils.makeInvisible(port));
        if (!NLUtils.isExpanded(startGate)) {
            return;
        }
        for (NLGate nLGate : ((NLInstanceGate)startGate).getSubGates()) {
            NLProcessors.makePortInvisibleInDiagram(nLGate, gatePred, portPred, monitor);
        }
    }

    public static void adjustAlwaysBlockLogic(NLInstanceGate startGate, NLConfig config, DProgressMonitor monitor) throws DCanceledException {
        NLProcessors.adjustAlwaysBlockLogic(startGate, config.getFlags().contains((Object)NLConfiguration.DETAILED_ALWAYS_BLOCK_LOGIC), monitor);
    }

    private static void adjustAlwaysBlockLogic(NLInstanceGate startGate, boolean detailedAlwaysBlockLogic, DProgressMonitor monitor) throws DCanceledException {
        NLUtils.checkCanceled(monitor);
        if (startGate == null) {
            return;
        }
        for (NLGate nLGate : startGate.getSubGates()) {
            NLUtils.checkCanceled(monitor);
            if (!NLUtils.isExpanded(nLGate)) continue;
            if (NLUtils.isLogicGate(nLGate) && nLGate.hasFlag(NLParameters.NLParametersFlag.IS_DETAILED_LOGIC_GATE) && !nLGate.getPorts().isEmpty()) {
                NLLogicGate logicGate = (NLLogicGate)nLGate;
                NLInstanceGate logicGateEnclosingGate = logicGate.getEnclosingGate();
                if (detailedAlwaysBlockLogic) {
                    ArrayList<NLPort> logicPortsCopy = new ArrayList<NLPort>(logicGate.getPorts());
                    for (NLPort port : logicPortsCopy) {
                        NLPort selfLoopPort;
                        NLGate selfLoopPortEnclosingate;
                        String otherLoopPortName;
                        NLUtils.checkCanceled(monitor);
                        if (!NLUtils.isSelfLoopPortName(port.getName()) || (otherLoopPortName = NLUtils.getPortNameFromSelfLoopPortName(port.getName())) == null || (selfLoopPortEnclosingate = (selfLoopPort = port).getEnclosingGate()) == null) continue;
                        NLPort otherLoopPort = logicGate.getPort(otherLoopPortName);
                        NLConnection exteriorSelfLoopConnection = null;
                        NLConnection interiorSelfLoopConnection = null;
                        Collection<NLConnection> connections = selfLoopPort.getConnections();
                        for (NLConnection connection : connections) {
                            Collection<NLPort> targets;
                            if (logicGateEnclosingGate.equals(connection.getEnclosingGate()) && (targets = connection.getTargets()).size() == 2) {
                                if (exteriorSelfLoopConnection == null) {
                                    exteriorSelfLoopConnection = connection;
                                } else {
                                    KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Multiple exterior self-loop connections found for port ", selfLoopPort);
                                }
                            }
                            if (!selfLoopPortEnclosingate.equals(connection.getEnclosingGate())) continue;
                            if (interiorSelfLoopConnection == null) {
                                interiorSelfLoopConnection = connection;
                                continue;
                            }
                            KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Multiple interior self-loop connections found for port ", selfLoopPort);
                        }
                        if (otherLoopPort == null || exteriorSelfLoopConnection == null) continue;
                        if (!NLFactory.removeSignalToPortConnection(selfLoopPort, exteriorSelfLoopConnection)) {
                            KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Could not remove exterior self-loop connection between ", selfLoopPort, exteriorSelfLoopConnection);
                        }
                        if (!NLFactory.removeSignalToPortConnection(otherLoopPort, exteriorSelfLoopConnection)) {
                            KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Could not remove exterior self-loop connection between ", otherLoopPort, exteriorSelfLoopConnection);
                        }
                        if (interiorSelfLoopConnection == null) continue;
                        if (!NLFactory.removeSignalToPortConnection(selfLoopPort, interiorSelfLoopConnection)) {
                            KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Could not remove interior self-loop connection between ", selfLoopPort, interiorSelfLoopConnection);
                        }
                        if (!NLFactory.removeSignalToPortConnection(otherLoopPort, interiorSelfLoopConnection)) {
                            KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Could not remove interior self-loop connection between ", otherLoopPort, interiorSelfLoopConnection);
                        }
                        if (logicGate.removePort(selfLoopPort) == null) {
                            KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Could not remove self-loop port ", selfLoopPort);
                        }
                        if (logicGate.removePort(otherLoopPort) != null) continue;
                        KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.NL_MODEL_CONSTRUCTION, "Could not remove self-loop port ", otherLoopPort);
                    }
                    continue;
                }
                Collection<? extends NLGate> internals = logicGate.getSubGates();
                if (internals == null || internals.isEmpty()) continue;
                NLUtils.makeInvisible(internals.toArray(new NLGate[internals.size()]));
                continue;
            }
            if (!(nLGate instanceof NLInstanceGate)) continue;
            NLProcessors.adjustAlwaysBlockLogic((NLInstanceGate)nLGate, detailedAlwaysBlockLogic, monitor);
        }
    }

    public static void copyGatesInTop(NLInstanceGate topGate, List<NLAbstractBase> originalGates, NLConfig config, DProgressMonitor monitor) throws DCanceledException {
        NLUtils.checkCanceled(monitor);
        NLProcessors.expandToDepth(topGate, 1, new HashSet<Object>(), monitor);
        NLFiltersProcessors.hideEverything(topGate, monitor);
        for (NLAbstractBase originalGate : originalGates) {
            NLProcessors.copyGateInTop(topGate, originalGate, monitor);
        }
        config.setTopInstance(topGate);
    }

    private static void copyGateInTop(NLInstanceGate topGate, NLAbstractBase originalGate, DProgressMonitor monitor) throws DCanceledException {
        if (!(originalGate instanceof NLGate)) {
            return;
        }
        NLGate resultGate = NLProcessors.findGateExcludingGenerateBlocks(topGate, (NLGate)originalGate, monitor);
        if (resultGate == null) {
            return;
        }
        if (resultGate instanceof NLBundleGate var4_5 && bundleGate.isBusGate()) {
            NLBusUtils.adjustBundleGate((NLBundleGate)bundleGate, monitor);
        }
        NLProcessors.copyGateInformations(originalGate, resultGate, monitor);
        ((NLAbstractBase)resultGate).setParameters(originalGate.getParameters());
        resultGate.addFlag(NLParameters.NLParametersFlag.IS_VISIBLE);
    }

    private static NLGate findGateExcludingGenerateBlocks(NLInstanceGate topGate, NLGate searchedGate, DProgressMonitor monitor) throws DCanceledException {
        for (NLGate nLGate : topGate.getSubGates()) {
            NLGate foundGate;
            DiagramInstanceWrapper searchedGateWrapper;
            NLUtils.checkCanceled(monitor);
            if (nLGate.getName().equals(searchedGate.getName())) {
                return nLGate;
            }
            DiagramInstanceWrapper currentGateWrapper = nLGate.getMapping(DiagramInstanceWrapper.class);
            if (currentGateWrapper != null && (searchedGateWrapper = searchedGate.getMapping(DiagramInstanceWrapper.class)) != null && currentGateWrapper.getInstance() == searchedGateWrapper.getInstance()) {
                return nLGate;
            }
            if (nLGate.getKind() != NLGateKind.BLOCK || (foundGate = NLProcessors.findGateExcludingGenerateBlocks((NLInstanceGate)nLGate, searchedGate, monitor)) == null) continue;
            nLGate.addFlag(NLParameters.NLParametersFlag.IS_VISIBLE);
            return foundGate;
        }
        return null;
    }

    private static void copyGateInformations(NLAbstractBase abstractOriginalGate, NLAbstractBase abstractResultGate, DProgressMonitor monitor) throws DCanceledException {
        if (!(abstractOriginalGate instanceof NLInstanceGate) || !(abstractResultGate instanceof NLInstanceGate)) {
            return;
        }
        NLInstanceGate originalGate = (NLInstanceGate)abstractOriginalGate;
        NLInstanceGate resultGate = (NLInstanceGate)abstractResultGate;
        for (NLPort nLPort : resultGate.getPorts()) {
            NLUtils.checkCanceled(monitor);
            for (NLPort originalPort : originalGate.getPorts()) {
                NLUtils.checkCanceled(monitor);
                if (!nLPort.getName().equals(originalPort.getName())) continue;
                NLProcessors.copyPortConnections(originalPort, nLPort, resultGate, monitor);
                nLPort.setParameters(originalPort.getParameters());
                nLPort.removeFlag(NLParameters.NLParametersFlag.OUTER_VISIBLE);
            }
        }
        for (NLGate nLGate : originalGate.getSubGates()) {
            NLUtils.checkCanceled(monitor);
            nLGate.setEnclosingGate(resultGate);
            resultGate.addSubGate(nLGate);
        }
        for (NLConnection nLConnection : originalGate.getSignals()) {
            NLUtils.checkCanceled(monitor);
            resultGate.addSignal(nLConnection);
        }
    }

    private static void copyPortConnections(NLPort originalPort, NLPort resultPort, NLInstanceGate connectionEnclosingGate, DProgressMonitor monitor) throws DCanceledException {
        for (NLConnection originalConnection : originalPort.getConnections()) {
            NLUtils.checkCanceled(monitor);
            originalConnection.removeTarget(originalPort);
            originalConnection.addTarget(resultPort);
            originalConnection.setEnclosingGate(connectionEnclosingGate);
            resultPort.addConnection(originalConnection);
        }
    }

    public static void copyConnectionsInTop(NLInstanceGate topGate, List<NLAbstractBase> originalConnections, NLConfig config, DProgressMonitor monitor) throws DCanceledException {
        NLUtils.checkCanceled(monitor);
        NLProcessors.expandToDepth(topGate, 1, new HashSet<Object>(), monitor);
        NLFiltersProcessors.hideEverything(topGate, monitor);
        for (NLAbstractBase copyConnection : originalConnections) {
            if (!(copyConnection instanceof NLConnection)) continue;
            Iterator<NLConnection> it = topGate.getSignals().iterator();
            while (it.hasNext()) {
                NLUtils.checkCanceled(monitor);
                NLConnection signal = it.next();
                if (!signal.getName().equals(copyConnection.getName())) continue;
                signal.setParameters(copyConnection.getParameters());
            }
        }
        config.setTopInstance(topGate);
    }

    public static void addWaveformInfo(NLInstanceGate topInstance, NLConfig nlConfig) {
        if (!nlConfig.getSchematicShowWaveformInfo()) {
            return;
        }
        DVTWaveViewIDEFactory.getInstance().addSchematicDiagramWaveformInfo(topInstance);
    }
}

