/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.netlist.utils;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import ro.amiq.dvt.diagrams.DProgressMonitor;
import ro.amiq.dvt.diagrams.exceptions.DCanceledException;
import ro.amiq.dvt.diagrams.klay.KLayDiagramDebug;
import ro.amiq.dvt.diagrams.netlist.model.NLConnection;
import ro.amiq.dvt.diagrams.netlist.model.NLFactory;
import ro.amiq.dvt.diagrams.netlist.model.NLGate;
import ro.amiq.dvt.diagrams.netlist.model.NLGateKind;
import ro.amiq.dvt.diagrams.netlist.model.NLInstanceGate;
import ro.amiq.dvt.diagrams.netlist.model.NLLogicGate;
import ro.amiq.dvt.diagrams.netlist.model.NLLogicStatement;
import ro.amiq.dvt.diagrams.netlist.model.NLParameters;
import ro.amiq.dvt.diagrams.netlist.model.NLPort;
import ro.amiq.dvt.diagrams.netlist.utils.NLProcessors;
import ro.amiq.dvt.diagrams.netlist.utils.NLUtils;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.model.DiagramInstanceWrapper;
import ro.amiq.dvt.logic.form.LFConverterOptions;
import ro.amiq.dvt.logic.form.LogicForm;
import ro.amiq.dvt.model.reflection.DummyInstance;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.HierarchicalElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.ui.trace.connections.model.TCEndSet;
import ro.amiq.dvt.ui.trace.connections.model.TCNode;
import ro.amiq.dvt.ui.trace.connections.model.TCPathChain;
import ro.amiq.dvt.ui.trace.connections.model.TCPathPoint;
import ro.amiq.dvt.ui.trace.connections.model.TCPathRedundance;
import ro.amiq.dvt.ui.trace.connections.model.TCStatement;
import ro.amiq.dvt.ui.trace.connections.utils.TCOperation;
import ro.amiq.dvt.ui.trace.connections.utils.TCViewUtilsBatch;

public class NLTCProcessors {
    private NLTCProcessors() {
    }

    public static final NLInstanceGate transformToTraceAllPathsDiagram(NLInstanceGate topInstance, TCPathPoint startPoint, TCEndSet sources, TCPathChain driveCausedBy, TCEndSet destinations, TCPathChain loadCausedBy, TCOperation operation, DProgressMonitor monitor) throws DCanceledException {
        monitor.checkCanceled();
        if (sources != null) {
            for (TCPathPoint source : sources.getPoints()) {
                NLTCProcessors.transformToTracePathDiagramWithOperation(topInstance, source, TCViewUtilsBatch.getEndPointKind(source, sources, destinations, startPoint), driveCausedBy, startPoint, operation, monitor);
            }
        }
        if (destinations != null) {
            for (TCPathPoint destination : destinations.getPoints()) {
                NLTCProcessors.transformToTracePathDiagramWithOperation(topInstance, destination, TCViewUtilsBatch.getEndPointKind(destination, sources, destinations, startPoint), loadCausedBy, startPoint, operation, monitor);
            }
        }
        NLTCProcessors.makeBlockGatesVisible(topInstance, monitor);
        NLUtils.makeVisible(topInstance);
        return topInstance;
    }

    public static final NLInstanceGate transformToTracePathDiagram(NLInstanceGate topInstance, TCPathPoint point, TCEndSet sources, TCPathChain driveCausedBy, TCEndSet destinations, TCPathChain loadCausedBy, TCPathPoint startPoint, TCOperation operation, DProgressMonitor monitor) throws DCanceledException {
        monitor.checkCanceled();
        TCViewUtilsBatch.TCEndPointKind endPointKind = TCViewUtilsBatch.getEndPointKind(point, sources, destinations, startPoint);
        boolean onPath = false;
        if (operation == TCOperation.DRIVE || operation == TCOperation.DRIVE_AND_LOAD) {
            onPath |= NLTCProcessors.transformToTracePathDiagramWithOperation(topInstance, driveCausedBy.getEffectFromEffect(point), endPointKind, driveCausedBy, startPoint, TCOperation.DRIVE, monitor) != null;
        }
        if (operation == TCOperation.LOAD || operation == TCOperation.DRIVE_AND_LOAD) {
            onPath |= NLTCProcessors.transformToTracePathDiagramWithOperation(topInstance, loadCausedBy.getEffectFromEffect(point), endPointKind, loadCausedBy, startPoint, TCOperation.LOAD, monitor) != null;
        }
        if (!onPath) {
            NLUtils.makeVisible(topInstance);
            return topInstance;
        }
        NLTCProcessors.makeBlockGatesVisible(topInstance, monitor);
        NLInstanceGate firstVisible = NLTCProcessors.findFirstVisibleInstanceGate(topInstance, monitor);
        if (firstVisible == null) {
            firstVisible = topInstance;
        }
        NLTCProcessors.transformToTopGate(firstVisible);
        NLUtils.makeVisible(firstVisible);
        return firstVisible;
    }

    private static final NLInstanceGate findFirstVisibleInstanceGate(NLInstanceGate topInstance, DProgressMonitor monitor) throws DCanceledException {
        monitor.checkCanceled();
        if (topInstance == null) {
            return null;
        }
        NLInstanceGate firstVisible = null;
        if (NLUtils.isVisible(topInstance)) {
            firstVisible = topInstance;
        } else {
            for (NLGate nLGate : topInstance.getSubGates()) {
                NLInstanceGate visibleSubGate;
                if (!(nLGate instanceof NLInstanceGate) || (visibleSubGate = NLTCProcessors.findFirstVisibleInstanceGate((NLInstanceGate)nLGate, monitor)) == null) continue;
                if (firstVisible != null) break;
                firstVisible = visibleSubGate;
            }
        }
        return firstVisible;
    }

    private static final NLInstanceGate transformToTracePathDiagramWithOperation(NLInstanceGate topInstance, TCPathPoint endPoint, TCViewUtilsBatch.TCEndPointKind endPointKind, TCPathChain causedBy, TCPathPoint startPoint, TCOperation operation, DProgressMonitor monitor) throws DCanceledException {
        monitor.checkCanceled();
        if (topInstance == null || endPoint == null || causedBy == null) {
            return null;
        }
        NLInstanceGate endGate = NLTCProcessors.expandAndMakeVisible(NLTCProcessors.findInstanceGateTopDown(topInstance, endPoint.node, new HashSet<Object>()));
        if (endGate == null) {
            KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.TRACE_DIAGRAM_CONSTRUCTION, "Could not find TC gate for ", endPoint.node);
            return null;
        }
        NLInstanceGate firstCauseGate = NLTCProcessors.traceConnectInstanceGates(endGate, endPoint, endPointKind, causedBy, startPoint, operation, monitor);
        if (firstCauseGate == null) {
            KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.TRACE_DIAGRAM_CONSTRUCTION, "Could not connect TC gates", firstCauseGate, endGate);
            return null;
        }
        return firstCauseGate;
    }

    private static final NLInstanceGate traceConnectInstanceGates(NLInstanceGate effectGate, TCPathPoint effect, TCViewUtilsBatch.TCEndPointKind endPointKind, TCPathChain causedBy, TCPathPoint startPoint, TCOperation operation, DProgressMonitor monitor) throws DCanceledException {
        TCPathPoint cause;
        monitor.checkCanceled();
        if (effectGate == null || effect == null || causedBy == null) {
            return null;
        }
        if (NLTCProcessors.traceMarkPortOrConnectSequentialLogic(effectGate, effect.signal, endPointKind, operation)) {
            endPointKind = null;
        }
        if ((cause = causedBy.getCauseFromEffect(effect)) == null) {
            NLTCProcessors.traceMarkPortOrConnectSequentialLogic(effectGate, effect.signal, TCViewUtilsBatch.getEndPointKind(effect, null, null, startPoint), operation);
            NLTCProcessors.traceMakeConnectionVisible(effectGate.getSignal(effect.signal), effect.signal instanceof HierarchicalElement, operation);
            return effectGate;
        }
        NLInstanceGate causeGate = NLTCProcessors.expandAndMakeVisible(NLTCProcessors.findNeighbourGate(effectGate, cause.node));
        boolean nextStep = false;
        if (causeGate == effectGate) {
            int checkDirection = NLTCProcessors.traceCheckLogicDirection(cause, effect);
            if (checkDirection > 0) {
                nextStep = NLTCProcessors.traceConnectLogic(effectGate, cause, effect, checkDirection, endPointKind, operation, monitor);
            } else if (checkDirection < 0) {
                nextStep = NLTCProcessors.traceConnectLogic(causeGate, effect, cause, checkDirection, endPointKind, operation, monitor);
            }
        } else {
            nextStep = NLTCProcessors.traceConnectPortConnection(causeGate, cause, effectGate, effect, endPointKind, operation, monitor);
        }
        if (!nextStep) {
            KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.TRACE_DIAGRAM_CONSTRUCTION, "Could not connect TC gates", causeGate, effectGate);
            return null;
        }
        return NLTCProcessors.traceConnectInstanceGates(causeGate, cause, null, causedBy, startPoint, operation, monitor);
    }

    private static boolean traceMarkPortOrConnectSequentialLogic(NLInstanceGate effectGate, IRfNamedElement effectSignal, TCViewUtilsBatch.TCEndPointKind endPointKind, TCOperation operation) {
        if (effectGate == null || effectSignal == null || endPointKind == null) {
            return false;
        }
        if (NLTCProcessors.traceConnectSequentialLogic(effectGate, effectSignal, endPointKind, operation)) {
            endPointKind = null;
        }
        if (NLTCProcessors.traceMarkEndPointPort(effectGate.getPort(effectSignal), endPointKind)) {
            endPointKind = null;
        }
        return endPointKind == null;
    }

    private static final void transformToTopGate(NLInstanceGate gate) {
        if (gate == null || gate.isTopGate()) {
            return;
        }
        for (NLPort port : gate.getPorts()) {
            for (NLConnection conn : port.getExternalConnections()) {
                if (conn.getEnclosingGate() == gate) continue;
                NLFactory.removeSignalToPortConnection(port, conn);
            }
        }
        NLInstanceGate enclosingGate = gate.getEnclosingGate();
        enclosingGate.removeSubGate(gate);
        gate.setEnclosingGate(null);
    }

    private static final int traceCheckLogicDirection(TCPathPoint cause, TCPathPoint effect) {
        if (cause != null && effect != null && effect.isLogic()) {
            return 1;
        }
        if (effect != null && cause != null && cause.isLogic()) {
            return -1;
        }
        return 0;
    }

    private static final boolean traceConnectLogic(NLInstanceGate enclosingGate, TCPathPoint cause, TCPathPoint effect, int checkLogicDirection, TCViewUtilsBatch.TCEndPointKind endPointKind, TCOperation operation, DProgressMonitor monitor) throws DCanceledException {
        NLGate closestAncestorInstanceGate;
        DiagramInstanceWrapper closestAncestorInstanceWrapper;
        monitor.checkCanceled();
        if (enclosingGate == null || effect == null) {
            return false;
        }
        IRfNamedElement enclosingDesignOrInstance = enclosingGate.getMapping(IRfNamedElement.class);
        LogicForm effectLogicForm = effect.getEnclosingLogicForm(enclosingDesignOrInstance, (closestAncestorInstanceWrapper = (closestAncestorInstanceGate = enclosingGate.getClosestAncestorInstanceSkippingBlocks()) != null ? closestAncestorInstanceGate.getMapping(DiagramInstanceWrapper.class) : null) != null ? closestAncestorInstanceWrapper.getInstance() : null);
        if (effectLogicForm == null) {
            return false;
        }
        TCStatement statement = effect.statement;
        if (statement == null) {
            return false;
        }
        monitor.checkCanceled();
        NLGate traceLogicGate = NLTCProcessors.makeTraceConnectionLogicGate(NLLogicStatement.of(effectLogicForm, statement), enclosingGate);
        if (traceLogicGate != null) {
            NLTCProcessors.traceMakeConnectionVisible(enclosingGate.getSignal(effect.signal), effect.signal instanceof HierarchicalElement, operation);
            if (cause != null) {
                NLTCProcessors.traceMakeConnectionVisible(enclosingGate.getSignal(cause.signal), cause.signal instanceof HierarchicalElement, operation);
                NLTCProcessors.traceMarkEndPointPort(traceLogicGate.getPort(checkLogicDirection > 0 ? effect.signal : cause.signal), endPointKind);
            } else {
                NLTCProcessors.traceMarkEndPointPort(traceLogicGate.getPort(checkLogicDirection > 0 ? effect.signal : null), endPointKind);
            }
        }
        return true;
    }

    private static final boolean traceConnectPortConnection(NLInstanceGate causeGate, TCPathPoint cause, NLInstanceGate effectGate, TCPathPoint effect, TCViewUtilsBatch.TCEndPointKind endPointKind, TCOperation operation, DProgressMonitor monitor) throws DCanceledException {
        int checkDirection;
        monitor.checkCanceled();
        if (causeGate == null || cause == null || effectGate == null || effect == null) {
            return false;
        }
        TCStatement statement = effect.statement;
        int n = checkDirection = effectGate.hasAncestor(causeGate) ? 1 : -1;
        if (checkDirection > 0) {
            LogicForm signalExpression = NLTCProcessors.getTracePortConnectionSignalExpression(effect, cause.node);
            return NLTCProcessors.makeTracePortConnection(effectGate, effect, causeGate, cause, statement, signalExpression, checkDirection, endPointKind, operation, monitor);
        }
        LogicForm signalExpression = NLTCProcessors.getTracePortConnectionSignalExpression(effect, effect.node);
        return NLTCProcessors.makeTracePortConnection(causeGate, cause, effectGate, effect, statement, signalExpression, checkDirection, endPointKind, operation, monitor);
    }

    private static final boolean makeTracePortConnection(NLInstanceGate innerGate, TCPathPoint innerCause, NLInstanceGate outerGate, TCPathPoint outerEffect, TCStatement signalExpressionStatement, LogicForm signalExpressionLogic, int checkPCDirection, TCViewUtilsBatch.TCEndPointKind endPointKind, TCOperation operation, DProgressMonitor monitor) throws DCanceledException {
        monitor.checkCanceled();
        NLPort innerPort = innerGate.getPort(innerCause.signal);
        if (innerPort == null) {
            KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.TRACE_DIAGRAM_CONSTRUCTION, "Could not find port for connecting trace", innerGate, innerPort);
            return false;
        }
        innerPort.getParameters().addFlag(NLParameters.NLParametersFlag.IS_PORT_IN_PORT_CONNECTION);
        if (signalExpressionLogic == null || innerPort.isInterfacePort()) {
            return NLTCProcessors.makeTracePortConnectionWithoutGate(innerGate, innerPort, outerGate, outerEffect.signal, operation);
        }
        signalExpressionStatement.goToInfo.text = "";
        NLConnection dummySignal = NLFactory.createSignalExpressionSignal(signalExpressionLogic, signalExpressionStatement, outerGate, innerPort.getDirection() == NLPort.NLPortDirection.DIR_OUT);
        if (!NLFactory.createCommonSignalToPortConnection(innerPort, dummySignal)) {
            return NLTCProcessors.makeTracePortConnectionWithoutGate(innerGate, innerPort, outerGate, outerEffect.signal, operation);
        }
        NLGate signalExpressionGate = NLTCProcessors.makeTraceConnectionLogicGate(NLLogicStatement.of(signalExpressionLogic, signalExpressionStatement), outerGate);
        if (signalExpressionGate == null) {
            return false;
        }
        NLTCProcessors.traceMakeConnectionVisible(dummySignal, false, operation);
        NLTCProcessors.traceMakeConnectionVisible(outerGate.getSignal(outerEffect.signal), outerEffect.signal instanceof HierarchicalElement, operation);
        NLTCProcessors.traceMarkEndPointPort(signalExpressionGate.getPort(checkPCDirection > 0 ? innerCause.signal : outerEffect.signal), endPointKind);
        return true;
    }

    private static final boolean makeTracePortConnectionWithoutGate(NLInstanceGate innerGate, NLPort innerPort, NLInstanceGate outerGate, IRfNamedElement outerSignal, TCOperation operation) {
        if (innerPort.isInterfacePort()) {
            IRfNamedElement iRfNamedElement = outerSignal = outerSignal instanceof HierarchicalElement ? ((HierarchicalElement)outerSignal).getFirstSegment() : outerSignal;
        }
        if (!innerGate.makeConnection(innerPort, outerGate, outerSignal)) {
            KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.TRACE_DIAGRAM_CONSTRUCTION, "Could not trace connect port to signal", innerPort, outerSignal);
            return false;
        }
        NLTCProcessors.traceMakeConnectionVisible(outerGate.getSignal(outerSignal), outerSignal instanceof HierarchicalElement, operation);
        return true;
    }

    private static final NLGate makeTraceConnectionLogicGate(NLLogicStatement logicStatement, NLInstanceGate enclosingGate) {
        if (logicStatement == null || enclosingGate == null) {
            return null;
        }
        NLGate logicGate = enclosingGate.getSubGate(logicStatement);
        if (logicGate == null) {
            logicGate = enclosingGate.addSubGate(NLFactory.createGate(logicStatement, enclosingGate));
            if (logicGate == null) {
                KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.TRACE_DIAGRAM_CONSTRUCTION, "Could not add logic gate in the trace path (cause - > effect)", enclosingGate);
                return null;
            }
            NLUtils.makeInvisible(logicGate);
            for (NLPort port : logicGate.getPorts()) {
                NLUtils.makeInvisible(port);
            }
        }
        return logicGate;
    }

    private static final boolean traceMakeConnectionVisible(NLConnection conn, boolean isHierarchicalSignal, TCOperation operation) {
        if (conn == null) {
            return false;
        }
        NLUtils.makeVisible(conn);
        boolean hasMarkedSequentialPort = false;
        for (NLPort target : conn.getTargets()) {
            NLPort sameNamedPort;
            NLGate targetGate = target.getEnclosingGate();
            if (targetGate == null) continue;
            NLGateKind targetGateKind = targetGate.getKind();
            if (isHierarchicalSignal && targetGateKind == NLGateKind.BUNDLE && (sameNamedPort = targetGate.getSameNamedPort()) != null) {
                for (NLConnection fullConnection : sameNamedPort.getConnections()) {
                    NLTCProcessors.traceMakeConnectionVisible(fullConnection, false, operation);
                }
            }
            if (targetGateKind == NLGateKind.LOGIC && ((NLLogicGate)targetGate).isSequentialAlwaysBlock()) {
                if ((operation != TCOperation.DRIVE || target.getDirection() != NLPort.NLPortDirection.DIR_OUT) && (operation != TCOperation.LOAD || target.getDirection() != NLPort.NLPortDirection.DIR_IN)) continue;
                hasMarkedSequentialPort = true;
                NLUtils.makeVisible(target, targetGate);
                target.addFlag(NLParameters.NLParametersFlag.OUTER_VISIBLE);
                target.addFlag(NLParameters.NLParametersFlag.INNER_VISIBLE);
                continue;
            }
            NLUtils.makeVisible(target, targetGate);
            target.addFlag(NLParameters.NLParametersFlag.OUTER_VISIBLE);
            target.addFlag(NLParameters.NLParametersFlag.INNER_VISIBLE);
        }
        return hasMarkedSequentialPort;
    }

    private static final void makeBlockGatesVisible(NLInstanceGate gate, DProgressMonitor monitor) throws DCanceledException {
        monitor.checkCanceled();
        if (!NLUtils.isExpanded(gate)) {
            return;
        }
        if (gate.getKind() == NLGateKind.BLOCK && NLProcessors.checkIsVisibleGate(gate)) {
            NLUtils.makeVisible(gate);
        }
        for (NLGate nLGate : gate.getSubGates()) {
            if (!(nLGate instanceof NLInstanceGate)) continue;
            NLTCProcessors.makeBlockGatesVisible((NLInstanceGate)nLGate, monitor);
        }
    }

    private static final NLInstanceGate findNeighbourGate(NLInstanceGate startGate, TCNode target) {
        if (startGate == null || target == null) {
            return startGate;
        }
        if (target.namedElement == startGate.getMapping(IRfNamedElement.class)) {
            return startGate;
        }
        NLInstanceGate ancestor = NLTCProcessors.findAncestorGateIncludingBlocks(startGate.getEnclosingGate(), target);
        return ancestor != null ? ancestor : NLTCProcessors.findDescendentGate(startGate, target, true);
    }

    private static final boolean traceMarkEndPointPort(NLPort port, TCViewUtilsBatch.TCEndPointKind endPointKind) {
        if (port == null || endPointKind == null) {
            return false;
        }
        NLPort.NLPortDirection direction = port.getDirection();
        NLGate enclosingGate = port.getEnclosingGate();
        boolean isLogicGate = NLUtils.isLogicGate(enclosingGate);
        if (isLogicGate && !((NLLogicGate)enclosingGate).isSequentialAlwaysBlock()) {
            KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.TRACE_DIAGRAM_CONSTRUCTION, "Combinational logic gate port is TC source/destination/start", port);
        }
        switch (endPointKind) {
            case SOURCE: {
                if (direction == NLPort.NLPortDirection.DIR_OUT && !isLogicGate) {
                    KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.TRACE_DIAGRAM_CONSTRUCTION, "Output port is TC source", port);
                }
                port.getParameters().addFlag(NLParameters.NLParametersFlag.IS_TRACE_SOURCE);
                break;
            }
            case DESTINATION: {
                if (direction == NLPort.NLPortDirection.DIR_IN && !isLogicGate) {
                    KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.TRACE_DIAGRAM_CONSTRUCTION, "Input port is TC destination", port);
                }
                port.getParameters().addFlag(NLParameters.NLParametersFlag.IS_TRACE_DESTINATION);
                break;
            }
            case MIXED: {
                port.getParameters().addFlag(NLParameters.NLParametersFlag.IS_TRACE_SOURCE).addFlag(NLParameters.NLParametersFlag.IS_TRACE_DESTINATION);
                break;
            }
            case START: {
                port.getParameters().addFlag(NLParameters.NLParametersFlag.IS_TRACE_START);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private static final NLInstanceGate findAncestorGateIncludingBlocks(NLInstanceGate startGate, TCNode target) {
        if (startGate == null || target == null) {
            return startGate;
        }
        NLInstanceGate currentGate = startGate;
        do {
            if (target.namedElement == currentGate.getMapping(IRfNamedElement.class)) {
                return currentGate;
            }
            if (currentGate.getKind() == NLGateKind.BLOCK) continue;
            return null;
        } while ((currentGate = currentGate.getEnclosingGate()) != null);
        return null;
    }

    private static final NLInstanceGate findDescendentGate(NLInstanceGate topInstance, TCNode node, boolean insideBlocks) {
        if (topInstance == null || node == null) {
            return topInstance;
        }
        ArrayDeque<NLInstanceGate> boundary = new ArrayDeque<NLInstanceGate>();
        boundary.add(topInstance);
        while (!boundary.isEmpty()) {
            NLInstanceGate parentGate = (NLInstanceGate)boundary.poll();
            parentGate.expand(null);
            for (NLGate nLGate : parentGate.getSubGates()) {
                IRfNamedElement subGateNamedElem;
                IRfNamedElement nodeNamedElem = node.namedElement instanceof DummyInstance ? ((DummyInstance)node.namedElement).design : node.namedElement;
                IRfNamedElement iRfNamedElement = subGateNamedElem = nLGate.getMapping(IRfNamedElement.class) instanceof DummyInstance ? ((DummyInstance)nLGate.getMapping(IRfNamedElement.class)).design : nLGate.getMapping(IRfNamedElement.class);
                if (nodeNamedElem == subGateNamedElem && (nLGate.getKind() == NLGateKind.BLOCK || nLGate.getMapping(TCNode.class) == node)) {
                    return (NLInstanceGate)nLGate;
                }
                if (!insideBlocks || nLGate.getKind() != NLGateKind.BLOCK) continue;
                boundary.add((NLInstanceGate)nLGate);
            }
        }
        return null;
    }

    private static final NLInstanceGate findInstanceGateTopDown(NLInstanceGate topInstance, TCNode node, Set<Object> visited) {
        ElementPath nodePath;
        ElementPath elementPath;
        if (topInstance == null || node == null) {
            return null;
        }
        if (node.namedElement == topInstance.getMapping(IRfNamedElement.class) && (elementPath = NLUtils.getPath(topInstance)).equals(nodePath = NLUtils.getPath(node))) {
            return topInstance;
        }
        topInstance.expand(visited);
        for (NLGate nLGate : topInstance.getSubGates()) {
            if (!(nLGate instanceof NLInstanceGate)) continue;
            NLProcessors.addGateToVisited(topInstance, visited);
            NLInstanceGate foundGate = NLTCProcessors.findInstanceGateTopDown((NLInstanceGate)nLGate, node, visited);
            if (foundGate != null) {
                return foundGate;
            }
            NLProcessors.removeGateFromVisited(topInstance, visited);
        }
        return null;
    }

    private static final boolean traceConnectSequentialLogic(NLInstanceGate endGate, IRfNamedElement endPointSignal, TCViewUtilsBatch.TCEndPointKind endPointKind, TCOperation operation) {
        if (endGate == null || endPointSignal == null) {
            return false;
        }
        if (endPointKind == null) {
            return false;
        }
        IRfDesignElement design = endGate.getDesign();
        if (design == null) {
            return false;
        }
        LinkedHashMap<IRfNamedElement, LogicForm> concurrentBlocksLogic = new LinkedHashMap<IRfNamedElement, LogicForm>(4);
        DesignUtils.collectConcurrentBlocksWithOperators(design, concurrentBlocksLogic, LFConverterOptions.NL_INSTANCE_SET, NLInstanceGate.ASSIGN_HID_FLATTENING, NLInstanceGate.NULL_PROGRESS_MONITOR);
        LinkedHashMap<IRfNamedElement, LogicForm> sequentialBlocksLogic = new LinkedHashMap<IRfNamedElement, LogicForm>(4);
        DesignUtils.collectSequentialBlocksWithOperators2(design, sequentialBlocksLogic, concurrentBlocksLogic.keySet(), LFConverterOptions.NL_INSTANCE_SET, NLInstanceGate.ASSIGN_HID_FLATTENING, NLInstanceGate.NULL_PROGRESS_MONITOR);
        if (sequentialBlocksLogic.isEmpty()) {
            return false;
        }
        endGate.addAlwaysBlockLogicGates(sequentialBlocksLogic, logicGate -> {
            NLUtils.makeInvisible(logicGate);
            for (NLPort port : logicGate.getPorts()) {
                NLUtils.makeInvisible(port);
                if (port.getDirection() == NLPort.NLPortDirection.DIR_OUT) {
                    NLTCProcessors.traceMarkEndPointPort(port, TCViewUtilsBatch.TCEndPointKind.SOURCE);
                    continue;
                }
                if (port.getDirection() != NLPort.NLPortDirection.DIR_IN) continue;
                NLTCProcessors.traceMarkEndPointPort(port, TCViewUtilsBatch.TCEndPointKind.DESTINATION);
            }
        }, true);
        return NLTCProcessors.traceMakeConnectionVisible(endGate.getSignal(endPointSignal), endPointSignal instanceof HierarchicalElement, operation);
    }

    private static LogicForm getTracePortConnectionSignalExpression(TCPathPoint point, TCNode enclosingNode) {
        if (point == null || enclosingNode == null) {
            return null;
        }
        TCStatement statement = point.statement;
        if (statement == null || statement.kind != TCStatement.TCStatementKind.PORT_CONNECTION) {
            return null;
        }
        TCNode closestAncestorInstanceNode = enclosingNode.getClosestAncestorInstanceSkippingBlocks();
        ELInstance closestAncestorInstance = closestAncestorInstanceNode != null ? closestAncestorInstanceNode.getELInstance() : null;
        return point.getEnclosingLogicForm(enclosingNode.namedElement, closestAncestorInstance);
    }

    public static final NLInstanceGate transformToTraceAllDiagram(NLInstanceGate topInstance, TCNode topNode, TCPathPoint startPoint, TCEndSet sources, TCPathChain driveCausedBy, TCPathRedundance driveRedundance, TCEndSet destinations, TCPathChain loadCausedBy, TCPathRedundance loadRedundance, DProgressMonitor monitor) throws DCanceledException {
        monitor.checkCanceled();
        Bundle bundle = new Bundle(startPoint, sources, driveCausedBy, driveRedundance, destinations, loadCausedBy, loadRedundance, monitor);
        NLTCProcessors.transformToTraceAllExplorer(topInstance, topNode, bundle);
        NLTCProcessors.makeBlockGatesVisible(topInstance, monitor);
        NLUtils.makeVisible(topInstance);
        return topInstance;
    }

    private static void transformToTraceAllExplorer(NLInstanceGate topInstance, TCNode topNode, Bundle bundle) throws DCanceledException {
        ArrayDeque<PairInstanceNode> boundary = new ArrayDeque<PairInstanceNode>();
        boundary.add(new PairInstanceNode(topInstance, topNode));
        NLTCProcessors.expandAndMakeVisible(topInstance);
        while (!boundary.isEmpty()) {
            bundle.monitor.checkCanceled();
            PairInstanceNode hotPair = (PairInstanceNode)boundary.poll();
            for (TCNode childNode : hotPair.node().getChildren()) {
                if (!childNode.hotVisible()) continue;
                NLInstanceGate childGate = NLTCProcessors.findDescendentGate(hotPair.gate(), childNode, false);
                if (childGate == null) {
                    KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.TRACE_DIAGRAM_CONSTRUCTION, "Could not find TC instance", childNode);
                    continue;
                }
                NLTCProcessors.expandAndMakeVisible(childGate);
                boundary.add(new PairInstanceNode(childGate, childNode));
            }
            Map<IRfNamedElement, Long> hotSignalsMap = hotPair.node().getHotSignalsMap();
            ArrayList<Pair<NLConnection, Pair<IRfNamedElement, TCOperation>>> workSignals = new ArrayList<Pair<NLConnection, Pair<IRfNamedElement, TCOperation>>>(hotSignalsMap.size());
            for (Map.Entry<IRfNamedElement, Long> hotSignalEntry : hotSignalsMap.entrySet()) {
                long roles = hotSignalEntry.getValue();
                if ((roles & TCOperation.DRIVE_VALUE) != 0L) {
                    workSignals.add(NLTCProcessors.traceConnectInternalSignalWithOperation(hotPair, hotSignalEntry.getKey(), TCOperation.DRIVE, bundle));
                }
                if ((roles & TCOperation.LOAD_VALUE) == 0L) continue;
                workSignals.add(NLTCProcessors.traceConnectInternalSignalWithOperation(hotPair, hotSignalEntry.getKey(), TCOperation.LOAD, bundle));
            }
            workSignals.stream().filter(Objects::nonNull).forEach(pair -> {
                boolean bl = NLTCProcessors.traceMakeConnectionVisible((NLConnection)pair.item, ((Pair)pair.object).item instanceof HierarchicalElement, (TCOperation)((Object)((Object)((Pair)pair.object).object)));
            });
        }
    }

    private static Pair<NLConnection, Pair<IRfNamedElement, TCOperation>> traceConnectInternalSignalWithOperation(PairInstanceNode enclosing, IRfNamedElement hotSignal, TCOperation operation, Bundle bundle) throws DCanceledException {
        IRfNamedElement particularSignal;
        NLConnection nlSignal;
        bundle.monitor.checkCanceled();
        TCPathChain causedBy = operation == TCOperation.DRIVE ? bundle.driveCausedBy : bundle.loadCausedBy;
        TCPathRedundance redundance = operation == TCOperation.DRIVE ? bundle.driveRedundance : bundle.loadRedundance;
        NLInstanceGate effectGate = enclosing.gate();
        if (effectGate == null) {
            return null;
        }
        TCPathPoint effect = causedBy.getEffectFromEffect(TCPathPoint.of(enclosing.node(), hotSignal, null));
        KLayDiagramDebug.debugInfo(KLayDiagramDebug.DebugRegion.TRACE_DIAGRAM_CONSTRUCTION, "Reached hot signal ", hotSignal);
        TCViewUtilsBatch.TCEndPointKind endPointKind = TCViewUtilsBatch.getEndPointKind(effect, bundle.sources, bundle.destinations, bundle.startPoint);
        if (NLTCProcessors.traceMarkPortOrConnectSequentialLogic(effectGate, hotSignal, endPointKind, operation)) {
            endPointKind = null;
        }
        if ((nlSignal = effectGate.getSignal(particularSignal = hotSignal instanceof HierarchicalElement ? ((HierarchicalElement)hotSignal).getFirstSegment() : hotSignal)) == null) {
            KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.TRACE_DIAGRAM_CONSTRUCTION, "Could not find trace signal in gate", particularSignal, effectGate);
            return null;
        }
        TCPathPoint cause = causedBy.getCauseFromEffect(effect);
        NLTCProcessors.traceConnectInternalSignalForCause(cause, effectGate, effect, endPointKind, operation, bundle);
        List<TCPathChain.TCPathLink> otherCauses = redundance.getRedundantCauses(effect);
        if (otherCauses != null) {
            for (TCPathChain.TCPathLink otherCause : otherCauses) {
                NLTCProcessors.traceConnectInternalSignalForCause(otherCause.cause, effectGate, otherCause.effect, null, operation, bundle);
                KLayDiagramDebug.debugInfo(KLayDiagramDebug.DebugRegion.TRACE_DIAGRAM_CONSTRUCTION, "Additional cause for effect", otherCause.cause, otherCause.effect);
            }
        }
        return new Pair<NLConnection, Pair<IRfNamedElement, TCOperation>>(nlSignal, new Pair<IRfNamedElement, TCOperation>(hotSignal, operation));
    }

    private static final void traceConnectInternalSignalForCause(TCPathPoint cause, NLInstanceGate effectGate, TCPathPoint effect, TCViewUtilsBatch.TCEndPointKind endPointKind, TCOperation operation, Bundle bundle) throws DCanceledException {
        if (effect == null) {
            return;
        }
        if (!effect.isPortExpression()) {
            if (effect.isLogic()) {
                if (!NLTCProcessors.traceConnectLogic(effectGate, cause, effect, 1, endPointKind, operation, bundle.monitor)) {
                    KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.TRACE_DIAGRAM_CONSTRUCTION, "Could not create logic for ", effect);
                }
            } else if (effect.isPortConnection() && cause != null) {
                NLInstanceGate causeGate = NLTCProcessors.expandAndMakeVisible(NLTCProcessors.findNeighbourGate(effectGate, cause.node));
                if (!NLTCProcessors.traceConnectPortConnection(causeGate, cause, effectGate, effect, endPointKind, operation, bundle.monitor)) {
                    KLayDiagramDebug.debugError(KLayDiagramDebug.DebugRegion.TRACE_DIAGRAM_CONSTRUCTION, "Could not connect TC gates", causeGate, effectGate);
                }
            } else {
                KLayDiagramDebug.debugInfo(KLayDiagramDebug.DebugRegion.TRACE_DIAGRAM_CONSTRUCTION, "No need to connect TC signal ", effectGate, effect);
            }
        }
    }

    public static final void handleOutputPortsForDriveOperation(NLGate topInstance, TCOperation operation, DProgressMonitor monitor) throws DCanceledException {
        monitor.checkCanceled();
        if (operation != TCOperation.DRIVE && operation != TCOperation.DRIVE_AND_LOAD) {
            return;
        }
        NLProcessors.makePortInvisibleInDiagram(topInstance, gate -> NLUtils.isExpanded(gate), port -> {
            boolean isFiltered;
            if (port.getDirection() == NLPort.NLPortDirection.DIR_IN) {
                return false;
            }
            if (!port.hasFlag(NLParameters.NLParametersFlag.IS_VISIBLE)) {
                return false;
            }
            List<NLConnection> connections = port.getExternalConnections();
            if (!connections.isEmpty()) {
                return false;
            }
            NLParameters portParameters = port.getParameters();
            boolean bl = isFiltered = !portParameters.hasFlags(NLParameters.NLParametersFlag.IS_TRACE_SOURCE.value() | NLParameters.NLParametersFlag.IS_TRACE_DESTINATION.value() | NLParameters.NLParametersFlag.IS_TRACE_START.value());
            if (isFiltered) {
                KLayDiagramDebug.debugInfo(KLayDiagramDebug.DebugRegion.TRACE_DIAGRAM_CONSTRUCTION, "Made invisible the non-input port", port);
            }
            return isFiltered;
        }, monitor);
    }

    public static NLInstanceGate expandAndMakeVisible(NLInstanceGate gate) {
        NLUtils.makeVisible(gate);
        return gate != null ? gate.expand(null) : null;
    }

    private static class Bundle {
        final TCPathPoint startPoint;
        final TCEndSet sources;
        final TCPathChain driveCausedBy;
        final TCPathRedundance driveRedundance;
        final TCEndSet destinations;
        final TCPathChain loadCausedBy;
        final TCPathRedundance loadRedundance;
        final DProgressMonitor monitor;

        public Bundle(TCPathPoint startPoint, TCEndSet sources, TCPathChain driveCausedBy, TCPathRedundance driveRedundance, TCEndSet destinations, TCPathChain loadCausedBy, TCPathRedundance loadRedundance, DProgressMonitor monitor) {
            this.startPoint = startPoint;
            this.sources = sources;
            this.driveCausedBy = driveCausedBy;
            this.driveRedundance = driveRedundance;
            this.destinations = destinations;
            this.loadCausedBy = loadCausedBy;
            this.loadRedundance = loadRedundance;
            this.monitor = monitor;
        }
    }

    private static class Pair<K, V> {
        K item;
        V object;

        public Pair(K item, V object) {
            this.item = item;
            this.object = object;
        }

        public String toString() {
            return "<" + this.item + ", " + this.object + ">";
        }
    }

    private static class PairInstanceNode
    extends Pair<NLInstanceGate, TCNode> {
        public PairInstanceNode(NLInstanceGate instance, TCNode node) {
            super(instance, node);
        }

        final NLInstanceGate gate() {
            return (NLInstanceGate)this.item;
        }

        final TCNode node() {
            return (TCNode)this.object;
        }
    }
}

