/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.netlist.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.diagrams.DProgressMonitor;
import ro.amiq.dvt.diagrams.exceptions.DCanceledException;
import ro.amiq.dvt.diagrams.klay.KLayDiagramDebug;
import ro.amiq.dvt.diagrams.netlist.model.NLAbstractBase;
import ro.amiq.dvt.diagrams.netlist.model.NLConnection;
import ro.amiq.dvt.diagrams.netlist.model.NLELInstanceGate;
import ro.amiq.dvt.diagrams.netlist.model.NLGate;
import ro.amiq.dvt.diagrams.netlist.model.NLGateKind;
import ro.amiq.dvt.diagrams.netlist.model.NLImplicitGate;
import ro.amiq.dvt.diagrams.netlist.model.NLInstanceGate;
import ro.amiq.dvt.diagrams.netlist.model.NLInstanceGateExpandState;
import ro.amiq.dvt.diagrams.netlist.model.NLLogicGate;
import ro.amiq.dvt.diagrams.netlist.model.NLLogicStatement;
import ro.amiq.dvt.diagrams.netlist.model.NLPDInstanceGate;
import ro.amiq.dvt.diagrams.netlist.model.NLParameters;
import ro.amiq.dvt.diagrams.netlist.model.NLPort;
import ro.amiq.dvt.diagrams.netlist.model.NLPortGate;
import ro.amiq.dvt.diagrams.netlist.model.NLPortLabelOptions;
import ro.amiq.dvt.diagrams.netlist.utils.NLConfig;
import ro.amiq.dvt.diagrams.netlist.utils.NLProcessors;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.model.DiagramInstanceWrapper;
import ro.amiq.dvt.logic.form.model.LFResolvedFanIn;
import ro.amiq.dvt.model.reflection.DummyInstance;
import ro.amiq.dvt.model.reflection.DummyPort;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.HierarchicalElement;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfEntityComplement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbSegment;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBreadcrumbUtils;
import ro.amiq.dvt.ui.trace.connections.model.TCConnSignal;
import ro.amiq.dvt.ui.trace.connections.model.TCNode;
import ro.amiq.dvt.ui.trace.connections.utils.TCUtils;

public interface NLUtils {
    public static final int NLLABEL_MAX_CHARACTERS = 20;
    public static final String FLOW_EDGE_SEPARATOR = " - ";
    public static final int MIN_HDEPTH = 1;
    public static final int MIN_HLEVEL = 0;
    public static final /* synthetic */ int[] $SWITCH_TABLE$ro$amiq$dvt$diagrams$netlist$model$NLPort$NLPortDirection;
    public static final /* synthetic */ int[] $SWITCH_TABLE$ro$amiq$dvt$model$reflection$IRfNamedElement$ElementKind;

    static {
        $SWITCH_TABLE$ro$amiq$dvt$diagrams$netlist$model$NLPort$NLPortDirection = NLUtils.$SWITCH_TABLE$ro$amiq$dvt$diagrams$netlist$model$NLPort$NLPortDirection();
        $SWITCH_TABLE$ro$amiq$dvt$model$reflection$IRfNamedElement$ElementKind = NLUtils.$SWITCH_TABLE$ro$amiq$dvt$model$reflection$IRfNamedElement$ElementKind();
    }

    public static IRfNamedElement resolveSignal(Object signal, DesignUtils.DesignRequest request, ELInstance closestAncestorInstance, boolean acceptVariables, Map<IRfInstanceElement, Set<DummyPort>> dummyPortMap) {
        IRfNamedElement signalElement = DesignUtils.resolveSignal(signal, request, closestAncestorInstance, dummyPortMap);
        return DesignUtils.isValidSignalCandidate(signalElement, request == null ? null : request.instancePath) || MethodCallUtils.isValidMethodArgument(signalElement) || acceptVariables && (DesignUtils.isVHDLVariable(signalElement) || DesignUtils.isVLOGVariable(signalElement)) ? signalElement : null;
    }

    public static boolean isVlogOrVHDLVariable(Object signalElement) {
        return DesignUtils.isVHDLVariable(signalElement) || DesignUtils.isVLOGVariable(signalElement);
    }

    public static NLPort.NLPortDirection getPortDirectionFrom(IRfPortElement portElement) {
        if (portElement == null) {
            return NLPort.NLPortDirection.DIR_NONE;
        }
        if (portElement.isOutput()) {
            return NLPort.NLPortDirection.DIR_OUT;
        }
        if (portElement.isInput()) {
            return NLPort.NLPortDirection.DIR_IN;
        }
        if (portElement.isInout()) {
            return NLPort.NLPortDirection.DIR_INOUT;
        }
        if (portElement.isInterfacePort()) {
            return NLPort.NLPortDirection.DIR_INOUT;
        }
        if (portElement.isLinkage()) {
            return NLPort.NLPortDirection.DIR_LINKAGE;
        }
        if (portElement.isBuffer()) {
            return NLPort.NLPortDirection.DIR_BUFFER;
        }
        if (portElement.isRef()) {
            return NLPort.NLPortDirection.DIR_REF;
        }
        return NLPort.NLPortDirection.DIR_NONE;
    }

    public static NLPort.NLPortDirection getPortDirectionOfPort(NLPort nlPort) {
        if (nlPort == null) {
            return null;
        }
        NLGate enclosingGate = nlPort.getEnclosingGate();
        return enclosingGate instanceof NLPortGate ? NLUtils.getOppositePortDirection(((NLPortGate)enclosingGate).getDirection()) : nlPort.getDirection();
    }

    public static NLPort.NLPortDirection getOppositePortDirection(NLPort.NLPortDirection direction) {
        if (direction == null) {
            return NLPort.NLPortDirection.DIR_NONE;
        }
        switch (direction) {
            case DIR_IN: {
                return NLPort.NLPortDirection.DIR_OUT;
            }
            case DIR_OUT: {
                return NLPort.NLPortDirection.DIR_IN;
            }
        }
        return direction;
    }

    public static boolean isDestinationPort(NLPort port) {
        if (port == null) {
            return false;
        }
        NLGate enclosingGate = port.getEnclosingGate();
        if (enclosingGate instanceof NLPortGate) {
            return !((NLPortGate)enclosingGate).isInput();
        }
        NLPort.NLPortDirection direction = port.getDirection();
        return direction == NLPort.NLPortDirection.DIR_IN || direction == NLPort.NLPortDirection.DIR_INOUT;
    }

    public static boolean isSourcePort(NLPort port) {
        if (port == null) {
            return false;
        }
        NLPort.NLPortDirection direction = port.getDirection();
        return direction == NLPort.NLPortDirection.DIR_OUT || direction == NLPort.NLPortDirection.DIR_INOUT;
    }

    public static boolean isDestinationPortExclusive(NLPort port) {
        if (port == null) {
            return false;
        }
        return !NLUtils.isSourcePort(port) && NLUtils.isDestinationPort(port);
    }

    public static boolean isSourcePortExclusive(NLPort port) {
        if (port == null) {
            return false;
        }
        return NLUtils.isSourcePort(port) && !NLUtils.isDestinationPort(port);
    }

    public static boolean isSourceAndDestinationPort(NLPort port) {
        if (port == null) {
            return false;
        }
        return NLUtils.isSourcePort(port) && NLUtils.isDestinationPort(port);
    }

    public static String getNLName(Object element) {
        if (element == null) {
            return null;
        }
        if (element instanceof String) {
            return (String)element;
        }
        if (element instanceof HierarchicalElement) {
            return ((HierarchicalElement)element).getFullName();
        }
        if (element instanceof NLAbstractBase) {
            return ((NLAbstractBase)element).getName();
        }
        if (element instanceof NLLogicStatement) {
            return ((NLLogicStatement)element).toString();
        }
        if (element instanceof LFResolvedFanIn) {
            return ((LFResolvedFanIn)element).toString();
        }
        if (element instanceof TCNode) {
            if (TCUtils.getELMemory((TCNode)element) == null) {
                return ((TCNode)element).namedElement.getNameForDiagram();
            }
            String genBlockPrefixForDiagram = ((TCNode)element).genBlockPrefixForDiagram;
            String prefix = genBlockPrefixForDiagram == null ? "" : genBlockPrefixForDiagram;
            return String.valueOf(prefix) + ((TCNode)element).getLabel();
        }
        if (element instanceof IRfNamedElement) {
            return ((IRfNamedElement)element).getNameForDiagram();
        }
        if (element instanceof DiagramInstanceWrapper) {
            return ((DiagramInstanceWrapper)element).getNameForDiagram();
        }
        if (element instanceof TCConnSignal && ((TCConnSignal)element).signal instanceof HidImplicit) {
            HidImplicit hidImplicit = (HidImplicit)((TCConnSignal)element).signal;
            return hidImplicit.getName();
        }
        return null;
    }

    public static String getSeqNLName(NLGate enclosingGate) {
        return String.valueOf(NLUtils.getNLName(NLLogicStatement.FLOW_SEQ)) + " " + enclosingGate.getName();
    }

    public static String getNLLabel(Object element, ElementPath instancePath, NLPortLabelOptions portLabelOptions) {
        if (element instanceof TCNode) {
            element = ((TCNode)element).namedElement;
        }
        String result = "";
        if (element instanceof String) {
            result = (String)element;
        } else if (element instanceof NLLogicStatement) {
            result = "";
        } else if (element instanceof LFResolvedFanIn) {
            result = "";
        } else if (element instanceof HierarchicalElement) {
            result = ((HierarchicalElement)element).getFullName();
        } else if (element instanceof DummyPort) {
            result = ((DummyPort)element).getLabel();
        } else if (element instanceof IRfInstanceElement || DesignUtils.getDesignKind(element) != IRfNamedElement.ElementKind.UNKNOWN) {
            result = NLUtils.getDesignNLLabel((IRfNamedElement)element, DesignUtils.getDesign(DesignUtils.DesignRequest.of((IRfNamedElement)element, instancePath, null, true, null)), null);
        } else {
            if (element instanceof IRfFieldElement var4_5) {
                result = fieldElement.getLabelForDiagram(instancePath, portLabelOptions);
                if (result == null) {
                    result = fieldElement.getName();
                }
            } else if (element instanceof IRfNamedElement) {
                result = ((IRfNamedElement)element).getName();
            }
        }
        return result != null ? result : "";
    }

    public static String getNLLabel(Object element, NLPortLabelOptions portLabelOptions) {
        return NLUtils.getNLLabel(element, null, portLabelOptions);
    }

    public static String getNLLabel(Object element) {
        return NLUtils.getNLLabel(element, null, null);
    }

    public static String getDesignNLLabel(DiagramInstanceWrapper instance, IRfNamedElement resolvedDesign) {
        IRfInstanceElement description = instance.getDescription();
        if (description instanceof DummyInstance) {
            return instance.getNameForDiagram();
        }
        return String.valueOf(instance.getGenblockPrefixForDiagram()) + NLUtils.getDesignNLLabel(description, resolvedDesign, instance.getHierarchyPath());
    }

    public static String getDesignNLLabel(IRfNamedElement element, IRfNamedElement resolvedDesign, ElementPath instancePath) {
        if (element == null) {
            return "";
        }
        IRfNamedElement iRfNamedElement = element = element instanceof DummyInstance ? ((DummyInstance)element).design : DesignUtils.toGenericDesignElement(element);
        if (element instanceof IRfInstanceElement) {
            String instanceName = instancePath != null && ((IRfInstanceElement)element).isArray() ? instancePath.lastSegment() : ((IRfInstanceElement)element).getName();
            return NLUtils.getDesignNLInstanceLabel(instanceName, (IRfInstanceElement)element, resolvedDesign, instancePath);
        }
        if (element instanceof IRfDesignElement) {
            StringBuilder result = new StringBuilder();
            IRfDesignElement designElement = (IRfDesignElement)element;
            switch (designElement.getKind()) {
                case VHDL_ENTITY: {
                    IRfDesignElement architecture = designElement.getArchitecture();
                    if (architecture != null) {
                        result.append(NLUtils.getDesignNLLabel(architecture, null, instancePath));
                        break;
                    }
                    result.append(designElement.getName());
                    break;
                }
                case VHDL_ARCHITECTURE: {
                    IRfDesignElement entity = ((IRfBlockElement)designElement).getEntity();
                    if (entity != null) {
                        List<? extends IRfBlockElement> architectures = entity.getArchitectures();
                        if (architectures != null && architectures.size() > 1) {
                            result.append(designElement.getName()).append(" of ");
                        }
                        result.append(entity.getName());
                        break;
                    }
                    result.append(designElement.getName());
                    break;
                }
                case VHDL_COMPONENT: {
                    String componentName = designElement.getName();
                    if (resolvedDesign == null) {
                        result.append(componentName);
                        break;
                    }
                    String actualTypeLabel = NLUtils.getDesignNLLabel(resolvedDesign, null, instancePath);
                    if (actualTypeLabel.endsWith(componentName)) {
                        result.append(actualTypeLabel);
                        break;
                    }
                    result.append(componentName).append(" ").append("[").append(actualTypeLabel).append("]");
                    break;
                }
                default: {
                    result.append(designElement.getName());
                }
            }
            return result.toString();
        }
        if (element != null) {
            return element.getName();
        }
        return "";
    }

    public static String getDesignNLInstanceLabel(String instanceName, IRfInstanceElement instance, IRfNamedElement resolvedDesign, ElementPath instancePath) {
        StringBuilder result = new StringBuilder();
        IRfNamedElement design = instance.getGenericDesign(instancePath);
        if (DesignUtils.getDesignKind(design) == IRfNamedElement.ElementKind.VLOG_PRIMITIVE && (instanceName == null || instanceName.startsWith("__n_"))) {
            return design.getName();
        }
        result.append(instanceName);
        if (design instanceof IRfDesignElement) {
            result.append("\n").append("(").append(NLUtils.getDesignNLLabel(design, resolvedDesign, instancePath)).append(")");
        } else {
            String designName = instance.getAssociatedTypeName();
            if (designName != null) {
                result.append("\n").append("(").append(designName).append(")");
            }
        }
        return result.toString();
    }

    public static boolean isExpanded(NLGate gate) {
        return gate instanceof NLInstanceGate && ((NLInstanceGate)gate).getExpandState() != NLInstanceGateExpandState.COLLAPSED;
    }

    public static boolean isLogicGate(NLAbstractBase object) {
        return object instanceof NLGate && ((NLGate)object).getKind() == NLGateKind.LOGIC;
    }

    public static boolean isInternalLogicGate(NLAbstractBase object) {
        return object instanceof NLLogicGate.NLInternalLogicGate;
    }

    public static boolean isPDTopInstance(NLAbstractBase object) {
        return object instanceof NLPDInstanceGate && object.getEnclosingGate() == null;
    }

    public static boolean isImplicitGate(NLAbstractBase object) {
        return object instanceof NLImplicitGate;
    }

    public static boolean isInternalLogicGatePort(NLAbstractBase object) {
        return object instanceof NLPort && object.getEnclosingGate() instanceof NLLogicGate.NLInternalLogicGate;
    }

    public static boolean isInternalLogicGateConnection(NLAbstractBase object) {
        return object instanceof NLConnection && object.getEnclosingGate() instanceof NLLogicGate;
    }

    public static boolean isDiagramsShowConstants(NLAbstractBase gate) {
        return gate != null && gate instanceof NLInstanceGate && gate.hasFlag(NLParameters.NLParametersFlag.SCHEMATIC_SHOW_CONSTANTS);
    }

    public static boolean isDiagramsShowPortFullyQualifiedName(NLAbstractBase gate) {
        return gate != null && gate.hasFlag(NLParameters.NLParametersFlag.DIAGRAM_SHOW_PORT_FULLY_QUALIFIED_NAME);
    }

    public static boolean hasTopEnclosingGate(NLAbstractBase elem) {
        NLGate enclosingGate = elem.getEnclosingGate();
        return enclosingGate != null && enclosingGate.isTopGate();
    }

    public static NLGateKind getGateKind(NLGate gate) {
        if (gate == null) {
            return null;
        }
        return gate.getKind();
    }

    public static boolean isVisible(NLAbstractBase ... bases) {
        if (bases == null) {
            return false;
        }
        NLAbstractBase[] nLAbstractBaseArray = bases;
        int n = bases.length;
        int n2 = 0;
        while (n2 < n) {
            NLAbstractBase base = nLAbstractBaseArray[n2];
            if (base != null && base.getParameters().hasFlag(NLParameters.NLParametersFlag.IS_VISIBLE)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void makeVisible(NLAbstractBase ... bases) {
        if (bases == null) {
            return;
        }
        NLAbstractBase[] nLAbstractBaseArray = bases;
        int n = bases.length;
        int n2 = 0;
        while (n2 < n) {
            NLAbstractBase base = nLAbstractBaseArray[n2];
            if (base != null) {
                base.addFlag(NLParameters.NLParametersFlag.IS_VISIBLE);
                base.removeFlag(NLParameters.NLParametersFlag.IS_DELETED);
            }
            ++n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void makeGateAndPortsVisible(NLGate gate) {
        NLAbstractBase port;
        if (gate == null) {
            return;
        }
        NLUtils.makeVisible(gate);
        Iterator<NLPort> iterator = gate.getPorts().iterator();
        while (iterator.hasNext()) {
            port = iterator.next();
            NLUtils.makeVisible(port);
        }
        NLGate nLGate = gate;
        if (nLGate instanceof NLLogicGate && (port = (NLLogicGate)nLGate) == (NLLogicGate)((Object)iterator)) {
            void logicGate;
            logicGate.makeConnectedImplicitGateVisible();
        }
    }

    public static void makeGateAndGenerateBlocksVisible(NLGate sourceGate) {
        if (sourceGate == null) {
            return;
        }
        NLUtils.makeGateAndPortsVisible(sourceGate);
        NLInstanceGate enclosingGate = sourceGate.getEnclosingGate();
        while (enclosingGate != null && enclosingGate.getKind() == NLGateKind.BLOCK) {
            NLUtils.makeVisible(enclosingGate);
            enclosingGate = enclosingGate.getEnclosingGate();
        }
    }

    public static void makeInvisible(NLAbstractBase ... bases) {
        NLUtils.makeInvisible(false, bases);
    }

    public static void makeInvisible(boolean addIsFiltered, NLAbstractBase ... bases) {
        if (bases == null) {
            return;
        }
        NLAbstractBase[] nLAbstractBaseArray = bases;
        int n = bases.length;
        int n2 = 0;
        while (n2 < n) {
            NLAbstractBase base = nLAbstractBaseArray[n2];
            if (base != null && base.hasFlag(NLParameters.NLParametersFlag.IS_VISIBLE)) {
                base.removeFlag(NLParameters.NLParametersFlag.IS_VISIBLE);
                if (addIsFiltered) {
                    base.addFlag(NLParameters.NLParametersFlag.IS_FILTERED);
                } else {
                    base.removeFlag(NLParameters.NLParametersFlag.INNER_VISIBLE);
                    base.removeFlag(NLParameters.NLParametersFlag.OUTER_VISIBLE);
                }
            }
            ++n2;
        }
    }

    public static NLInstanceGate findEnclosingScopeGate(NLInstanceGate startGate, IRfScopeElement signalScope) {
        if (startGate instanceof NLELInstanceGate) {
            return NLUtils.findELEnclosingScopeGate((NLELInstanceGate)startGate, signalScope);
        }
        if (startGate == null || !(signalScope instanceof IRfNamedElement)) {
            return null;
        }
        signalScope = DesignUtils.getDesign(DesignUtils.DesignRequest.of((IRfNamedElement)signalScope, true));
        NLInstanceGate currentGate = startGate;
        do {
            IRfNamedElement signalScopeDesign;
            IRfNamedElement mapping;
            if ((mapping = currentGate.getMapping(IRfNamedElement.class)) == null) {
                return null;
            }
            if (signalScope == mapping) {
                return currentGate;
            }
            IRfDesignElement mappingDesign = currentGate.getDesign();
            if (mappingDesign == (signalScopeDesign = (IRfNamedElement)signalScope)) {
                return currentGate;
            }
            if (DesignUtils.getDesignKind(mappingDesign) == IRfNamedElement.ElementKind.VHDL_ARCHITECTURE) {
                mappingDesign = ((IRfEntityComplement)((Object)mappingDesign)).getEntity();
            }
            if (DesignUtils.getDesignKind(signalScopeDesign) == IRfNamedElement.ElementKind.VHDL_ARCHITECTURE) {
                signalScopeDesign = ((IRfEntityComplement)((Object)signalScopeDesign)).getEntity();
            }
            if (mappingDesign == signalScopeDesign) {
                return currentGate;
            }
            if (currentGate.getKind() == NLGateKind.BLOCK) continue;
            return null;
        } while ((currentGate = currentGate.getEnclosingGate()) != null);
        return null;
    }

    public static NLInstanceGate findELEnclosingScopeGate(NLELInstanceGate startGate, IRfScopeElement signalScope) {
        if (startGate == null || !(signalScope instanceof IRfNamedElement)) {
            return null;
        }
        NLInstanceGate currentGate = startGate;
        do {
            IRfNamedElement signalScopeDesign;
            DiagramInstanceWrapper mapping;
            if ((mapping = currentGate.getMapping(DiagramInstanceWrapper.class)) == null) {
                return null;
            }
            if (signalScope == mapping.getDescription()) {
                return currentGate;
            }
            IRfDesignElement mappingDesign = ((NLInstanceGate)currentGate).getDesign();
            if (mappingDesign == (signalScopeDesign = (IRfNamedElement)signalScope)) {
                return currentGate;
            }
            if (DesignUtils.getDesignKind(mappingDesign) == IRfNamedElement.ElementKind.VHDL_ARCHITECTURE) {
                mappingDesign = ((IRfEntityComplement)((Object)mappingDesign)).getEntity();
            }
            if (DesignUtils.getDesignKind(signalScopeDesign) == IRfNamedElement.ElementKind.VHDL_ARCHITECTURE) {
                signalScopeDesign = ((IRfEntityComplement)((Object)signalScopeDesign)).getEntity();
            }
            if (mappingDesign == signalScopeDesign) {
                return currentGate;
            }
            if (currentGate.getKind() == NLGateKind.BLOCK) continue;
            return null;
        } while ((currentGate = currentGate.getEnclosingGate()) != null);
        return null;
    }

    @NotNull
    public static List<NLPort> getSourcePortsSkippingLogic(NLConnection signal, boolean allowSequentialLogic, DProgressMonitor monitor) throws DCanceledException {
        NLUtils.checkCanceled(monitor);
        if (signal == null) {
            return Collections.emptyList();
        }
        KLayDiagramDebug.debugInfo(KLayDiagramDebug.DebugRegion.FLOW_DIAGRAM_CONSTRUCTION, "Source ports skipping logic for ", signal);
        Collection sourcePorts = signal.getSourcePorts();
        HashSet<NLPort> visited = new HashSet<NLPort>();
        ListIterator<NLPort> listIterator = sourcePorts.listIterator();
        NLGate signalGate = signal.getEnclosingGate();
        while (listIterator.hasNext()) {
            NLUtils.checkCanceled(monitor);
            NLPort port = (NLPort)listIterator.next();
            NLGate portEnclosingGate = port.getEnclosingGate();
            if (!(portEnclosingGate instanceof NLLogicGate) || portEnclosingGate.isSequentialAlwaysBlock() && (!allowSequentialLogic || signalGate == portEnclosingGate.getEnclosingGate())) continue;
            listIterator.remove();
            visited.add(port);
            KLayDiagramDebug.debugInfo(KLayDiagramDebug.DebugRegion.FLOW_DIAGRAM_CONSTRUCTION, "Removed port", port);
            for (NLPort logicSourcePort : portEnclosingGate.getSourcePorts()) {
                if (visited.contains(logicSourcePort) || sourcePorts.contains(logicSourcePort)) continue;
                listIterator.add(logicSourcePort);
                KLayDiagramDebug.debugInfo(KLayDiagramDebug.DebugRegion.FLOW_DIAGRAM_CONSTRUCTION, "Added port", logicSourcePort);
            }
            listIterator = sourcePorts.listIterator();
        }
        return sourcePorts;
    }

    @NotNull
    public static List<NLPort> getDestinationPortsSkippingLogic(NLConnection signal, boolean allowSequentialLogic, DProgressMonitor monitor) throws DCanceledException {
        NLUtils.checkCanceled(monitor);
        if (signal == null) {
            return Collections.emptyList();
        }
        KLayDiagramDebug.debugInfo(KLayDiagramDebug.DebugRegion.FLOW_DIAGRAM_CONSTRUCTION, "Destination ports skipping logic for ", signal);
        Collection destinationPorts = signal.getDestinationPorts();
        HashSet<NLPort> visited = new HashSet<NLPort>();
        ListIterator<NLPort> listIterator = destinationPorts.listIterator();
        NLGate signalGate = signal.getEnclosingGate();
        while (listIterator.hasNext()) {
            NLPort port = (NLPort)listIterator.next();
            NLUtils.checkCanceled(monitor);
            NLGate portEnclosingGate = port.getEnclosingGate();
            if (!(portEnclosingGate instanceof NLLogicGate) || portEnclosingGate.isSequentialAlwaysBlock() && (!allowSequentialLogic || signalGate == portEnclosingGate.getEnclosingGate())) continue;
            listIterator.remove();
            visited.add(port);
            KLayDiagramDebug.debugInfo(KLayDiagramDebug.DebugRegion.FLOW_DIAGRAM_CONSTRUCTION, "Removed port", port);
            for (NLPort logicDestinationPort : portEnclosingGate.getDestinationPorts()) {
                if (visited.contains(logicDestinationPort) || destinationPorts.contains(logicDestinationPort)) continue;
                listIterator.add(logicDestinationPort);
                KLayDiagramDebug.debugInfo(KLayDiagramDebug.DebugRegion.FLOW_DIAGRAM_CONSTRUCTION, "Added port", logicDestinationPort);
            }
            listIterator = destinationPorts.listIterator();
        }
        return destinationPorts;
    }

    public static String getFlowEdgeName(NLGate source, NLGate destination) {
        StringBuilder builder = new StringBuilder();
        if (source == null || destination == null) {
            return builder.toString();
        }
        String sourceName = source.getName();
        String destinationName = destination.getName();
        if (sourceName == null || destinationName == null) {
            return builder.toString();
        }
        builder.append(sourceName).append(FLOW_EDGE_SEPARATOR).append(destinationName);
        return NLUtils.getNLName(builder.toString());
    }

    public static String getFlowEdgeName(Collection<NLGate> sourceGates, Collection<NLGate> destinationGates, NLPort.NLPortDirection portDirection) {
        StringBuilder builder = new StringBuilder();
        if (sourceGates == null || destinationGates == null || sourceGates.isEmpty() || destinationGates.isEmpty()) {
            return builder.toString();
        }
        builder.append(sourceGates).append(FLOW_EDGE_SEPARATOR).append(destinationGates);
        if (portDirection != NLPort.NLPortDirection.DIR_NONE) {
            builder.append(FLOW_EDGE_SEPARATOR).append((Object)portDirection);
        }
        return NLUtils.getNLName(builder.toString());
    }

    public static String getSameNamedPortName(String nlName) {
        return nlName + "__dvt__internal__me__port";
    }

    public static boolean isSameNamedPortName(String nlName) {
        return nlName != null ? nlName.indexOf("__dvt__internal__me__port") > -1 : false;
    }

    public static String getSelfLoopPortName(String portName) {
        return portName + "__dvt__internal__self__loop_ port";
    }

    public static boolean isSelfLoopPortName(String portName) {
        return portName != null && portName.endsWith("__dvt__internal__self__loop_ port");
    }

    public static String getPortNameFromSelfLoopPortName(String selfLoopPortName) {
        if (selfLoopPortName == null) {
            return null;
        }
        int index = selfLoopPortName.indexOf("__dvt__internal__self__loop_ port");
        if (index == -1) {
            return null;
        }
        return selfLoopPortName.substring(0, index);
    }

    public static int getHDepth(NLGate gate) {
        if (!(gate instanceof NLInstanceGate) || ((NLInstanceGate)gate).getExpandState() == NLInstanceGateExpandState.COLLAPSED || ((NLInstanceGate)gate).getExpandState() == NLInstanceGateExpandState.INVISIBLE) {
            return 1;
        }
        int max = 1;
        for (NLGate nLGate : ((NLInstanceGate)gate).getSubGates()) {
            max = Math.max(max, 1 + NLUtils.getHDepth(nLGate));
        }
        return max;
    }

    public static int getHLevel(NLGate gate) {
        if (gate == null || gate.getEnclosingGate() == null) {
            return 0;
        }
        int max = Math.max(0, 1 + NLUtils.getHLevel(gate.getEnclosingGate()));
        return max;
    }

    public static ElementPath getPath(NLGate gate) {
        if (gate == null) {
            return ElementPath.EMPTY_PATH;
        }
        String name = gate.getName();
        if (name == null) {
            return ElementPath.EMPTY_PATH;
        }
        NLInstanceGate enclosingGate = gate.getEnclosingGate();
        return ElementPath.join(enclosingGate != null ? NLUtils.getPath(enclosingGate) : null, name);
    }

    public static ElementPath getDiagramPath(NLGate gate) {
        NLInstanceGate enclosingGate;
        if (gate == null) {
            return ElementPath.EMPTY_PATH;
        }
        String label = gate.getLabel() != null ? gate.getLabel() : "";
        String name = label.contains("\n") ? label.substring(0, label.indexOf("\n")) : label;
        if (name.isEmpty()) {
            name = gate.getName();
        }
        return ElementPath.join((enclosingGate = gate.getEnclosingGate()) != null ? NLUtils.getDiagramPath(enclosingGate) : null, name);
    }

    public static ElementPath getConnectionPath(NLConnection connection) {
        if (connection == null || connection.getEnclosingGate() == null) {
            return ElementPath.EMPTY_PATH;
        }
        ElementPath path = ElementPath.join(NLUtils.getDiagramPath(connection.getEnclosingGate()), connection.getLabel());
        return path;
    }

    public static ElementPath getPortPath(NLPort port) {
        if (port == null) {
            return ElementPath.EMPTY_PATH;
        }
        ElementPath path = ElementPath.join(NLUtils.getDiagramPath(port.getEnclosingGate()), port.getLabel());
        return path;
    }

    public static ElementPath getPath(NLGate gate, Function<NLGate, String> getName) {
        if (gate == null) {
            return ElementPath.EMPTY_PATH;
        }
        String name = getName.apply(gate);
        if (name == null) {
            return ElementPath.EMPTY_PATH;
        }
        NLInstanceGate enclosingGate = gate.getEnclosingGate();
        return ElementPath.join(enclosingGate != null ? NLUtils.getPath(enclosingGate, getName) : null, name);
    }

    public static ElementPath getPath(TCNode node) {
        if (node == null) {
            return ElementPath.EMPTY_PATH;
        }
        String name = NLUtils.getNLName(node);
        if (name == null) {
            return ElementPath.EMPTY_PATH;
        }
        TCNode parent = node.parent;
        return ElementPath.join(parent != null && parent.hotVisible() ? NLUtils.getPath(parent) : null, name);
    }

    public static List<BreadcrumbSegment> getPathSegments(NLInstanceGate gate) {
        if (gate == null) {
            return Collections.emptyList();
        }
        if (gate.isTopGate()) {
            return Collections.emptyList();
        }
        NLInstanceGate enclosingGate = gate.getEnclosingGate();
        if (enclosingGate == null) {
            return Collections.emptyList();
        }
        return DHBreadcrumbUtils.toBreadcrumbSegments(gate.getMapping(DiagramInstanceWrapper.class).getHierarchyPath(), false);
    }

    public static IRfNamedElement getNLDesign(Object element) {
        if (element instanceof DiagramInstanceWrapper) {
            return ((DiagramInstanceWrapper)element).getBinding(true);
        }
        IRfNamedElement design = null;
        if (element instanceof TCNode) {
            design = DesignUtils.getDesign(((TCNode)element).designRequest());
        }
        if (element instanceof IRfNamedElement) {
            design = DesignUtils.getDesign(DesignUtils.DesignRequest.of((IRfNamedElement)element, true));
        }
        if (element instanceof ELInstance) {
            design = ((ELInstance)element).getBinding(false);
        }
        return DesignUtils.getDesignKind(design) != IRfNamedElement.ElementKind.UNKNOWN ? design : null;
    }

    public static ElementPath getGatePathToTop(NLInstanceGate gate) {
        NLInstanceGate parentGate = gate.getEnclosingGate();
        if (parentGate == null) {
            return gate.getParameters().hasPath() ? ElementPath.from(gate.getParameters().getTopPath().toString(), ".") : null;
        }
        if (gate instanceof NLELInstanceGate && gate.getKind() != NLGateKind.BLOCK) {
            DiagramInstanceWrapper mapping = gate.getMapping(DiagramInstanceWrapper.class);
            return mapping.getHierarchyPath();
        }
        ElementPath parentPath = NLUtils.getGatePathToTop(parentGate);
        if (parentPath == null) {
            return null;
        }
        parentPath = ElementPath.join(parentPath, gate.getName());
        return parentPath;
    }

    public static DVTPFModel getPFModel(Object object) {
        if (!(object instanceof NLInstanceGate)) {
            return null;
        }
        NLInstanceGate instance = (NLInstanceGate)object;
        IRfSingleLangProject rfProject = instance.getRfProject();
        if (rfProject == null) {
            return null;
        }
        IProject iproject = rfProject.getProject();
        if (iproject == null) {
            return null;
        }
        RfMixedLangProject rfMLP = RfMixedLangManager.getInstance().getRfMixedLangProject(iproject, false);
        if (rfMLP == null) {
            return null;
        }
        DVTPFModel pfModel = rfMLP.getPFModel();
        if (pfModel == null || !pfModel.hasPowerDomains()) {
            return null;
        }
        return pfModel;
    }

    public static boolean containsSelectedElements(NLAbstractBase object) {
        if (!(object instanceof NLInstanceGate)) {
            return false;
        }
        NLInstanceGate gate = (NLInstanceGate)object;
        for (NLGate nLGate : gate.getSubGates()) {
            if (nLGate.hasFlag(NLParameters.NLParametersFlag.IS_FOCUSED)) {
                return true;
            }
            if (nLGate instanceof NLInstanceGate) {
                for (NLConnection connection : ((NLInstanceGate)nLGate).getSignals()) {
                    if (!connection.hasFlag(NLParameters.NLParametersFlag.IS_FOCUSED)) continue;
                    return true;
                }
            }
            if (!NLUtils.containsSelectedElements(nLGate)) continue;
            return true;
        }
        return false;
    }

    public static SelectionNewModel copyModelForSelection(final Set<NLAbstractBase> selection, NLConfig config, final NLParameters.NLParametersFlag ... flags) {
        NLInstanceGate newModel;
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        NLInstanceGate topInstance = config.getTopInstance();
        NLAbstractBase firstSelectedElement = selection.iterator().next();
        if (topInstance == null) {
            topInstance = (NLInstanceGate)firstSelectedElement.getTopGate();
        }
        LinkedHashSet<NLAbstractBase> newSelection = new LinkedHashSet<NLAbstractBase>();
        final SelectionNewModel result = new SelectionNewModel(null, newSelection);
        result.topGate = newModel = NLProcessors.copyModel(topInstance, new BiConsumer<NLAbstractBase, NLAbstractBase>(){

            @Override
            public void accept(NLAbstractBase original, NLAbstractBase copy) {
                if (!selection.contains(original)) {
                    return;
                }
                result.selection.add(copy);
                int i = 0;
                while (i < flags.length) {
                    if (flags[i] == NLParameters.NLParametersFlag.IS_DELETED) {
                        copy.removeAllFlags();
                        if (copy.getEnclosingGate() != null) {
                            copy.getEnclosingGate().addFlag(NLParameters.NLParametersFlag.IS_ACTION_SELECTED);
                        }
                        if (copy instanceof NLInstanceGate) {
                            ((NLInstanceGate)copy).setSubGates(null);
                            ((NLInstanceGate)copy).setSignals(null);
                            for (NLPort port : ((NLInstanceGate)copy).getPorts()) {
                                port.removeAllFlags();
                            }
                        }
                        if (copy instanceof NLConnection) {
                            for (NLPort target : ((NLConnection)copy).getTargets()) {
                                if (target.getEnclosingGate().equals(copy.getEnclosingGate())) {
                                    target.removeFlag(NLParameters.NLParametersFlag.INNER_VISIBLE);
                                    continue;
                                }
                                target.removeFlag(NLParameters.NLParametersFlag.OUTER_VISIBLE);
                            }
                        }
                    }
                    copy.addFlag(flags[i]);
                    ++i;
                }
            }
        });
        return result;
    }

    public static IRfNamedElement adjustTopElement(IRfNamedElement topElement) {
        IRfNamedElement.ElementKind designKind = DesignUtils.getDesignKind(topElement);
        return designKind == IRfNamedElement.ElementKind.VHDL_ENTITY || designKind == IRfNamedElement.ElementKind.VHDL_COMPONENT ? DesignUtils.getDesign(DesignUtils.DesignRequest.of(topElement, true)) : topElement;
    }

    public static void checkCanceled(DProgressMonitor monitor) throws DCanceledException {
        if (monitor != null) {
            monitor.checkCanceled();
        }
    }

    public static class SelectionNewModel {
        NLInstanceGate topGate;
        Set<NLAbstractBase> selection;

        SelectionNewModel(NLInstanceGate topGate, Set<NLAbstractBase> selection) {
            this.topGate = topGate;
            this.selection = selection;
        }

        public NLInstanceGate getTopGate() {
            return this.topGate;
        }

        public Set<NLAbstractBase> getSelection() {
            return this.selection;
        }
    }
}

