/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.preferences;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.diagrams.fsm.editor.actions.menu.DFSMActionMessages;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.utils.DVTStringUtil;

public class DFSMPreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    Group fsmGroup;
    StringFieldEditor hideNamesInConditions;
    Combo showTransitionsCombo;

    public DFSMPreferencesPage() {
        super(1);
        this.setPreferenceStore(DVTPlugin.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        this.initializeDialogUnits((Control)parent);
        this.fsmGroup = new Group(parent, 0);
        this.fsmGroup.setText("FSM");
        GridLayoutFactory.swtDefaults().applyTo((Composite)this.fsmGroup);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fsmGroup);
        Dialog.applyDialogFont((Control)this.fsmGroup);
        BooleanFieldEditor highlightPrevAndNextStates = new BooleanFieldEditor("designdiagrams.fsm_highlight_prev_and_next_states", "Highlight previous and next states", (Composite)this.fsmGroup);
        highlightPrevAndNextStates.setPreferenceStore(DVTPlugin.getDefault().getPreferenceStore());
        this.addField((FieldEditor)highlightPrevAndNextStates);
        BooleanFieldEditor showDiagramNotifications = new BooleanFieldEditor("designdiagrams.fsm_show_notifications", "Show diagram notifications", (Composite)this.fsmGroup);
        showDiagramNotifications.setPreferenceStore(DVTPlugin.getDefault().getPreferenceStore());
        this.addField((FieldEditor)showDiagramNotifications);
        ComboFieldEditor diagramDirection = new ComboFieldEditor("designdiagrams.fsm_direction", DFSMActionMessages.preferencesDirectionText, this.getValues(PrefConst.FSM_DIAGRAM_DIRECTION_VALUES), (Composite)this.fsmGroup);
        diagramDirection.setPreferenceStore(DVTPlugin.getDefault().getPreferenceStore());
        this.addField((FieldEditor)diagramDirection);
        ComboFieldEditor placementStrategy = new ComboFieldEditor("designdiagrams.fsm_node_placement_strategy", DFSMActionMessages.preferencesPlacementStrategyText, PrefConst.FSM_NODE_PLACEMENT_STRATEGY_VALUES, (Composite)this.fsmGroup);
        placementStrategy.setPreferenceStore(DVTPlugin.getDefault().getPreferenceStore());
        this.addField((FieldEditor)placementStrategy);
        ComboFieldEditor enforceTransitionPorts = new ComboFieldEditor("designdiagrams.fsm_enforce_transition_ports", DFSMActionMessages.preferencesEnforceEdgePortSideText, this.getValues(PrefConst.FSM_ENFORCE_TRANSITION_PORTS_VALUES), (Composite)this.fsmGroup);
        enforceTransitionPorts.setPreferenceStore(DVTPlugin.getDefault().getPreferenceStore());
        this.addField((FieldEditor)enforceTransitionPorts);
        ComboFieldEditor enforceInitialState = new ComboFieldEditor("designdiagrams.fsm_enforce_initial_state_layer", DFSMActionMessages.preferencesInitialStateNodeLayerText, PrefConst.FSM_ENFORCE_INITIAL_STATE_LAYER_VALUES, (Composite)this.fsmGroup);
        enforceInitialState.setPreferenceStore(DVTPlugin.getDefault().getPreferenceStore());
        this.addField((FieldEditor)enforceInitialState);
        BooleanFieldEditor showDefaultState = new BooleanFieldEditor("designdiagrams.fsm_show_default_state", DFSMActionMessages.preferencesShowDefaultStateTextVlog, (Composite)this.fsmGroup);
        showDefaultState.setPreferenceStore(DVTPlugin.getDefault().getPreferenceStore());
        this.addField((FieldEditor)showDefaultState);
        BooleanFieldEditor loopbackTransitions = new BooleanFieldEditor("designdiagrams.fsm_loopback_transitions", DFSMActionMessages.preferencesShowLoopBackEdgesText, (Composite)this.fsmGroup);
        loopbackTransitions.setPreferenceStore(DVTPlugin.getDefault().getPreferenceStore());
        this.addField((FieldEditor)loopbackTransitions);
        this.createShowTransitionsCombo();
        this.hideNamesInConditions = new StringFieldEditor("designdiagrams.fsm_hide_names_in_conditions", DFSMActionMessages.preferencesFilterNamesText, (Composite)this.fsmGroup);
        this.hideNamesInConditions.setPreferenceStore(DVTPlugin.getDefault().getPreferenceStore());
        this.addField((FieldEditor)this.hideNamesInConditions);
        BooleanFieldEditor filterCommonExpressionsInConditions = new BooleanFieldEditor("designdiagrams.fms_filter_common_expressions_in_conditions", DFSMActionMessages.preferencesHideCommonExpressionInConditionText, (Composite)this.fsmGroup);
        filterCommonExpressionsInConditions.setPreferenceStore(DVTPlugin.getDefault().getPreferenceStore());
        this.addField((FieldEditor)filterCommonExpressionsInConditions);
        ComboFieldEditor exportTableFormat = new ComboFieldEditor("designdiagrams.fsm_export_table_format", DFSMActionMessages.exportTableFormat, PrefConst.FSM_EXPORT_TABLE_FORMAT_VALUES, (Composite)this.fsmGroup);
        exportTableFormat.setPreferenceStore(DVTPlugin.getDefault().getPreferenceStore());
        this.addField((FieldEditor)exportTableFormat);
    }

    private void createShowTransitionsCombo() {
        String[] values = PrefConst.FSM_SHOW_TRANSITION_LABELS_VALUES;
        String selectedValue = DVTPlugin.getDefault().getPreferenceStore().getString("designdiagrams.fsm_show_edge_transition_labels");
        Label showTransitionsLabel = new Label((Composite)this.fsmGroup, 0);
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)showTransitionsLabel);
        showTransitionsLabel.setText(DFSMActionMessages.preferencesShowEdgeLabelsText);
        this.showTransitionsCombo = new Combo((Composite)this.fsmGroup, 2056);
        this.showTransitionsCombo.setData((Object)values);
        int i = 0;
        while (i < values.length) {
            String value = values[i];
            this.showTransitionsCombo.add(DVTStringUtil.toNiceTitleCase(value.toString()));
            if (selectedValue.equalsIgnoreCase(value.toString())) {
                this.showTransitionsCombo.select(i);
            }
            ++i;
        }
        this.showTransitionsCombo.addModifyListener(e -> {
            String newValue = values[this.showTransitionsCombo.getSelectionIndex()];
            DVTPlugin.getDefault().getPreferenceStore().setValue("designdiagrams.fsm_show_edge_transition_labels", newValue);
        });
    }

    private String[][] getValues(String[] preferences) {
        int len = preferences.length;
        String[][] result = new String[len][2];
        int i = 0;
        while (i < len) {
            result[i][0] = DVTStringUtil.toNiceTitleCase(preferences[i]);
            result[i][1] = preferences[i];
            ++i;
        }
        return result;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        super.performDefaults();
        DVTPlugin.getDefault().getPreferenceStore().setToDefault("designdiagrams.fsm_show_edge_transition_labels");
        int i = 0;
        while (i < PrefConst.FSM_SHOW_TRANSITION_LABELS_VALUES.length) {
            if (PrefConst.FSM_SHOW_TRANSITION_LABELS_VALUES[i].equals(PrefConst.FSM_SHOW_TRANSITION_LABELS_DEFAULT)) {
                this.showTransitionsCombo.select(i);
            }
            ++i;
        }
    }
}

