/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.preferences;

import java.util.ArrayList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.diagrams.uml.preferences.UMLFilterClass;
import ro.amiq.dvt.startup.core.DVTLogger;

public abstract class TablesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Table firstTbl;
    private Table secondTbl;
    private final String firstPref;
    private final String secondPref;
    protected String firstHeader;
    protected String firstLabel;
    protected String secondHeader;
    protected String secondLabel;
    protected String defaultText;
    protected boolean firstTableCheckBox;
    protected boolean secondTableCheckBox;
    private boolean isUML = true;

    public TablesPreferencePage(String includesPref, String excludesPref) {
        this.firstPref = includesPref;
        this.secondPref = excludesPref;
    }

    public void init(IWorkbench workbench) {
        if (this.isUML) {
            this.defaultText = "pkg::class";
            this.firstHeader = "Base classes";
            this.firstLabel = "package_name::class_name";
            this.firstTableCheckBox = false;
            this.secondHeader = "Exclude the following (check the box to exclude children also)";
            this.secondLabel = "package_name::class_name";
            this.secondTableCheckBox = true;
        }
    }

    private void loadFields(Table table, String prefConst, boolean useDefaults) {
        table.removeAll();
        IPreferenceStore prefStore = DVTPlugin.getDefault().getPreferenceStore();
        String prefVal = useDefaults ? prefStore.getDefaultString(prefConst) : prefStore.getString(prefConst);
        if (this.isUML) {
            try {
                for (UMLFilterClass clazz : UMLFilterClass.readClassesFromString(prefVal)) {
                    TableItem item = new TableItem(table, 0);
                    item.setText(0, clazz.name);
                    item.setChecked(clazz.withDescendants);
                }
            }
            catch (UMLFilterClass.InvalidStringRepresentationException invalidStringRepresentationException) {
                DVTLogger.INSTANCE.logDebug("Invalid UVM Diagram classes found");
            }
        } else {
            String[] stringArray = prefVal.split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String entry = stringArray[n2];
                if (!entry.trim().isEmpty()) {
                    TableItem item = new TableItem(table, 0);
                    item.setText(0, entry.trim());
                }
                ++n2;
            }
        }
    }

    private String getString(Table tbl, GetDescendantsFromTableOption opt) {
        TableItem[] items = tbl.getItems();
        if (this.isUML) {
            ArrayList<UMLFilterClass> classes = new ArrayList<UMLFilterClass>(items.length);
            TableItem[] tableItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                classes.add(new UMLFilterClass(item.getText(), switch (opt) {
                    case GetDescendantsFromTableOption.FORCE_WITH -> true;
                    case GetDescendantsFromTableOption.FORCE_WITHOUT -> false;
                    case GetDescendantsFromTableOption.USE_TABLE_ITEM -> item.getChecked();
                    default -> {
                        DVTLogger.INSTANCE.logError("Unknown option: " + (Object)((Object)opt));
                        yield item.getChecked();
                    }
                }));
                ++n2;
            }
            return UMLFilterClass.toString(classes);
        }
        StringBuilder sb = new StringBuilder();
        TableItem[] tableItemArray = items;
        int n = items.length;
        int n3 = 0;
        while (n3 < n) {
            TableItem item = tableItemArray[n3];
            sb.append(item.getText()).append(";");
            ++n3;
        }
        return sb.toString();
    }

    protected Control createContents(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        main.setLayout((Layout)layout);
        this.firstTbl = this.makeTableSection(main, this.firstHeader, this.firstLabel, this.firstPref, this.firstTableCheckBox, false);
        this.secondTbl = this.makeTableSection(main, this.secondHeader, this.secondLabel, this.secondPref, this.secondTableCheckBox, false);
        return main;
    }

    private Table makeTableSection(Composite parent, String sectionName, String columnName, String prefConst, boolean descendantsChkbox, final boolean checkNewTableItems) {
        Group main = new Group(parent, 0);
        main.setText(sectionName);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        main.setLayout((Layout)layout);
        main.setLayoutData((Object)new GridData(1808));
        main.setFont(parent.getFont());
        final Table table = new Table((Composite)main, 0x10800 | (descendantsChkbox ? 32 : 0));
        GridData data = new GridData(1808);
        table.setLayoutData((Object)data);
        table.setHeaderVisible(this.isUML);
        table.setLinesVisible(this.isUML);
        TableColumn column = new TableColumn(table, 0);
        column.setText(columnName);
        column.pack();
        this.loadFields(table, prefConst, false);
        final TableEditor editor = new TableEditor(table);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        editor.minimumWidth = 50;
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item;
                Control oldEditor = editor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                if ((item = (TableItem)e.item) == null) {
                    return;
                }
                Text newEditor = new Text((Composite)table, 0);
                newEditor.setText(item.getText(0));
                newEditor.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent me) {
                        Text text = (Text)editor.getEditor();
                        TableItem tableItem = editor.getItem();
                        if (text.isDisposed() || tableItem.isDisposed()) {
                            return;
                        }
                        tableItem.setText(0, text.getText());
                    }
                });
                newEditor.selectAll();
                newEditor.setFocus();
                editor.setEditor((Control)newEditor, item, 0);
            }
        });
        Composite buttons = new Composite((Composite)main, 0);
        buttons.setLayout((Layout)new GridLayout());
        GridData layoutData = new GridData(1040);
        layoutData.verticalAlignment = 128;
        buttons.setLayoutData((Object)layoutData);
        Button newBtn = new Button(buttons, 8);
        newBtn.setLayoutData((Object)new GridData(768));
        newBtn.setText("New");
        newBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Control oldEditor = editor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                TableItem item = new TableItem(table, 0);
                item.setText(TablesPreferencePage.this.defaultText);
                item.setChecked(checkNewTableItems);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Button deleteBtn = new Button(buttons, 8);
        deleteBtn.setLayoutData((Object)new GridData(768));
        deleteBtn.setText("Delete");
        deleteBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int idx = table.getSelectionIndex();
                if (idx == -1) {
                    return;
                }
                Control oldEditor = editor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                table.remove(idx);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        return table;
    }

    public boolean performOk() {
        IPreferenceStore prefStore = DVTPlugin.getDefault().getPreferenceStore();
        prefStore.setValue(this.firstPref, this.getString(this.firstTbl, GetDescendantsFromTableOption.FORCE_WITH));
        prefStore.setValue(this.secondPref, this.getString(this.secondTbl, GetDescendantsFromTableOption.USE_TABLE_ITEM));
        DVTPlugin.getDefault().savePreferences();
        return true;
    }

    protected void performDefaults() {
        this.loadFields(this.firstTbl, this.firstPref, true);
        this.loadFields(this.secondTbl, this.secondPref, true);
        super.performDefaults();
    }

    protected static enum GetDescendantsFromTableOption {
        FORCE_WITH,
        FORCE_WITHOUT,
        USE_TABLE_ITEM;

    }
}

