/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.tables;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.diagrams.tables.ITableRowData;
import ro.amiq.dvt.diagrams.tables.ITableWrapper;
import ro.amiq.dvt.diagrams.tables.TableExportFormat;
import ro.amiq.dvt.diagrams.tables.TableExportUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.StoppableJob;

public class TableExportJob
extends StoppableJob {
    private static final String GENERATING_ERROR_MESSAGE = "Error while generating {0} table.";
    private TableExportFormat extension;
    private ITableWrapper model;
    private List<? extends ITableRowData> rows;

    public TableExportJob(String name, TableExportFormat extension, ITableWrapper model, List<? extends ITableRowData> rows) {
        super(name);
        this.extension = extension;
        this.model = model;
        this.rows = rows;
    }

    @Override
    protected IStatus stoppableRun(IProgressMonitor monitor) {
        try {
            try {
                monitor.beginTask("Generate " + (Object)((Object)this.extension), -1);
                String tableContent = TableExportUtils.INSTANCE.exportTableToFormat(this.extension, this.model, this.rows);
                StringSelection stringSelection = new StringSelection(tableContent);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(stringSelection, null);
                PlatformUI.getWorkbench().getDisplay().asyncExec(() -> TableExportUtils.INSTANCE.displayStatusNotification(this.model.getTableName()));
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                Status status = new Status(4, "ro.amiq.dvt", MessageFormat.format(GENERATING_ERROR_MESSAGE, this.model.getTableName()), (Throwable)e);
                monitor.done();
                return status;
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }
}

