/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.tables;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang.StringUtils;
import ro.amiq.dvt.diagrams.tables.ITableRowData;
import ro.amiq.dvt.diagrams.tables.ITableWrapper;
import ro.amiq.dvt.diagrams.tables.TableExportFormat;
import ro.amiq.dvt.diagrams.tables.TableExportJob;
import ro.amiq.dvt.ui.smartcopy.SmartCopyUtils;
import ro.amiq.dvt.utils.DVTStringUtil;

public enum TableExportUtils {
    INSTANCE;

    public static final String EXPORT_TABLE_JOB_NAME = "Copying Table";
    private static final String TABLE_COPIED_MESSAGE = "{0} copied to Clipboard!";
    private static final Pattern LOGICAL_OR_PATTERN;

    static {
        LOGICAL_OR_PATTERN = Pattern.compile("\\|");
    }

    public void copyToClipboard(TableExportFormat extension, ITableWrapper model) {
        this.copyToClipboard(extension, model, model.getTableRows());
    }

    public void copyToClipboard(TableExportFormat extension, ITableWrapper model, List<? extends ITableRowData> rows) {
        TableExportJob job = new TableExportJob(EXPORT_TABLE_JOB_NAME, extension, model, rows);
        job.setPriority(30);
        job.setUser(true);
        job.schedule();
    }

    public String exportTableToFormat(TableExportFormat format, ITableWrapper model) {
        return this.exportTableToFormat(format, model, model.getTableRows());
    }

    public String exportTableToFormat(TableExportFormat format, ITableWrapper model, List<? extends ITableRowData> rows) {
        switch (format) {
            case CSV: {
                return this.tableToCSV(model, rows);
            }
            case MarkDown: {
                return this.tableToMarkDown(model, rows);
            }
            case AsciiDoc: {
                return this.tableToASCIIDoc(model, rows);
            }
            case rST: {
                return this.tableToSphinx(model, rows);
            }
        }
        return "";
    }

    private String tableToCSV(ITableWrapper model, List<? extends ITableRowData> rows) {
        StringBuilder sb = new StringBuilder();
        List<String> headers = model.getTableHeaders();
        sb.append(headers.stream().collect(Collectors.joining(", "))).append(System.lineSeparator());
        rows.stream().filter(row -> !row.shouldFilterRow()).forEach(row -> {
            StringBuilder stringBuilder2 = sb.append(IntStream.range(0, headers.size()).mapToObj(i -> model.getTableColumnValue((ITableRowData)row, i)).collect(Collectors.joining(", "))).append("\n");
        });
        return sb.toString();
    }

    private String tableToMarkDown(ITableWrapper model, List<? extends ITableRowData> rows) {
        StringBuilder sb = new StringBuilder("| ");
        List<String> headers = model.getTableHeaders();
        List<Integer> maxLengthForAllCollumns = this.getMaxLengthForAllCollumns(model, rows);
        IntStream.range(0, headers.size()).forEach(i -> {
            StringBuilder stringBuilder2 = sb.append((String)headers.get(i)).append(StringUtils.repeat((String)" ", (int)((Integer)maxLengthForAllCollumns.get(i) - ((String)headers.get(i)).length()))).append("| ");
        });
        sb.append(System.lineSeparator());
        IntStream.range(0, headers.size()).forEach(i -> {
            StringBuilder stringBuilder2 = sb.append("|:").append(StringUtils.repeat((String)"-", (int)((Integer)maxLengthForAllCollumns.get(i) - 1))).append(":");
        });
        sb.append("|").append(System.lineSeparator());
        for (ITableRowData iTableRowData : rows) {
            if (iTableRowData.shouldFilterRow()) continue;
            sb.append("| ");
            int i2 = 0;
            while (i2 < headers.size()) {
                String tableCell = model.getTableColumnValue(iTableRowData, i2);
                tableCell = DVTStringUtil.replaceAll(LOGICAL_OR_PATTERN, tableCell, "\\\\|");
                sb.append(tableCell);
                sb.append(StringUtils.repeat((String)" ", (int)(maxLengthForAllCollumns.get(i2) - tableCell.length())));
                sb.append("| ");
                ++i2;
            }
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }

    private String tableToASCIIDoc(ITableWrapper model, List<? extends ITableRowData> rows) {
        StringBuilder sb = new StringBuilder();
        List<String> headers = model.getTableHeaders();
        List<Integer> columnLengths = this.getMaxLengthForAllCollumns(model, rows);
        Integer DEFAULT_COLUMN_WIDTH = 10;
        sb.append("[%header,cols=\"");
        sb.append(DEFAULT_COLUMN_WIDTH).append(StringUtils.repeat((String)(", " + DEFAULT_COLUMN_WIDTH), (int)(headers.size() - 1)));
        sb.append("\"]").append(System.lineSeparator()).append("|===").append(System.lineSeparator());
        IntStream.range(0, headers.size()).forEach(i -> {
            StringBuilder stringBuilder2 = sb.append("| ").append((String)headers.get(i)).append(StringUtils.repeat((String)" ", (int)((Integer)columnLengths.get(i) - ((String)headers.get(i)).length())));
        });
        sb.append(System.lineSeparator());
        for (ITableRowData iTableRowData : rows) {
            if (iTableRowData.shouldFilterRow()) continue;
            int i2 = 0;
            while (i2 < headers.size()) {
                String tableCell = model.getTableColumnValue(iTableRowData, i2);
                tableCell = DVTStringUtil.replaceAll(LOGICAL_OR_PATTERN, tableCell, "\\\\|");
                sb.append("| ").append(tableCell);
                sb.append(StringUtils.repeat((String)" ", (int)(columnLengths.get(i2) - tableCell.length())));
                ++i2;
            }
            sb.append(System.lineSeparator());
        }
        sb.append("|===");
        return sb.toString();
    }

    private String tableToSphinx(ITableWrapper model, List<? extends ITableRowData> rows) {
        StringBuilder sb = new StringBuilder(".. list-table:: ");
        sb.append(model.getTableName()).append(System.lineSeparator());
        List<String> headers = model.getTableHeaders();
        sb.append("   :widths: ");
        headers.stream().forEach(h -> {
            StringBuilder stringBuilder2 = sb.append(10).append(" ");
        });
        sb.append(System.lineSeparator());
        sb.append("   :header-rows: 1").append(System.lineSeparator()).append(System.lineSeparator());
        sb.append("   * - ");
        sb.append(headers.stream().collect(Collectors.joining(String.valueOf(System.lineSeparator()) + "     - ")));
        sb.append(System.lineSeparator());
        rows.stream().filter(row -> !row.shouldFilterRow()).forEach(row -> {
            sb.append("   * - ");
            sb.append(IntStream.range(0, headers.size()).mapToObj(i -> model.getTableColumnValue((ITableRowData)row, i)).collect(Collectors.joining(String.valueOf(System.lineSeparator()) + "     - ")));
            sb.append(System.lineSeparator());
        });
        return sb.toString();
    }

    private List<Integer> getMaxLengthForAllCollumns(ITableWrapper model, List<? extends ITableRowData> rows) {
        Integer CELL_PADDING = 4;
        List<String> headers = model.getTableHeaders();
        ArrayList<Integer> columnLengths = new ArrayList<Integer>(headers.size());
        ListIterator<String> iterator = headers.listIterator();
        while (iterator.hasNext()) {
            int maxLength = 0;
            for (ITableRowData iTableRowData : rows) {
                String tableColumnValue = model.getTableColumnValue(iTableRowData, iterator.nextIndex());
                if (tableColumnValue == null || tableColumnValue.isEmpty()) continue;
                maxLength = Math.max(tableColumnValue.length(), maxLength);
            }
            maxLength = Math.max(maxLength, iterator.next().length());
            columnLengths.add(maxLength + CELL_PADDING);
        }
        return columnLengths;
    }

    public void displayStatusNotification(String tableName) {
        SmartCopyUtils.updateStatusBarWithInfo(MessageFormat.format(TABLE_COPIED_MESSAGE, tableName));
    }
}

