/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.uml;

import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KGraphElement;
import de.cau.cs.kieler.core.kgraph.KLabel;
import de.cau.cs.kieler.core.kgraph.KLabeledGraphElement;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.kgraph.KPort;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.kiml.klayoutdata.KEdgeLayout;
import de.cau.cs.kieler.kiml.klayoutdata.KIdentifier;
import de.cau.cs.kieler.kiml.klayoutdata.KLayoutDataFactory;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.options.Direction;
import de.cau.cs.kieler.kiml.options.EdgeLabelPlacement;
import de.cau.cs.kieler.kiml.options.EdgeRouting;
import de.cau.cs.kieler.kiml.options.EdgeType;
import de.cau.cs.kieler.kiml.options.HierarchyHandling;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.NodeLabelPlacement;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.kiml.options.SizeConstraint;
import de.cau.cs.kieler.kiml.options.SizeOptions;
import de.cau.cs.kieler.kiml.util.KimlUtil;
import de.cau.cs.kieler.klay.layered.p2layers.LayeringStrategy;
import de.cau.cs.kieler.klay.layered.p3order.CrossingMinimizationStrategy;
import de.cau.cs.kieler.klay.layered.p4nodes.NodePlacementStrategy;
import de.cau.cs.kieler.klay.layered.properties.GreedySwitchType;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import de.cau.cs.kieler.klay.layered.properties.SelfLoopPlacement;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import ro.amiq.dvt.diagrams.klay.model.KLaySize;
import ro.amiq.dvt.diagrams.klay.model.KLayWrapper;
import ro.amiq.dvt.diagrams.uml.UMLDiagramConfiguration;
import ro.amiq.dvt.diagrams.uml.model.IUMLElement;
import ro.amiq.dvt.diagrams.uml.model.UMLAbstractEdge;
import ro.amiq.dvt.diagrams.uml.model.UMLAssociationEdge;
import ro.amiq.dvt.diagrams.uml.model.UMLInheritanceEdge;
import ro.amiq.dvt.diagrams.uml.model.UMLModel;
import ro.amiq.dvt.diagrams.uml.model.UMLNode;
import ro.amiq.dvt.diagrams.uml.model.UMLNodeMember;
import ro.amiq.dvt.diagrams.uml.model.UMLPackage;
import ro.amiq.dvt.diagrams.uml.rendering.UMLRenderingUtils;
import ro.amiq.dvt.draw.utils.FontFactory;

public class UMLDiagramAdapter {
    private final UMLDiagramConfiguration config;
    private final UMLModel model;
    private final String layoutAlgorithm = "de.cau.cs.kieler.klay.layered";

    public UMLDiagramAdapter(UMLModel model) {
        this.config = model.getConfig();
        this.model = model;
    }

    public void setKMainNodeInfo(KNode node, UMLNode umlNode, UMLDiagramConfiguration config) {
        this.setKIdentifier((KGraphElement)node, this.getKIdentifier(umlNode));
        UMLRenderingUtils.renderNode(node, umlNode, config);
        if (node.getChildren().isEmpty()) {
            this.setKLabels((KLabeledGraphElement)node, umlNode);
        }
        KShapeLayout nodeShapeLayout = (KShapeLayout)node.getData(KShapeLayout.class);
        this.setKNodeLayoutOptions(nodeShapeLayout, Direction.RIGHT, this.getKNodeSizeOptions(), this.getKNodeSizeConstraint(), this.getKNodeHierarchyHandling(), this.getKNodePortContraints());
        this.setLNodeLayeredOptions(nodeShapeLayout);
    }

    public void setKMethodsNodeInfo(KNode node, UMLNode umlNode) {
        if (umlNode == null) {
            return;
        }
        this.setKIdentifier((KGraphElement)node, this.getKIdentifier(umlNode));
        UMLRenderingUtils.renderNode(node, umlNode, null);
        this.setKMethodsLabels(node, umlNode);
        KShapeLayout nodeShapeLayout = (KShapeLayout)node.getData(KShapeLayout.class);
        this.setKNodeLayoutOptions(nodeShapeLayout, Direction.RIGHT, this.getKNodeSizeOptions(), this.getKNodeSizeConstraint(), this.getKNodeHierarchyHandling(), this.getKNodePortContraints());
        this.setLNodeLayeredOptions(nodeShapeLayout);
    }

    public void setKFieldsNodeInfo(KNode node, UMLNode umlNode) {
        if (umlNode == null) {
            return;
        }
        this.setKIdentifier((KGraphElement)node, this.getKIdentifier(umlNode));
        UMLRenderingUtils.renderNode(node, umlNode, null);
        this.setKFieldsLabels(node, umlNode);
        KShapeLayout nodeShapeLayout = (KShapeLayout)node.getData(KShapeLayout.class);
        this.setKNodeLayoutOptions(nodeShapeLayout, Direction.RIGHT, this.getKNodeSizeOptions(), this.getKNodeSizeConstraint(), this.getKNodeHierarchyHandling(), this.getKNodePortContraints());
        this.setLNodeLayeredOptions(nodeShapeLayout);
    }

    public void setKEventsNodeInfo(KNode node, UMLNode umlNode) {
        if (umlNode == null) {
            return;
        }
        this.setKIdentifier((KGraphElement)node, this.getKIdentifier(umlNode));
        UMLRenderingUtils.renderNode(node, umlNode, null);
        this.setKEventsLabels(node, umlNode);
        KShapeLayout nodeShapeLayout = (KShapeLayout)node.getData(KShapeLayout.class);
        this.setKNodeLayoutOptions(nodeShapeLayout, Direction.RIGHT, this.getKNodeSizeOptions(), this.getKNodeSizeConstraint(), this.getKNodeHierarchyHandling(), this.getKNodePortContraints());
        this.setLNodeLayeredOptions(nodeShapeLayout);
    }

    public void setKEdgeInfo(KEdge edge, UMLAbstractEdge umlEdge, EdgeType edgeType, boolean addLabel) {
        if (umlEdge == null) {
            return;
        }
        this.setKIdentifier((KGraphElement)edge, this.getKIdentifier(umlEdge));
        if (umlEdge instanceof UMLAssociationEdge) {
            UMLRenderingUtils.renderAssociationEdge(edge, this.config);
            if (edgeType == null) {
                edgeType = EdgeType.ASSOCIATION;
            }
            if (!umlEdge.getSource().fields.isEmpty()) {
                for (UMLNodeMember field : umlEdge.getSource().fields) {
                    if (field.getMarker() == null || !field.getMarker().equals(((UMLAssociationEdge)umlEdge).getMarker())) continue;
                    field.setKEdge(edge);
                    break;
                }
            }
        } else {
            UMLRenderingUtils.renderInheritanceEdge(edge, (UMLInheritanceEdge)umlEdge, this.config);
            if (edgeType == null) {
                edgeType = ((UMLInheritanceEdge)umlEdge).isImplements() ? EdgeType.GENERALIZATION : EdgeType.DIRECTED;
            }
        }
        if (!(!addLabel || umlEdge.getSource().equals(umlEdge.getDestination()) && this.config.get(UMLDiagramConfiguration.UMLConfigKey.ORTHOGONAL_EDGE_ROUTING).booleanValue())) {
            this.setKLabels((KLabeledGraphElement)edge, umlEdge);
        }
        this.setKEdgeLayoutOptions((KEdgeLayout)edge.getData(KEdgeLayout.class), edgeType, this.getKEdgeThickness());
    }

    private void setKNodeLayoutOptions(KShapeLayout nodeLayout, Direction direction, EnumSet<SizeOptions> nodeSizeOptions, EnumSet<SizeConstraint> nodeSizeContraints, HierarchyHandling hierarchyHandling, PortConstraints portConstraints) {
        if (nodeLayout == null) {
            return;
        }
        nodeLayout.setProperty(LayoutOptions.DIRECTION, (Object)direction);
        nodeLayout.setProperty(LayoutOptions.ALGORITHM, (Object)"de.cau.cs.kieler.klay.layered");
        nodeLayout.setProperty(LayoutOptions.SIZE_OPTIONS, nodeSizeOptions);
        nodeLayout.setProperty(LayoutOptions.SIZE_CONSTRAINT, nodeSizeContraints);
        nodeLayout.setProperty(LayoutOptions.PORT_CONSTRAINTS, (Object)portConstraints);
        nodeLayout.setProperty(LayoutOptions.HIERARCHY_HANDLING, (Object)hierarchyHandling);
    }

    private void setKEdgeLayoutOptions(KEdgeLayout edgeLayout, EdgeType edgeType, float edgeThickness) {
        if (edgeLayout == null) {
            return;
        }
        if (edgeType != null) {
            edgeLayout.setProperty(LayoutOptions.EDGE_TYPE, (Object)edgeType);
        }
        edgeLayout.setProperty(LayoutOptions.EDGE_ROUTING, (Object)this.getEdgeRouting());
        edgeLayout.setProperty(LayoutOptions.THICKNESS, (Object)Float.valueOf(Math.max(edgeThickness, 2.0f)));
    }

    private void setKLabels(KLabeledGraphElement parent, IUMLElement object) {
        if (parent == null || object == null) {
            return;
        }
        if (object instanceof UMLPackage) {
            KLabel label = KimlUtil.createInitializedLabel((KLabeledGraphElement)parent);
            String padding = "  ";
            String packageName = ((UMLPackage)object).getName();
            label.setText(String.valueOf(padding) + packageName + padding);
            label.getData().add((Object)KLayWrapper.of(object));
            this.setKIdentifier((KGraphElement)label, "package_label_for_" + packageName);
            UMLRenderingUtils.renderLabel(label, object);
            this.setKPackageLabelLayoutOptions((KShapeLayout)label.getData(KShapeLayout.class), this.getKLabelFixedSize(label));
        } else if (object instanceof UMLNode) {
            String text = this.config.get(UMLDiagramConfiguration.UMLConfigKey.SHOW_PACKAGE_INFORMATION) != false ? ((UMLNode)object).getFullName() : ((UMLNode)object).getName();
            if (text == null) {
                return;
            }
            this.setKLabel(object, text, parent);
        } else if (object instanceof UMLAssociationEdge) {
            UMLAssociationEdge edge = (UMLAssociationEdge)object;
            String text = edge.getInstanceName();
            if (text == null) {
                return;
            }
            this.setKLabel(edge, text, parent);
        } else {
            UMLInheritanceEdge edge = (UMLInheritanceEdge)object;
            this.setKLabel(edge, edge.getEdgeLabel(), parent);
        }
    }

    private void setKLabel(IUMLElement object, String text, KLabeledGraphElement parent) {
        if (text == null || text.isEmpty()) {
            return;
        }
        KLabel label = KimlUtil.createInitializedLabel((KLabeledGraphElement)parent);
        if (object != null) {
            label.getData().add((Object)KLayWrapper.of(object));
        }
        if (object instanceof UMLNodeMember) {
            for (UMLAbstractEdge edge : this.model.diagramEdges.keySet()) {
                UMLAssociationEdge actualEdge;
                if (!(edge instanceof UMLAssociationEdge) || (actualEdge = (UMLAssociationEdge)edge).getMarker() == null || !actualEdge.getMarker().equals(((UMLNodeMember)object).getMarker())) continue;
                actualEdge.setKLabel(label);
                break;
            }
        }
        String padding = "  ";
        label.setText(String.valueOf(padding) + text + padding);
        this.setKLabelInfo(label, object);
    }

    private void setKLabelInfo(KLabel label, IUMLElement object) {
        this.setKIdentifier((KGraphElement)label, this.getKIdentifier(object));
        UMLRenderingUtils.renderLabel(label, object);
        this.setKLabelLayoutOptions((KShapeLayout)label.getData(KShapeLayout.class), this.getKLabelFixedSize(label), label, object);
    }

    private PortConstraints getKNodePortContraints() {
        return PortConstraints.FIXED_SIDE;
    }

    private void setKIdentifier(KGraphElement kElement, String id) {
        KIdentifier identifier = (KIdentifier)kElement.getData(KIdentifier.class);
        if (identifier != null) {
            return;
        }
        identifier = KLayoutDataFactory.eINSTANCE.createKIdentifier();
        identifier.setId(id);
        kElement.getData().add((Object)identifier);
    }

    private String getKIdentifier(IUMLElement element) {
        if (element == null) {
            return "Root";
        }
        return element.getID();
    }

    private void setLNodeLayeredOptions(KShapeLayout nodeLayout) {
        if (nodeLayout == null) {
            return;
        }
        nodeLayout.setProperty(Properties.FEEDBACK_EDGES, (Object)true);
        nodeLayout.setProperty(Properties.SPLINE_SELF_LOOP_PLACEMENT, (Object)SelfLoopPlacement.EQUALLY_DISTRIBUTED);
    }

    private HierarchyHandling getKNodeHierarchyHandling() {
        return HierarchyHandling.INHERIT;
    }

    private EnumSet<SizeConstraint> getKNodeSizeConstraint() {
        return EnumSet.of(SizeConstraint.MINIMUM_SIZE, SizeConstraint.NODE_LABELS);
    }

    private EnumSet<SizeOptions> getKNodeSizeOptions() {
        return EnumSet.of(SizeOptions.DEFAULT_MINIMUM_SIZE);
    }

    private void setKLabelLayoutOptions(KShapeLayout layout, Point size, KLabel label, IUMLElement object) {
        if (layout == null) {
            return;
        }
        layout.setSize((float)size.x, (float)size.y);
        String text = label.getText();
        if (text.trim().length() > 0) {
            char c = text.trim().charAt(0);
            if (object instanceof UMLNode && text.contains(((UMLNode)object).getName())) {
                layout.setProperty(LayoutOptions.NODE_LABEL_PLACEMENT, (Object)NodeLabelPlacement.insideTopCenter());
            }
            if (c == '+' || c == '#' || c == '-' || c == '~') {
                layout.setProperty(LayoutOptions.NODE_LABEL_PLACEMENT, (Object)NodeLabelPlacement.insideTopLeft());
            }
            if (text.trim().matches("_*")) {
                layout.setProperty(LayoutOptions.NODE_LABEL_PLACEMENT, (Object)NodeLabelPlacement.insideTopLeft());
            }
        }
        layout.setProperty(LayoutOptions.EDGE_LABEL_PLACEMENT, (Object)EdgeLabelPlacement.CENTER);
    }

    private Point getKLabelFixedSize(KLabel label) {
        if (label == null) {
            return new Point(0, 0);
        }
        FontData fontData = UMLRenderingUtils.getFontData(label);
        if (fontData == null) {
            return new Point(0, 0);
        }
        return FontFactory.getInstance().stringExtent(label.getText(), fontData);
    }

    private float getKEdgeThickness() {
        return 2.0f;
    }

    public void setKPortInfo(KPort port, String portID, boolean isOutgoing) {
        this.setKIdentifier((KGraphElement)port, portID);
        UMLRenderingUtils.renderPort(port);
        this.setKPortLayoutOptions((KShapeLayout)port.getData(KShapeLayout.class), this.getKPortSide(isOutgoing));
    }

    private void setKPortLayoutOptions(KShapeLayout portLayout, PortSide side) {
        if (portLayout == null) {
            return;
        }
        portLayout.setProperty(LayoutOptions.PORT_SIDE, (Object)(side != null ? side : PortSide.UNDEFINED));
        portLayout.setSize(0.0f, 0.0f);
    }

    private PortSide getKPortSide(boolean isOutgoing) {
        Direction diagramDirection = this.config.get(UMLDiagramConfiguration.UMLConfigKey.DIRECTION);
        switch (diagramDirection) {
            case DOWN: {
                return isOutgoing ? PortSide.SOUTH : PortSide.NORTH;
            }
            case UP: {
                return isOutgoing ? PortSide.NORTH : PortSide.SOUTH;
            }
            case LEFT: {
                return isOutgoing ? PortSide.WEST : PortSide.EAST;
            }
            case RIGHT: {
                return isOutgoing ? PortSide.EAST : PortSide.WEST;
            }
        }
        return PortSide.UNDEFINED;
    }

    public void setKNodesSpacingInfo(Map<String, KNode> kNodes) {
        if (kNodes == null || kNodes.isEmpty()) {
            return;
        }
        for (KNode kNode : kNodes.values()) {
            KShapeLayout childLayout;
            KShapeLayout nodeLayout;
            KLayWrapper data = (KLayWrapper)kNode.getData(KLayWrapper.class);
            if (data != null && data.getOrigin() instanceof UMLPackage || (nodeLayout = (KShapeLayout)kNode.getData(KShapeLayout.class)) == null) continue;
            KLaySize size = this.getKNodeSpacingInfo(nodeLayout, (List<KLabel>)kNode.getLabels(), 4.0f);
            for (KNode child : kNode.getChildren()) {
                childLayout = (KShapeLayout)child.getData(KShapeLayout.class);
                if (childLayout == null) continue;
                KLaySize localNew = this.getKNodeSpacingInfo(childLayout, (List<KLabel>)child.getLabels(), 4.0f);
                childLayout.setProperty(LayoutOptions.MIN_HEIGHT, (Object)Float.valueOf(localNew.height));
                size.width = Math.max(size.width, localNew.width);
                size.height += localNew.height;
            }
            for (KNode child : kNode.getChildren()) {
                childLayout = (KShapeLayout)child.getData(KShapeLayout.class);
                if (childLayout == null) continue;
                childLayout.setProperty(LayoutOptions.MIN_WIDTH, (Object)Float.valueOf(size.width));
            }
            nodeLayout.setProperty(LayoutOptions.MIN_HEIGHT, (Object)Float.valueOf(size.height));
            nodeLayout.setProperty(LayoutOptions.MIN_WIDTH, (Object)Float.valueOf(size.width));
        }
    }

    private KLaySize getKNodeSpacingInfo(KShapeLayout nodeLayout, List<KLabel> labels, float labelSpacing) {
        nodeLayout.setProperty(LayoutOptions.LABEL_SPACING, (Object)Float.valueOf(labelSpacing));
        nodeLayout.setProperty(LayoutOptions.BORDER_SPACING, (Object)Float.valueOf(0.0f));
        nodeLayout.setProperty(LayoutOptions.SPACING, (Object)Float.valueOf(0.0f));
        KLaySize nLSpace = this.computeSpaceForNodeLabels(labels, labelSpacing);
        return nLSpace;
    }

    private KLaySize computeSpaceForNodeLabels(List<KLabel> nodeLabels, float labelSpacing) {
        KLaySize size = KLaySize.of(0.0f, 0.0f);
        if (nodeLabels == null || nodeLabels.isEmpty()) {
            return size;
        }
        for (KLabel nodeLabel : nodeLabels) {
            KShapeLayout labelLayout = (KShapeLayout)nodeLabel.getData(KShapeLayout.class);
            float lWidth = labelLayout.getWidth() + labelSpacing;
            float lHeight = labelLayout.getHeight() + labelSpacing;
            if (size.width < lWidth) {
                size.width = lWidth;
            }
            if (nodeLabel.getText().matches("\\s*")) continue;
            size.height += lHeight;
        }
        return size;
    }

    public void setRootKNodeInfo(String title, KNode root) {
        if (root == null) {
            return;
        }
        UMLRenderingUtils.renderDummyGate(root);
        this.setKLabel(null, title, (KLabeledGraphElement)root);
        KShapeLayout layout = (KShapeLayout)root.getData(KShapeLayout.class);
        if (layout == null) {
            return;
        }
        this.setRootKNodeLayoutOptions(layout);
        this.setRootLNodeLayeredOptions(layout, this.getRootKNodePlacement());
        this.setRootKNodeSpacingOptions(layout);
    }

    private void setRootLNodeLayeredOptions(KShapeLayout nodeLayout, NodePlacementStrategy nodePlacementStrategy) {
        if (nodeLayout == null) {
            return;
        }
        nodeLayout.setProperty(Properties.NODE_PLACER, (Object)nodePlacementStrategy);
        nodeLayout.setProperty(Properties.GREEDY_SWITCH_TYPE, (Object)GreedySwitchType.TWO_SIDED_BEST_OF_UP_OR_DOWN);
        nodeLayout.setProperty(Properties.NODE_LAYERING, (Object)LayeringStrategy.NETWORK_SIMPLEX);
        nodeLayout.setProperty(Properties.CROSS_MIN, (Object)CrossingMinimizationStrategy.LAYER_SWEEP);
        nodeLayout.setProperty(Properties.FEEDBACK_EDGES, (Object)true);
        nodeLayout.setProperty(Properties.SPLINE_SELF_LOOP_PLACEMENT, (Object)SelfLoopPlacement.EQUALLY_DISTRIBUTED);
    }

    private void setRootKNodeSpacingOptions(KShapeLayout nodeLayout) {
        if (nodeLayout == null) {
            return;
        }
        nodeLayout.setProperty(LayoutOptions.SPACING, (Object)Float.valueOf(20.0f));
        nodeLayout.setProperty(LayoutOptions.BORDER_SPACING, (Object)Float.valueOf(12.0f));
        nodeLayout.setProperty((IProperty)Properties.EDGE_NODE_SPACING_FACTOR, (Object)Float.valueOf(1.0f));
        nodeLayout.setProperty((IProperty)Properties.EDGE_SPACING_FACTOR, (Object)Float.valueOf(1.0f));
        nodeLayout.setProperty(Properties.OBJ_SPACING_IN_LAYER_FACTOR, (Object)Float.valueOf(1.0f));
    }

    private NodePlacementStrategy getRootKNodePlacement() {
        return NodePlacementStrategy.BRANDES_KOEPF;
    }

    private EdgeRouting getEdgeRouting() {
        return this.config.get(UMLDiagramConfiguration.UMLConfigKey.ORTHOGONAL_EDGE_ROUTING) != false ? EdgeRouting.ORTHOGONAL : EdgeRouting.SPLINES;
    }

    private void setRootKNodeLayoutOptions(KShapeLayout nodeLayout) {
        if (nodeLayout == null) {
            return;
        }
        nodeLayout.setProperty(LayoutOptions.DIRECTION, (Object)this.config.get(UMLDiagramConfiguration.UMLConfigKey.DIRECTION));
        nodeLayout.setProperty(LayoutOptions.EDGE_ROUTING, (Object)this.getEdgeRouting());
        nodeLayout.setProperty(LayoutOptions.ALGORITHM, (Object)"de.cau.cs.kieler.klay.layered");
        nodeLayout.setProperty(LayoutOptions.EXPAND_NODES, (Object)true);
        nodeLayout.setProperty(LayoutOptions.HIERARCHY_HANDLING, (Object)HierarchyHandling.INCLUDE_CHILDREN);
    }

    private void setKMethodsLabels(KNode node, UMLNode umlNode) {
        for (UMLNodeMember method : umlNode.methods) {
            this.setKLabel(method, method.getMemberName(), (KLabeledGraphElement)node);
        }
    }

    private void setKFieldsLabels(KNode node, UMLNode umlNode) {
        if (umlNode.showFields) {
            for (UMLNodeMember field : umlNode.fields) {
                this.setKLabel(field, field.getMemberName(), (KLabeledGraphElement)node);
            }
        }
    }

    private void setKEventsLabels(KNode node, UMLNode umlNode) {
        if (umlNode.showEvents) {
            for (UMLNodeMember event : umlNode.events) {
                this.setKLabel(event, event.getMemberName(), (KLabeledGraphElement)node);
            }
        }
    }

    public void setPackageNodeInfo(KNode node, UMLPackage packageNode) {
        this.setKIdentifier((KGraphElement)node, "package_node__" + packageNode.getName());
        node.getData().add((Object)KLayWrapper.of(packageNode));
        UMLRenderingUtils.renderPackageNode(node);
        this.setKLabels((KLabeledGraphElement)node, packageNode);
        KShapeLayout nodeShapeLayout = (KShapeLayout)node.getData(KShapeLayout.class);
        nodeShapeLayout.setProperty(LayoutOptions.BORDER_SPACING, (Object)Float.valueOf(50.0f));
        this.setKNodeLayoutOptions(nodeShapeLayout, this.config.get(UMLDiagramConfiguration.UMLConfigKey.DIRECTION), this.getKNodeSizeOptions(), this.getKNodeSizeConstraint(), HierarchyHandling.INCLUDE_CHILDREN, this.getKNodePortContraints());
        this.setLNodeLayeredOptions(nodeShapeLayout);
    }

    private void setKPackageLabelLayoutOptions(KShapeLayout layout, Point size) {
        if (layout == null) {
            return;
        }
        layout.setSize((float)size.x, (float)size.y);
        layout.setProperty(LayoutOptions.NODE_LABEL_PLACEMENT, (Object)NodeLabelPlacement.outsideTopCenter());
    }
}

