/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.uml;

import de.cau.cs.kieler.kiml.options.Direction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.diagrams.uml.UMLConfigDefault;

public class UMLDiagramConfiguration {
    private static String prefixFromConfig = "";
    private Map<String, Object> store = new HashMap<String, Object>();
    private List<String> prefFilters;

    public String getPrefix() {
        return prefixFromConfig;
    }

    public boolean fullMethodSignature() {
        return this.get(UMLConfigKey.SHOW_FULL_METHOD_SIGNATURE);
    }

    public List<String> getPrefFilters() {
        return this.prefFilters;
    }

    public void setPrefFilters(List<String> filters) {
        this.prefFilters = filters;
    }

    public <V> void set(UMLConfigKey<V> key, V value) {
        this.store.put(key.id, value);
        if (key == UMLConfigKey.ASSOCIATIONS && value == RelationOption.ALL) {
            this.store.put(UMLConfigKey.PARENTS.id, (Object)RelationOption.ALL);
        }
    }

    public <V> V get(UMLConfigKey<V> key) {
        return (V)this.store.get(key.id);
    }

    public boolean generateForSpecador() {
        return this.get(UMLConfigKey.FOR_SPECADOR) != null;
    }

    public boolean getPublicOnly() {
        return this.get(UMLConfigKey.MEMBERS) == MembersOption.PUBLIC;
    }

    public UMLDiagramConfiguration copyConfig() {
        UMLDiagramConfiguration copy = new UMLDiagramConfiguration();
        for (Map.Entry<String, Object> entry : this.store.entrySet()) {
            copy.store.put(entry.getKey(), entry.getValue());
        }
        copy.setPrefFilters(this.getPrefFilters());
        return copy;
    }

    public Direction getDirectionFromString(String direction) {
        switch (direction.toLowerCase()) {
            case "down": 
            case "top-bottom": {
                return Direction.DOWN;
            }
            case "right": 
            case "left-right": {
                return Direction.RIGHT;
            }
            case "right-left": 
            case "left": {
                return Direction.LEFT;
            }
        }
        return Direction.UP;
    }

    public RelationOption getRelationFromString(String relation) {
        switch (relation.toLowerCase()) {
            case "all": {
                return RelationOption.ALL;
            }
            case "selected": {
                return RelationOption.SELECTED;
            }
            case "none": {
                return RelationOption.NONE;
            }
        }
        return RelationOption.CUSTOM_DEPTH;
    }

    public MembersOption getMembersFromString(String members) {
        switch (members.toLowerCase()) {
            case "all": {
                return MembersOption.ALL;
            }
            case "public": {
                return MembersOption.PUBLIC;
            }
        }
        return MembersOption.NONE;
    }

    public static final UMLDiagramConfiguration getDefault() {
        return UMLConfigDefault.getDefault();
    }

    public static final UMLDiagramConfiguration getArchDefault() {
        UMLDiagramConfiguration config = new UMLDiagramConfiguration();
        config.set(UMLConfigKey.PARENTS, RelationOption.NONE);
        config.set(UMLConfigKey.PARENTS_DEPTH, 1);
        config.set(UMLConfigKey.CHILDREN, RelationOption.NONE);
        config.set(UMLConfigKey.CHILDREN_DEPTH, 1);
        config.set(UMLConfigKey.ASSOCIATIONS, RelationOption.SELECTED);
        config.set(UMLConfigKey.ASSOCIATIONS_DEPTH, 1);
        config.set(UMLConfigKey.DIRECTION, Direction.RIGHT);
        config.set(UMLConfigKey.MEMBERS, MembersOption.NONE);
        config.set(UMLConfigKey.SHOW_METHODS, true);
        config.set(UMLConfigKey.SHOW_FIELDS, true);
        config.set(UMLConfigKey.SHOW_EVENTS, true);
        config.set(UMLConfigKey.SHOW_FULL_METHOD_SIGNATURE, false);
        config.set(UMLConfigKey.SHOW_ASSOCIATION_LABELS, true);
        config.set(UMLConfigKey.ORTHOGONAL_EDGE_ROUTING, true);
        config.set(UMLConfigKey.SHOW_PACKAGE_INFORMATION, false);
        config.set(UMLConfigKey.GROUP_BY_PACKAGE, true);
        return config;
    }

    public static UMLDiagramConfiguration getInheritanceConfig(boolean orthogonalEdgeRouting) {
        UMLDiagramConfiguration config = new UMLDiagramConfiguration();
        config.set(UMLConfigKey.PARENTS, RelationOption.ALL);
        config.set(UMLConfigKey.PARENTS_DEPTH, 1);
        config.set(UMLConfigKey.CHILDREN, RelationOption.ALL);
        config.set(UMLConfigKey.CHILDREN_DEPTH, 1);
        config.set(UMLConfigKey.ASSOCIATIONS, RelationOption.NONE);
        config.set(UMLConfigKey.ASSOCIATIONS_DEPTH, 1);
        config.set(UMLConfigKey.MEMBERS, MembersOption.NONE);
        config.set(UMLConfigKey.SHOW_METHODS, true);
        config.set(UMLConfigKey.SHOW_FIELDS, true);
        config.set(UMLConfigKey.SHOW_EVENTS, true);
        config.set(UMLConfigKey.DIRECTION, Direction.LEFT);
        config.set(UMLConfigKey.ORTHOGONAL_EDGE_ROUTING, orthogonalEdgeRouting);
        config.set(UMLConfigKey.SHOW_PACKAGE_INFORMATION, true);
        config.set(UMLConfigKey.SHOW_FULL_METHOD_SIGNATURE, false);
        config.set(UMLConfigKey.SHOW_ASSOCIATION_LABELS, true);
        config.set(UMLConfigKey.GROUP_BY_PACKAGE, false);
        config.set(UMLConfigKey.FOR_SPECADOR, true);
        return config;
    }

    public static UMLDiagramConfiguration getPackageInheritanceConfig(boolean orthogonalEdgeRouting) {
        UMLDiagramConfiguration config = new UMLDiagramConfiguration();
        config.set(UMLConfigKey.PARENTS, RelationOption.ALL);
        config.set(UMLConfigKey.PARENTS_DEPTH, 1);
        config.set(UMLConfigKey.CHILDREN, RelationOption.ALL);
        config.set(UMLConfigKey.CHILDREN_DEPTH, 1);
        config.set(UMLConfigKey.ASSOCIATIONS, RelationOption.NONE);
        config.set(UMLConfigKey.ASSOCIATIONS_DEPTH, 1);
        config.set(UMLConfigKey.MEMBERS, MembersOption.NONE);
        config.set(UMLConfigKey.SHOW_METHODS, true);
        config.set(UMLConfigKey.SHOW_FIELDS, true);
        config.set(UMLConfigKey.SHOW_EVENTS, true);
        config.set(UMLConfigKey.DIRECTION, Direction.LEFT);
        config.set(UMLConfigKey.ORTHOGONAL_EDGE_ROUTING, orthogonalEdgeRouting);
        config.set(UMLConfigKey.SHOW_PACKAGE_INFORMATION, false);
        config.set(UMLConfigKey.SHOW_FULL_METHOD_SIGNATURE, false);
        config.set(UMLConfigKey.SHOW_ASSOCIATION_LABELS, true);
        config.set(UMLConfigKey.GROUP_BY_PACKAGE, false);
        config.set(UMLConfigKey.FOR_SPECADOR, true);
        return config;
    }

    public static UMLDiagramConfiguration getCollaborationConfig(boolean orthogonalEdgeRouting) {
        UMLDiagramConfiguration config = new UMLDiagramConfiguration();
        config.set(UMLConfigKey.PARENTS, RelationOption.CUSTOM_DEPTH);
        config.set(UMLConfigKey.PARENTS_DEPTH, 1);
        config.set(UMLConfigKey.CHILDREN, RelationOption.NONE);
        config.set(UMLConfigKey.CHILDREN_DEPTH, 1);
        config.set(UMLConfigKey.ASSOCIATIONS, RelationOption.CUSTOM_DEPTH);
        config.set(UMLConfigKey.ASSOCIATIONS_DEPTH, 1);
        config.set(UMLConfigKey.MEMBERS, MembersOption.NONE);
        config.set(UMLConfigKey.SHOW_METHODS, true);
        config.set(UMLConfigKey.SHOW_FIELDS, true);
        config.set(UMLConfigKey.SHOW_EVENTS, true);
        config.set(UMLConfigKey.DIRECTION, Direction.UP);
        config.set(UMLConfigKey.ORTHOGONAL_EDGE_ROUTING, orthogonalEdgeRouting);
        config.set(UMLConfigKey.SHOW_PACKAGE_INFORMATION, true);
        config.set(UMLConfigKey.SHOW_FULL_METHOD_SIGNATURE, false);
        config.set(UMLConfigKey.SHOW_ASSOCIATION_LABELS, true);
        config.set(UMLConfigKey.GROUP_BY_PACKAGE, false);
        config.set(UMLConfigKey.FOR_SPECADOR, true);
        return config;
    }

    public static UMLDiagramConfiguration getDirectAssociationsConfig(boolean orthogonalEdgeRouting) {
        UMLDiagramConfiguration config = new UMLDiagramConfiguration();
        config.set(UMLConfigKey.PARENTS, RelationOption.NONE);
        config.set(UMLConfigKey.PARENTS_DEPTH, 1);
        config.set(UMLConfigKey.CHILDREN, RelationOption.NONE);
        config.set(UMLConfigKey.CHILDREN_DEPTH, 1);
        config.set(UMLConfigKey.ASSOCIATIONS, RelationOption.CUSTOM_DEPTH);
        config.set(UMLConfigKey.ASSOCIATIONS_DEPTH, 1);
        config.set(UMLConfigKey.MEMBERS, MembersOption.NONE);
        config.set(UMLConfigKey.SHOW_METHODS, true);
        config.set(UMLConfigKey.SHOW_FIELDS, true);
        config.set(UMLConfigKey.SHOW_EVENTS, true);
        config.set(UMLConfigKey.DIRECTION, Direction.RIGHT);
        config.set(UMLConfigKey.ORTHOGONAL_EDGE_ROUTING, orthogonalEdgeRouting);
        config.set(UMLConfigKey.SHOW_PACKAGE_INFORMATION, true);
        config.set(UMLConfigKey.SHOW_FULL_METHOD_SIGNATURE, true);
        config.set(UMLConfigKey.SHOW_ASSOCIATION_LABELS, true);
        config.set(UMLConfigKey.GROUP_BY_PACKAGE, false);
        config.set(UMLConfigKey.FOR_SPECADOR, true);
        return config;
    }

    public static UMLDiagramConfiguration getSpecadorConfig(boolean orthogonalEdgeRouting) {
        UMLDiagramConfiguration config = new UMLDiagramConfiguration();
        config.set(UMLConfigKey.PARENTS, RelationOption.NONE);
        config.set(UMLConfigKey.PARENTS_DEPTH, 1);
        config.set(UMLConfigKey.CHILDREN, RelationOption.CUSTOM_DEPTH);
        config.set(UMLConfigKey.CHILDREN_DEPTH, 1);
        config.set(UMLConfigKey.ASSOCIATIONS, RelationOption.NONE);
        config.set(UMLConfigKey.ASSOCIATIONS_DEPTH, 1);
        config.set(UMLConfigKey.MEMBERS, MembersOption.PUBLIC);
        config.set(UMLConfigKey.SHOW_METHODS, true);
        config.set(UMLConfigKey.SHOW_FIELDS, true);
        config.set(UMLConfigKey.SHOW_EVENTS, true);
        config.set(UMLConfigKey.DIRECTION, Direction.LEFT);
        config.set(UMLConfigKey.ORTHOGONAL_EDGE_ROUTING, orthogonalEdgeRouting);
        config.set(UMLConfigKey.SHOW_PACKAGE_INFORMATION, true);
        config.set(UMLConfigKey.SHOW_FULL_METHOD_SIGNATURE, false);
        config.set(UMLConfigKey.SHOW_ASSOCIATION_LABELS, true);
        config.set(UMLConfigKey.GROUP_BY_PACKAGE, false);
        config.set(UMLConfigKey.FOR_SPECADOR, true);
        return config;
    }

    public static UMLDiagramConfiguration getSpecadorCollaborationConfig(boolean orthogonalEdgeRouting) {
        UMLDiagramConfiguration config = new UMLDiagramConfiguration();
        config.set(UMLConfigKey.PARENTS, RelationOption.NONE);
        config.set(UMLConfigKey.PARENTS_DEPTH, 1);
        config.set(UMLConfigKey.CHILDREN, RelationOption.NONE);
        config.set(UMLConfigKey.CHILDREN_DEPTH, 1);
        config.set(UMLConfigKey.ASSOCIATIONS, RelationOption.CUSTOM_DEPTH);
        config.set(UMLConfigKey.ASSOCIATIONS_DEPTH, 1);
        config.set(UMLConfigKey.MEMBERS, MembersOption.PUBLIC);
        config.set(UMLConfigKey.SHOW_METHODS, true);
        config.set(UMLConfigKey.SHOW_FIELDS, true);
        config.set(UMLConfigKey.SHOW_EVENTS, true);
        config.set(UMLConfigKey.DIRECTION, Direction.RIGHT);
        config.set(UMLConfigKey.ORTHOGONAL_EDGE_ROUTING, orthogonalEdgeRouting);
        config.set(UMLConfigKey.SHOW_PACKAGE_INFORMATION, true);
        config.set(UMLConfigKey.SHOW_FULL_METHOD_SIGNATURE, false);
        config.set(UMLConfigKey.SHOW_ASSOCIATION_LABELS, true);
        config.set(UMLConfigKey.GROUP_BY_PACKAGE, false);
        config.set(UMLConfigKey.FOR_SPECADOR, true);
        return config;
    }

    public static UMLDiagramConfiguration getConfigFromString(String configArgs) {
        ArrayList<String> configList = new ArrayList<String>();
        Object object = configArgs.split(";");
        int n = ((String[])object).length;
        int n2 = 0;
        while (n2 < n) {
            String arg = object[n2];
            if (arg.trim().length() != 0) {
                configList.add(arg.trim().toLowerCase());
            }
            ++n2;
        }
        prefixFromConfig = "C_" + String.join((CharSequence)"_", configList);
        prefixFromConfig = String.valueOf(prefixFromConfig.replaceAll(" ", "_")) + "_";
        if (configList.size() < 3) {
            return null;
        }
        UMLDiagramConfiguration config = UMLDiagramConfiguration.getDefault();
        config.set(UMLConfigKey.SHOW_METHODS, false);
        config.set(UMLConfigKey.SHOW_FIELDS, false);
        config.set(UMLConfigKey.SHOW_EVENTS, false);
        config.set(UMLConfigKey.ORTHOGONAL_EDGE_ROUTING, false);
        config.set(UMLConfigKey.DIRECTION, Direction.UP);
        config.set(UMLConfigKey.SHOW_ASSOCIATION_LABELS, false);
        config.set(UMLConfigKey.GROUP_BY_PACKAGE, false);
        try {
            switch ((String)configList.get(0)) {
                case "all": {
                    config.set(UMLConfigKey.PARENTS, RelationOption.ALL);
                    break;
                }
                case "selected": {
                    config.set(UMLConfigKey.PARENTS, RelationOption.SELECTED);
                    break;
                }
                case "none": {
                    config.set(UMLConfigKey.PARENTS, RelationOption.NONE);
                    break;
                }
                default: {
                    config.set(UMLConfigKey.PARENTS, RelationOption.CUSTOM_DEPTH);
                    config.set(UMLConfigKey.PARENTS_DEPTH, Integer.parseInt((String)configList.get(0)));
                }
            }
            switch ((String)configList.get(1)) {
                case "all": {
                    config.set(UMLConfigKey.CHILDREN, RelationOption.ALL);
                    break;
                }
                case "selected": {
                    config.set(UMLConfigKey.CHILDREN, RelationOption.SELECTED);
                    break;
                }
                case "none": {
                    config.set(UMLConfigKey.CHILDREN, RelationOption.NONE);
                    break;
                }
                default: {
                    config.set(UMLConfigKey.CHILDREN, RelationOption.CUSTOM_DEPTH);
                    config.set(UMLConfigKey.CHILDREN_DEPTH, Integer.parseInt((String)configList.get(1)));
                }
            }
            switch ((String)configList.get(2)) {
                case "all": {
                    config.set(UMLConfigKey.ASSOCIATIONS, RelationOption.ALL);
                    break;
                }
                case "selected": {
                    config.set(UMLConfigKey.ASSOCIATIONS, RelationOption.SELECTED);
                    break;
                }
                case "none": {
                    config.set(UMLConfigKey.ASSOCIATIONS, RelationOption.NONE);
                    break;
                }
                default: {
                    config.set(UMLConfigKey.ASSOCIATIONS, RelationOption.CUSTOM_DEPTH);
                    config.set(UMLConfigKey.ASSOCIATIONS_DEPTH, Integer.parseInt((String)configList.get(2)));
                }
            }
            int currentIndex = 3;
            if (currentIndex >= configList.size()) {
                return config;
            }
            switch ((String)configList.get(currentIndex)) {
                case "up": {
                    config.set(UMLConfigKey.DIRECTION, Direction.UP);
                    ++currentIndex;
                    break;
                }
                case "down": {
                    config.set(UMLConfigKey.DIRECTION, Direction.DOWN);
                    ++currentIndex;
                    break;
                }
                case "right": {
                    config.set(UMLConfigKey.DIRECTION, Direction.RIGHT);
                    ++currentIndex;
                    break;
                }
                case "left": {
                    config.set(UMLConfigKey.DIRECTION, Direction.LEFT);
                    ++currentIndex;
                }
            }
            if (currentIndex >= configList.size()) {
                return config;
            }
            switch ((String)configList.get(currentIndex)) {
                case "all": {
                    config.set(UMLConfigKey.MEMBERS, MembersOption.ALL);
                    ++currentIndex;
                    break;
                }
                case "public": {
                    config.set(UMLConfigKey.MEMBERS, MembersOption.PUBLIC);
                    ++currentIndex;
                    break;
                }
                case "none": {
                    config.set(UMLConfigKey.MEMBERS, MembersOption.NONE);
                    ++currentIndex;
                }
            }
            if (currentIndex >= configList.size()) {
                return config;
            }
            int i = 0;
            while (i < 3) {
                block115: {
                    if (currentIndex > configList.size() - 1) break block115;
                    switch ((String)configList.get(currentIndex)) {
                        case "fields": {
                            config.set(UMLConfigKey.SHOW_FIELDS, true);
                            ++currentIndex;
                            break;
                        }
                        case "events": {
                            config.set(UMLConfigKey.SHOW_EVENTS, true);
                            ++currentIndex;
                            break;
                        }
                        case "methods": {
                            config.set(UMLConfigKey.SHOW_METHODS, true);
                            ++currentIndex;
                        }
                    }
                }
                ++i;
            }
            if (currentIndex >= configList.size()) {
                return config;
            }
            switch ((String)configList.get(currentIndex)) {
                case "orthogonal": {
                    config.set(UMLConfigKey.ORTHOGONAL_EDGE_ROUTING, true);
                    ++currentIndex;
                    break;
                }
                case "splines": {
                    config.set(UMLConfigKey.ORTHOGONAL_EDGE_ROUTING, false);
                    ++currentIndex;
                }
            }
            if (currentIndex >= configList.size()) {
                return config;
            }
            if (((String)configList.get(currentIndex)).equals("package")) {
                config.set(UMLConfigKey.SHOW_PACKAGE_INFORMATION, true);
                ++currentIndex;
            }
            if (currentIndex >= configList.size()) {
                return config;
            }
            if (((String)configList.get(currentIndex)).equals("full signature")) {
                config.set(UMLConfigKey.SHOW_FULL_METHOD_SIGNATURE, true);
                ++currentIndex;
            }
            if (currentIndex >= configList.size()) {
                return config;
            }
            if (((String)configList.get(currentIndex)).equals("association labels")) {
                config.set(UMLConfigKey.SHOW_ASSOCIATION_LABELS, true);
                ++currentIndex;
            }
            if (currentIndex >= configList.size()) {
                return config;
            }
            if (((String)configList.get(currentIndex)).equals("group by package")) {
                config.set(UMLConfigKey.GROUP_BY_PACKAGE, true);
                config.set(UMLConfigKey.ORTHOGONAL_EDGE_ROUTING, true);
                if (config.get(UMLConfigKey.DIRECTION) == Direction.DOWN || config.get(UMLConfigKey.DIRECTION) == Direction.UP) {
                    config.set(UMLConfigKey.DIRECTION, Direction.RIGHT);
                }
                ++currentIndex;
            }
        }
        catch (Exception exception) {
            return null;
        }
        return config;
    }

    public String convertToString() {
        StringBuilder builder = new StringBuilder();
        switch (this.get(UMLConfigKey.PARENTS)) {
            case ALL: {
                builder.append("all; ");
                break;
            }
            case SELECTED: {
                builder.append("selected; ");
                break;
            }
            case CUSTOM_DEPTH: {
                builder.append(this.get(UMLConfigKey.PARENTS_DEPTH) + "; ");
                break;
            }
            default: {
                builder.append("none; ");
            }
        }
        switch (this.get(UMLConfigKey.CHILDREN)) {
            case ALL: {
                builder.append("all; ");
                break;
            }
            case SELECTED: {
                builder.append("selected; ");
                break;
            }
            case CUSTOM_DEPTH: {
                builder.append(this.get(UMLConfigKey.CHILDREN_DEPTH) + "; ");
                break;
            }
            default: {
                builder.append("none; ");
            }
        }
        switch (this.get(UMLConfigKey.ASSOCIATIONS)) {
            case ALL: {
                builder.append("all; ");
                break;
            }
            case SELECTED: {
                builder.append("selected; ");
                break;
            }
            case CUSTOM_DEPTH: {
                builder.append(this.get(UMLConfigKey.ASSOCIATIONS_DEPTH) + "; ");
                break;
            }
            default: {
                builder.append("none; ");
            }
        }
        switch (this.get(UMLConfigKey.DIRECTION)) {
            case RIGHT: {
                builder.append("right; ");
                break;
            }
            case LEFT: {
                builder.append("left; ");
                break;
            }
            case DOWN: {
                builder.append("down; ");
            }
            default: {
                builder.append("up; ");
            }
        }
        switch (this.get(UMLConfigKey.MEMBERS)) {
            case ALL: {
                builder.append("all; ");
                break;
            }
            case PUBLIC: {
                builder.append("public; ");
                break;
            }
            default: {
                builder.append("none; ");
            }
        }
        if (this.get(UMLConfigKey.SHOW_FIELDS).booleanValue()) {
            builder.append("fields; ");
        }
        if (this.get(UMLConfigKey.SHOW_EVENTS).booleanValue()) {
            builder.append("events; ");
        }
        if (this.get(UMLConfigKey.SHOW_METHODS).booleanValue()) {
            builder.append("methods; ");
        }
        if (this.get(UMLConfigKey.ORTHOGONAL_EDGE_ROUTING).booleanValue()) {
            builder.append("orthogonal; ");
        } else {
            builder.append("splines; ");
        }
        if (this.get(UMLConfigKey.SHOW_PACKAGE_INFORMATION).booleanValue()) {
            builder.append("package; ");
        }
        if (this.get(UMLConfigKey.SHOW_FULL_METHOD_SIGNATURE).booleanValue()) {
            builder.append("full signature; ");
        }
        if (this.get(UMLConfigKey.SHOW_ASSOCIATION_LABELS).booleanValue()) {
            builder.append("association labels; ");
        }
        if (this.get(UMLConfigKey.GROUP_BY_PACKAGE).booleanValue()) {
            builder.append("group by package; ");
        }
        return builder.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.convertToString().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UMLDiagramConfiguration other = (UMLDiagramConfiguration)obj;
        return this.toString().equals(other.toString());
    }

    public static enum MembersOption {
        NONE,
        PUBLIC,
        ALL;

    }

    public static enum RelationOption {
        NONE,
        SELECTED,
        CUSTOM_DEPTH,
        ALL;

    }

    public static final class UMLConfigKey<T> {
        private String id;
        public static final UMLConfigKey<RelationOption> PARENTS = new UMLConfigKey("uml.parents");
        public static final UMLConfigKey<Integer> PARENTS_DEPTH = new UMLConfigKey("uml.parents_depth");
        public static final UMLConfigKey<RelationOption> CHILDREN = new UMLConfigKey("uml.children");
        public static final UMLConfigKey<Integer> CHILDREN_DEPTH = new UMLConfigKey("uml.children_depth");
        public static final UMLConfigKey<RelationOption> ASSOCIATIONS = new UMLConfigKey("uml.associations");
        public static final UMLConfigKey<Integer> ASSOCIATIONS_DEPTH = new UMLConfigKey("uml.associations_depth");
        public static final UMLConfigKey<Direction> DIRECTION = new UMLConfigKey("uml.direction");
        public static final UMLConfigKey<MembersOption> MEMBERS = new UMLConfigKey("uml.members");
        public static final UMLConfigKey<Boolean> SHOW_FIELDS = new UMLConfigKey("uml.show_fields");
        public static final UMLConfigKey<Boolean> SHOW_METHODS = new UMLConfigKey("uml.show_methods");
        public static final UMLConfigKey<Boolean> SHOW_EVENTS = new UMLConfigKey("uml.show_events");
        public static final UMLConfigKey<Boolean> ORTHOGONAL_EDGE_ROUTING = new UMLConfigKey("uml.orthogonal_edge_routing");
        public static final UMLConfigKey<Boolean> SHOW_PACKAGE_INFORMATION = new UMLConfigKey("uml.show_package_information");
        public static final UMLConfigKey<Boolean> SHOW_FULL_METHOD_SIGNATURE = new UMLConfigKey("uml.show_full_method_signature");
        public static final UMLConfigKey<Boolean> SHOW_ASSOCIATION_LABELS = new UMLConfigKey("uml.show_association_labels");
        public static final UMLConfigKey<Boolean> GROUP_BY_PACKAGE = new UMLConfigKey("uml.group_by_package");
        public static final UMLConfigKey<Boolean> FOR_SPECADOR = new UMLConfigKey("uml.specador");

        private UMLConfigKey(String id) {
            this.id = id;
        }
    }
}

