/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.uml;

import de.cau.cs.kieler.core.kgraph.KNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.diagrams.DProgressMonitor;
import ro.amiq.dvt.diagrams.IDiagramEngine;
import ro.amiq.dvt.diagrams.exceptions.DCanceledException;
import ro.amiq.dvt.diagrams.uml.UMLDiagramAdapter;
import ro.amiq.dvt.diagrams.uml.UMLDiagramImporter;
import ro.amiq.dvt.diagrams.uml.model.UMLModel;
import ro.amiq.dvt.diagrams.uml.model.UMLNode;
import ro.amiq.dvt.diagrams.uml.preferences.UMLFilterClass;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.guifilters.GUIFilter;
import ro.amiq.dvt.ui.views.DVTViewManager;

public enum UMLDiagramEngine implements IDiagramEngine
{
    INSTANCE;


    public KNode makeNewDiagram(UMLModel model, DProgressMonitor monitor) throws DCanceledException {
        if ((model = this.makeUMLModel(model, monitor)) == null) {
            return null;
        }
        UMLDiagramAdapter adapter = new UMLDiagramAdapter(model);
        UMLDiagramImporter importer = new UMLDiagramImporter(adapter);
        return importer.toKLay("Class Diagram", model, monitor);
    }

    public UMLModel makeUMLModel(UMLModel model, DProgressMonitor monitor) {
        if (model.getDiagramKind() != UMLModel.DiagramKind.COLLABORATION && model.getDiagramKind() != UMLModel.DiagramKind.INHERITANCE && model.getDiagramKind() != UMLModel.DiagramKind.DIRECT) {
            model.getConfig().setPrefFilters(Collections.emptyList());
            List<GUIFilter> guiFilters = DVTViewManager.getGuiFilters(model.getProject());
            if (guiFilters != null) {
                for (GUIFilter guiFilter : guiFilters) {
                    if (monitor.isCanceled()) {
                        return null;
                    }
                    if (guiFilter.getType() != GUIFilter.FilterType.PREDEFINED || !"guiFiltersHideUVMLibrary".equals(guiFilter.getName())) continue;
                    model.getConfig().setPrefFilters(Arrays.asList("__UVM", "__KEEP_SELECTED"));
                }
            }
        }
        Map<String, Object> rightTypes = model.getRightTypes();
        if (model.gatherAllTypes()) {
            this.logMessage("=== UML === Gathering all types (START)");
            List<Object> allClasses = model.getAllClasses(model.getProject(), (IProgressMonitor)monitor);
            if (model.getDiagramKind() == UMLModel.DiagramKind.ARCHITECTURE || model.getDiagramKind() == UMLModel.DiagramKind.SEQUENCE) {
                Collection<UMLFilterClass> userExcludes;
                Collection<UMLFilterClass> userIncludes;
                try {
                    userIncludes = UMLFilterClass.readClassesFromString(model.getIncludePrefVal());
                    userExcludes = UMLFilterClass.readClassesFromString(model.getExcludePrefVal());
                }
                catch (UMLFilterClass.InvalidStringRepresentationException invalidStringRepresentationException) {
                    DVTLogger.INSTANCE.logDebug("Invalid UVM Diagram classes found");
                    return null;
                }
                model.setRightTypes(model.getAllClassesForDiagram(userIncludes, userExcludes, (IProgressMonitor)monitor));
                if (!this.replaceInvalidStructs(model, allClasses, monitor)) {
                    return null;
                }
            } else if (!model.getRightTypes().isEmpty() && !this.replaceInvalidStructs(model, allClasses, monitor)) {
                return null;
            }
            model.updateLeftTypes(allClasses);
            model.setGatherAllTypes(false);
            this.logMessage("=== UML === Gathering all types (END)");
        }
        if (monitor.isCanceled()) {
            return null;
        }
        model.setDirty();
        if (rightTypes.size() > 0) {
            Iterator<Object> iterator = rightTypes.values().iterator();
            while (iterator.hasNext()) {
                if (monitor.isCanceled()) {
                    return null;
                }
                Object element = iterator.next();
                if (!model.isPredefined(element) && !model.isValid(element)) {
                    iterator.remove();
                    continue;
                }
                UMLNode node = model.createNode(element);
                node.setSelected(true);
                model.addNode(node);
            }
        }
        this.logMessage("=== UML === Created initial nodes (" + model.getRightTypes().size() + ")");
        ArrayList<UMLNode> workingCopy = new ArrayList<UMLNode>(model.diagramNodes.keySet());
        for (UMLNode node : workingCopy) {
            if (monitor.isCanceled()) {
                return null;
            }
            if (!node.isSelected()) continue;
            node.setDirty(false);
            model.collectParents(node);
            model.collectChildren(node);
            model.collectFieldAssociationsOfNode(node, new LinkedHashSet<Object>());
        }
        this.logMessage("=== UML === Inheritance Edges: " + model.getNofInheritanceEdges());
        this.logMessage("=== UML === Association Edges:" + model.getNofAssociations());
        this.logMessage("=== UML === New Nodes:" + model.getNofNewNodes());
        if (monitor.isCanceled()) {
            return null;
        }
        model.collectParentsForExtendedDeterminants((IProgressMonitor)monitor);
        model.cleanUp((IProgressMonitor)monitor);
        this.logMessage("=== UML === End of model construction");
        return model;
    }

    private boolean replaceInvalidStructs(UMLModel model, List<Object> allClasses, DProgressMonitor monitor) {
        Map<String, Object> rightTypes = model.getRightTypes();
        for (Object element : allClasses) {
            if (monitor.isCanceled()) {
                return false;
            }
            String generateID = model.generateID(element);
            rightTypes.replace(generateID, element);
        }
        return true;
    }

    private void logMessage(String message) {
        if (DVTLogger.INSTANCE.isDebugMode()) {
            DVTLogger.INSTANCE.logInfo(message);
        }
    }
}

