/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.uml;

import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.kgraph.KPort;
import de.cau.cs.kieler.kiml.options.EdgeType;
import de.cau.cs.kieler.kiml.util.KimlUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import ro.amiq.dvt.diagrams.DProgressMonitor;
import ro.amiq.dvt.diagrams.exceptions.DCanceledException;
import ro.amiq.dvt.diagrams.klay.model.KLayWrapper;
import ro.amiq.dvt.diagrams.uml.UMLDiagramAdapter;
import ro.amiq.dvt.diagrams.uml.UMLDiagramConfiguration;
import ro.amiq.dvt.diagrams.uml.model.UMLAbstractEdge;
import ro.amiq.dvt.diagrams.uml.model.UMLModel;
import ro.amiq.dvt.diagrams.uml.model.UMLNode;
import ro.amiq.dvt.diagrams.uml.model.UMLPackage;

public class UMLDiagramImporter {
    private final UMLDiagramAdapter adapter;
    private Map<UMLPackage, KNode> pkgNodes = new LinkedHashMap<UMLPackage, KNode>();

    public UMLDiagramImporter(UMLDiagramAdapter adapter) {
        this.adapter = adapter;
    }

    public KNode toKLay(String title, UMLModel model, DProgressMonitor monitor) throws DCanceledException {
        Bundle bundle = Bundle.of(model.getConfig(), KimlUtil.createInitializedNode(), new LinkedHashMap<String, KNode>(), monitor);
        bundle.monitor.checkCanceled();
        if (bundle.groupByPackage.booleanValue()) {
            for (UMLPackage umlPackage : model.getPackages().values()) {
                KNode pkgNode = KimlUtil.createInitializedNode();
                this.adapter.setPackageNodeInfo(pkgNode, umlPackage);
                this.pkgNodes.put(umlPackage, pkgNode);
                bundle.root.getChildren().add((Object)pkgNode);
                bundle.kNodes.put(umlPackage.getID(), pkgNode);
            }
        }
        for (UMLNode node : model.diagramNodes.keySet()) {
            this.createOrGetKnode(node, node.getID(), bundle);
        }
        for (UMLAbstractEdge edge : model.diagramEdges.keySet()) {
            this.createKEdge(edge, bundle);
        }
        monitor.setDebugTimeoutInfo("Nodes: " + bundle.nofKNodes + "\nEdges: " + bundle.nofKEdges);
        this.adapter.setRootKNodeInfo(title, bundle.root);
        this.adapter.setKNodesSpacingInfo(bundle.kNodes);
        if (model.getConfig().get(UMLDiagramConfiguration.UMLConfigKey.GROUP_BY_PACKAGE).booleanValue()) {
            Iterator iter = bundle.root.getChildren().iterator();
            while (iter.hasNext()) {
                KNode kNode = (KNode)iter.next();
                if (kNode.getChildren() != null && !kNode.getChildren().isEmpty()) continue;
                iter.remove();
            }
        }
        return bundle.root;
    }

    private KNode createOrGetKnode(UMLNode umlNode, String kMapKey, Bundle bundle) {
        UMLPackage pkg;
        KNode kPkgNode;
        if (umlNode == null) {
            return null;
        }
        if (bundle.kNodes.containsKey(kMapKey)) {
            return bundle.kNodes.get(kMapKey);
        }
        KNode node = KimlUtil.createInitializedNode();
        bundle.kNodes.put(umlNode.getID(), node);
        ++bundle.nofKNodes;
        if (bundle.groupByPackage.booleanValue() && (kPkgNode = this.pkgNodes.get(pkg = umlNode.getPackage())) != null) {
            kPkgNode.getChildren().add((Object)node);
        }
        KNode childNode = KimlUtil.createInitializedNode();
        node.getChildren().add((Object)childNode);
        childNode.getData().add((Object)KLayWrapper.of(umlNode));
        this.adapter.setKMainNodeInfo(childNode, umlNode, bundle.config);
        if (umlNode.showFields && !umlNode.fields.isEmpty()) {
            KNode fieldsNode = KimlUtil.createInitializedNode();
            node.getChildren().add((Object)fieldsNode);
            fieldsNode.getData().add((Object)KLayWrapper.of(umlNode));
            this.adapter.setKFieldsNodeInfo(fieldsNode, umlNode);
        }
        if (umlNode.showEvents && !umlNode.events.isEmpty()) {
            KNode eventsNode = KimlUtil.createInitializedNode();
            node.getChildren().add((Object)eventsNode);
            eventsNode.getData().add((Object)KLayWrapper.of(umlNode));
            this.adapter.setKEventsNodeInfo(eventsNode, umlNode);
        }
        if (umlNode.showMethods && !umlNode.methods.isEmpty()) {
            KNode methodsNode = KimlUtil.createInitializedNode();
            node.getChildren().add((Object)methodsNode);
            methodsNode.getData().add((Object)KLayWrapper.of(umlNode));
            this.adapter.setKMethodsNodeInfo(methodsNode, umlNode);
        }
        umlNode.setNode(node);
        node.getData().add((Object)KLayWrapper.of(umlNode));
        if (!bundle.groupByPackage.booleanValue()) {
            bundle.root.getChildren().add((Object)node);
        }
        this.adapter.setKMainNodeInfo(node, umlNode, bundle.config);
        return node;
    }

    private void createKEdge(UMLAbstractEdge umlEdge, Bundle bundle) {
        if (umlEdge.getSource() == null || umlEdge.getDestination() == null) {
            return;
        }
        if (!bundle.groupByPackage.booleanValue() || umlEdge.getSource().getPackage().equals(umlEdge.getDestination().getPackage())) {
            KEdge edge = KimlUtil.createInitializedEdge();
            ++bundle.nofKEdges;
            KNode sourceNode = this.createOrGetKnode(umlEdge.getSource(), umlEdge.getSource().getID(), bundle);
            KNode destinationNode = this.createOrGetKnode(umlEdge.getDestination(), umlEdge.getDestination().getID(), bundle);
            if (sourceNode == null || destinationNode == null) {
                return;
            }
            edge.getData().add((Object)KLayWrapper.of(umlEdge));
            umlEdge.addKEdge(edge);
            edge.setSource(sourceNode);
            KPort sourcePort = KimlUtil.createInitializedPort();
            sourceNode.getPorts().add((Object)sourcePort);
            edge.setSourcePort(sourcePort);
            this.adapter.setKPortInfo(sourcePort, String.valueOf(umlEdge.getID()) + ".source", true);
            edge.setTarget(destinationNode);
            KPort targetPort = KimlUtil.createInitializedPort();
            destinationNode.getPorts().add((Object)targetPort);
            edge.setTargetPort(targetPort);
            this.adapter.setKPortInfo(targetPort, String.valueOf(umlEdge.getID()) + ".target", false);
            this.adapter.setKEdgeInfo(edge, umlEdge, null, true);
            return;
        }
        KNode sourceNode = this.createOrGetKnode(umlEdge.getSource(), umlEdge.getSource().getID(), bundle);
        KNode firstPackageNode = this.createOrGetKnode(umlEdge.getSource(), umlEdge.getSource().getPackage().getID(), bundle);
        if (sourceNode == null || firstPackageNode == null) {
            return;
        }
        KEdge edge = KimlUtil.createInitializedEdge();
        ++bundle.nofKEdges;
        edge.getData().add((Object)KLayWrapper.of(umlEdge));
        umlEdge.addKEdge(edge);
        edge.setSource(sourceNode);
        KPort sourcePort = KimlUtil.createInitializedPort();
        sourceNode.getPorts().add((Object)sourcePort);
        edge.setSourcePort(sourcePort);
        this.adapter.setKPortInfo(sourcePort, String.valueOf(umlEdge.getID()) + ".source", true);
        edge.setTarget(firstPackageNode);
        KPort firstTargetPort = KimlUtil.createInitializedPort();
        firstPackageNode.getPorts().add((Object)firstTargetPort);
        edge.setTargetPort(firstTargetPort);
        this.adapter.setKPortInfo(firstTargetPort, String.valueOf(umlEdge.getID()) + ".target1", true);
        this.adapter.setKEdgeInfo(edge, umlEdge, EdgeType.NONE, true);
        KNode secondPackageNode = this.createOrGetKnode(umlEdge.getDestination(), umlEdge.getDestination().getPackage().getID(), bundle);
        if (secondPackageNode == null) {
            return;
        }
        KEdge edge2 = KimlUtil.createInitializedEdge();
        ++bundle.nofKEdges;
        edge2.getData().add((Object)KLayWrapper.of(umlEdge));
        umlEdge.addKEdge(edge2);
        edge2.setSource(firstPackageNode);
        edge2.setSourcePort(firstTargetPort);
        KPort secondTargetPort = KimlUtil.createInitializedPort();
        secondPackageNode.getPorts().add((Object)secondTargetPort);
        edge2.setTarget(secondPackageNode);
        edge2.setTargetPort(secondTargetPort);
        this.adapter.setKPortInfo(secondTargetPort, String.valueOf(umlEdge.getID()) + ".target2", false);
        this.adapter.setKEdgeInfo(edge2, umlEdge, EdgeType.NONE, false);
        KNode destination = this.createOrGetKnode(umlEdge.getDestination(), umlEdge.getDestination().getID(), bundle);
        if (destination == null) {
            return;
        }
        KEdge edge3 = KimlUtil.createInitializedEdge();
        ++bundle.nofKEdges;
        edge3.getData().add((Object)KLayWrapper.of(umlEdge));
        umlEdge.addKEdge(edge3);
        edge3.setSource(secondPackageNode);
        edge3.setSourcePort(secondTargetPort);
        KPort destinationPort = KimlUtil.createInitializedPort();
        destination.getPorts().add((Object)destinationPort);
        edge3.setTarget(destination);
        edge3.setTargetPort(destinationPort);
        this.adapter.setKPortInfo(destinationPort, String.valueOf(umlEdge.getID()) + "finalTarget", false);
        this.adapter.setKEdgeInfo(edge3, umlEdge, EdgeType.DIRECTED, false);
    }

    public static class Bundle {
        public final DProgressMonitor monitor;
        public final Map<String, KNode> kNodes;
        public final Boolean groupByPackage;
        public final KNode root;
        public int nofKNodes;
        public int nofKEdges;
        public final UMLDiagramConfiguration config;

        private Bundle(UMLDiagramConfiguration config, KNode root, Map<String, KNode> kNodes, DProgressMonitor monitor) {
            this.config = config;
            this.groupByPackage = config.get(UMLDiagramConfiguration.UMLConfigKey.GROUP_BY_PACKAGE);
            this.root = root;
            this.monitor = monitor;
            this.kNodes = kNodes;
        }

        public static Bundle of(UMLDiagramConfiguration config, KNode root, Map<String, KNode> kNodes, DProgressMonitor monitor) {
            return new Bundle(config, root, kNodes, monitor);
        }
    }
}

