/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.uml.draw;

import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KGraphElement;
import de.cau.cs.kieler.core.kgraph.KLabel;
import de.cau.cs.kieler.core.kgraph.KLabeledGraphElement;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.krendering.KBackground;
import de.cau.cs.kieler.core.krendering.KColor;
import de.cau.cs.kieler.core.krendering.KColoring;
import de.cau.cs.kieler.core.krendering.KFontBold;
import de.cau.cs.kieler.core.krendering.KFontItalic;
import de.cau.cs.kieler.core.krendering.KFontName;
import de.cau.cs.kieler.core.krendering.KFontSize;
import de.cau.cs.kieler.core.krendering.KForeground;
import de.cau.cs.kieler.core.krendering.KLineStyle;
import de.cau.cs.kieler.core.krendering.KLineWidth;
import de.cau.cs.kieler.core.krendering.KPolyline;
import de.cau.cs.kieler.core.krendering.KRectangle;
import de.cau.cs.kieler.core.krendering.KRendering;
import de.cau.cs.kieler.core.krendering.KSpline;
import de.cau.cs.kieler.core.krendering.KStyle;
import de.cau.cs.kieler.core.krendering.KText;
import de.cau.cs.kieler.core.krendering.LineStyle;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.math.KVectorChain;
import de.cau.cs.kieler.kiml.klayoutdata.KEdgeLayout;
import de.cau.cs.kieler.kiml.klayoutdata.KIdentifier;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.options.EdgeType;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import ro.amiq.dvt.diagrams.klay.rendering.styles.KSelectionBackground;
import ro.amiq.dvt.diagrams.klay.rendering.styles.KSelectionForeground;
import ro.amiq.dvt.diagrams.klay.rendering.styles.KSelectionLineWidth;
import ro.amiq.dvt.diagrams.uml.draw.UMLDrawUtils;
import ro.amiq.dvt.diagrams.uml.draw.obj.DUMLContainer;
import ro.amiq.dvt.diagrams.uml.draw.obj.DUMLEdge;
import ro.amiq.dvt.diagrams.uml.draw.obj.DUMLLabel;
import ro.amiq.dvt.diagrams.uml.draw.obj.DUMLObject;
import ro.amiq.dvt.diagrams.uml.draw.obj.DUMLScene;
import ro.amiq.dvt.diagrams.uml.model.IUMLElement;
import ro.amiq.dvt.diagrams.uml.model.UMLPackage;
import ro.amiq.dvt.draw.obj.utils.DProperties;
import ro.amiq.dvt.draw.obj.utils.RGBV;
import ro.amiq.dvt.draw.utils.ColorFactory;
import ro.amiq.dvt.draw.utils.FRectangle;
import ro.amiq.dvt.draw.utils.FontFactory;

public enum UMLDrawConverter {
    INSTANCE;

    private static final DProperties.Key<FRectangle> FLOAT_LAYOUT;
    private static final DProperties.Key<List<DUMLObject>> CHILDREN;

    static {
        FLOAT_LAYOUT = new DProperties.Key("UMLDrawConverter.FLOAT_LAYOUT");
        CHILDREN = new DProperties.Key("UMLDrawConverter.CHILDREN");
    }

    public DUMLScene convert(KNode kRoot) {
        KShapeLayout kLayout = (KShapeLayout)kRoot.getData(KShapeLayout.class);
        Rectangle bounds = new Rectangle(0, 0, Math.round(kLayout.getWidth()), Math.round(kLayout.getHeight()));
        DUMLScene dScene = new DUMLScene(kRoot, bounds);
        this.registerDObject(dScene, (KGraphElement)kRoot, null, dScene);
        dScene.setProperty(FLOAT_LAYOUT, new FRectangle(kLayout.getXpos(), kLayout.getYpos(), kLayout.getWidth(), kLayout.getHeight()));
        this.convertKNodes((List<KNode>)kRoot.getChildren(), dScene);
        this.forgeUMLObjects(dScene);
        return dScene;
    }

    private void forgeUMLObjects(DUMLObject dObject) {
        dObject.forge();
        List<DUMLObject> dChildren = dObject.getProperty(CHILDREN);
        dObject.removeProperty(CHILDREN);
        dObject.removeProperty(FLOAT_LAYOUT);
        if (dChildren != null) {
            dChildren.sort(DUMLObject.COMPARATOR);
            dObject.addChildren(dChildren);
            for (DUMLObject dChild : dChildren) {
                this.forgeUMLObjects(dChild);
            }
        }
    }

    private void convertKNodes(List<KNode> kNodes, DUMLScene dScene) {
        for (KNode kNode : kNodes) {
            DUMLContainer dContainer = this.registerDObject(new DUMLContainer(), (KGraphElement)kNode, (KGraphElement)kNode.getParent(), dScene);
            IUMLElement umlObject = (IUMLElement)UMLDrawUtils.getUMLObjectFromKElement((KGraphElement)kNode);
            this.setLayoutProperties((KGraphElement)kNode, (KGraphElement)kNode.getParent(), dContainer, dScene);
            this.setRenderingProperties((KGraphElement)kNode, dContainer);
            if (umlObject instanceof UMLPackage) {
                for (KNode child : kNode.getChildren()) {
                    DUMLContainer container = this.registerDObject(new DUMLContainer(), (KGraphElement)child, (KGraphElement)kNode, dScene);
                    this.setLayoutProperties((KGraphElement)child, (KGraphElement)kNode, container, dScene);
                    this.setRenderingProperties((KGraphElement)child, container);
                    ArrayList<Integer> sectionYPositions = new ArrayList<Integer>();
                    this.convertSectionNodes(dScene, child, sectionYPositions);
                    container.setProperty(DUMLContainer.SECTION_YPOSITIONS, sectionYPositions);
                    this.convertKLabels((List<KLabel>)child.getLabels(), (KLabeledGraphElement)child, dScene, 0.0f);
                    this.convertKEdges((List<KEdge>)child.getOutgoingEdges(), dScene);
                }
                dContainer.setProperty(DUMLContainer.SECTION_YPOSITIONS, Collections.emptyList());
            } else {
                ArrayList<Integer> sectionYPositions = new ArrayList<Integer>();
                this.convertSectionNodes(dScene, kNode, sectionYPositions);
                dContainer.setProperty(DUMLContainer.SECTION_YPOSITIONS, sectionYPositions);
            }
            this.convertKLabels((List<KLabel>)kNode.getLabels(), (KLabeledGraphElement)kNode, dScene, 0.0f);
            this.convertKEdges((List<KEdge>)kNode.getOutgoingEdges(), dScene);
        }
    }

    private void convertSectionNodes(DUMLScene dScene, KNode kNode, List<Integer> sectionYPositions) {
        for (KNode kSectionNode : kNode.getChildren()) {
            float sectionYPosition = ((KShapeLayout)kSectionNode.getData(KShapeLayout.class)).getYpos();
            int sectionYPositionRounded = Math.round(sectionYPosition);
            if (sectionYPositionRounded > 0) {
                sectionYPositions.add(sectionYPositionRounded);
            }
            this.convertKLabels((List<KLabel>)kSectionNode.getLabels(), (KLabeledGraphElement)kNode, dScene, sectionYPosition);
        }
    }

    private void convertKEdges(List<KEdge> kEdges, DUMLScene dScene) {
        for (KEdge kEdge : kEdges) {
            KNode kContainerParent = this.findEdgeContainerParent(kEdge.getSource(), kEdge.getTarget());
            DUMLEdge dEdge = this.registerDObject(new DUMLEdge(), (KGraphElement)kEdge, (KGraphElement)kContainerParent, dScene);
            this.setRenderingProperties((KGraphElement)kEdge, dEdge);
            KNode kLayoutParent = this.findEdgeLayoutParent(kEdge.getSource(), kEdge.getTarget());
            DUMLObject dLayoutParent = dScene.getDObject((KGraphElement)kLayoutParent);
            FRectangle floatLayout = dLayoutParent.getProperty(FLOAT_LAYOUT);
            KEdgeLayout kEdgeLayout = (KEdgeLayout)kEdge.getData(KEdgeLayout.class);
            EdgeType edgeType = (EdgeType)kEdgeLayout.getProperty(LayoutOptions.EDGE_TYPE);
            dEdge.setProperty(DUMLEdge.EDGE_TYPE, edgeType);
            ArrayList<Point> dBendingPoints = new ArrayList<Point>();
            KVectorChain kEdgePoints = kEdgeLayout.createVectorChain();
            for (KVector kPoint : kEdgePoints) {
                dBendingPoints.add(floatLayout.relativeRound((float)kPoint.x, (float)kPoint.y));
            }
            this.adjustEdge((Point)dBendingPoints.get(0), (Point)dBendingPoints.get(1), false);
            if (edgeType == EdgeType.NONE) {
                this.adjustEdge((Point)dBendingPoints.get(dBendingPoints.size() - 1), (Point)dBendingPoints.get(dBendingPoints.size() - 2), false);
            } else {
                this.adjustEdge((Point)dBendingPoints.get(dBendingPoints.size() - 1), (Point)dBendingPoints.get(dBendingPoints.size() - 2), true);
            }
            dEdge.setProperty(DUMLEdge.BENDING_POINTS, dBendingPoints);
            for (KLabel kLabel : kEdge.getLabels()) {
                String text = kLabel.getText();
                boolean isEmpty = text == null || text.trim().length() == 0;
                DUMLLabel dLabel = this.registerDObject(isEmpty ? new DUMLLabel() : new DUMLLabel.DUMLSelectableLabel(false), (KGraphElement)kLabel, (KGraphElement)kLayoutParent, dScene);
                this.setLayoutProperties((KGraphElement)kLabel, (KGraphElement)kLayoutParent, dLabel, dScene);
                this.setTextProperties(kLabel, dLabel);
                this.setRenderingProperties((KGraphElement)kLabel, dLabel);
                dLabel.setProperty(DUMLLabel.TEXT, text);
                if (isEmpty) continue;
                dEdge.setLabel((DUMLLabel.DUMLSelectableLabel)dLabel);
                ((DUMLLabel.DUMLSelectableLabel)dLabel).setEdge(dEdge);
            }
        }
    }

    private KNode findEdgeContainerParent(KNode kNode1, KNode kNode2) {
        if (kNode1 == null || kNode2 == null) {
            return null;
        }
        if (kNode1.equals(kNode2)) {
            return kNode1;
        }
        HashSet<KNode> parents = new HashSet<KNode>();
        do {
            parents.add(kNode1);
        } while ((kNode1 = kNode1.getParent()) != null);
        do {
            if (!parents.contains(kNode2)) continue;
            return kNode2;
        } while ((kNode2 = kNode2.getParent()) != null);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private KNode findEdgeLayoutParent(KNode kNode1, KNode kNode2) {
        if (kNode1 == null || kNode2 == null) {
            return null;
        }
        if (!kNode1.equals(kNode2)) ** GOTO lbl7
        return kNode1.getParent();
lbl-1000:
        // 1 sources

        {
            if (!kNode1.equals(kNode2)) continue;
            return kNode1;
lbl7:
            // 2 sources

            ** while ((kNode2 = kNode2.getParent()) != null)
        }
lbl8:
        // 1 sources

        return kNode1.getParent();
    }

    private void convertKLabels(List<KLabel> kLables, KLabeledGraphElement kParent, DUMLScene dScene, float areaYpos) {
        for (KLabel kLabel : kLables) {
            String labelText = kLabel.getText().trim();
            String labelID = ((KIdentifier)kLabel.getData(KIdentifier.class)).getId();
            DUMLLabel dLabel = labelID.startsWith("package_label_for") ? (DUMLLabel)this.registerDObject(new DUMLLabel.DUMLSelectableLabel(true), (KGraphElement)kLabel, (KGraphElement)kParent, dScene) : (labelText.startsWith("+") || labelText.startsWith("-") || labelText.startsWith("#") || labelText.startsWith("~") ? (DUMLLabel)this.registerDObject(new DUMLLabel.DUMLSelectableLabel(false), (KGraphElement)kLabel, (KGraphElement)kParent, dScene) : this.registerDObject(new DUMLLabel(), (KGraphElement)kLabel, (KGraphElement)kParent, dScene));
            this.setLayoutProperties((KGraphElement)kLabel, (KGraphElement)kParent, dLabel, dScene, areaYpos);
            this.setTextProperties(kLabel, dLabel);
            this.setRenderingProperties((KGraphElement)kLabel, dLabel);
            dLabel.setProperty(DUMLLabel.TEXT, kLabel.getText());
        }
    }

    private void setTextProperties(KLabel kLabel, DUMLLabel dLabel) {
        KText kText = (KText)kLabel.getData(KText.class);
        String fontName = null;
        int fontSize = 0;
        int fontStyle = 0;
        EList styles = kText.getStyles();
        for (KStyle kStyle : styles) {
            if (kStyle instanceof KFontName) {
                fontName = ((KFontName)kStyle).getName();
                continue;
            }
            if (kStyle instanceof KFontSize) {
                fontSize = ((KFontSize)kStyle).getSize();
                continue;
            }
            if (kStyle instanceof KFontBold && ((KFontBold)kStyle).isBold()) {
                fontStyle |= 1;
                continue;
            }
            if (kStyle instanceof KFontItalic && ((KFontItalic)kStyle).isItalic()) {
                fontStyle |= 2;
                continue;
            }
            if (!(kStyle instanceof KForeground)) continue;
            dLabel.setProperty(DUMLObject.LINE_COLOR, this.convertKColoring((KColoring<?>)((KForeground)kStyle)));
        }
        dLabel.setProperty(DUMLLabel.FONT, FontFactory.getInstance().getFontData(fontName, fontSize, fontStyle));
    }

    private <T extends DUMLObject> T registerDObject(T dObject, KGraphElement kElement, KGraphElement kParent, DUMLScene dScene) {
        ((DUMLObject)dObject).setProperty(DUMLObject.KELEMENT, (KGraphElement)kElement);
        dScene.putDObject(kElement, (DUMLObject)dObject);
        DUMLObject dParent = dScene.getDObject(kParent);
        if (dParent != null) {
            List<DUMLObject> children = dParent.getProperty(CHILDREN);
            if (children == null) {
                children = new ArrayList<DUMLObject>();
                dParent.setProperty(CHILDREN, children);
            }
            children.add((DUMLObject)dObject);
        }
        return (T)dObject;
    }

    private void setLayoutProperties(KGraphElement kElement, KGraphElement kParent, DUMLObject dObject, DUMLScene dScene) {
        this.setLayoutProperties(kElement, kParent, dObject, dScene, 0.0f);
    }

    private void setLayoutProperties(KGraphElement kElement, KGraphElement kParent, DUMLObject dObject, DUMLScene dScene, float deltaY) {
        DUMLObject dParent = dScene.getDObject(kParent);
        FRectangle parentLayout = null;
        parentLayout = dParent == null ? new FRectangle(0.0f, 0.0f, 0.0f, 0.0f) : dParent.getProperty(FLOAT_LAYOUT);
        KShapeLayout kLayout = (KShapeLayout)kElement.getData(KShapeLayout.class);
        FRectangle currentLayout = parentLayout.relative(kLayout.getXpos(), kLayout.getYpos() + deltaY, kLayout.getWidth(), kLayout.getHeight());
        dObject.setProperty(FLOAT_LAYOUT, currentLayout);
        dObject.setProperty(DUMLObject.LAYOUT, currentLayout.round());
    }

    private void setRenderingProperties(KGraphElement kElement, DUMLObject dObject) {
        KRendering kRendering = (KRendering)kElement.getData(KRendering.class);
        if (kRendering instanceof KRectangle) {
            dObject.setProperty(DUMLContainer.ROUNDED, false);
        } else if (kRendering instanceof KSpline) {
            dObject.setProperty(DUMLEdge.SPLINE, true);
        } else if (kRendering instanceof KPolyline) {
            dObject.setProperty(DUMLEdge.SPLINE, false);
        }
        EList kStyles = kRendering.getStyles();
        for (KStyle kStyle : kStyles) {
            if (kStyle instanceof KSelectionBackground) {
                dObject.setProperty(DUMLObject.SELECTED_FILL_COLOR, this.convertKColoring((KSelectionBackground)kStyle));
                continue;
            }
            if (kStyle instanceof KBackground) {
                dObject.setProperty(DUMLObject.FILL_COLOR, this.convertKColoring((KColoring<?>)((KBackground)kStyle)));
                continue;
            }
            if (kStyle instanceof KSelectionForeground) {
                dObject.setProperty(DUMLObject.SELECTED_LINE_COLOR, this.convertKColoring((KSelectionForeground)kStyle));
                continue;
            }
            if (kStyle instanceof KForeground) {
                dObject.setProperty(DUMLObject.LINE_COLOR, this.convertKColoring((KColoring<?>)((KForeground)kStyle)));
                continue;
            }
            if (kStyle instanceof KSelectionLineWidth) {
                dObject.setProperty(DUMLObject.SELECTED_LINE_WIDTH, Math.round(((KSelectionLineWidth)kStyle).getLineWidth()));
                continue;
            }
            if (kStyle instanceof KLineWidth) {
                dObject.setProperty(DUMLObject.LINE_WIDTH, Math.round(((KLineWidth)kStyle).getLineWidth()));
                continue;
            }
            if (!(kStyle instanceof KLineStyle)) continue;
            dObject.setProperty(DUMLObject.LINE_STYLE, this.convertKLineStyle(((KLineStyle)kStyle).getLineStyle()));
        }
    }

    private RGBV convertKColoring(KColoring<?> kColoring) {
        KColor color = kColoring.getColor();
        return ColorFactory.getInstance().getRGBV(color.getRed(), color.getGreen(), color.getBlue(), kColoring.getAlpha() > 0);
    }

    private int convertKLineStyle(LineStyle kStyle) {
        if (kStyle == LineStyle.SOLID) {
            return 1;
        }
        if (kStyle == LineStyle.DASH) {
            return 2;
        }
        if (kStyle == LineStyle.DASHDOT) {
            return 4;
        }
        if (kStyle == LineStyle.DASHDOTDOT) {
            return 5;
        }
        if (kStyle == LineStyle.DOT) {
            return 3;
        }
        return 1;
    }

    private void adjustEdge(Point edgeP1, Point edgeP2, boolean hasArrow) {
        int diff;
        int n = diff = hasArrow ? 4 : 1;
        if (edgeP1.x - edgeP2.x == 0) {
            edgeP1.y += (diff *= edgeP1.y > edgeP2.y ? -1 : 1);
        } else if (edgeP1.y - edgeP2.y == 0) {
            edgeP1.x += (diff *= edgeP1.x > edgeP2.x ? -1 : 1);
        }
    }
}

