/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.uml.draw.obj;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Rectangle;
import ro.amiq.dvt.diagrams.uml.draw.obj.DUMLObject;
import ro.amiq.dvt.draw.obj.base.DObject;
import ro.amiq.dvt.draw.obj.base.DShape;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;
import ro.amiq.dvt.draw.obj.primitive.DLine;
import ro.amiq.dvt.draw.obj.primitive.DRectangle;
import ro.amiq.dvt.draw.obj.primitive.DRoundRectangle;
import ro.amiq.dvt.draw.obj.utils.DProperties;
import ro.amiq.dvt.draw.obj.utils.RGBV;

public class DUMLContainer
extends DUMLObject
implements DSelectable {
    public static final DProperties.Key<Boolean> ROUNDED = new DProperties.Key("DUMLContainer.ROUNDED");
    public static final DProperties.Key<List<Integer>> SECTION_YPOSITIONS = new DProperties.Key("DUMLContainer.SECTION_YPOSITIONS");
    private final List<DLine> lines = new ArrayList<DLine>();
    private DShape rectangle;

    @Override
    public void forge() {
        Rectangle layout = (Rectangle)this.getProperty(LAYOUT);
        this.rectangle = this.getProperty(ROUNDED) != false ? new DRoundRectangle(layout.x, layout.y, layout.width, layout.height, 10) : new DRectangle(layout.x, layout.y, layout.width, layout.height);
        this.rectangle.setLineStyle((Integer)this.getProperty(LINE_STYLE));
        this.rectangle.setLineWidth((Integer)this.getProperty(LINE_WIDTH));
        this.rectangle.setLineColor((RGBV)this.getProperty(LINE_COLOR));
        this.rectangle.setFillColor((RGBV)this.getProperty(FILL_COLOR));
        this.rectangle.setURL((String)this.getProperty(URL));
        this.rectangle.setLineCap(1);
        this.rectangle.setLineAutoScale(true);
        this.addChild(this.rectangle);
        List<Integer> areaYPositions = this.getProperty(SECTION_YPOSITIONS);
        for (Integer areaYPos : areaYPositions) {
            DLine line = new DLine(new int[]{layout.x, layout.y + areaYPos, layout.x + layout.width, layout.y + areaYPos});
            line.setLineStyle((Integer)this.getProperty(LINE_STYLE));
            line.setLineWidth((Integer)this.getProperty(LINE_WIDTH));
            line.setLineColor((RGBV)this.getProperty(LINE_COLOR));
            line.setLineCap(1);
            line.setLineAutoScale(true);
            this.lines.add(line);
            this.addChild(line);
        }
    }

    @Override
    public void select(boolean selected, String type) {
        this.rectangle.setLineColor(selected ? (RGBV)this.getProperty(SELECTED_LINE_COLOR) : (RGBV)this.getProperty(LINE_COLOR));
        this.rectangle.setFillColor(selected ? (RGBV)this.getProperty(SELECTED_FILL_COLOR) : (RGBV)this.getProperty(FILL_COLOR));
        this.rectangle.setLineWidth(selected ? ((Integer)this.getProperty(SELECTED_LINE_WIDTH)).intValue() : ((Integer)this.getProperty(LINE_WIDTH)).intValue());
        for (DLine line : this.lines) {
            line.setLineColor(selected ? (RGBV)this.getProperty(SELECTED_LINE_COLOR) : (RGBV)this.getProperty(LINE_COLOR));
            line.setLineWidth(selected ? ((Integer)this.getProperty(SELECTED_LINE_WIDTH)).intValue() : ((Integer)this.getProperty(LINE_WIDTH)).intValue());
        }
    }

    @Override
    public List<DObject> getSelectedObjects() {
        ArrayList<DObject> selectedObjects = new ArrayList<DObject>();
        selectedObjects.add(this.rectangle);
        selectedObjects.addAll(this.lines);
        return selectedObjects;
    }

    @Override
    public <T> void setProperty(DProperties.Key<T> key, T value) {
        super.setProperty(key, value);
        if (key == URL && this.rectangle != null) {
            this.rectangle.setURL((String)value);
        }
    }
}

