/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.uml.draw.obj;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Rectangle;
import ro.amiq.dvt.diagrams.uml.draw.obj.DUMLEdge;
import ro.amiq.dvt.diagrams.uml.draw.obj.DUMLObject;
import ro.amiq.dvt.draw.obj.base.DObject;
import ro.amiq.dvt.draw.obj.interaction.DSearchable;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;
import ro.amiq.dvt.draw.obj.primitive.DText;
import ro.amiq.dvt.draw.obj.utils.DProperties;
import ro.amiq.dvt.draw.obj.utils.RGBV;

public class DUMLLabel
extends DUMLObject
implements DSearchable {
    public static final DProperties.Key<FontData> FONT = new DProperties.Key("DUMLLabel.FONT");
    public static final DProperties.Key<String> TEXT = new DProperties.Key("DUMLLabel.TEXT");
    protected DText text;

    @Override
    public void forge() {
        Rectangle layout = (Rectangle)this.getProperty(LAYOUT);
        this.text = new DText(this.getProperty(TEXT), layout.x, layout.y, layout.width, layout.height, this.getProperty(FONT));
        this.text.setTextColor((RGBV)this.getProperty(LINE_COLOR));
        this.addChild(this.text);
        if (this instanceof DUMLSelectableLabel) {
            ((DUMLSelectableLabel)this).select(false, "MAIN_SELECTION");
        }
    }

    @Override
    public String getSearchText() {
        return this.getProperty(TEXT);
    }

    @Override
    public void highlightSearchMatch(DSearchable.Highlight highlight) {
        DText text = (DText)this.getChildren().get(0);
        if (highlight == DSearchable.Highlight.NONE) {
            text.setHighlight(-1, -1);
        } else {
            text.setHighlightColor(highlight.getColor());
            text.setHighlight(1, this.getProperty(TEXT).length() - 1);
        }
    }

    @Override
    public String shortValueString() {
        return this.getProperty(TEXT);
    }

    public static class DUMLSelectableLabel
    extends DUMLLabel
    implements DSelectable {
        private DUMLEdge edge;
        private boolean isPackageLabel;

        public DUMLSelectableLabel(boolean isPackageLabel) {
            this.isPackageLabel = isPackageLabel;
        }

        public void setEdge(DUMLEdge edge) {
            this.edge = edge;
        }

        public DUMLEdge getEdge() {
            return this.edge;
        }

        public boolean isPackageLabel() {
            return this.isPackageLabel;
        }

        @Override
        public void select(boolean selected, String type) {
            RGBV lineColor = selected ? (RGBV)this.getProperty(SELECTED_LINE_COLOR) : (RGBV)this.getProperty(LINE_COLOR);
            this.text.setTextColor(lineColor);
        }

        @Override
        public List<DObject> getSelectedObjects() {
            ArrayList<DObject> selectedObjects = new ArrayList<DObject>();
            selectedObjects.add(this.text);
            return selectedObjects;
        }
    }
}

