/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.uml.editor;

import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KGraphElement;
import de.cau.cs.kieler.core.kgraph.KLabel;
import de.cau.cs.kieler.core.kgraph.KNode;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.DMenuItem;
import ro.amiq.dvt.diagrams.uml.draw.UMLDrawUtils;
import ro.amiq.dvt.diagrams.uml.draw.obj.DUMLEdge;
import ro.amiq.dvt.diagrams.uml.draw.obj.DUMLLabel;
import ro.amiq.dvt.diagrams.uml.draw.obj.DUMLObject;
import ro.amiq.dvt.diagrams.uml.draw.obj.DUMLScene;
import ro.amiq.dvt.diagrams.uml.editor.actions.menu.DUMLMenuActionFactory;
import ro.amiq.dvt.diagrams.uml.model.IUMLElement;
import ro.amiq.dvt.diagrams.uml.model.UMLAbstractEdge;
import ro.amiq.dvt.diagrams.uml.model.UMLAssociationEdge;
import ro.amiq.dvt.diagrams.uml.model.UMLNodeMember;
import ro.amiq.dvt.diagrams.uml.model.UMLPackage;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;

public abstract class DUMLEditorContributorsCommon {
    public List<DMenuItem> getMenuItems(DDiagramEditor diagramEditor, Set<DSelectable> selection) {
        return DUMLMenuActionFactory.createActions(selection, diagramEditor.getInput().getDiagram(), diagramEditor);
    }

    public Map<String, Set<DSelectable>> getSelectedObjects(DDiagramEditor diagramEditor, DSelectable object) {
        LinkedHashMap<String, Set<DSelectable>> selection = new LinkedHashMap<String, Set<DSelectable>>();
        LinkedHashSet<DSelectable> selectables = new LinkedHashSet<DSelectable>();
        selectables.add(object);
        if (UMLDrawUtils.getUMLElementFromDUMLObject((DUMLObject)((Object)object), IUMLElement.class) == null) {
            return selection;
        }
        DUMLScene scene = (DUMLScene)diagramEditor.getCanvas().getContent();
        this.getEdgeParts(object, selectables, scene);
        if (!(object instanceof DUMLLabel.DUMLSelectableLabel)) {
            KNode kNode;
            if (UMLDrawUtils.getUMLElementFromDUMLObject((DUMLObject)((Object)object), IUMLElement.class) instanceof UMLPackage && (kNode = (KNode)UMLDrawUtils.getKElementFromUMLDObject((DUMLObject)((Object)object))) != null) {
                for (KLabel label : kNode.getLabels()) {
                    selectables.add((DSelectable)((Object)scene.getDObject((KGraphElement)label)));
                }
            }
            selection.put("MAIN_SELECTION", selectables);
            return selection;
        }
        DUMLLabel.DUMLSelectableLabel selectableLabel = (DUMLLabel.DUMLSelectableLabel)object;
        if (selectableLabel.isPackageLabel()) {
            DSelectable packageNode = null;
            KGraphElement kLabel = UMLDrawUtils.getKElementFromUMLDObject(selectableLabel);
            if (kLabel != null && ((KLabel)kLabel).getParent() != null) {
                packageNode = (DSelectable)((Object)scene.getDObject((KGraphElement)((KLabel)kLabel).getParent()));
            }
            if (packageNode != null) {
                selectables.add(packageNode);
            }
            selection.put("MAIN_SELECTION", selectables);
            return selection;
        }
        if (selectableLabel.getEdge() != null) {
            KLabel label;
            DUMLEdge dEdge = selectableLabel.getEdge();
            selectables.add(dEdge);
            this.getEdgeParts(dEdge, selectables, scene);
            UMLAbstractEdge edge = UMLDrawUtils.getUMLElementFromDUMLObject(dEdge, UMLAbstractEdge.class);
            if (edge.isAssociation() && (label = ((UMLAssociationEdge)edge).getMemberKLabel()) != null) {
                DUMLLabel.DUMLSelectableLabel dLabel = (DUMLLabel.DUMLSelectableLabel)scene.getDObject((KGraphElement)label);
                selectables.add(dLabel);
            }
        } else {
            KEdge edge = UMLDrawUtils.getUMLElementFromDUMLObject(selectableLabel, UMLNodeMember.class).getKEdge();
            if (edge != null) {
                DUMLEdge dEdge = (DUMLEdge)scene.getDObject((KGraphElement)edge);
                selectables.add(dEdge);
                this.getEdgeParts(dEdge, selectables, scene);
            }
        }
        selection.put("MAIN_SELECTION", selectables);
        return selection;
    }

    private void getEdgeParts(DSelectable object, Set<DSelectable> selectables, DUMLScene scene) {
        if (!(object instanceof DUMLEdge)) {
            return;
        }
        UMLAbstractEdge umlEdge = UMLDrawUtils.getUMLElementFromDUMLObject((DUMLEdge)object, UMLAbstractEdge.class);
        List<KEdge> kEdges = umlEdge.getKEdges();
        if (kEdges == null) {
            return;
        }
        for (KEdge kEdge : kEdges) {
            DUMLEdge dEdge = (DUMLEdge)scene.getDObject((KGraphElement)kEdge);
            selectables.add(dEdge);
            if (dEdge.getLabel() == null) continue;
            selectables.add(dEdge.getLabel());
        }
        if (umlEdge.isAssociation() && ((UMLAssociationEdge)umlEdge).getMemberKLabel() != null) {
            selectables.add((DUMLLabel.DUMLSelectableLabel)scene.getDObject((KGraphElement)((UMLAssociationEdge)umlEdge).getMemberKLabel()));
        }
    }
}

