/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.uml.editor;

import org.eclipse.core.resources.IProject;
import org.eclipse.ui.IWorkbenchWindow;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.DDiagramEditorInput;
import ro.amiq.dvt.diagrams.editor.DFocusContributor;
import ro.amiq.dvt.diagrams.editor.DMKCContributor;
import ro.amiq.dvt.diagrams.editor.DMenuContributor;
import ro.amiq.dvt.diagrams.editor.DSelectionContributor;
import ro.amiq.dvt.diagrams.editor.DToolbarContributor;
import ro.amiq.dvt.diagrams.editor.DTransitionTableContributor;
import ro.amiq.dvt.diagrams.uml.UMLDiagram;
import ro.amiq.dvt.diagrams.uml.editor.DUMLEditorContributors;
import ro.amiq.dvt.diagrams.uml.editor.DUMLEditorFactoryCommon;
import ro.amiq.dvt.diagrams.uml.model.UMLModel;
import ro.amiq.dvt.ui.Utils;

public class DUMLEditorFactory
extends DUMLEditorFactoryCommon {
    private static DUMLEditorFactory INSTANCE;
    private static final Object SYNC_OBJECT;

    static {
        SYNC_OBJECT = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DUMLEditorFactory getInstance() {
        if (INSTANCE == null) {
            Object object = SYNC_OBJECT;
            synchronized (object) {
                INSTANCE = new DUMLEditorFactory();
            }
        }
        return INSTANCE;
    }

    public DUMLEditorFactory() {
    }

    public DUMLEditorFactory(UMLDiagram diagram) {
        this.diagram = diagram;
    }

    @Override
    public DDiagramEditorInput createEditorInput(DDiagram diagram) {
        DToolbarContributor toolbarContributor = DUMLEditorContributors.getInstance()::getToolbarActions;
        DMenuContributor menuContributor = DUMLEditorContributors.getInstance()::getMenuItems;
        DSelectionContributor selectionContributor = DUMLEditorContributors.getInstance()::getSelectedObjects;
        return new DDiagramEditorInput(diagram, toolbarContributor, menuContributor, selectionContributor, DTransitionTableContributor.EMPTY, DMKCContributor.EMPTY, DFocusContributor.EMPTY, null);
    }

    public void refreshUMLDiagrams(IWorkbenchWindow window, IProject project) {
        DDiagramEditor.diagramEditorsAsStream(window).filter(editor -> editor.getInput().getDiagram() instanceof UMLDiagram).forEach(editor -> {
            DDiagram editorDiagram = editor.getInput().getDiagram();
            if (!(editorDiagram instanceof UMLDiagram)) {
                return;
            }
            if (project != null && !project.equals((Object)editorDiagram.getProject())) {
                return;
            }
            UMLModel model = ((UMLDiagram)editorDiagram).getModel();
            model.setGatherAllTypes(true);
            Utils.asyncExec(() -> editor.updateEditor());
        });
    }
}

