/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.uml.editor;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchWindow;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.diagrams.design.editor.DDesignEditorFactory;
import ro.amiq.dvt.diagrams.editor.IDiagramToolbarMenuItemProvider;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.power.format.DVTPFModel;

public class PowerDomainsDiagramToolbarMenuItemContributor
implements IDiagramToolbarMenuItemProvider {
    @Override
    public void addMenuEntry(Menu menu, IStructuredSelection selection, IWorkbenchWindow window) {
        final IProject project = DVTPlugin.getSelectionManager().getLastSelectedProject();
        if (project == null) {
            return;
        }
        RfMixedLangProject mixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(project, false);
        if (mixedLangProject == null) {
            return;
        }
        DVTPFModel pfModel = mixedLangProject.getPFModel();
        if (pfModel == null || !pfModel.hasPowerDomains()) {
            return;
        }
        MenuItem menuItem = new MenuItem(menu, 0);
        menuItem.setText("Supply Network Diagram");
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DDesignEditorFactory.getInstance().newPowerDomainsDiagram(project, null).openEditor();
            }
        });
    }

    @Override
    public int compareTo(IDiagramToolbarMenuItemProvider o) {
        return this.getProviderName().compareToIgnoreCase(o.getProviderName());
    }

    @Override
    public String getProviderName() {
        return "2.C. Power Domains Diagram";
    }
}

