/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.uml.editor.actions;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.utils.DEditorDialog;
import ro.amiq.dvt.diagrams.uml.UMLDiagram;
import ro.amiq.dvt.diagrams.uml.UMLDiagramConfiguration;
import ro.amiq.dvt.diagrams.uml.editor.DUMLEditorFactory;
import ro.amiq.dvt.diagrams.uml.editor.actions.UMLPreferencesWidget;
import ro.amiq.dvt.diagrams.uml.model.UMLModel;
import ro.amiq.dvt.diagrams.uml.model.UMLNode;

public class DUMLPreferencesPanel
extends DEditorDialog {
    private UMLDiagram umlDiagram = (UMLDiagram)this.getDiagramEditor().getInput().getDiagram();
    private UMLDiagramConfiguration configCopy = this.umlDiagram.getModel().getConfig().copyConfig();
    private UMLPreferencesWidget preferencesWidget;

    public DUMLPreferencesPanel(DDiagramEditor diagramEditor, Point location) {
        super(diagramEditor, location, false);
    }

    @Override
    public void createMainArea(Composite parent) {
        this.preferencesWidget = new UMLPreferencesWidget(parent, this.configCopy);
    }

    @Override
    protected void createBottomArea(Composite parent) {
        Composite composite = this.createBottomComposite(parent, 2);
        this.createPreferencesLink("ro.amiq.dvt.diagrams.UMLDiagramPreferencePage", composite);
        Composite buttonsComposite = this.createButtonsComposite(composite, 3);
        this.createButton(buttonsComposite, 8, "Cancel", () -> {
            boolean bl = this.close();
        });
        this.createButton(buttonsComposite, 8, "New", () -> this.openEditor(true));
        this.createButton(buttonsComposite, 8, "Apply", () -> this.openEditor(false));
    }

    private void openEditor(boolean newEditor) {
        if (this.umlDiagram == null) {
            return;
        }
        UMLModel model = this.umlDiagram.getModel();
        for (UMLNode node : model.diagramNodes.keySet()) {
            boolean trump;
            if (!node.isSelected()) continue;
            boolean bl = trump = this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.MEMBERS) != UMLDiagramConfiguration.MembersOption.NONE;
            if (this.preferencesWidget.hasMembersChanged()) {
                node.showMethods = this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.SHOW_METHODS) != false && trump;
                node.showFields = this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.SHOW_FIELDS) != false && trump;
                boolean bl2 = node.showEvents = this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.SHOW_EVENTS) != false && trump;
            }
            if (this.preferencesWidget.hasShowMethodsChanged()) {
                boolean bl3 = node.showMethods = this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.SHOW_METHODS) != false && trump;
            }
            if (this.preferencesWidget.hasShowFieldsChanged()) {
                boolean bl4 = node.showFields = this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.SHOW_FIELDS) != false && trump;
            }
            if (this.preferencesWidget.hasShowEventsChanged()) {
                boolean bl5 = node.showEvents = this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.SHOW_EVENTS) != false && trump;
            }
            if (!this.preferencesWidget.hasShowFullMethodSignatureChanged()) continue;
            node.updateMembers(model, false, false, node.showMethods);
        }
        DUMLEditorFactory factory = DUMLEditorFactory.getInstance().newUMLDiagram(model.getCopy(this.configCopy));
        this.close();
        if (factory != null) {
            if (newEditor) {
                factory.openNewEditor();
            } else {
                factory.openReuseEditor(this.getDiagramEditor());
            }
        }
    }
}

