/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.uml.editor.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.actions.DSelectPanelAbstract;
import ro.amiq.dvt.diagrams.uml.UMLDiagram;
import ro.amiq.dvt.diagrams.uml.UMLDiagramConfiguration;
import ro.amiq.dvt.diagrams.uml.editor.DUMLEditorFactory;
import ro.amiq.dvt.diagrams.uml.model.UMLModel;
import ro.amiq.dvt.diagrams.uml.utils.FilteredList;
import ro.amiq.dvt.diagrams.uml.utils.MouseEnhancedFilteredList;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTNamedElementGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.utils.DVTColorUtil;

public class DUMLSelectPanel
extends DSelectPanelAbstract {
    private static final Object[] GUI_FILTERED_CONTENT = new Object[]{"All filtered by Content Filters."};
    private UMLDiagram umlDiagram = (UMLDiagram)this.getDiagramEditor().getInput().getDiagram();
    private UMLDiagramConfiguration diagramConfig = ((UMLDiagram)this.getDiagramEditor().getInput().getDiagram()).getModel().getConfig();
    private Label filtersLabel;
    private UMLModel diagramModelCopy = this.umlDiagram.getModel().getCopy(this.diagramConfig);
    protected Text statusBar;

    public DUMLSelectPanel(DDiagramEditor diagramEditor, Point location) {
        super(diagramEditor, location, false);
    }

    @Override
    public void createFiltersLabel(Composite buttonContainer) {
        this.filtersLabel = new Label(buttonContainer, 0x1000000);
    }

    @Override
    public MouseEnhancedFilteredList createSpecificPanelProviders(Composite container, boolean isLeftPanel) {
        MouseEnhancedFilteredList panel = null;
        PanelProvider panelProvider = new PanelProvider();
        if (isLeftPanel) {
            this.setLeftPanelProvider(panelProvider);
            panel = new MouseEnhancedFilteredList(container, 2050, this.getLeftPanelProvider(), true, true, true, true);
            panel.setLabelProvider(this.getLeftPanelProvider());
        } else {
            this.setRightPanelProvider(panelProvider);
            panel = new MouseEnhancedFilteredList(container, 2050, this.getRightPanelProvider(), true, true, true, true);
            panel.setLabelProvider(this.getRightPanelProvider());
        }
        return panel;
    }

    @Override
    public void addStatusBar() {
        this.statusBar = new Text(this.fPanelContainer, 2056);
        DVTColorUtil.INSTANCE.setBackground((Control)this.statusBar, JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.filter.backgroundColor"));
        DVTColorUtil.INSTANCE.setForeground((Control)this.statusBar, JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.filter.foregroundColor"));
        this.statusBar.setLayoutData((Object)new GridData(4, 1024, true, false, 3, 0));
    }

    @Override
    public void addButtons(Composite parent) {
    }

    @Override
    public MouseListener getMouseListener(final FilteredList panel) {
        return new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                if (panel == DUMLSelectPanel.this.leftPanel) {
                    DUMLSelectPanel.this.addItems(DUMLSelectPanel.this.leftPanel.getSelection());
                } else if (panel == DUMLSelectPanel.this.rightPanel) {
                    DUMLSelectPanel.this.removeItems(DUMLSelectPanel.this.rightPanel.getSelection());
                }
            }

            public void mouseDown(MouseEvent e) {
                String details;
                Object[] selection = DUMLSelectPanel.this.leftPanel.getSelection();
                if (selection == null || selection.length == 0) {
                    return;
                }
                Object element = selection[0];
                if (element instanceof String) {
                    return;
                }
                if (element != null && (details = DUMLSelectPanel.this.diagramModelCopy.getDetails(element)) != null) {
                    DUMLSelectPanel.this.statusBar.setText(details);
                }
            }

            public void mouseUp(MouseEvent e) {
            }
        };
    }

    @Override
    public SelectionListener getSelectionListener(final FilteredList panel) {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                String details;
                Object[] selection = panel.getSelection();
                if (selection == null || selection.length == 0 || selection[0] instanceof String) {
                    return;
                }
                Object element = selection[0];
                if (element != null && (details = DUMLSelectPanel.this.diagramModelCopy.getDetails(element)) != null) {
                    DUMLSelectPanel.this.statusBar.setText(details);
                }
            }
        };
    }

    @Override
    public void setInput() {
        boolean addLabel = false;
        Set leftTypesCopy = Collections.newSetFromMap(new IdentityHashMap());
        leftTypesCopy.addAll(this.diagramModelCopy.getLeftTypes());
        Set rightTypesCopy = Collections.newSetFromMap(new IdentityHashMap());
        rightTypesCopy.addAll(this.diagramModelCopy.getRightTypes().values());
        HashSet<String> names = new HashSet<String>();
        boolean showPackage = false;
        Iterator it = leftTypesCopy.iterator();
        while (it.hasNext()) {
            IRfNamedElement element;
            Object next = it.next();
            if (next instanceof IRfDefElement) {
                next = ((IRfDefElement)next).getNamedElement();
            }
            if (DVTNamedElementGUIFilterMatcher.filterElement(ViewSet.ViewName.DIAGRAM, (IRfNamedElement)next, () -> DUMLSelectPanel.lambda$0(element = (IRfNamedElement)next)) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                it.remove();
                addLabel = true;
                continue;
            }
            if (showPackage || names.add(this.leftPanel.getLabelProvider().getText((Object)element))) continue;
            showPackage = true;
        }
        Iterator it2 = rightTypesCopy.iterator();
        while (it2.hasNext()) {
            IRfNamedElement element;
            Object next = it2.next();
            if (next instanceof IRfDefElement) {
                next = ((IRfDefElement)next).getNamedElement();
            }
            if (DVTNamedElementGUIFilterMatcher.filterElement(ViewSet.ViewName.DIAGRAM, (IRfNamedElement)next, () -> DUMLSelectPanel.lambda$1(element = (IRfNamedElement)next)) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                it2.remove();
                addLabel = true;
                continue;
            }
            if (showPackage || names.add(this.leftPanel.getLabelProvider().getText((Object)element))) continue;
            showPackage = true;
        }
        if (addLabel) {
            this.filtersLabel.setImage(DVTImages.imageCache.getImage(DVTImages.GUI_FILTERS_ICON));
            this.filtersLabel.setToolTipText("Content Filters matched!");
        } else {
            this.filtersLabel.setImage(null);
        }
        ((PanelProvider)this.getLeftPanelProvider()).showPackage(showPackage);
        ((PanelProvider)this.getRightPanelProvider()).showPackage(showPackage);
        this.leftPanel.setTextUnique(!showPackage);
        this.rightPanel.setTextUnique(!showPackage);
        if (leftTypesCopy.isEmpty()) {
            if (addLabel) {
                this.leftPanel.setElements(GUI_FILTERED_CONTENT);
            } else {
                this.leftPanel.setElements(NO_DATA);
            }
        } else {
            this.leftPanel.setElements(leftTypesCopy.toArray());
        }
        this.rightPanel.setElements(rightTypesCopy.toArray());
    }

    @Override
    public void addItems(Object[] items) {
        this.addItemsToPanel(items, this.leftPanel, this.rightPanel);
        this.diagramModelCopy.setRightTypes(new ArrayList<Object>(Arrays.asList(items)));
        this.diagramModelCopy.updateLeftTypes(this.diagramModelCopy.getLeftTypes());
    }

    @Override
    public void removeItems(Object[] items) {
        this.addItemsToPanel(items, this.rightPanel, this.leftPanel);
        this.diagramModelCopy.removeRightTypes(Arrays.asList(items));
    }

    @Override
    public void addAll() {
        this.addItemsToPanel(this.leftPanel.getElements(), this.leftPanel, this.rightPanel);
        for (Object o : this.diagramModelCopy.getLeftTypes()) {
            this.diagramModelCopy.getRightTypes().put(this.diagramModelCopy.generateID(o), o);
        }
        this.diagramModelCopy.setLeftTypes(new LinkedHashSet<Object>());
    }

    @Override
    public void removeAll() {
        this.addItemsToPanel(this.rightPanel.getElements(), this.rightPanel, this.leftPanel);
        ArrayList<Object> rightTypesCopy = new ArrayList<Object>(this.diagramModelCopy.getRightTypes().values());
        this.diagramModelCopy.removeRightTypes(rightTypesCopy);
    }

    private void addItemsToPanel(Object[] items, MouseEnhancedFilteredList source, MouseEnhancedFilteredList destination) {
        if (items == null || items.length < 1) {
            return;
        }
        List<Object> itemsList = Arrays.asList(items);
        if (itemsList.contains(GUI_FILTERED_CONTENT[0]) || itemsList.contains(NO_DATA[0])) {
            return;
        }
        HashMap<String, Object> sourceMap = new HashMap<String, Object>();
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            sourceMap.put(this.leftPanel.getLabelProvider().getText(item), item);
            ++n2;
        }
        List<Object> temp = this.removeAll(new ArrayList<Object>(Arrays.asList(source.getElements())), sourceMap);
        if (temp.isEmpty()) {
            if (this.filtersLabel.getImage() != null) {
                source.setElements(GUI_FILTERED_CONTENT);
            } else {
                source.setElements(NO_DATA);
            }
        } else {
            source.setElements(temp.toArray());
        }
        ArrayList<Object> destinationList = new ArrayList<Object>(Arrays.asList(destination.getElements()));
        if (destinationList.contains(NO_DATA[0]) || destinationList.contains(GUI_FILTERED_CONTENT[0])) {
            destinationList.remove(NO_DATA[0]);
            destinationList.remove(GUI_FILTERED_CONTENT[0]);
        }
        destinationList.addAll(sourceMap.values());
        destination.setElements(destinationList.toArray());
        source.setSelection(new int[1]);
        destination.setSelection(new int[1]);
    }

    public <T> List<T> removeAll(List<T> source, Map<String, ? extends T> toRemove) {
        if (toRemove.isEmpty()) {
            return source;
        }
        ArrayList<T> result = new ArrayList<T>(source.size());
        int removeCount = toRemove.size();
        for (T element : source) {
            if (removeCount == 0 || !toRemove.containsKey(this.leftPanel.getLabelProvider().getText(element))) {
                result.add(element);
                continue;
            }
            --removeCount;
        }
        return result;
    }

    @Override
    public void openEditor(boolean newEditor) {
        if (this.umlDiagram == null) {
            return;
        }
        this.diagramModelCopy.setDiagramKind(UMLModel.DiagramKind.NA);
        DUMLEditorFactory factory = DUMLEditorFactory.getInstance().newUMLDiagram(this.diagramModelCopy);
        this.close();
        if (factory != null) {
            if (newEditor) {
                factory.openNewEditor();
            } else {
                factory.openReuseEditor(this.getDiagramEditor());
            }
        }
    }

    private static /* synthetic */ String lambda$0(IRfNamedElement iRfNamedElement) {
        return iRfNamedElement.getNameForDiagram();
    }

    private static /* synthetic */ String lambda$1(IRfNamedElement iRfNamedElement) {
        return iRfNamedElement.getNameForDiagram();
    }

    public final class PanelProvider
    extends LabelProvider {
        private boolean showPackage;

        public void showPackage(boolean showPackage) {
            this.showPackage = showPackage;
        }

        public Image getImage(Object element) {
            if (element instanceof String) {
                return null;
            }
            return DUMLSelectPanel.this.diagramModelCopy.getIcon(element);
        }

        public String getText(Object element) {
            if (!(element instanceof String)) {
                return !this.showPackage ? DUMLSelectPanel.this.diagramModelCopy.getNodeName(element) : this.getFullText(element);
            }
            if (((String)element).equals("All filtered by Content Filters.")) {
                return "All filtered by Content Filters.";
            }
            return "No data.";
        }

        public String getFullText(Object element) {
            if (!(element instanceof String)) {
                return DUMLSelectPanel.this.diagramModelCopy.getFullNodeName(element);
            }
            if (((String)element).equals("All filtered by Content Filters.")) {
                return "All filtered by Content Filters.";
            }
            return "No data.";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

