/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.uml.editor.actions;

import de.cau.cs.kieler.kiml.options.Direction;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import ro.amiq.dvt.diagrams.uml.UMLDiagramConfiguration;

public class UMLPreferencesWidget {
    private final UMLDiagramConfiguration configCopy;
    private boolean membersChanged;
    private boolean showMethodsChanged;
    private boolean showFieldsChanged;
    private boolean showEventsChanged;
    private boolean showFullMethodSignatureChanged;
    private Button parentsNone;
    private Button parentsSelected;
    private Button parentsCustom;
    private Button parentsAll;
    private Button childrenNone;
    private Button childrenSelected;
    private Button childrenCustom;
    private Button childrenAll;
    private Button associationsNone;
    private Button associationsSelected;
    private Button associationsCustom;
    private Button associationsAll;
    private Button directionUp;
    private Button directionDown;
    private Button directionRight;
    private Button directionLeft;
    private Button membersAll;
    private Button membersPublic;
    private Button membersNone;
    private Button membersKindEvents;
    private Button membersKindMethods;
    private Button membersKindFields;
    private Button packageInfo;
    private Button fullSignature;
    private Button associationLabels;
    private Button groupByPackage;
    private Button edgeRouting;
    private Spinner parentsDepthSpinner;
    private Spinner childrenDepthSpinner;
    private Spinner associationsDepthSpinner;

    public UMLPreferencesWidget(Composite parent, UMLDiagramConfiguration configCopy) {
        this.configCopy = configCopy;
        Composite panelContainer = new Composite(parent, 0);
        panelContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        panelContainer.setLayout((Layout)new GridLayout(2, false));
        this.createParentsGroup(panelContainer);
        this.createChildrenGroup(panelContainer);
        this.createAssociationsGroup(panelContainer);
        this.createGraphDirectionGroup(panelContainer);
        this.createMembersGroup(panelContainer);
        this.createMembersKindGroup(panelContainer);
        this.createFullMethodSignatureGroup(panelContainer);
        this.createAssociationLabelsGroup(panelContainer);
        this.createEdgeRoutingGroup(panelContainer);
        this.createPackageInfoGroup(panelContainer);
        this.createGroupByPackageGroup(panelContainer);
    }

    private void createParentsGroup(Composite parent) {
        Group group = new Group(parent, 16);
        group.setText(" Parents ");
        group.setLayout((Layout)new GridLayout(2, true));
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        this.parentsNone = UMLPreferencesWidget.createRadioButton((Composite)group, "None", this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.PARENTS) == UMLDiagramConfiguration.RelationOption.NONE);
        this.parentsNone.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.parentsNone.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UMLPreferencesWidget.this.parentsNone.getSelection()) {
                    UMLPreferencesWidget.this.configCopy.set(UMLDiagramConfiguration.UMLConfigKey.PARENTS, UMLDiagramConfiguration.RelationOption.NONE);
                }
            }
        });
        this.parentsSelected = UMLPreferencesWidget.createRadioButton((Composite)group, "Selected", this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.PARENTS) == UMLDiagramConfiguration.RelationOption.SELECTED);
        this.parentsSelected.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.parentsSelected.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UMLPreferencesWidget.this.parentsSelected.getSelection()) {
                    UMLPreferencesWidget.this.configCopy.set(UMLDiagramConfiguration.UMLConfigKey.PARENTS, UMLDiagramConfiguration.RelationOption.SELECTED);
                }
            }
        });
        this.parentsCustom = UMLPreferencesWidget.createRadioButton((Composite)group, "Depth:", this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.PARENTS) == UMLDiagramConfiguration.RelationOption.CUSTOM_DEPTH);
        this.parentsCustom.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        GridData gridData = new GridData(4, 4, true, false);
        this.parentsDepthSpinner = new Spinner((Composite)group, 2048);
        this.parentsDepthSpinner.setLayoutData((Object)gridData);
        this.parentsDepthSpinner.setSelection(this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.PARENTS_DEPTH).intValue());
        this.parentsDepthSpinner.setEnabled(this.parentsCustom.getSelection());
        this.parentsDepthSpinner.setMinimum(1);
        this.parentsDepthSpinner.setMaximum(99);
        this.parentsCustom.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UMLPreferencesWidget.this.parentsCustom.getSelection()) {
                    UMLPreferencesWidget.this.parentsDepthSpinner.setEnabled(true);
                    UMLPreferencesWidget.this.configCopy.set(UMLDiagramConfiguration.UMLConfigKey.PARENTS, UMLDiagramConfiguration.RelationOption.CUSTOM_DEPTH);
                    UMLPreferencesWidget.this.configCopy.set(UMLDiagramConfiguration.UMLConfigKey.PARENTS_DEPTH, UMLPreferencesWidget.this.parentsDepthSpinner.getSelection());
                } else {
                    UMLPreferencesWidget.this.parentsDepthSpinner.setEnabled(false);
                }
            }
        });
        this.parentsDepthSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UMLPreferencesWidget.this.configCopy.set(UMLDiagramConfiguration.UMLConfigKey.PARENTS_DEPTH, UMLPreferencesWidget.this.parentsDepthSpinner.getSelection());
            }
        });
        this.parentsAll = UMLPreferencesWidget.createRadioButton((Composite)group, "All", this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.PARENTS) == UMLDiagramConfiguration.RelationOption.ALL);
        this.parentsAll.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.parentsAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UMLPreferencesWidget.this.parentsAll.getSelection()) {
                    UMLPreferencesWidget.this.configCopy.set(UMLDiagramConfiguration.UMLConfigKey.PARENTS, UMLDiagramConfiguration.RelationOption.ALL);
                }
            }
        });
    }

    private void createChildrenGroup(Composite parent) {
        Group group = new Group(parent, 16);
        group.setText(" Children ");
        group.setLayout((Layout)new GridLayout(2, true));
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        this.childrenNone = UMLPreferencesWidget.createRadioButton((Composite)group, "None", this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.CHILDREN) == UMLDiagramConfiguration.RelationOption.NONE);
        this.childrenNone.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.childrenNone.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UMLPreferencesWidget.this.childrenNone.getSelection()) {
                    UMLPreferencesWidget.this.configCopy.set(UMLDiagramConfiguration.UMLConfigKey.CHILDREN, UMLDiagramConfiguration.RelationOption.NONE);
                }
            }
        });
        this.childrenSelected = UMLPreferencesWidget.createRadioButton((Composite)group, "Selected", this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.CHILDREN) == UMLDiagramConfiguration.RelationOption.SELECTED);
        this.childrenSelected.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.childrenSelected.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UMLPreferencesWidget.this.childrenSelected.getSelection()) {
                    UMLPreferencesWidget.this.configCopy.set(UMLDiagramConfiguration.UMLConfigKey.CHILDREN, UMLDiagramConfiguration.RelationOption.SELECTED);
                }
            }
        });
        this.childrenCustom = UMLPreferencesWidget.createRadioButton((Composite)group, "Depth:", this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.CHILDREN) == UMLDiagramConfiguration.RelationOption.CUSTOM_DEPTH);
        this.childrenCustom.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        GridData gridData = new GridData(4, 4, true, false);
        this.childrenDepthSpinner = new Spinner((Composite)group, 2048);
        this.childrenDepthSpinner.setLayoutData((Object)gridData);
        this.childrenDepthSpinner.setSelection(this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.CHILDREN_DEPTH).intValue());
        this.childrenDepthSpinner.setEnabled(this.childrenCustom.getSelection());
        this.childrenDepthSpinner.setMinimum(1);
        this.childrenDepthSpinner.setMaximum(99);
        this.childrenCustom.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UMLPreferencesWidget.this.childrenCustom.getSelection()) {
                    UMLPreferencesWidget.this.childrenDepthSpinner.setEnabled(true);
                    UMLPreferencesWidget.this.configCopy.set(UMLDiagramConfiguration.UMLConfigKey.CHILDREN, UMLDiagramConfiguration.RelationOption.CUSTOM_DEPTH);
                    UMLPreferencesWidget.this.configCopy.set(UMLDiagramConfiguration.UMLConfigKey.CHILDREN_DEPTH, UMLPreferencesWidget.this.childrenDepthSpinner.getSelection());
                } else {
                    UMLPreferencesWidget.this.childrenDepthSpinner.setEnabled(false);
                }
            }
        });
        this.childrenDepthSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UMLPreferencesWidget.this.configCopy.set(UMLDiagramConfiguration.UMLConfigKey.CHILDREN_DEPTH, UMLPreferencesWidget.this.childrenDepthSpinner.getSelection());
            }
        });
        this.childrenAll = UMLPreferencesWidget.createRadioButton((Composite)group, "All", this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.CHILDREN) == UMLDiagramConfiguration.RelationOption.ALL);
        this.childrenAll.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.childrenAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UMLPreferencesWidget.this.childrenAll.getSelection()) {
                    UMLPreferencesWidget.this.configCopy.set(UMLDiagramConfiguration.UMLConfigKey.CHILDREN, UMLDiagramConfiguration.RelationOption.ALL);
                }
            }
        });
    }

    private void createAssociationsGroup(Composite parent) {
        Group group = new Group(parent, 16);
        group.setText(" Associations ");
        group.setLayout((Layout)new GridLayout(2, true));
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        this.associationsNone = UMLPreferencesWidget.createRadioButton((Composite)group, "None", this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.ASSOCIATIONS) == UMLDiagramConfiguration.RelationOption.NONE);
        this.associationsNone.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.associationsNone.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UMLPreferencesWidget.this.associationsNone.getSelection()) {
                    UMLPreferencesWidget.this.configCopy.set(UMLDiagramConfiguration.UMLConfigKey.ASSOCIATIONS, UMLDiagramConfiguration.RelationOption.NONE);
                }
            }
        });
        this.associationsSelected = UMLPreferencesWidget.createRadioButton((Composite)group, "Selected", this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.ASSOCIATIONS) == UMLDiagramConfiguration.RelationOption.SELECTED);
        this.associationsSelected.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.associationsSelected.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UMLPreferencesWidget.this.associationsSelected.getSelection()) {
                    UMLPreferencesWidget.this.configCopy.set(UMLDiagramConfiguration.UMLConfigKey.ASSOCIATIONS, UMLDiagramConfiguration.RelationOption.SELECTED);
                }
            }
        });
        this.associationsCustom = UMLPreferencesWidget.createRadioButton((Composite)group, "Depth:", this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.ASSOCIATIONS) == UMLDiagramConfiguration.RelationOption.CUSTOM_DEPTH);
        this.associationsCustom.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        GridData gridData = new GridData(4, 4, true, false);
        this.associationsDepthSpinner = new Spinner((Composite)group, 2048);
        this.associationsDepthSpinner.setLayoutData((Object)gridData);
        this.associationsDepthSpinner.setSelection(this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.ASSOCIATIONS_DEPTH).intValue());
        this.associationsDepthSpinner.setEnabled(this.associationsCustom.getSelection());
        this.associationsDepthSpinner.setMinimum(1);
        this.associationsDepthSpinner.setMaximum(99);
        this.associationsCustom.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UMLPreferencesWidget.this.associationsCustom.getSelection()) {
                    UMLPreferencesWidget.this.associationsDepthSpinner.setEnabled(true);
                    UMLPreferencesWidget.this.configCopy.set(UMLDiagramConfiguration.UMLConfigKey.ASSOCIATIONS, UMLDiagramConfiguration.RelationOption.CUSTOM_DEPTH);
                    UMLPreferencesWidget.this.configCopy.set(UMLDiagramConfiguration.UMLConfigKey.ASSOCIATIONS_DEPTH, UMLPreferencesWidget.this.associationsDepthSpinner.getSelection());
                } else {
                    UMLPreferencesWidget.this.associationsDepthSpinner.setEnabled(false);
                }
            }
        });
        this.associationsDepthSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UMLPreferencesWidget.this.configCopy.set(UMLDiagramConfiguration.UMLConfigKey.ASSOCIATIONS_DEPTH, UMLPreferencesWidget.this.associationsDepthSpinner.getSelection());
            }
        });
        this.associationsAll = UMLPreferencesWidget.createRadioButton((Composite)group, "All", this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.ASSOCIATIONS) == UMLDiagramConfiguration.RelationOption.ALL);
        this.associationsAll.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.associationsAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UMLPreferencesWidget.this.associationsAll.getSelection()) {
                    UMLPreferencesWidget.this.configCopy.set(UMLDiagramConfiguration.UMLConfigKey.ASSOCIATIONS, UMLDiagramConfiguration.RelationOption.ALL);
                }
            }
        });
    }

    private void createMembersGroup(Composite parent) {
        Group group = new Group(parent, 16);
        group.setText(" Members ");
        group.setLayout((Layout)new RowLayout(512));
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        this.membersAll = UMLPreferencesWidget.createRadioButton((Composite)group, "All", this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.MEMBERS) == UMLDiagramConfiguration.MembersOption.ALL);
        this.membersAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UMLPreferencesWidget.this.membersAll.getSelection()) {
                    UMLPreferencesWidget.this.configCopy.set(UMLDiagramConfiguration.UMLConfigKey.MEMBERS, UMLDiagramConfiguration.MembersOption.ALL);
                    UMLPreferencesWidget.this.membersChanged = true;
                    UMLPreferencesWidget.this.membersKindFields.setEnabled(true);
                    UMLPreferencesWidget.this.membersKindMethods.setEnabled(true);
                    UMLPreferencesWidget.this.membersKindEvents.setEnabled(true);
                }
            }
        });
        this.membersPublic = UMLPreferencesWidget.createRadioButton((Composite)group, "Public", this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.MEMBERS) == UMLDiagramConfiguration.MembersOption.PUBLIC);
        this.membersPublic.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UMLPreferencesWidget.this.membersPublic.getSelection()) {
                    UMLPreferencesWidget.this.configCopy.set(UMLDiagramConfiguration.UMLConfigKey.MEMBERS, UMLDiagramConfiguration.MembersOption.PUBLIC);
                    UMLPreferencesWidget.this.membersChanged = true;
                    UMLPreferencesWidget.this.membersKindFields.setEnabled(true);
                    UMLPreferencesWidget.this.membersKindMethods.setEnabled(true);
                    UMLPreferencesWidget.this.membersKindEvents.setEnabled(true);
                }
            }
        });
        this.membersNone = UMLPreferencesWidget.createRadioButton((Composite)group, "None", this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.MEMBERS) == UMLDiagramConfiguration.MembersOption.NONE);
        this.membersNone.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UMLPreferencesWidget.this.membersNone.getSelection()) {
                    UMLPreferencesWidget.this.configCopy.set(UMLDiagramConfiguration.UMLConfigKey.MEMBERS, UMLDiagramConfiguration.MembersOption.NONE);
                    UMLPreferencesWidget.this.membersChanged = true;
                    UMLPreferencesWidget.this.membersKindFields.setEnabled(false);
                    UMLPreferencesWidget.this.membersKindMethods.setEnabled(false);
                    UMLPreferencesWidget.this.membersKindEvents.setEnabled(false);
                }
            }
        });
    }

    private void createMembersKindGroup(Composite parent) {
        Group group = new Group(parent, 16);
        group.setText(" Member Kinds ");
        group.setLayout((Layout)new RowLayout(512));
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        boolean enabled = this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.MEMBERS) == UMLDiagramConfiguration.MembersOption.ALL || this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.MEMBERS) == UMLDiagramConfiguration.MembersOption.PUBLIC;
        this.membersKindFields = UMLPreferencesWidget.createCheckButton((Composite)group, "Fields", this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.SHOW_FIELDS));
        this.membersKindFields.setEnabled(enabled);
        this.membersKindFields.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UMLPreferencesWidget.this.configCopy.set(UMLDiagramConfiguration.UMLConfigKey.SHOW_FIELDS, UMLPreferencesWidget.this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.SHOW_FIELDS) == false);
                UMLPreferencesWidget.this.showFieldsChanged = true;
            }
        });
        this.membersKindEvents = UMLPreferencesWidget.createCheckButton((Composite)group, "Events", this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.SHOW_EVENTS));
        this.membersKindEvents.setEnabled(enabled);
        this.membersKindEvents.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UMLPreferencesWidget.this.configCopy.set(UMLDiagramConfiguration.UMLConfigKey.SHOW_EVENTS, UMLPreferencesWidget.this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.SHOW_EVENTS) == false);
                UMLPreferencesWidget.this.showEventsChanged = true;
            }
        });
        this.membersKindMethods = UMLPreferencesWidget.createCheckButton((Composite)group, "Methods", this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.SHOW_METHODS));
        this.membersKindMethods.setEnabled(enabled);
        this.membersKindMethods.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UMLPreferencesWidget.this.configCopy.set(UMLDiagramConfiguration.UMLConfigKey.SHOW_METHODS, UMLPreferencesWidget.this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.SHOW_METHODS) == false);
                UMLPreferencesWidget.this.showMethodsChanged = true;
            }
        });
    }

    private void createGraphDirectionGroup(Composite parent) {
        Group group = new Group(parent, 16);
        group.setText(" Graph Direction ");
        group.setLayout((Layout)new RowLayout(512));
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        this.directionDown = UMLPreferencesWidget.createRadioButton((Composite)group, "Top-Bottom", this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.DIRECTION) == Direction.DOWN);
        this.directionDown.setEnabled(this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.GROUP_BY_PACKAGE) == false);
        this.directionDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UMLPreferencesWidget.this.directionDown.getSelection()) {
                    UMLPreferencesWidget.this.configCopy.set(UMLDiagramConfiguration.UMLConfigKey.DIRECTION, Direction.DOWN);
                }
            }
        });
        this.directionUp = UMLPreferencesWidget.createRadioButton((Composite)group, "Bottom-Top", this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.DIRECTION) == Direction.UP);
        this.directionUp.setEnabled(this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.GROUP_BY_PACKAGE) == false);
        this.directionUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UMLPreferencesWidget.this.directionUp.getSelection()) {
                    UMLPreferencesWidget.this.configCopy.set(UMLDiagramConfiguration.UMLConfigKey.DIRECTION, Direction.UP);
                }
            }
        });
        this.directionRight = UMLPreferencesWidget.createRadioButton((Composite)group, "Left-Right", this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.DIRECTION) == Direction.RIGHT);
        this.directionRight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UMLPreferencesWidget.this.directionRight.getSelection()) {
                    UMLPreferencesWidget.this.configCopy.set(UMLDiagramConfiguration.UMLConfigKey.DIRECTION, Direction.RIGHT);
                }
            }
        });
        this.directionLeft = UMLPreferencesWidget.createRadioButton((Composite)group, "Right-Left", this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.DIRECTION) == Direction.LEFT);
        this.directionLeft.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UMLPreferencesWidget.this.directionLeft.getSelection()) {
                    UMLPreferencesWidget.this.configCopy.set(UMLDiagramConfiguration.UMLConfigKey.DIRECTION, Direction.LEFT);
                }
            }
        });
    }

    private void createPackageInfoGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new RowLayout(512));
        composite.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.packageInfo = UMLPreferencesWidget.createCheckButton(composite, "Show package information", this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.SHOW_PACKAGE_INFORMATION));
        this.packageInfo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UMLPreferencesWidget.this.configCopy.set(UMLDiagramConfiguration.UMLConfigKey.SHOW_PACKAGE_INFORMATION, UMLPreferencesWidget.this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.SHOW_PACKAGE_INFORMATION) == false);
            }
        });
    }

    private void createFullMethodSignatureGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new RowLayout(512));
        composite.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.fullSignature = UMLPreferencesWidget.createCheckButton(composite, "Show full method signature", this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.SHOW_FULL_METHOD_SIGNATURE));
        this.fullSignature.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UMLPreferencesWidget.this.configCopy.set(UMLDiagramConfiguration.UMLConfigKey.SHOW_FULL_METHOD_SIGNATURE, UMLPreferencesWidget.this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.SHOW_FULL_METHOD_SIGNATURE) == false);
                UMLPreferencesWidget.this.showFullMethodSignatureChanged = true;
            }
        });
    }

    private void createAssociationLabelsGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new RowLayout(512));
        composite.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.associationLabels = UMLPreferencesWidget.createCheckButton(composite, "Show association labels", this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.SHOW_ASSOCIATION_LABELS));
        this.associationLabels.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UMLPreferencesWidget.this.configCopy.set(UMLDiagramConfiguration.UMLConfigKey.SHOW_ASSOCIATION_LABELS, UMLPreferencesWidget.this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.SHOW_ASSOCIATION_LABELS) == false);
            }
        });
    }

    private void createGroupByPackageGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new RowLayout(512));
        composite.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.groupByPackage = UMLPreferencesWidget.createCheckButton(composite, "Group by package", this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.GROUP_BY_PACKAGE));
        this.groupByPackage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UMLPreferencesWidget.this.configCopy.set(UMLDiagramConfiguration.UMLConfigKey.GROUP_BY_PACKAGE, UMLPreferencesWidget.this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.GROUP_BY_PACKAGE) == false);
                if (UMLPreferencesWidget.this.groupByPackage.getSelection()) {
                    if (UMLPreferencesWidget.this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.DIRECTION) != Direction.RIGHT || UMLPreferencesWidget.this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.DIRECTION) != Direction.LEFT) {
                        UMLPreferencesWidget.this.configCopy.set(UMLDiagramConfiguration.UMLConfigKey.DIRECTION, Direction.RIGHT);
                        UMLPreferencesWidget.this.directionRight.setSelection(true);
                    }
                    UMLPreferencesWidget.this.directionDown.setSelection(false);
                    UMLPreferencesWidget.this.directionUp.setSelection(false);
                    UMLPreferencesWidget.this.configCopy.set(UMLDiagramConfiguration.UMLConfigKey.ORTHOGONAL_EDGE_ROUTING, true);
                    UMLPreferencesWidget.this.edgeRouting.setSelection(true);
                }
                UMLPreferencesWidget.this.directionDown.setEnabled(UMLPreferencesWidget.this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.GROUP_BY_PACKAGE) == false);
                UMLPreferencesWidget.this.directionUp.setEnabled(UMLPreferencesWidget.this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.GROUP_BY_PACKAGE) == false);
                UMLPreferencesWidget.this.edgeRouting.setEnabled(UMLPreferencesWidget.this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.GROUP_BY_PACKAGE) == false);
            }
        });
    }

    private void createEdgeRoutingGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new RowLayout(512));
        composite.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.edgeRouting = UMLPreferencesWidget.createCheckButton(composite, "Orthogonal edge routing", this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.ORTHOGONAL_EDGE_ROUTING));
        this.edgeRouting.setEnabled(this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.GROUP_BY_PACKAGE) == false);
        this.edgeRouting.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UMLPreferencesWidget.this.configCopy.set(UMLDiagramConfiguration.UMLConfigKey.ORTHOGONAL_EDGE_ROUTING, UMLPreferencesWidget.this.configCopy.get(UMLDiagramConfiguration.UMLConfigKey.ORTHOGONAL_EDGE_ROUTING) == false);
            }
        });
    }

    protected static Button createRadioButton(Composite group, String text, boolean initialSelection) {
        Button button = new Button(group, 16400);
        button.setText(text);
        button.setSelection(initialSelection);
        return button;
    }

    protected static Button createCheckButton(Composite group, String text, boolean initialSelection) {
        Button button = new Button(group, 16416);
        button.setText(text);
        button.setSelection(initialSelection);
        return button;
    }

    public boolean hasMembersChanged() {
        return this.membersChanged;
    }

    public boolean hasShowMethodsChanged() {
        return this.showMethodsChanged;
    }

    public boolean hasShowFieldsChanged() {
        return this.showFieldsChanged;
    }

    public boolean hasShowEventsChanged() {
        return this.showEventsChanged;
    }

    public boolean hasShowFullMethodSignatureChanged() {
        return this.showFullMethodSignatureChanged;
    }

    public void updateButtons(UMLDiagramConfiguration config) {
        this.parentsNone.setSelection(config.get(UMLDiagramConfiguration.UMLConfigKey.PARENTS) == UMLDiagramConfiguration.RelationOption.NONE);
        this.parentsSelected.setSelection(config.get(UMLDiagramConfiguration.UMLConfigKey.PARENTS) == UMLDiagramConfiguration.RelationOption.SELECTED);
        this.parentsCustom.setSelection(config.get(UMLDiagramConfiguration.UMLConfigKey.PARENTS) == UMLDiagramConfiguration.RelationOption.CUSTOM_DEPTH);
        this.parentsAll.setSelection(config.get(UMLDiagramConfiguration.UMLConfigKey.PARENTS) == UMLDiagramConfiguration.RelationOption.ALL);
        this.childrenNone.setSelection(config.get(UMLDiagramConfiguration.UMLConfigKey.CHILDREN) == UMLDiagramConfiguration.RelationOption.NONE);
        this.childrenSelected.setSelection(config.get(UMLDiagramConfiguration.UMLConfigKey.CHILDREN) == UMLDiagramConfiguration.RelationOption.SELECTED);
        this.childrenCustom.setSelection(config.get(UMLDiagramConfiguration.UMLConfigKey.CHILDREN) == UMLDiagramConfiguration.RelationOption.CUSTOM_DEPTH);
        this.childrenAll.setSelection(config.get(UMLDiagramConfiguration.UMLConfigKey.CHILDREN) == UMLDiagramConfiguration.RelationOption.ALL);
        this.associationsNone.setSelection(config.get(UMLDiagramConfiguration.UMLConfigKey.ASSOCIATIONS) == UMLDiagramConfiguration.RelationOption.NONE);
        this.associationsSelected.setSelection(config.get(UMLDiagramConfiguration.UMLConfigKey.ASSOCIATIONS) == UMLDiagramConfiguration.RelationOption.SELECTED);
        this.associationsCustom.setSelection(config.get(UMLDiagramConfiguration.UMLConfigKey.ASSOCIATIONS) == UMLDiagramConfiguration.RelationOption.CUSTOM_DEPTH);
        this.associationsAll.setSelection(config.get(UMLDiagramConfiguration.UMLConfigKey.ASSOCIATIONS) == UMLDiagramConfiguration.RelationOption.ALL);
        this.directionUp.setSelection(config.get(UMLDiagramConfiguration.UMLConfigKey.DIRECTION) == Direction.UP);
        this.directionDown.setSelection(config.get(UMLDiagramConfiguration.UMLConfigKey.DIRECTION) == Direction.DOWN);
        this.directionRight.setSelection(config.get(UMLDiagramConfiguration.UMLConfigKey.DIRECTION) == Direction.RIGHT);
        this.directionLeft.setSelection(config.get(UMLDiagramConfiguration.UMLConfigKey.DIRECTION) == Direction.LEFT);
        this.membersAll.setSelection(config.get(UMLDiagramConfiguration.UMLConfigKey.MEMBERS) == UMLDiagramConfiguration.MembersOption.ALL);
        this.membersPublic.setSelection(config.get(UMLDiagramConfiguration.UMLConfigKey.MEMBERS) == UMLDiagramConfiguration.MembersOption.PUBLIC);
        this.membersNone.setSelection(config.get(UMLDiagramConfiguration.UMLConfigKey.MEMBERS) == UMLDiagramConfiguration.MembersOption.NONE);
        boolean enabled = config.get(UMLDiagramConfiguration.UMLConfigKey.MEMBERS) != UMLDiagramConfiguration.MembersOption.NONE;
        this.membersKindEvents.setEnabled(enabled);
        this.membersKindMethods.setEnabled(enabled);
        this.membersKindFields.setEnabled(enabled);
        this.membersKindEvents.setSelection(config.get(UMLDiagramConfiguration.UMLConfigKey.SHOW_EVENTS).booleanValue());
        this.membersKindMethods.setSelection(config.get(UMLDiagramConfiguration.UMLConfigKey.SHOW_METHODS).booleanValue());
        this.membersKindFields.setSelection(config.get(UMLDiagramConfiguration.UMLConfigKey.SHOW_FIELDS).booleanValue());
        this.packageInfo.setSelection(config.get(UMLDiagramConfiguration.UMLConfigKey.SHOW_PACKAGE_INFORMATION).booleanValue());
        this.fullSignature.setSelection(config.get(UMLDiagramConfiguration.UMLConfigKey.SHOW_FULL_METHOD_SIGNATURE).booleanValue());
        this.associationLabels.setSelection(config.get(UMLDiagramConfiguration.UMLConfigKey.SHOW_ASSOCIATION_LABELS).booleanValue());
        this.groupByPackage.setSelection(config.get(UMLDiagramConfiguration.UMLConfigKey.GROUP_BY_PACKAGE).booleanValue());
        this.edgeRouting.setSelection(config.get(UMLDiagramConfiguration.UMLConfigKey.ORTHOGONAL_EDGE_ROUTING).booleanValue());
        this.directionDown.setEnabled(config.get(UMLDiagramConfiguration.UMLConfigKey.GROUP_BY_PACKAGE) == false);
        this.directionUp.setEnabled(config.get(UMLDiagramConfiguration.UMLConfigKey.GROUP_BY_PACKAGE) == false);
        this.edgeRouting.setEnabled(config.get(UMLDiagramConfiguration.UMLConfigKey.GROUP_BY_PACKAGE) == false);
        this.parentsDepthSpinner.setEnabled(config.get(UMLDiagramConfiguration.UMLConfigKey.PARENTS) == UMLDiagramConfiguration.RelationOption.CUSTOM_DEPTH);
        this.parentsDepthSpinner.setSelection(config.get(UMLDiagramConfiguration.UMLConfigKey.PARENTS_DEPTH).intValue());
        this.childrenDepthSpinner.setEnabled(config.get(UMLDiagramConfiguration.UMLConfigKey.CHILDREN) == UMLDiagramConfiguration.RelationOption.CUSTOM_DEPTH);
        this.childrenDepthSpinner.setSelection(config.get(UMLDiagramConfiguration.UMLConfigKey.CHILDREN_DEPTH).intValue());
        this.associationsDepthSpinner.setEnabled(config.get(UMLDiagramConfiguration.UMLConfigKey.ASSOCIATIONS) == UMLDiagramConfiguration.RelationOption.CUSTOM_DEPTH);
        this.associationsDepthSpinner.setSelection(config.get(UMLDiagramConfiguration.UMLConfigKey.ASSOCIATIONS_DEPTH).intValue());
    }
}

