/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.uml.editor.actions.menu;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.DMenuAction;
import ro.amiq.dvt.diagrams.uml.UMLDiagram;
import ro.amiq.dvt.diagrams.uml.editor.DUMLEditorFactory;
import ro.amiq.dvt.diagrams.uml.model.IUMLViewSelectable;
import ro.amiq.dvt.diagrams.uml.model.UMLModel;
import ro.amiq.dvt.diagrams.uml.model.UMLNode;

public class DUMLDeselectTypeMenuAction
extends DMenuAction {
    private List<UMLNode> selectedNodes = new ArrayList<UMLNode>();
    private DDiagramEditor diagramEditor;

    public DUMLDeselectTypeMenuAction(List<IUMLViewSelectable> selection, DDiagram diagram, DDiagramEditor diagramEditor, String text) {
        super(diagram, text);
        for (IUMLViewSelectable selectable : selection) {
            if (!(selectable instanceof UMLNode)) continue;
            this.selectedNodes.add((UMLNode)selectable);
        }
        this.diagramEditor = diagramEditor;
    }

    @Override
    public boolean isVisible() {
        if (this.selectedNodes.isEmpty()) {
            return false;
        }
        for (UMLNode node : this.selectedNodes) {
            if (node.isSelected()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void run() {
        UMLDiagram umlDiagram = (UMLDiagram)this.diagramEditor.getInput().getDiagram();
        UMLModel initialModel = umlDiagram.getModel();
        UMLModel model = initialModel.getCopy(initialModel.getConfig());
        Map<String, Object> rightTypes = model.getRightTypes();
        Set<Object> leftTypes = model.getLeftTypes();
        ArrayList<UMLNode> selectedNodesCopy = new ArrayList<UMLNode>(this.selectedNodes.size());
        for (UMLNode node : this.selectedNodes) {
            UMLNode selectedNodeCopy = model.diagramNodes.get(node);
            if (selectedNodeCopy == null) continue;
            selectedNodesCopy.add(selectedNodeCopy);
        }
        for (UMLNode node : selectedNodesCopy) {
            node.deselect();
            Object rightType = rightTypes.remove(node.getID());
            if (rightType != null) {
                leftTypes.add(rightType);
            }
            node.showMethods = false;
            node.showFields = false;
            node.showEvents = false;
        }
        model.setDiagramKind(UMLModel.DiagramKind.NA);
        DUMLEditorFactory factory = DUMLEditorFactory.getInstance().newUMLDiagram(model);
        if (factory != null) {
            this.openReuseEditor(factory, this.diagramEditor);
        }
    }
}

