/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.uml.editor.actions.menu;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.DMenuCascade;
import ro.amiq.dvt.diagrams.editor.DMenuItem;
import ro.amiq.dvt.diagrams.editor.DMenuSeparator;
import ro.amiq.dvt.diagrams.uml.draw.UMLDrawUtils;
import ro.amiq.dvt.diagrams.uml.editor.actions.menu.DUMLActionMessages;
import ro.amiq.dvt.diagrams.uml.editor.actions.menu.DUMLDeselectTypeMenuAction;
import ro.amiq.dvt.diagrams.uml.editor.actions.menu.DUMLGoToSourceMenuAction;
import ro.amiq.dvt.diagrams.uml.editor.actions.menu.DUMLHideAllMenuAction;
import ro.amiq.dvt.diagrams.uml.editor.actions.menu.DUMLSelectTypeMenuAction;
import ro.amiq.dvt.diagrams.uml.editor.actions.menu.DUMLShowAllMenuAction;
import ro.amiq.dvt.diagrams.uml.editor.actions.menu.DUMLToggleEventsMenuAction;
import ro.amiq.dvt.diagrams.uml.editor.actions.menu.DUMLToggleFieldsMenuAction;
import ro.amiq.dvt.diagrams.uml.editor.actions.menu.DUMLToggleMethodsMenuAction;
import ro.amiq.dvt.diagrams.uml.model.IUMLViewSelectable;
import ro.amiq.dvt.diagrams.uml.model.IUMLViewSelectable2;
import ro.amiq.dvt.diagrams.uml.model.UMLNode;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;
import ro.amiq.dvt.model.reflection.GoToInfo;

public final class DUMLMenuActionFactory {
    private DUMLMenuActionFactory() {
    }

    public static List<DMenuItem> createActions(Set<DSelectable> selection, DDiagram diagram, DDiagramEditor diagramEditor) {
        if (diagram == null) {
            return Collections.emptyList();
        }
        DMenuItem selectActions = DUMLMenuActionFactory.createSelectActions(selection, diagram, diagramEditor);
        DMenuItem deselectActions = DUMLMenuActionFactory.createDeselectActions(selection, diagram, diagramEditor);
        DMenuItem updateMembers = DUMLMenuActionFactory.createUpdateMembersActions(selection, diagram, diagramEditor);
        ArrayList<DMenuItem> result = new ArrayList<DMenuItem>();
        for (DMenuItem item : DUMLMenuActionFactory.createGoToSourceActions(selection, diagram)) {
            if (!item.isVisible()) continue;
            result.add(item);
        }
        if (selectActions != null && selectActions.isVisible()) {
            result.add(selectActions);
        }
        if (deselectActions != null && deselectActions.isVisible()) {
            result.add(deselectActions);
        }
        if (updateMembers != null) {
            result.add(updateMembers);
        }
        return result;
    }

    private static List<DMenuItem> createGoToSourceActions(Set<DSelectable> selections, DDiagram diagram) {
        ArrayList<IUMLViewSelectable> umlViewSelectables = new ArrayList<IUMLViewSelectable>();
        Iterator<DSelectable> iterator = selections.iterator();
        while (iterator.hasNext()) {
            umlViewSelectables.add(UMLDrawUtils.getUMLViewSelectable(iterator.next()));
        }
        if (umlViewSelectables.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<GoToInfo> goTos = new ArrayList<GoToInfo>();
        for (IUMLViewSelectable umlViewSelectable : umlViewSelectables) {
            if (umlViewSelectable == null) continue;
            goTos.addAll(umlViewSelectable.hasGoToSource());
        }
        if (goTos.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new DUMLGoToSourceMenuAction(diagram, goTos, DUMLActionMessages.goToSourceTitle));
    }

    private static DMenuItem createSelectActions(Set<DSelectable> selections, DDiagram diagram, DDiagramEditor diagramEditor) {
        ArrayList<IUMLViewSelectable> umlViewSelectables = new ArrayList<IUMLViewSelectable>();
        Iterator<DSelectable> iterator = selections.iterator();
        while (iterator.hasNext()) {
            umlViewSelectables.add(UMLDrawUtils.getUMLViewSelectable(iterator.next()));
        }
        if (umlViewSelectables.isEmpty()) {
            return null;
        }
        DUMLSelectTypeMenuAction action = umlViewSelectables.size() == 1 ? new DUMLSelectTypeMenuAction(umlViewSelectables, diagram, diagramEditor, DUMLActionMessages.selectTypeTitle) : new DUMLSelectTypeMenuAction(umlViewSelectables, diagram, diagramEditor, DUMLActionMessages.selectTypesTitle);
        return action;
    }

    private static DMenuItem createDeselectActions(Set<DSelectable> selections, DDiagram diagram, DDiagramEditor diagramEditor) {
        ArrayList<IUMLViewSelectable> umlViewSelectables = new ArrayList<IUMLViewSelectable>();
        Iterator<DSelectable> iterator = selections.iterator();
        while (iterator.hasNext()) {
            umlViewSelectables.add(UMLDrawUtils.getUMLViewSelectable(iterator.next()));
        }
        if (umlViewSelectables.isEmpty()) {
            return null;
        }
        DUMLDeselectTypeMenuAction action = umlViewSelectables.size() == 1 ? new DUMLDeselectTypeMenuAction(umlViewSelectables, diagram, diagramEditor, DUMLActionMessages.deselectTypeTitle) : new DUMLDeselectTypeMenuAction(umlViewSelectables, diagram, diagramEditor, DUMLActionMessages.deselectTypesTitle);
        return action;
    }

    private static DMenuItem createUpdateMembersActions(Set<DSelectable> selections, DDiagram diagram, DDiagramEditor diagramEditor) {
        ArrayList<IUMLViewSelectable2> umlViewSelectables = new ArrayList<IUMLViewSelectable2>();
        Iterator<DSelectable> iterator = selections.iterator();
        while (iterator.hasNext()) {
            IUMLViewSelectable2 umlViewSelectable2 = UMLDrawUtils.getUMLViewSelectable2(iterator.next());
            if (umlViewSelectable2 == null || ((UMLNode)umlViewSelectable2).noActions() || ((UMLNode)umlViewSelectable2).isExtendedDeterminant || ((UMLNode)umlViewSelectable2).getName().contains("CIRCULAR INHERITANCE")) continue;
            umlViewSelectables.add(umlViewSelectable2);
        }
        if (umlViewSelectables.isEmpty()) {
            return null;
        }
        ArrayList<DMenuItem> subActions = new ArrayList<DMenuItem>();
        subActions.add(new DUMLToggleFieldsMenuAction(umlViewSelectables, diagram, diagramEditor, DUMLActionMessages.toggleFieldsTitle));
        subActions.add(new DUMLToggleEventsMenuAction(umlViewSelectables, diagram, diagramEditor, DUMLActionMessages.toggleEventsTitle));
        subActions.add(new DUMLToggleMethodsMenuAction(umlViewSelectables, diagram, diagramEditor, DUMLActionMessages.toggleMethodsTitle));
        subActions.add(DMenuSeparator.INSTANCE);
        subActions.add(new DUMLShowAllMenuAction(umlViewSelectables, diagram, diagramEditor, DUMLActionMessages.showAllTitle));
        subActions.add(new DUMLHideAllMenuAction(umlViewSelectables, diagram, diagramEditor, DUMLActionMessages.hideAllTitle));
        DMenuCascade cascade = new DMenuCascade(DUMLActionMessages.updateMembersTitle, subActions);
        return cascade;
    }
}

