/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.uml.editor.actions.menu;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.DMenuAction;
import ro.amiq.dvt.diagrams.uml.UMLDiagram;
import ro.amiq.dvt.diagrams.uml.UMLDiagramConfiguration;
import ro.amiq.dvt.diagrams.uml.editor.DUMLEditorFactory;
import ro.amiq.dvt.diagrams.uml.model.IUMLViewSelectable;
import ro.amiq.dvt.diagrams.uml.model.UMLModel;
import ro.amiq.dvt.diagrams.uml.model.UMLNode;

public class DUMLSelectTypeMenuAction
extends DMenuAction {
    private List<UMLNode> selectedNodes = new ArrayList<UMLNode>();
    private DDiagramEditor diagramEditor;

    public DUMLSelectTypeMenuAction(List<IUMLViewSelectable> selection, DDiagram diagram, DDiagramEditor diagramEditor, String text) {
        super(diagram, text);
        for (IUMLViewSelectable selectable : selection) {
            if (!(selectable instanceof UMLNode)) continue;
            this.selectedNodes.add((UMLNode)selectable);
        }
        this.diagramEditor = diagramEditor;
    }

    @Override
    public boolean isVisible() {
        if (this.selectedNodes.isEmpty()) {
            return false;
        }
        for (UMLNode node : this.selectedNodes) {
            if (node.noActions() || node.isSelected() || node.isExtendedDeterminant || node.getName().contains("CIRCULAR INHERITANCE")) continue;
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        UMLDiagram umlDiagram = (UMLDiagram)this.diagramEditor.getInput().getDiagram();
        UMLModel initialModel = umlDiagram.getModel();
        UMLDiagramConfiguration config = initialModel.getConfig();
        UMLModel model = initialModel.getCopy(initialModel.getConfig());
        Map<String, Object> rightTypes = model.getRightTypes();
        Set<Object> leftTypes = model.getLeftTypes();
        ArrayList<UMLNode> selectedNodesCopy = new ArrayList<UMLNode>(this.selectedNodes.size());
        for (UMLNode node : this.selectedNodes) {
            UMLNode selectedNodeCopy = model.diagramNodes.get(node);
            if (selectedNodeCopy == null) continue;
            selectedNodesCopy.add(selectedNodeCopy);
        }
        boolean hasMembers = config.get(UMLDiagramConfiguration.UMLConfigKey.MEMBERS) != UMLDiagramConfiguration.MembersOption.NONE;
        for (UMLNode node : selectedNodesCopy) {
            node.setSelected(true);
            rightTypes.put(node.getID(), node.getElement());
            leftTypes.remove(node.getElement());
            if (!hasMembers) continue;
            node.showMethods = config.get(UMLDiagramConfiguration.UMLConfigKey.SHOW_METHODS);
            node.showFields = config.get(UMLDiagramConfiguration.UMLConfigKey.SHOW_FIELDS);
            node.showEvents = config.get(UMLDiagramConfiguration.UMLConfigKey.SHOW_EVENTS);
        }
        model.setDiagramKind(UMLModel.DiagramKind.NA);
        DUMLEditorFactory factory = DUMLEditorFactory.getInstance().newUMLDiagram(model);
        if (factory != null) {
            this.openReuseEditor(factory, this.diagramEditor);
        }
    }
}

