/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.uml.model;

import de.cau.cs.kieler.core.kgraph.KLabel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import ro.amiq.dvt.diagrams.uml.model.IUMLElement;
import ro.amiq.dvt.diagrams.uml.model.IUMLViewSelectable;
import ro.amiq.dvt.diagrams.uml.model.UMLAbstractEdge;
import ro.amiq.dvt.diagrams.uml.model.UMLNode;
import ro.amiq.dvt.model.reflection.GoToInfo;

public class UMLAssociationEdge
extends UMLAbstractEdge
implements IUMLElement,
IUMLViewSelectable {
    private List<String> instanceNames = new ArrayList<String>(4);
    private List<GoToInfo> instanceMarkers = new ArrayList<GoToInfo>(4);
    private KLabel label;

    public UMLAssociationEdge(UMLNode src, UMLNode dest, String instanceName, GoToInfo marker) {
        super(UMLAssociationEdge.generateID(src.getID(), dest.getID(), instanceName), src, dest);
        if (instanceName != null) {
            this.instanceNames.add(instanceName);
        }
        if (marker != null) {
            this.instanceMarkers.add(marker);
        }
    }

    private static String generateID(String id1, String id2, String name) {
        return id1 + " -> " + id2 + " : " + name;
    }

    @Override
    public boolean isAssociation() {
        return true;
    }

    public GoToInfo getMarker() {
        if (this.instanceMarkers.size() == 1) {
            return this.instanceMarkers.get(0);
        }
        return null;
    }

    public void setKLabel(KLabel label) {
        this.label = label;
    }

    public KLabel getMemberKLabel() {
        return this.label;
    }

    public String getInstanceName() {
        return this.instanceNames.isEmpty() ? "" : this.instanceNames.get(0);
    }

    @Override
    public Collection<GoToInfo> hasGoToSource() {
        return this.instanceMarkers;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.instanceMarkers == null ? 0 : this.instanceMarkers.hashCode());
        result = 31 * result + (this.instanceNames == null ? 0 : this.instanceNames.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UMLAssociationEdge other = (UMLAssociationEdge)obj;
        if (this.instanceMarkers == null ? other.instanceMarkers != null : !this.instanceMarkers.equals(other.instanceMarkers)) {
            return false;
        }
        return !(this.instanceNames == null ? other.instanceNames != null : !this.instanceNames.equals(other.instanceNames));
    }
}

