/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.uml.model;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.uml.UMLDiagramConfiguration;
import ro.amiq.dvt.diagrams.uml.model.UMLAbstractEdge;
import ro.amiq.dvt.diagrams.uml.model.UMLAssociationEdge;
import ro.amiq.dvt.diagrams.uml.model.UMLInheritanceEdge;
import ro.amiq.dvt.diagrams.uml.model.UMLNode;
import ro.amiq.dvt.diagrams.uml.model.UMLNodeMember;
import ro.amiq.dvt.diagrams.uml.model.UMLPackage;
import ro.amiq.dvt.diagrams.uml.preferences.UMLFilterClass;
import ro.amiq.dvt.model.reflection.GoToInfo;

public abstract class UMLModel {
    protected UMLDiagramConfiguration config;
    public Map<UMLNode, UMLNode> diagramNodes = new LinkedHashMap<UMLNode, UMLNode>();
    public Map<UMLAbstractEdge, UMLAbstractEdge> diagramEdges = new LinkedHashMap<UMLAbstractEdge, UMLAbstractEdge>();
    protected IProject project;
    private DiagramKind diagramKind = DiagramKind.NA;
    public boolean publicAssociationsOnly;
    protected Predicate<Object> elementPathChecker;
    private String includePrefVal;
    private String excludePrefVal;
    private int nofInheritanceEdges;
    private int nofAssociationEdges;
    private int nofNewNodes;
    private Map<String, UMLPackage> packages = new LinkedHashMap<String, UMLPackage>();
    protected boolean gatherAllTypes;
    protected Set<Object> leftTypes = Collections.newSetFromMap(new IdentityHashMap());
    protected Map<String, Object> rightTypes = new LinkedHashMap<String, Object>();

    public UMLModel(UMLDiagramConfiguration config) {
        this.config = config;
    }

    public abstract List<Object> getAllClasses(IProject var1, IProgressMonitor var2);

    protected abstract LanguageKind getLanguageKind();

    protected abstract List<UMLNode> getClassParents(UMLNode var1);

    protected abstract List<UMLNode> getClassChildren(Object var1);

    protected abstract List<UMLNodeMember> getFields(Object var1, boolean var2);

    protected abstract List<UMLNodeMember> getMethods(Object var1, boolean var2);

    protected abstract List<UMLNodeMember> getEvents(Object var1, boolean var2);

    protected abstract String getFieldLabelText(Object var1);

    protected abstract String getMethodLabelText(Object var1);

    protected abstract String getEventLabelText(Object var1);

    protected abstract String getFieldParameters(Object var1);

    protected abstract Object getClassTypeOfField(UMLNodeMember var1);

    protected abstract String getClassGenericParams(Object var1);

    protected abstract GoToInfo getSourceMarker(Object var1);

    public abstract UMLNode createNode(Object var1);

    public abstract String generateID(Object var1);

    public abstract String getNodeName(Object var1);

    public abstract String getFullNodeName(Object var1);

    public abstract Image getIcon(Object var1);

    public abstract String getDetails(Object var1);

    public abstract UMLModel getCopy(UMLDiagramConfiguration var1);

    public abstract boolean internalStruct(Object var1);

    public abstract boolean isPredefined(Object var1);

    public abstract boolean isValid(Object var1);

    public String getName() {
        if (this.diagramKind == DiagramKind.ARCHITECTURE) {
            return "Architecture of " + (this.project != null ? this.project.getName() : "");
        }
        if (this.diagramKind == DiagramKind.SEQUENCE) {
            return "Sequences of " + (this.project != null ? this.project.getName() : "");
        }
        if (this.rightTypes.isEmpty()) {
            return "UML";
        }
        String name = "UML of ";
        int counter = 0;
        Iterator<Object> iterator = this.rightTypes.values().iterator();
        while (iterator.hasNext()) {
            if (++counter == 3) {
                name = String.valueOf(name) + "...";
                break;
            }
            if (counter == 2) {
                name = String.valueOf(name) + ", ";
            }
            name = String.valueOf(name) + this.getNodeName(iterator.next());
        }
        return name;
    }

    public String getTooltip() {
        if (this.diagramKind == DiagramKind.ARCHITECTURE || this.diagramKind == DiagramKind.SEQUENCE || this.rightTypes.isEmpty()) {
            return this.getName();
        }
        Iterator<Object> iterator = this.rightTypes.values().iterator();
        StringBuilder name = new StringBuilder("UML of ");
        if (iterator.hasNext()) {
            name.append(this.getNodeName(iterator.next()));
        }
        while (iterator.hasNext()) {
            name.append(", ").append(this.getNodeName(iterator.next()));
        }
        return name.toString();
    }

    public int getNofInheritanceEdges() {
        int result = this.nofInheritanceEdges;
        this.nofInheritanceEdges = 0;
        return result;
    }

    public int getNofAssociations() {
        int result = this.nofAssociationEdges;
        this.nofAssociationEdges = 0;
        return result;
    }

    public int getNofNewNodes() {
        int result = this.nofNewNodes;
        this.nofNewNodes = 0;
        return result;
    }

    public DiagramKind getDiagramKind() {
        return this.diagramKind;
    }

    public void setDiagramKind(DiagramKind kind) {
        this.diagramKind = kind;
    }

    public void setRightTypes(Collection<Object> rightTypes) {
        if (rightTypes == null || rightTypes.isEmpty()) {
            return;
        }
        for (Object object : rightTypes) {
            this.rightTypes.put(this.generateID(object), object);
        }
    }

    public void removeRightTypes(Collection<Object> rightTypes) {
        for (Object type : rightTypes) {
            this.rightTypes.remove(this.generateID(type));
        }
        this.leftTypes.addAll(rightTypes);
    }

    public void updateLeftTypes(Collection<Object> typesSet) {
        this.leftTypes = Collections.newSetFromMap(new IdentityHashMap());
        if (typesSet.isEmpty()) {
            return;
        }
        this.leftTypes.addAll(typesSet);
        for (Object rightType : this.rightTypes.values()) {
            this.leftTypes.remove(rightType);
        }
    }

    public void setLeftTypes(Set<Object> types) {
        this.leftTypes = types;
    }

    public Map<String, Object> getRightTypes() {
        return this.rightTypes;
    }

    public Set<Object> getLeftTypes() {
        return this.leftTypes;
    }

    public Map<String, UMLPackage> getPackages() {
        return this.packages;
    }

    public void addNode(UMLNode node) {
        if (this.diagramNodes.containsKey(node)) {
            node.setDirty(false);
            this.packages.put(node.getPackage().getName(), node.getPackage());
            return;
        }
        if (node.isSelected() && this.config.get(UMLDiagramConfiguration.UMLConfigKey.MEMBERS) != UMLDiagramConfiguration.MembersOption.NONE) {
            node.showMethods = this.config.get(UMLDiagramConfiguration.UMLConfigKey.SHOW_METHODS);
            node.showFields = this.config.get(UMLDiagramConfiguration.UMLConfigKey.SHOW_FIELDS);
            node.showEvents = this.config.get(UMLDiagramConfiguration.UMLConfigKey.SHOW_EVENTS);
        }
        node.updateMembers(this, node.showFields, node.showEvents, node.showMethods);
        if (node.getName() == null || node.getName().length() == 0) {
            node.setFullName(this.getFullNodeName(node.getElement()));
            node.setName(this.getNodeName(node.getElement()));
            String genericParams = " " + this.getClassGenericParams(node.getElement());
            if (genericParams.length() > 1) {
                node.setFullName(String.valueOf(node.getFullName()) + genericParams);
                node.setName(String.valueOf(node.getName()) + genericParams);
            }
        }
        ++this.nofNewNodes;
        this.diagramNodes.put(node, node);
        this.packages.put(node.getPackage().getName(), node.getPackage());
    }

    public void collectParentsForExtendedDeterminants(IProgressMonitor monitor) {
        if (this.getLanguageKind() != LanguageKind.E) {
            return;
        }
        for (UMLNode node : this.diagramNodes.keySet()) {
            List<UMLNode> classParents;
            if (monitor.isCanceled()) {
                return;
            }
            if (!node.isExtendedDeterminant || (classParents = this.getClassParents(node)) == null || classParents.isEmpty()) continue;
            for (UMLNode parent : classParents) {
                if (parent.isDirty() || !this.diagramNodes.containsKey(parent) || !parent.shouldGatherChildren) continue;
                this.addEdge(this.createInheritanceEdge(node, parent));
            }
        }
    }

    protected UMLNode createNode(Object element, boolean isPredefined) {
        if (element == null) {
            return null;
        }
        UMLNode node = new UMLNode(this.generateID(element = this.resolveTemplateStructInstance(element)), element, isPredefined, this.getSourceMarker(element));
        UMLNode existingNode = this.diagramNodes.get(node);
        if (existingNode != null) {
            node = existingNode;
        }
        return node;
    }

    private UMLInheritanceEdge createInheritanceEdge(UMLNode child, UMLNode parent) {
        if (child == null || parent == null) {
            return null;
        }
        UMLInheritanceEdge edge = new UMLInheritanceEdge(child, parent);
        UMLAbstractEdge existingEdge = this.diagramEdges.get(edge);
        if (existingEdge != null) {
            edge = (UMLInheritanceEdge)existingEdge;
        }
        edge.setReplacedParams(this.getClassReplacedParams(edge));
        return edge;
    }

    private UMLAbstractEdge createAssociationEdge(UMLNode initialNode, UMLNode fieldTypeNode, String fieldName, GoToInfo fieldGoToInfo) {
        UMLAssociationEdge edge;
        UMLAbstractEdge existingEdge;
        if (initialNode == null || fieldTypeNode == null || fieldName == null) {
            return null;
        }
        String label = "";
        if (this.config.get(UMLDiagramConfiguration.UMLConfigKey.SHOW_ASSOCIATION_LABELS).booleanValue()) {
            label = fieldName;
        }
        if ((existingEdge = this.diagramEdges.get(edge = new UMLAssociationEdge(initialNode, fieldTypeNode, label, fieldGoToInfo))) != null) {
            edge = (UMLAssociationEdge)existingEdge;
        }
        return edge;
    }

    public boolean addEdge(UMLAbstractEdge edge) {
        if ((edge = this.filterEdges(edge, this.diagramKind)) == null) {
            return false;
        }
        if (this.diagramEdges.containsKey(edge)) {
            return true;
        }
        if (edge.isAssociation()) {
            ++this.nofAssociationEdges;
        } else {
            ++this.nofInheritanceEdges;
        }
        this.diagramEdges.put(edge, edge);
        return true;
    }

    public IProject getProject() {
        return this.project;
    }

    public void collectFieldAssociationsOfNode(UMLNode initialNode, Set<Object> visitedStructs) {
        if (this.config.get(UMLDiagramConfiguration.UMLConfigKey.ASSOCIATIONS) == UMLDiagramConfiguration.RelationOption.NONE) {
            return;
        }
        int depth = this.config.get(UMLDiagramConfiguration.UMLConfigKey.ASSOCIATIONS) == UMLDiagramConfiguration.RelationOption.CUSTOM_DEPTH ? this.config.get(UMLDiagramConfiguration.UMLConfigKey.ASSOCIATIONS_DEPTH) : -1;
        ArrayDeque<UMLNode> queue = new ArrayDeque<UMLNode>();
        queue.offer(initialNode);
        do {
            Object genericStruct;
            initialNode = (UMLNode)queue.poll();
            if (depth != -1 && initialNode.getDistance() >= depth || visitedStructs.contains(genericStruct = initialNode.getElement())) continue;
            visitedStructs.add(genericStruct);
            UMLNode node = initialNode;
            if (this.isAlias(initialNode)) {
                List<UMLNode> classParents = this.getClassParents(initialNode);
                if (classParents == null || classParents.isEmpty() || !this.addEdge(this.createInheritanceEdge(initialNode, node = classParents.get(0)))) continue;
                this.addNode(node);
                node.setDistance(initialNode.getDistance());
                visitedStructs.add(node.getElement());
            }
            boolean shouldAdd = true;
            for (UMLNodeMember nodeMember : this.getFields(node.getElement(), false)) {
                UMLNode parent;
                List<UMLNode> classParents;
                UMLNode nodeFromField;
                Object fieldType;
                if (this.isPort(nodeMember) || (fieldType = this.getClassTypeOfField(nodeMember)) == null || this.internalStruct(fieldType) || (nodeFromField = this.createNode(fieldType)) == null || this.config.get(UMLDiagramConfiguration.UMLConfigKey.ASSOCIATIONS) == UMLDiagramConfiguration.RelationOption.SELECTED && !nodeFromField.isSelected() || this.publicAssociationsOnly && !nodeMember.isPublic || !this.addEdge(this.createAssociationEdge(node, nodeFromField, nodeMember.getID(), nodeMember.getMarker()))) continue;
                this.addNode(nodeFromField);
                for (UMLNode node1 : queue) {
                    if (visitedStructs.contains(nodeFromField.getElement()) || node1.getFullName().equals(nodeFromField.getFullName())) {
                        shouldAdd = false;
                        break;
                    }
                    shouldAdd = true;
                }
                if (shouldAdd) {
                    nodeFromField.setDistance(node.getDistance() + 1);
                    queue.offer(nodeFromField);
                    shouldAdd = true;
                }
                if (nodeFromField.getDistance() != depth || !this.isAlias(nodeFromField) || (classParents = this.getClassParents(nodeFromField)) == null || classParents.isEmpty() || (parent = classParents.get(0)) == null || !this.addEdge(this.createInheritanceEdge(nodeFromField, parent))) continue;
                this.addNode(parent);
                parent.setDistance(nodeFromField.getDistance());
            }
        } while (!queue.isEmpty());
        for (UMLNode node : this.diagramNodes.keySet()) {
            node.setDistance(0);
        }
    }

    private void collectParents(UMLNode initialElement, int depth) {
        if (depth == 0) {
            return;
        }
        List<UMLNode> parentsRfStruct = this.getClassParents(initialElement);
        if (parentsRfStruct == null || parentsRfStruct.isEmpty()) {
            return;
        }
        for (UMLNode parentElement : parentsRfStruct) {
            UMLInheritanceEdge edge;
            if (parentElement == null || this.internalStruct(parentElement.getElement()) || this.config.get(UMLDiagramConfiguration.UMLConfigKey.PARENTS) == UMLDiagramConfiguration.RelationOption.SELECTED && !parentElement.isSelected() || !this.addEdge(edge = this.createInheritanceEdge(initialElement, parentElement))) continue;
            this.addNode(parentElement);
            if (this.config.get(UMLDiagramConfiguration.UMLConfigKey.PARENTS) == UMLDiagramConfiguration.RelationOption.ALL) {
                this.collectParents(parentElement, -1);
            }
            if (this.config.get(UMLDiagramConfiguration.UMLConfigKey.PARENTS) != UMLDiagramConfiguration.RelationOption.CUSTOM_DEPTH || depth <= 0) continue;
            if (this.isAlias(initialElement)) {
                this.collectParents(parentElement, depth);
                continue;
            }
            this.collectParents(parentElement, depth - 1);
        }
    }

    public void collectParents(UMLNode nodeElement) {
        if (this.config.get(UMLDiagramConfiguration.UMLConfigKey.PARENTS) == UMLDiagramConfiguration.RelationOption.NONE) {
            return;
        }
        this.collectParents(nodeElement, this.config.get(UMLDiagramConfiguration.UMLConfigKey.PARENTS) == UMLDiagramConfiguration.RelationOption.CUSTOM_DEPTH ? this.config.get(UMLDiagramConfiguration.UMLConfigKey.PARENTS_DEPTH) : -1);
    }

    private void collectChildren(UMLNode initialNode, int depth) {
        if (depth == 0) {
            return;
        }
        initialNode.shouldGatherChildren = true;
        List<UMLNode> children = this.getClassChildren(initialNode.getElement());
        if (children == null) {
            return;
        }
        for (UMLNode child : children) {
            UMLInheritanceEdge edge;
            List<UMLNode> classParents;
            if (this.internalStruct(child.getElement()) || this.config.get(UMLDiagramConfiguration.UMLConfigKey.CHILDREN) == UMLDiagramConfiguration.RelationOption.SELECTED && !child.isSelected() || (classParents = this.getClassParents(child)) == null || classParents.isEmpty() || !classParents.contains(initialNode)) continue;
            child.shouldGatherChildren = true;
            if (depth == 1 && !child.isSelected()) {
                child.shouldGatherChildren = false;
            }
            if (!this.addEdge(edge = this.createInheritanceEdge(child, initialNode))) continue;
            this.addNode(child);
            if (this.config.get(UMLDiagramConfiguration.UMLConfigKey.CHILDREN) == UMLDiagramConfiguration.RelationOption.ALL) {
                this.collectChildren(child, -1);
            }
            if (this.config.get(UMLDiagramConfiguration.UMLConfigKey.CHILDREN) != UMLDiagramConfiguration.RelationOption.CUSTOM_DEPTH || depth <= 0) continue;
            this.collectChildren(child, depth - 1);
        }
    }

    public void collectChildren(UMLNode node) {
        if (this.config.get(UMLDiagramConfiguration.UMLConfigKey.CHILDREN) == UMLDiagramConfiguration.RelationOption.NONE) {
            for (UMLNode node1 : this.diagramNodes.keySet()) {
                node1.shouldGatherChildren = false;
            }
            return;
        }
        if (this.config.get(UMLDiagramConfiguration.UMLConfigKey.CHILDREN) == UMLDiagramConfiguration.RelationOption.CUSTOM_DEPTH) {
            this.collectChildren(node, this.config.get(UMLDiagramConfiguration.UMLConfigKey.CHILDREN_DEPTH));
        } else {
            this.collectChildren(node, -1);
        }
    }

    public void cleanUp(IProgressMonitor monitor) {
        Iterator<UMLNode> iter = this.diagramNodes.keySet().iterator();
        while (iter.hasNext()) {
            if (monitor.isCanceled()) {
                return;
            }
            UMLNode nextNode = iter.next();
            if (nextNode.isDirty() && !nextNode.isSelected() || nextNode.isExtendedDeterminant) {
                iter.remove();
                continue;
            }
            nextNode.updateMembers(this, nextNode.showFields, nextNode.showEvents, nextNode.showMethods);
        }
    }

    public UMLDiagramConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(UMLDiagramConfiguration config) {
        this.config = config;
    }

    public void setDirty() {
        Iterator<UMLNode> iterator = this.diagramNodes.keySet().iterator();
        while (iterator.hasNext()) {
            UMLNode node = iterator.next();
            if (node.getElement() == null || !this.isValid(node.getElement()) && !this.isPredefined(node.getElement())) {
                iterator.remove();
                continue;
            }
            node.setDirty(true);
            node.setSelected(false);
            node.shouldGatherChildren = false;
        }
        this.diagramEdges.clear();
    }

    public void setElementPathChecker(Predicate<Object> checkValid) {
        this.elementPathChecker = checkValid;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void copyNodes(UMLModel model) {
        for (UMLNode node : model.diagramNodes.keySet()) {
            node = node.getCopy();
            node.updateMembers(this, node.showFields, node.showEvents, node.showMethods);
            this.diagramNodes.put(node, node);
        }
    }

    protected String getClassReplacedParams(UMLInheritanceEdge edge) {
        return "";
    }

    public Set<Object> getAllClassesForDiagram(Collection<UMLFilterClass> userIncludes, Collection<UMLFilterClass> userExcludes, IProgressMonitor monitor) {
        Set<Object> result = Collections.newSetFromMap(new IdentityHashMap());
        Set forbidden = Collections.newSetFromMap(new IdentityHashMap());
        Set includedWithDescendants = Collections.newSetFromMap(new IdentityHashMap());
        Set excludedWithDescendants = Collections.newSetFromMap(new IdentityHashMap());
        List<Object> allClasses = this.getAllClasses(this.project, monitor);
        Map<Object, Set<Object>> typedefsForType = this.getTypedefsForAllTypes(allClasses);
        block0: for (Object classObj : allClasses) {
            Object crt;
            ArrayDeque<Object> queue;
            boolean withDescendants;
            String classFullyQ = this.getFullNodeName(classObj);
            if (!includedWithDescendants.contains(classObj)) {
                for (UMLFilterClass userClass : userIncludes) {
                    if (monitor.isCanceled()) {
                        return null;
                    }
                    if (!userClass.getPattern().matcher(classFullyQ).matches()) continue;
                    withDescendants = userClass.withDescendants;
                    queue = new ArrayDeque<Object>();
                    queue.add(classObj);
                    while (!queue.isEmpty()) {
                        if (monitor.isCanceled()) {
                            return null;
                        }
                        crt = queue.remove();
                        if (typedefsForType.containsKey(crt)) {
                            queue.addAll((Collection)typedefsForType.get(crt));
                        }
                        if (withDescendants && !includedWithDescendants.contains(crt)) {
                            for (UMLNode node : this.getClassChildren(crt)) {
                                queue.add(node.getElement());
                            }
                            includedWithDescendants.add(crt);
                        }
                        if (forbidden.contains(crt)) continue;
                        result.add(crt);
                    }
                    if (withDescendants) break;
                }
            }
            if (excludedWithDescendants.contains(classObj)) continue;
            for (UMLFilterClass userClass : userExcludes) {
                if (monitor.isCanceled()) {
                    return null;
                }
                if (!userClass.getPattern().matcher(classFullyQ).matches()) continue;
                withDescendants = userClass.withDescendants;
                queue = new ArrayDeque();
                queue.add(classObj);
                while (!queue.isEmpty()) {
                    if (monitor.isCanceled()) {
                        return null;
                    }
                    crt = queue.remove();
                    result.remove(crt);
                    forbidden.add(crt);
                    if (!withDescendants || excludedWithDescendants.contains(crt)) continue;
                    for (UMLNode node : this.getClassChildren(crt)) {
                        queue.add(node.getElement());
                    }
                    excludedWithDescendants.add(crt);
                }
                if (withDescendants) continue block0;
            }
        }
        this.filterUVMClasses(result);
        return result;
    }

    public void filterUVMClasses(Collection<Object> result) {
    }

    private Map<Object, Set<Object>> getTypedefsForAllTypes(List<Object> allTypes) {
        if (this.getLanguageKind() != LanguageKind.VLOG) {
            return Collections.emptyMap();
        }
        IdentityHashMap<Object, Set<Object>> typedefsForType = new IdentityHashMap<Object, Set<Object>>();
        for (Object typedef : allTypes) {
            Object type = this.getTranslatedType(typedef);
            if (type == null) continue;
            if (!typedefsForType.containsKey(type)) {
                typedefsForType.put(type, Collections.newSetFromMap(new IdentityHashMap()));
            }
            ((Set)typedefsForType.get(type)).add(typedef);
        }
        return typedefsForType;
    }

    protected Object getTranslatedType(Object typedef) {
        return null;
    }

    protected boolean isAlias(UMLNode initialElement) {
        return false;
    }

    protected boolean isPort(UMLNodeMember nodeMember) {
        return false;
    }

    protected UMLAbstractEdge filterEdges(UMLAbstractEdge edge, DiagramKind diagramKind) {
        return edge;
    }

    protected Object resolveTemplateStructInstance(Object object) {
        return object;
    }

    public boolean gatherAllTypes() {
        return this.gatherAllTypes;
    }

    public void setGatherAllTypes(boolean gatherAllTypes) {
        this.gatherAllTypes = gatherAllTypes;
    }

    public void setIncludePrefVal(String includePrefVal) {
        this.includePrefVal = includePrefVal;
    }

    public void setExcludePrefVal(String excludePrefVal) {
        this.excludePrefVal = excludePrefVal;
    }

    public String getIncludePrefVal() {
        return this.includePrefVal;
    }

    public String getExcludePrefVal() {
        return this.excludePrefVal;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.config == null ? 0 : this.config.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        int otherRightTypesSize;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UMLModel other = (UMLModel)obj;
        if (this.config == null ? other.config != null : !this.config.equals(other.config)) {
            return false;
        }
        int rightTypesSize = this.rightTypes.size();
        if (rightTypesSize != (otherRightTypesSize = other.rightTypes.size())) {
            return false;
        }
        for (String key : this.rightTypes.keySet()) {
            if (other.rightTypes.get(key) != null) continue;
            return false;
        }
        return true;
    }

    public static enum DiagramKind {
        NA,
        INHERITANCE,
        COLLABORATION,
        DIRECT,
        ARCHITECTURE,
        SEQUENCE;

    }
}

