/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.uml.model;

import de.cau.cs.kieler.core.kgraph.KNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import ro.amiq.dvt.diagrams.uml.model.IUMLElement;
import ro.amiq.dvt.diagrams.uml.model.IUMLViewSelectable;
import ro.amiq.dvt.diagrams.uml.model.IUMLViewSelectable2;
import ro.amiq.dvt.diagrams.uml.model.UMLModel;
import ro.amiq.dvt.diagrams.uml.model.UMLNodeMember;
import ro.amiq.dvt.diagrams.uml.model.UMLPackage;
import ro.amiq.dvt.model.reflection.GoToInfo;

public class UMLNode
implements IUMLElement,
IUMLViewSelectable,
IUMLViewSelectable2 {
    private final String ID;
    private final Object elementCache;
    private boolean selected;
    private boolean dirty;
    public boolean isExtendedDeterminant;
    public boolean isInterface;
    public boolean shouldGatherChildren;
    private boolean isPredefined;
    private boolean noActions;
    private int distance;
    public List<UMLNodeMember> methods = new ArrayList<UMLNodeMember>();
    public List<UMLNodeMember> fields = new ArrayList<UMLNodeMember>();
    public List<UMLNodeMember> events = new ArrayList<UMLNodeMember>();
    private String name;
    private String fullName;
    private final GoToInfo marker;
    public boolean showMethods;
    public boolean showFields;
    public boolean showEvents;
    private KNode kNode;
    private UMLPackage enclosingPackage;

    public UMLNode(String ID, Object element, boolean isPredefined, GoToInfo marker) {
        this.ID = ID;
        this.elementCache = element;
        this.isPredefined = isPredefined;
        this.marker = marker;
        this.name = "";
    }

    @Override
    public String getID() {
        return this.ID;
    }

    public Object getElement() {
        return this.elementCache;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getName() {
        return this.name;
    }

    public void setPackage(UMLPackage enclosingPackage) {
        this.enclosingPackage = enclosingPackage;
    }

    public UMLPackage getPackage() {
        return this.enclosingPackage;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isExtendedDeterminant() {
        return this.isExtendedDeterminant;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean isPredefined() {
        return this.isPredefined;
    }

    public void setDistance(int distance) {
        this.distance = distance;
    }

    public int getDistance() {
        return this.distance;
    }

    public void setSelected(boolean value) {
        this.selected = value;
    }

    public void deselect() {
        this.selected = false;
    }

    public void setNode(KNode node) {
        this.kNode = node;
    }

    public void updateMembers(UMLModel model, boolean showFields, boolean showEvents, boolean showMethods) {
        if (this.noActions) {
            return;
        }
        if (showMethods) {
            this.methods = model.getMethods(this.getElement(), model.getConfig().getPublicOnly());
        } else {
            this.methods.clear();
        }
        if (showFields) {
            this.fields = model.getFields(this.getElement(), model.getConfig().getPublicOnly());
        } else {
            this.fields.clear();
        }
        if (showEvents) {
            this.events = model.getEvents(this.getElement(), model.getConfig().getPublicOnly());
        } else {
            this.events.clear();
        }
        Collections.sort(this.methods);
        Collections.sort(this.fields);
        Collections.sort(this.events);
    }

    @Override
    public void toggleAll(boolean value) {
        this.showFields = this.showEvents = value;
        this.showMethods = this.showEvents;
    }

    @Override
    public void toggleMethods() {
        this.showMethods = !this.showMethods;
    }

    @Override
    public void toggleFields() {
        this.showFields = !this.showFields;
    }

    @Override
    public void toggleEvents() {
        this.showEvents = !this.showEvents;
    }

    @Override
    public Collection<GoToInfo> hasGoToSource() {
        if (this.marker == null) {
            return Collections.emptyList();
        }
        return Collections.singleton(this.marker);
    }

    public GoToInfo getMarker() {
        return this.marker;
    }

    public KNode getKNode() {
        return this.kNode;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean value) {
        this.dirty = value;
    }

    public void setNoActions() {
        this.noActions = true;
    }

    public boolean noActions() {
        return this.noActions;
    }

    public UMLNode getCopy() {
        UMLNode copy = new UMLNode(this.ID, this.elementCache, this.isPredefined, this.marker);
        copy.selected = this.selected;
        copy.dirty = this.dirty;
        copy.distance = this.distance;
        copy.fullName = this.fullName;
        copy.isExtendedDeterminant = this.isExtendedDeterminant;
        copy.isInterface = this.isInterface;
        copy.isPredefined = this.isPredefined;
        copy.name = this.name;
        copy.noActions = this.noActions;
        copy.shouldGatherChildren = this.shouldGatherChildren;
        copy.showFields = this.showFields;
        copy.showEvents = this.showEvents;
        copy.showMethods = this.showMethods;
        return copy;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.ID == null ? 0 : this.ID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UMLNode other = (UMLNode)obj;
        return !(this.ID == null ? other.ID != null : !this.ID.equals(other.ID));
    }

    public String toString() {
        return this.getFullName();
    }
}

