/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.uml.preferences;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.diagrams.uml.UMLConfigDefault;
import ro.amiq.dvt.diagrams.uml.UMLDiagramConfiguration;
import ro.amiq.dvt.diagrams.uml.editor.actions.UMLPreferencesWidget;

public class UMLDiagramPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "ro.amiq.dvt.diagrams.UMLDiagramPreferencePage";
    private UMLDiagramConfiguration config;
    private UMLPreferencesWidget preferencesWidget;

    public void init(IWorkbench workbench) {
        this.config = UMLConfigDefault.getDefault();
        this.setDescription("Choose the starting configuration for UML diagrams");
    }

    protected Control createContents(Composite parent) {
        this.preferencesWidget = new UMLPreferencesWidget(parent, this.config);
        return parent;
    }

    private void setNewDefaultConfig(UMLDiagramConfiguration config) {
        DVTPlugin.getDefault().getPreferenceStore().setValue("umldiagrams.uml_parents", this.relationToInt(config.get(UMLDiagramConfiguration.UMLConfigKey.PARENTS), UMLDiagramConfiguration.UMLConfigKey.PARENTS_DEPTH));
        DVTPlugin.getDefault().getPreferenceStore().setValue("umldiagrams.uml_children", this.relationToInt(config.get(UMLDiagramConfiguration.UMLConfigKey.CHILDREN), UMLDiagramConfiguration.UMLConfigKey.CHILDREN_DEPTH));
        DVTPlugin.getDefault().getPreferenceStore().setValue("umldiagrams.uml_associations", this.relationToInt(config.get(UMLDiagramConfiguration.UMLConfigKey.ASSOCIATIONS), UMLDiagramConfiguration.UMLConfigKey.ASSOCIATIONS_DEPTH));
        String direction = "";
        switch (config.get(UMLDiagramConfiguration.UMLConfigKey.DIRECTION)) {
            case DOWN: {
                direction = "down";
                break;
            }
            case RIGHT: {
                direction = "right";
                break;
            }
            case LEFT: {
                direction = "left";
                break;
            }
            default: {
                direction = "up";
            }
        }
        DVTPlugin.getDefault().getPreferenceStore().setValue("umldiagrams.uml_direction", direction);
        String members = "";
        switch (config.get(UMLDiagramConfiguration.UMLConfigKey.MEMBERS)) {
            case NONE: {
                members = "none";
                break;
            }
            case PUBLIC: {
                members = "public";
                break;
            }
            case ALL: {
                members = "all";
            }
        }
        DVTPlugin.getDefault().getPreferenceStore().setValue("umldiagrams.uml_members", members);
        DVTPlugin.getDefault().getPreferenceStore().setValue("umldiagrams.uml_show_fields", config.get(UMLDiagramConfiguration.UMLConfigKey.SHOW_FIELDS).booleanValue());
        DVTPlugin.getDefault().getPreferenceStore().setValue("umldiagrams.uml_show_events", config.get(UMLDiagramConfiguration.UMLConfigKey.SHOW_EVENTS).booleanValue());
        DVTPlugin.getDefault().getPreferenceStore().setValue("umldiagrams.uml_show_methods", config.get(UMLDiagramConfiguration.UMLConfigKey.SHOW_METHODS).booleanValue());
        DVTPlugin.getDefault().getPreferenceStore().setValue("umldiagrams.uml_package_information", config.get(UMLDiagramConfiguration.UMLConfigKey.SHOW_PACKAGE_INFORMATION).booleanValue());
        DVTPlugin.getDefault().getPreferenceStore().setValue("umldiagrams.uml_full_signature", config.get(UMLDiagramConfiguration.UMLConfigKey.SHOW_FULL_METHOD_SIGNATURE).booleanValue());
        DVTPlugin.getDefault().getPreferenceStore().setValue("umldiagrams.uml_association_labels", config.get(UMLDiagramConfiguration.UMLConfigKey.SHOW_ASSOCIATION_LABELS).booleanValue());
        DVTPlugin.getDefault().getPreferenceStore().setValue("umldiagrams.uml_group_by_package", config.get(UMLDiagramConfiguration.UMLConfigKey.GROUP_BY_PACKAGE).booleanValue());
        DVTPlugin.getDefault().getPreferenceStore().setValue("umldiagrams.uml_orthogonal_routing", config.get(UMLDiagramConfiguration.UMLConfigKey.ORTHOGONAL_EDGE_ROUTING).booleanValue());
    }

    private int relationToInt(UMLDiagramConfiguration.RelationOption option, UMLDiagramConfiguration.UMLConfigKey<Integer> key) {
        switch (option) {
            case NONE: {
                return 0;
            }
            case SELECTED: {
                return -2;
            }
            case CUSTOM_DEPTH: {
                return this.config.get(key);
            }
        }
        return -1;
    }

    private UMLDiagramConfiguration.RelationOption intToRelation(int value) {
        switch (value) {
            case -2: {
                return UMLDiagramConfiguration.RelationOption.SELECTED;
            }
            case -1: {
                return UMLDiagramConfiguration.RelationOption.ALL;
            }
            case 0: {
                return UMLDiagramConfiguration.RelationOption.NONE;
            }
        }
        return UMLDiagramConfiguration.RelationOption.CUSTOM_DEPTH;
    }

    protected void performApply() {
        this.setNewDefaultConfig(this.config);
        super.performApply();
    }

    public boolean performOk() {
        this.setNewDefaultConfig(this.config);
        return super.performOk();
    }

    protected void performDefaults() {
        super.performDefaults();
        UMLDiagramConfiguration.RelationOption option = this.intToRelation(1);
        this.config.set(UMLDiagramConfiguration.UMLConfigKey.PARENTS, option);
        this.config.set(UMLDiagramConfiguration.UMLConfigKey.PARENTS_DEPTH, 1);
        option = this.intToRelation(1);
        this.config.set(UMLDiagramConfiguration.UMLConfigKey.CHILDREN, option);
        this.config.set(UMLDiagramConfiguration.UMLConfigKey.CHILDREN_DEPTH, 1);
        option = this.intToRelation(1);
        this.config.set(UMLDiagramConfiguration.UMLConfigKey.ASSOCIATIONS, option);
        this.config.set(UMLDiagramConfiguration.UMLConfigKey.ASSOCIATIONS_DEPTH, 1);
        this.config.set(UMLDiagramConfiguration.UMLConfigKey.DIRECTION, this.config.getDirectionFromString("up"));
        this.config.set(UMLDiagramConfiguration.UMLConfigKey.MEMBERS, this.config.getMembersFromString("none"));
        this.config.set(UMLDiagramConfiguration.UMLConfigKey.SHOW_FIELDS, true);
        this.config.set(UMLDiagramConfiguration.UMLConfigKey.SHOW_EVENTS, true);
        this.config.set(UMLDiagramConfiguration.UMLConfigKey.SHOW_METHODS, true);
        this.config.set(UMLDiagramConfiguration.UMLConfigKey.ORTHOGONAL_EDGE_ROUTING, false);
        this.config.set(UMLDiagramConfiguration.UMLConfigKey.SHOW_PACKAGE_INFORMATION, false);
        this.config.set(UMLDiagramConfiguration.UMLConfigKey.SHOW_FULL_METHOD_SIGNATURE, false);
        this.config.set(UMLDiagramConfiguration.UMLConfigKey.SHOW_ASSOCIATION_LABELS, true);
        this.config.set(UMLDiagramConfiguration.UMLConfigKey.GROUP_BY_PACKAGE, false);
        this.config.set(UMLDiagramConfiguration.UMLConfigKey.ORTHOGONAL_EDGE_ROUTING, false);
        this.setNewDefaultConfig(this.config);
        this.preferencesWidget.updateButtons(this.config);
    }

    public boolean performCancel() {
        this.setNewDefaultConfig(UMLConfigDefault.getDefault());
        return super.performCancel();
    }
}

