/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.uml.preferences;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class UMLFilterClass {
    private static final String fieldSeparator = "+";
    private static final String classSeparator = "#";
    private static Map<Character, String> customReplaces = new HashMap<Character, String>();
    public final String name;
    public final boolean withDescendants;
    private Pattern pattern;

    static {
        customReplaces.put(Character.valueOf('.'), Pattern.quote("."));
        customReplaces.put(Character.valueOf('*'), ".*");
    }

    public UMLFilterClass(String name, boolean withDescendants) {
        if (name.length() == 0) {
            throw new IllegalArgumentException("Empty name");
        }
        this.name = name;
        this.withDescendants = withDescendants;
    }

    public Pattern getPattern() {
        if (this.pattern == null) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < this.name.length()) {
                int j = this.name.length();
                for (char c : customReplaces.keySet()) {
                    int x = this.name.indexOf(c, i);
                    if (x == -1 || x >= j) continue;
                    j = x;
                }
                sb.append(Pattern.quote(this.name.substring(i, j)));
                if (j < this.name.length()) {
                    sb.append(customReplaces.get(Character.valueOf(this.name.charAt(j))));
                }
                i = j + 1;
            }
            this.pattern = Pattern.compile(sb.toString());
        }
        return this.pattern;
    }

    public String toString() {
        return String.valueOf(this.withDescendants) + fieldSeparator + this.name;
    }

    public static UMLFilterClass readClassFromString(String str) throws InvalidStringRepresentationException {
        String[] items = str.split(Pattern.quote(fieldSeparator));
        if (items.length != 2) {
            throw new InvalidStringRepresentationException();
        }
        return new UMLFilterClass(items[1], Boolean.valueOf(items[0]));
    }

    public static String toString(Collection<UMLFilterClass> items) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (UMLFilterClass item : items) {
            if (first) {
                first = false;
            } else {
                result.append(classSeparator);
            }
            result.append(item.toString());
        }
        return result.toString();
    }

    public static Collection<UMLFilterClass> readClassesFromString(String str) throws InvalidStringRepresentationException {
        String[] classStrings = str.split(Pattern.quote(classSeparator));
        ArrayList<UMLFilterClass> result = new ArrayList<UMLFilterClass>(classStrings.length);
        String[] stringArray = classStrings;
        int n = classStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String classString = stringArray[n2];
            if (!classString.isEmpty()) {
                result.add(UMLFilterClass.readClassFromString(classString));
            }
            ++n2;
        }
        return result;
    }

    private static Collection<UMLFilterClass> make(Map<String, Boolean> namesAndDescendants) {
        ArrayList<UMLFilterClass> result = new ArrayList<UMLFilterClass>(namesAndDescendants.size());
        for (Map.Entry<String, Boolean> e : namesAndDescendants.entrySet()) {
            result.add(new UMLFilterClass(e.getKey(), e.getValue()));
        }
        return result;
    }

    public static Collection<UMLFilterClass> getDefaultArchIncludes() {
        LinkedHashMap<String, Boolean> map = new LinkedHashMap<String, Boolean>();
        map.put("uvm_pkg::uvm*", true);
        map.put("ovm_pkg::ovm*", true);
        map.put("main::uvm*", true);
        map.put("main::ovm*", true);
        map.put("*::vmm*", true);
        map.put("vmm*", true);
        return UMLFilterClass.make(map);
    }

    public static Collection<UMLFilterClass> getDefaultArchExcludes() {
        LinkedHashMap<String, Boolean> map = new LinkedHashMap<String, Boolean>();
        map.put("uvm_pkg::*", false);
        map.put("uvm_pkg::uvm_sequence", true);
        map.put("uvm_pkg::uvm_test", true);
        map.put("uvm_pkg::uvm_reg", true);
        map.put("ovm_pkg::*", false);
        map.put("*.type_id", false);
        map.put("ovm_pkg::ovm_sequence", true);
        map.put("ovm_pkg::ovm_test", true);
        map.put("main::uvm*", false);
        map.put("main::ovm*", false);
        map.put("*::vmm*", false);
        map.put("vmm*", false);
        map.put("*::vmm_data", true);
        map.put("vmm_data", true);
        map.put("*::vmm*scenario*", true);
        map.put("vmm*scenario*", true);
        return UMLFilterClass.make(map);
    }

    public static Collection<UMLFilterClass> getDefaultSeqIncludes() {
        LinkedHashMap<String, Boolean> map = new LinkedHashMap<String, Boolean>();
        map.put("uvm_pkg::uvm_sequence", true);
        map.put("ovm_pkg::ovm_sequence", true);
        map.put("*::any_sequence", true);
        map.put("*::vmm_data", true);
        map.put("vmm_data", true);
        map.put("*::vmm*scenario*", true);
        map.put("vmm*scenario*", true);
        return UMLFilterClass.make(map);
    }

    public static Collection<UMLFilterClass> getDefaultSeqExcludes() {
        LinkedHashMap<String, Boolean> map = new LinkedHashMap<String, Boolean>();
        map.put("uvm_pkg::*", false);
        map.put("ovm_pkg::*", false);
        map.put("*.type_id", false);
        map.put("*::any_sequence", false);
        map.put("*::vmm*", false);
        map.put("vmm*", false);
        map.put("*::vmm*scenario*", false);
        map.put("vmm*scenario*", false);
        return UMLFilterClass.make(map);
    }

    public static class InvalidStringRepresentationException
    extends Exception {
    }
}

