/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.uml.rendering;

import de.cau.cs.kieler.core.kgraph.KLabel;
import de.cau.cs.kieler.core.krendering.KFontBold;
import de.cau.cs.kieler.core.krendering.KRendering;
import de.cau.cs.kieler.core.krendering.KRenderingFactory;
import de.cau.cs.kieler.core.krendering.KText;
import de.cau.cs.kieler.core.krendering.LineStyle;
import org.eclipse.swt.graphics.RGB;
import ro.amiq.dvt.diagrams.uml.UMLDiagramConfiguration;
import ro.amiq.dvt.diagrams.uml.model.IUMLElement;
import ro.amiq.dvt.diagrams.uml.model.UMLNode;
import ro.amiq.dvt.diagrams.uml.rendering.UMLRenderingConstants;

public abstract class UMLDefaultRendering {
    static final KRenderingFactory RENDERING_FACTORY;

    static {
        UMLRenderingConstants.init();
        RENDERING_FACTORY = KRenderingFactory.eINSTANCE;
    }

    public RGB getColor(String colorID) {
        return (RGB)UMLRenderingConstants.DEFAULTS_MAP.get(colorID);
    }

    public KRendering getDummyNodeRenderingOrDefault() {
        return RENDERING_FACTORY.createKRectangle();
    }

    public KRendering getNodeRenderingOrDefault() {
        return RENDERING_FACTORY.createKRectangle();
    }

    public float getLineWidth(String id) {
        return ((Float)UMLRenderingConstants.DEFAULTS_MAP.get(id)).floatValue();
    }

    public LineStyle getLineStyleOrDefault(String nodeLineStyleId) {
        return (LineStyle)UMLRenderingConstants.DEFAULTS_MAP.get(nodeLineStyleId);
    }

    public KRendering getPortRenderingOrDefault() {
        return RENDERING_FACTORY.createKRectangle();
    }

    public KRendering getEdgeRenderingOrDefault(UMLDiagramConfiguration config) {
        if (!config.get(UMLDiagramConfiguration.UMLConfigKey.ORTHOGONAL_EDGE_ROUTING).booleanValue()) {
            return RENDERING_FACTORY.createKSpline();
        }
        return RENDERING_FACTORY.createKPolyline();
    }

    public KText getLabelRenderingOrDefault() {
        return RENDERING_FACTORY.createKText();
    }

    public int getFontSize(KLabel label, IUMLElement elem) {
        if (label.getText().trim().length() == 0) {
            return 18;
        }
        char x = label.getText().trim().charAt(0);
        if (label.getText().matches("\\s*") || label.getText().trim().matches("_*")) {
            return (Integer)UMLRenderingConstants.DEFAULTS_MAP.get("umldiagrams.font_size_nested_label");
        }
        if (x == '+' || x == '-' || x == '#' || x == '~') {
            return (Integer)UMLRenderingConstants.DEFAULTS_MAP.get("umldiagrams.font_size_nested_label");
        }
        if (elem instanceof UMLNode) {
            return (Integer)UMLRenderingConstants.DEFAULTS_MAP.get("umldiagram.font_size_class_label");
        }
        return (Integer)UMLRenderingConstants.DEFAULTS_MAP.get("umldiagrams.font_size_edge_label");
    }

    public String getFontName() {
        return (String)UMLRenderingConstants.DEFAULTS_MAP.get("umldiagram.font_name");
    }

    public KFontBold getFontBoldOrDefault(KLabel label, IUMLElement elem) {
        KFontBold fontBold = RENDERING_FACTORY.createKFontBold();
        fontBold.setBold(false);
        if (elem instanceof UMLNode && (((UMLNode)elem).getName().equals(label.getText().trim()) || ((UMLNode)elem).getFullName().equals(label.getText().trim()))) {
            fontBold.setBold(true);
        }
        return fontBold;
    }
}

