/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.uml.rendering;

import de.cau.cs.kieler.core.kgraph.KLabel;
import de.cau.cs.kieler.core.krendering.KFontBold;
import de.cau.cs.kieler.core.krendering.KRendering;
import de.cau.cs.kieler.core.krendering.KRenderingFactory;
import de.cau.cs.kieler.core.krendering.KText;
import de.cau.cs.kieler.core.krendering.LineStyle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.diagrams.uml.UMLDiagramConfiguration;
import ro.amiq.dvt.diagrams.uml.model.IUMLElement;
import ro.amiq.dvt.diagrams.uml.model.UMLNode;
import ro.amiq.dvt.diagrams.uml.model.UMLPackage;
import ro.amiq.dvt.diagrams.uml.preferences.UMLPreferenceInitializer;
import ro.amiq.dvt.diagrams.uml.rendering.UMLDefaultRendering;
import ro.amiq.dvt.model.reflection.NotNull;

public class UMLRendering
extends UMLDefaultRendering {
    private static volatile UMLRendering INSTANCE;
    private static final Object SYNC_INSTANCE;
    static final IPreferenceStore STORE;
    static final KRenderingFactory RENDERING_FACTORY;

    static {
        SYNC_INSTANCE = new Object();
        STORE = DVTPlugin.getDefault().getPreferenceStore();
        RENDERING_FACTORY = KRenderingFactory.eINSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UMLRendering getInstance() {
        if (INSTANCE == null) {
            Object object = SYNC_INSTANCE;
            synchronized (object) {
                INSTANCE = new UMLRendering();
            }
        }
        return INSTANCE;
    }

    @Override
    public RGB getColor(String colorID) {
        return PreferenceConverter.getColor((IPreferenceStore)STORE, (String)colorID);
    }

    @Override
    public float getLineWidth(String id) {
        return STORE.getFloat(id);
    }

    @Override
    public String getFontName() {
        return STORE.getString("umldiagram.font_name");
    }

    @Override
    public int getFontSize(KLabel label, IUMLElement elem) {
        if (label.getText().trim().length() == 0) {
            return 18;
        }
        if (elem instanceof UMLPackage) {
            return STORE.getInt("umldiagrams.font_size_package_label");
        }
        char x = label.getText().trim().charAt(0);
        if (label.getText().matches("\\s*") || label.getText().trim().matches("_*")) {
            return STORE.getInt("umldiagrams.font_size_nested_label");
        }
        if (x == '+' || x == '-' || x == '#' || x == '~') {
            return STORE.getInt("umldiagrams.font_size_nested_label");
        }
        if (elem instanceof UMLNode) {
            return STORE.getInt("umldiagram.font_size_class_label");
        }
        return STORE.getInt("umldiagrams.font_size_edge_label");
    }

    @Override
    public KFontBold getFontBoldOrDefault(KLabel label, IUMLElement elem) {
        KFontBold fontBold = RENDERING_FACTORY.createKFontBold();
        fontBold.setBold(false);
        if (elem instanceof UMLPackage) {
            fontBold.setBold(true);
            return fontBold;
        }
        if (elem instanceof UMLNode && (((UMLNode)elem).getName().equals(label.getText().trim()) || ((UMLNode)elem).getFullName().equals(label.getText().trim()))) {
            fontBold.setBold(true);
        }
        return fontBold;
    }

    @Override
    @NotNull
    public KRendering getEdgeRenderingOrDefault(UMLDiagramConfiguration config) {
        if (!config.get(UMLDiagramConfiguration.UMLConfigKey.ORTHOGONAL_EDGE_ROUTING).booleanValue()) {
            return RENDERING_FACTORY.createKSpline();
        }
        return RENDERING_FACTORY.createKPolyline();
    }

    @Override
    @NotNull
    public KRendering getNodeRenderingOrDefault() {
        return RENDERING_FACTORY.createKRectangle();
    }

    @Override
    @NotNull
    public KRendering getDummyNodeRenderingOrDefault() {
        return RENDERING_FACTORY.createKRectangle();
    }

    @Override
    @NotNull
    public KRendering getPortRenderingOrDefault() {
        return RENDERING_FACTORY.createKRectangle();
    }

    @Override
    @NotNull
    public KText getLabelRenderingOrDefault() {
        return RENDERING_FACTORY.createKText();
    }

    @Override
    @NotNull
    public LineStyle getLineStyleOrDefault(String nodeLineStyleId) {
        return UMLPreferenceInitializer.getLineStyleFromString(STORE.getString(nodeLineStyleId));
    }
}

