/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.uml.rendering;

import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KLabel;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.kgraph.KPort;
import de.cau.cs.kieler.core.krendering.KColor;
import de.cau.cs.kieler.core.krendering.KFontBold;
import de.cau.cs.kieler.core.krendering.KFontItalic;
import de.cau.cs.kieler.core.krendering.KFontName;
import de.cau.cs.kieler.core.krendering.KFontSize;
import de.cau.cs.kieler.core.krendering.KRendering;
import de.cau.cs.kieler.core.krendering.KStyle;
import de.cau.cs.kieler.core.krendering.KText;
import de.cau.cs.kieler.core.krendering.LineStyle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import ro.amiq.dvt.diagrams.klay.rendering.KLayStyleFactory;
import ro.amiq.dvt.diagrams.uml.UMLDiagramConfiguration;
import ro.amiq.dvt.diagrams.uml.model.IUMLElement;
import ro.amiq.dvt.diagrams.uml.model.UMLInheritanceEdge;
import ro.amiq.dvt.diagrams.uml.model.UMLNode;
import ro.amiq.dvt.diagrams.uml.model.UMLPackage;
import ro.amiq.dvt.diagrams.uml.rendering.UMLRendering;
import ro.amiq.dvt.diagrams.uml.rendering.UMLRenderingConstants;
import ro.amiq.dvt.draw.utils.ColorFactory;
import ro.amiq.dvt.draw.utils.FontFactory;

public interface UMLRenderingUtils {
    public static final KLayStyleFactory STYLE_FACTORY = KLayStyleFactory.INSTANCE;

    public static void renderNode(KNode node, UMLNode umlNode, UMLDiagramConfiguration config) {
        KRendering nodeRendering = UMLRendering.getInstance().getNodeRenderingOrDefault();
        if (nodeRendering == null) {
            return;
        }
        EList styles = nodeRendering.getStyles();
        if (umlNode.isSelected()) {
            bgColor = UMLRenderingUtils.getColor("umldiagrams.background_selected_class_rgb");
            if (config != null && config.get(UMLDiagramConfiguration.UMLConfigKey.FOR_SPECADOR) != null && config.get(UMLDiagramConfiguration.UMLConfigKey.FOR_SPECADOR).booleanValue()) {
                bgColor = KLayStyleFactory.createColorFromRGB(UMLRenderingConstants.VANILLA);
            }
            styles.add((Object)STYLE_FACTORY.createBackground(bgColor, 255));
        } else if (umlNode.isExtendedDeterminant() || umlNode.hasGoToSource().isEmpty() || umlNode.isPredefined()) {
            bgColor = KLayStyleFactory.createColorFromRGB(UMLRenderingConstants.GRAY);
            styles.add((Object)STYLE_FACTORY.createBackground(bgColor, 255));
        } else {
            bgColor = UMLRenderingUtils.getColor("umldiagrams.background_class_rgb");
            styles.add((Object)STYLE_FACTORY.createBackground(bgColor, 255));
        }
        KColor fgColor = UMLRenderingUtils.getColor("umldiagrams.foreground_class_rgb");
        styles.add((Object)STYLE_FACTORY.createForeground(fgColor, 255));
        float lineWidth = UMLRendering.getInstance().getLineWidth("umldiagrams.line_width");
        styles.add((Object)STYLE_FACTORY.createLineWidth(lineWidth));
        if (umlNode.isExtendedDeterminant) {
            lineStyle = UMLRendering.getInstance().getLineStyleOrDefault("umldiagrams.association_line_style");
            styles.add((Object)STYLE_FACTORY.createLineStyle(lineStyle));
        } else {
            lineStyle = UMLRendering.getInstance().getLineStyleOrDefault("umldiagrams.node_line_style");
            styles.add((Object)STYLE_FACTORY.createLineStyle(lineStyle));
        }
        KColor bgColor = UMLRenderingUtils.getColor("umldiagrams.selection_background_class_rgb");
        styles.add((Object)STYLE_FACTORY.createSelectionBackground(bgColor, 255));
        fgColor = UMLRenderingUtils.getColor("umldiagrams.selection_foreground_class_rgb");
        styles.add((Object)STYLE_FACTORY.createSelectionForeground(fgColor, 255));
        lineWidth = UMLRendering.getInstance().getLineWidth("umldiagrams.line_width");
        styles.add((Object)STYLE_FACTORY.createSelectionLineWidth(lineWidth));
        node.getData().add((Object)nodeRendering);
    }

    public static KColor getColor(String colorID) {
        RGB rgb = UMLRendering.getInstance().getColor(colorID);
        return KLayStyleFactory.createColorFromRGB(rgb);
    }

    public static void renderDummyGate(KNode dummyNode) {
        KRendering gateRendering = UMLRendering.getInstance().getDummyNodeRenderingOrDefault();
        if (gateRendering == null) {
            return;
        }
        EList styles = gateRendering.getStyles();
        KColor bgColor = KLayStyleFactory.createColorFromRGB(ColorFactory.getInstance().getRGB(255, 255, 255));
        int bgAlpha = 0;
        styles.add((Object)STYLE_FACTORY.createBackground(bgColor, bgAlpha));
        KColor fgColor = KLayStyleFactory.createColorFromRGB(ColorFactory.getInstance().getRGB(255, 255, 255));
        int fgAlpha = 0;
        styles.add((Object)STYLE_FACTORY.createForeground(fgColor, fgAlpha));
        dummyNode.getData().add((Object)gateRendering);
    }

    public static void renderPort(KPort port) {
        KRendering rendering = UMLRendering.getInstance().getPortRenderingOrDefault();
        if (rendering == null) {
            return;
        }
        EList styles = rendering.getStyles();
        KColor bgColor = KLayStyleFactory.createColorFromRGB(ColorFactory.getInstance().getRGB(255, 255, 255));
        int bgAlpha = 0;
        styles.add((Object)STYLE_FACTORY.createBackground(bgColor, bgAlpha));
        KColor fgColor = KLayStyleFactory.createColorFromRGB(ColorFactory.getInstance().getRGB(255, 255, 255));
        int fgAlpha = 0;
        styles.add((Object)STYLE_FACTORY.createForeground(fgColor, fgAlpha));
        port.getData().add((Object)rendering);
    }

    public static void renderInheritanceEdge(KEdge edge, UMLInheritanceEdge umlEdge, UMLDiagramConfiguration config) {
        KRendering edgeRendering = UMLRendering.getInstance().getEdgeRenderingOrDefault(config);
        if (edgeRendering == null) {
            return;
        }
        EList styles = edgeRendering.getStyles();
        KColor fgColor = UMLRenderingUtils.getColor("umldiagrams.foreground_edge_rgb");
        styles.add((Object)STYLE_FACTORY.createForeground(fgColor, 255));
        KColor bgColor = UMLRenderingUtils.getColor("umldiagrams.background_inheritance_edge_rgb");
        styles.add((Object)STYLE_FACTORY.createBackground(bgColor, 255));
        float lineWidth = UMLRendering.getInstance().getLineWidth("umldiagrams.line_width");
        styles.add((Object)STYLE_FACTORY.createLineWidth(lineWidth));
        if (umlEdge.isImplements()) {
            lineStyle = UMLRendering.getInstance().getLineStyleOrDefault("umldiagrams.association_line_style");
            styles.add((Object)STYLE_FACTORY.createLineStyle(lineStyle));
        } else {
            lineStyle = UMLRendering.getInstance().getLineStyleOrDefault("umldiagrams.inheritance_line_style");
            styles.add((Object)STYLE_FACTORY.createLineStyle(lineStyle));
        }
        fgColor = UMLRenderingUtils.getColor("umldiagrams.selection_label_foreground_edge_rgb");
        styles.add((Object)STYLE_FACTORY.createSelectionForeground(fgColor, 255));
        bgColor = UMLRenderingUtils.getColor("umldiagrams.selection_inheritance_background_edge_rgb");
        styles.add((Object)STYLE_FACTORY.createSelectionBackground(bgColor, 255));
        lineWidth = UMLRendering.getInstance().getLineWidth("umldiagrams.selection_line_width");
        styles.add((Object)STYLE_FACTORY.createSelectionLineWidth(lineWidth));
        edge.getData().add((Object)edgeRendering);
    }

    public static void renderAssociationEdge(KEdge edge, UMLDiagramConfiguration config) {
        KRendering edgeRendering = UMLRendering.getInstance().getEdgeRenderingOrDefault(config);
        if (edgeRendering == null) {
            return;
        }
        EList styles = edgeRendering.getStyles();
        KColor fgColor = UMLRenderingUtils.getColor("umldiagrams.foreground_edge_rgb");
        styles.add((Object)STYLE_FACTORY.createForeground(fgColor, 255));
        KColor bgColor = UMLRenderingUtils.getColor("umldiagrams.background_association_edge_rgb");
        styles.add((Object)STYLE_FACTORY.createBackground(bgColor, 255));
        float lineWidth = UMLRendering.getInstance().getLineWidth("umldiagrams.line_width");
        styles.add((Object)STYLE_FACTORY.createLineWidth(lineWidth));
        LineStyle lineStyle = UMLRendering.getInstance().getLineStyleOrDefault("umldiagrams.association_line_style");
        styles.add((Object)STYLE_FACTORY.createLineStyle(lineStyle));
        fgColor = UMLRenderingUtils.getColor("umldiagrams.selection_label_foreground_edge_rgb");
        styles.add((Object)STYLE_FACTORY.createSelectionForeground(fgColor, 255));
        bgColor = UMLRenderingUtils.getColor("umldiagrams.selection_association_background_edge_rgb");
        styles.add((Object)STYLE_FACTORY.createSelectionBackground(bgColor, 255));
        lineWidth = UMLRendering.getInstance().getLineWidth("umldiagrams.selection_line_width");
        styles.add((Object)STYLE_FACTORY.createSelectionLineWidth(lineWidth));
        edge.getData().add((Object)edgeRendering);
    }

    public static void renderLabel(KLabel label, IUMLElement elem) {
        KText labelRendering = UMLRendering.getInstance().getLabelRenderingOrDefault();
        if (labelRendering == null) {
            return;
        }
        EList styles = labelRendering.getStyles();
        int size = UMLRendering.getInstance().getFontSize(label, elem);
        styles.add((Object)STYLE_FACTORY.createFontSize(size));
        String fontName = UMLRendering.getInstance().getFontName();
        styles.add((Object)STYLE_FACTORY.createFontName(fontName));
        KFontBold fontBold = UMLRendering.getInstance().getFontBoldOrDefault(label, elem);
        styles.add((Object)fontBold);
        KColor fgColor = UMLRenderingUtils.getColor("umldiagrams.label_foregound_edge_rgb");
        styles.add((Object)STYLE_FACTORY.createForeground(fgColor, 255));
        if (label.getParent() instanceof KEdge || elem instanceof UMLPackage) {
            fgColor = UMLRenderingUtils.getColor("umldiagrams.selection_label_foreground_edge_rgb");
            styles.add((Object)STYLE_FACTORY.createSelectionForeground(fgColor, 255));
        } else {
            fgColor = UMLRenderingUtils.getColor("umldiagrams.selection_member_label_foreground_rgb");
            styles.add((Object)STYLE_FACTORY.createSelectionForeground(fgColor, 255));
        }
        label.getData().add((Object)labelRendering);
    }

    public static FontData getFontData(KLabel label) {
        if (label == null) {
            return null;
        }
        KRendering text = (KRendering)label.getData(KRendering.class);
        if (!(text instanceof KText)) {
            return null;
        }
        String fontName = null;
        int fontSize = 0;
        int fontStyle = 0;
        EList styles = text.getStyles();
        for (KStyle style : styles) {
            if (style instanceof KFontSize) {
                fontSize = ((KFontSize)style).getSize();
                continue;
            }
            if (style instanceof KFontName) {
                fontName = ((KFontName)style).getName();
                continue;
            }
            if (style instanceof KFontBold && ((KFontBold)style).isBold()) {
                fontStyle |= 1;
                continue;
            }
            if (!(style instanceof KFontItalic) || !((KFontItalic)style).isItalic()) continue;
            fontStyle |= 2;
        }
        return FontFactory.getInstance().getFontData(fontName, fontSize, fontStyle);
    }

    public static void renderPackageNode(KNode node) {
        KRendering nodeRendering = UMLRendering.getInstance().getNodeRenderingOrDefault();
        if (nodeRendering == null) {
            return;
        }
        EList styles = nodeRendering.getStyles();
        KColor bgColor = UMLRenderingUtils.getColor("umldiagrams.background_class_rgb");
        styles.add((Object)STYLE_FACTORY.createBackground(bgColor, 0));
        KColor fgColor = UMLRenderingUtils.getColor("umldiagrams.foreground_class_rgb");
        styles.add((Object)STYLE_FACTORY.createForeground(fgColor, 255));
        float lineWidth = UMLRendering.getInstance().getLineWidth("umldiagrams.selection_line_width");
        styles.add((Object)STYLE_FACTORY.createLineWidth(lineWidth));
        LineStyle lineStyle = UMLRendering.getInstance().getLineStyleOrDefault("umldiagrams.node_line_style");
        styles.add((Object)STYLE_FACTORY.createLineStyle(lineStyle));
        bgColor = UMLRenderingUtils.getColor("umldiagrams.selection_background_class_rgb");
        styles.add((Object)STYLE_FACTORY.createSelectionBackground(bgColor, 0));
        fgColor = UMLRenderingUtils.getColor("umldiagrams.selection_foreground_package_rgb");
        styles.add((Object)STYLE_FACTORY.createSelectionForeground(fgColor, 255));
        lineWidth = UMLRendering.getInstance().getLineWidth("umldiagrams.selection_line_width");
        styles.add((Object)STYLE_FACTORY.createSelectionLineWidth(lineWidth));
        node.getData().add((Object)nodeRendering);
    }
}

