/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import ro.amiq.dvt.diagrams.wave.WaveViewerSignalTableView;
import ro.amiq.dvt.diagrams.wave.draw.WCanvas;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableElement;
import ro.amiq.dvt.utils.DVTStringUtil;

public class DWaveSignalTableDragSourceListener
implements DragSourceListener {
    private WaveViewerSignalTableView signalsView;
    private WCanvas canvas;
    private List<TreeItem> dragSourceItems;

    public DWaveSignalTableDragSourceListener(WaveViewerSignalTableView signalsView, WCanvas canvas) {
        this.signalsView = signalsView;
        this.canvas = canvas;
        this.dragSourceItems = null;
    }

    public void dragStart(DragSourceEvent event) {
        this.dragSourceItems = this.getDragSourceItemFromTreeSelection();
        event.doit = this.dragSourceItems != null;
    }

    public void dragSetData(DragSourceEvent event) {
        List<WSignalsTableElement> elementWrappers;
        if (this.dragSourceItems == null || this.dragSourceItems.isEmpty() || this.dragSourceItems.get(0).isDisposed()) {
            this.dragSourceItems = this.getDragSourceItemFromTreeSelection();
        }
        event.data = (elementWrappers = this.getElementWrappers()) != null ? DVTStringUtil.join(elementWrappers, "%_%") : null;
    }

    public void dragFinished(DragSourceEvent event) {
        if (event.detail == 2) {
            DVTVCDUtils.refreshWaveViewer(this.signalsView, this.canvas);
        }
        this.dragSourceItems = null;
    }

    private List<TreeItem> getDragSourceItemFromTreeSelection() {
        Tree tree = this.signalsView.getLazyTree().getTree();
        TreeItem[] selection = tree.getSelection();
        if (selection.length == 0) {
            return null;
        }
        ArrayList<TreeItem> result = new ArrayList<TreeItem>();
        TreeItem[] treeItemArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath itemTreePath;
            Object element;
            TreeItem selectedTreeItem = treeItemArray[n2];
            Object treeItemData = selectedTreeItem.getData();
            if (treeItemData instanceof TreePath && (element = (itemTreePath = (TreePath)treeItemData).getElement()) instanceof WSignalsTableElement) {
                result.add(selectedTreeItem);
            }
            ++n2;
        }
        return result;
    }

    private List<WSignalsTableElement> getElementWrappers() {
        ArrayList<WSignalsTableElement> result = new ArrayList<WSignalsTableElement>();
        for (TreeItem dragSourceItem : this.dragSourceItems) {
            Object treeItemData = dragSourceItem.getData();
            if (!(treeItemData instanceof TreePath)) {
                return null;
            }
            TreePath itemTreePath = (TreePath)treeItemData;
            Object element = itemTreePath.getElement();
            if (!(element instanceof WSignalsTableElement)) {
                return null;
            }
            result.add((WSignalsTableElement)element);
        }
        return result;
    }

    public List<TreeItem> getDragSourceItems() {
        return this.dragSourceItems;
    }

    public WCanvas getCanvas() {
        return this.canvas;
    }
}

