/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave;

import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import ro.amiq.dvt.diagrams.wave.DWaveSignalTableDragSourceListener;
import ro.amiq.dvt.diagrams.wave.DWaveSignalTableDropTargetListenerCommon;
import ro.amiq.dvt.diagrams.wave.WaveViewerSignalTableView;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableElement;

public class DWaveSignalTableDropTargetListener
extends DWaveSignalTableDropTargetListenerCommon {
    public DWaveSignalTableDropTargetListener(WaveViewerSignalTableView signalsView, DWaveSignalTableDragSourceListener dragSourceListener) {
        super(signalsView, dragSourceListener);
    }

    public void dragOver(DropTargetEvent event) {
        Tree tree = this.signalsView.getLazyTree().getTree();
        event.feedback = 24;
        if (event.item != null) {
            TreeItem item = (TreeItem)event.item;
            Point pt = event.display.map(null, (Control)tree, event.x, event.y);
            Rectangle bounds = item.getBounds();
            if (pt.y < bounds.y + bounds.height / 3) {
                event.feedback |= 2;
            } else if (pt.y > bounds.y + 2 * bounds.height / 3) {
                event.feedback |= 4;
            }
        }
    }

    @Override
    protected int getUpdatedSourceElementId(WSignalsTableElement sourceElement, WSignalsTableElement targetElement, TreeItem targetTreeItem, DropTargetEvent dropEvent) {
        int sourceElementId = sourceElement.getId();
        int targetElementId = targetElement.getId();
        if (sourceElementId == -1 || targetElementId == -1) {
            return -1;
        }
        Tree tree = this.signalsView.getLazyTree().getTree();
        Point dropPoint = dropEvent.display.map(null, (Control)tree, dropEvent.x, dropEvent.y);
        Rectangle targetItemBounds = targetTreeItem.getBounds();
        int updatedSourceElementId = -1;
        if (dropPoint.y < targetItemBounds.y + targetItemBounds.height / 2) {
            updatedSourceElementId = targetElementId;
        } else if (dropPoint.y >= targetItemBounds.y + targetItemBounds.height / 2) {
            updatedSourceElementId = targetElementId + 1;
        }
        return updatedSourceElementId;
    }

    @Override
    protected boolean isInsertedAboveTargetWrapper(TreeItem targetTreeItem, DropTargetEvent dropEvent) {
        Tree tree = this.signalsView.getLazyTree().getTree();
        Point dropPoint = dropEvent.display.map(null, (Control)tree, dropEvent.x, dropEvent.y);
        Rectangle targetItemBounds = targetTreeItem.getBounds();
        return dropPoint.y < targetItemBounds.y + targetItemBounds.height / 2;
    }
}

