/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.widgets.TreeItem;
import ro.amiq.dvt.diagrams.wave.DWaveSignalTableDragSourceListener;
import ro.amiq.dvt.diagrams.wave.WaveViewerSignalTableView;
import ro.amiq.dvt.diagrams.wave.draw.WCanvas;
import ro.amiq.dvt.diagrams.wave.draw.WViewport;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.ui.waveviewer.ISignalsTableHierarchialElement;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableElement;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableGroup;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableSeparator;

public abstract class DWaveSignalTableDropTargetListenerCommon
extends DropTargetAdapter {
    protected WaveViewerSignalTableView signalsView;
    private DWaveSignalTableDragSourceListener dragSourceListener;

    protected DWaveSignalTableDropTargetListenerCommon(WaveViewerSignalTableView signalsView, DWaveSignalTableDragSourceListener dragSourceListener) {
        this.signalsView = signalsView;
        this.dragSourceListener = dragSourceListener;
    }

    public void drop(DropTargetEvent dropEvent) {
        if (dropEvent.data == null || !(dropEvent.item instanceof TreeItem)) {
            dropEvent.detail = 0;
            return;
        }
        List<TreeItem> sources = this.dragSourceListener.getDragSourceItems();
        List<WSignalsTableElement> sourceWrappers = this.getItemTableSignalWrappers(sources);
        boolean isGroupSelected = false;
        int i = 0;
        while (i < sourceWrappers.size()) {
            if (sourceWrappers.get(i) instanceof WSignalsTableGroup) {
                isGroupSelected = true;
                break;
            }
            ++i;
        }
        i = sources.size() - 1;
        while (i >= 0) {
            TreeItem source = sources.get(i);
            WSignalsTableElement sourceWrapper = sourceWrappers.get(i);
            if (!(sourceWrapper instanceof ISignalsTableHierarchialElement && ((ISignalsTableHierarchialElement)((Object)sourceWrapper)).isChildElement() || isGroupSelected && !(sourceWrapper instanceof WSignalsTableGroup))) {
                boolean isSuccessful;
                int updatedSourceNodeOrderId;
                TreeItem sourceParentGroup = source.getParentItem();
                WSignalsTableElement sourceParentGroupWrapper = this.getItemTableSignalWrapper(sourceParentGroup);
                TreeItem target = this.getFirstLevelTreeItem((TreeItem)dropEvent.item);
                WSignalsTableElement targetWrapper = this.getItemTableSignalWrapper(target);
                TreeItem targetParentGroup = target.getParentItem();
                WSignalsTableElement targetParentGroupWrapper = this.getItemTableSignalWrapper(targetParentGroup);
                if (sourceWrapper instanceof WSignalsTableGroup && targetParentGroupWrapper instanceof WSignalsTableGroup) {
                    updatedSourceNodeOrderId = this.getUpdatedSourceElementId(sourceWrapper, targetParentGroupWrapper, targetParentGroup, dropEvent);
                    if (updatedSourceNodeOrderId == -1) {
                        dropEvent.detail = 0;
                        return;
                    }
                    isSuccessful = this.dragAndDropInsideGroup(sourceWrapper, null, updatedSourceNodeOrderId);
                    if (!isSuccessful) {
                        dropEvent.detail = 0;
                    }
                    return;
                }
                if (sourceWrapper instanceof WSignalsTableSeparator && targetWrapper instanceof WSignalsTableGroup && !this.isInsertedAboveTargetWrapper(target, dropEvent)) {
                    updatedSourceNodeOrderId = 0;
                    if (sourceParentGroupWrapper != null) {
                        this.dragAndDropBetweenGroups(sourceWrapper, sourceParentGroupWrapper, targetWrapper, updatedSourceNodeOrderId);
                    } else {
                        this.dragAndDropInsideGroupFromOutsideGroup(sourceWrapper, targetWrapper, updatedSourceNodeOrderId);
                    }
                } else if ((sourceWrapper instanceof WSignalsTableGroup || sourceWrapper instanceof WSignalsTableSeparator) && (targetWrapper instanceof WSignalsTableGroup || targetWrapper instanceof WSignalsTableSeparator) && sourceWrapper != targetWrapper && sourceParentGroup == null && targetParentGroup == null) {
                    updatedSourceNodeOrderId = this.getUpdatedSourceElementId(sourceWrapper, targetWrapper, target, dropEvent);
                    if (updatedSourceNodeOrderId == -1) {
                        dropEvent.detail = 0;
                        return;
                    }
                    isSuccessful = this.dragAndDropInsideGroup(sourceWrapper, null, updatedSourceNodeOrderId);
                    if (!isSuccessful) {
                        dropEvent.detail = 0;
                    }
                } else if (sourceWrapper instanceof WSignalsTableSeparator && sourceParentGroupWrapper instanceof WSignalsTableGroup && (targetWrapper instanceof WSignalsTableGroup || targetWrapper instanceof WSignalsTableSeparator) && targetParentGroup == null) {
                    updatedSourceNodeOrderId = this.getUpdatedSourceElementId(sourceWrapper, targetWrapper, target, dropEvent);
                    if (updatedSourceNodeOrderId == -1) {
                        dropEvent.detail = 0;
                        return;
                    }
                    this.dragAndDropOutsideGroupFromInsideGroup(sourceWrapper, sourceParentGroupWrapper, updatedSourceNodeOrderId);
                } else if (sourceWrapper != null && sourceParentGroupWrapper instanceof WSignalsTableGroup && targetWrapper != null && sourceParentGroupWrapper == targetWrapper) {
                    boolean isSuccessful2 = this.dragAndDropInsideGroup(sourceWrapper, sourceParentGroupWrapper, 0);
                    if (!isSuccessful2) {
                        dropEvent.detail = 0;
                        return;
                    }
                } else if (sourceWrapper != null && sourceParentGroupWrapper instanceof WSignalsTableGroup && targetWrapper instanceof WSignalsTableGroup && sourceParentGroupWrapper != targetWrapper) {
                    updatedSourceNodeOrderId = 0;
                    this.dragAndDropBetweenGroups(sourceWrapper, sourceParentGroupWrapper, targetWrapper, updatedSourceNodeOrderId);
                } else if (sourceWrapper != null && sourceParentGroupWrapper instanceof WSignalsTableGroup && targetWrapper != null && sourceParentGroupWrapper == targetParentGroupWrapper) {
                    updatedSourceNodeOrderId = this.getUpdatedSourceElementId(sourceWrapper, targetWrapper, target, dropEvent);
                    if (updatedSourceNodeOrderId == -1) {
                        dropEvent.detail = 0;
                        return;
                    }
                    isSuccessful = this.dragAndDropInsideGroup(sourceWrapper, sourceParentGroupWrapper, updatedSourceNodeOrderId);
                    if (!isSuccessful) {
                        dropEvent.detail = 0;
                    }
                } else if (sourceWrapper != null && sourceParentGroupWrapper instanceof WSignalsTableGroup && targetWrapper != null && targetParentGroupWrapper instanceof WSignalsTableGroup && sourceParentGroupWrapper != targetParentGroupWrapper) {
                    updatedSourceNodeOrderId = this.getUpdatedSourceElementId(sourceWrapper, targetWrapper, target, dropEvent);
                    if (updatedSourceNodeOrderId == -1) {
                        dropEvent.detail = 0;
                        return;
                    }
                    this.dragAndDropBetweenGroups(sourceWrapper, sourceParentGroupWrapper, targetParentGroupWrapper, updatedSourceNodeOrderId);
                } else if (sourceWrapper instanceof WSignalsTableSeparator && targetWrapper != null && targetParentGroupWrapper instanceof WSignalsTableGroup && sourceParentGroupWrapper != targetParentGroupWrapper) {
                    updatedSourceNodeOrderId = this.getUpdatedSourceElementId(sourceWrapper, targetWrapper, target, dropEvent);
                    if (updatedSourceNodeOrderId == -1) {
                        dropEvent.detail = 0;
                        return;
                    }
                    this.dragAndDropInsideGroupFromOutsideGroup(sourceWrapper, targetParentGroupWrapper, updatedSourceNodeOrderId);
                }
            }
            --i;
        }
    }

    public TreeItem getFirstLevelTreeItem(TreeItem treeItem) {
        TreeItem parentItem = treeItem.getParentItem();
        WSignalsTableElement parentTableElement = this.getItemTableSignalWrapper(parentItem);
        while (parentTableElement != null && !(parentTableElement instanceof WSignalsTableGroup)) {
            treeItem = parentItem;
            parentItem = treeItem.getParentItem();
            parentTableElement = this.getItemTableSignalWrapper(parentItem);
        }
        return treeItem;
    }

    public WSignalsTableElement getItemTableSignalWrapper(TreeItem item) {
        if (item == null) {
            return null;
        }
        Object itemData = item.getData();
        if (!(itemData instanceof TreePath)) {
            return null;
        }
        return DVTVCDUtils.getSignalsTableElement((TreePath)itemData);
    }

    public List<WSignalsTableElement> getItemTableSignalWrappers(List<TreeItem> items) {
        if (items == null || items.isEmpty()) {
            return null;
        }
        ArrayList<WSignalsTableElement> result = new ArrayList<WSignalsTableElement>();
        for (TreeItem item : items) {
            Object itemData = item.getData();
            if (!(itemData instanceof TreePath)) continue;
            result.add(DVTVCDUtils.getSignalsTableElement((TreePath)itemData));
        }
        return result;
    }

    protected abstract int getUpdatedSourceElementId(WSignalsTableElement var1, WSignalsTableElement var2, TreeItem var3, DropTargetEvent var4);

    protected abstract boolean isInsertedAboveTargetWrapper(TreeItem var1, DropTargetEvent var2);

    private boolean dragAndDropInsideGroup(WSignalsTableElement sourceWrapper, WSignalsTableElement sourceParentGroupWrapper, int updatedSourceNodeOrderId) {
        int originalSourceNodeOrderId = sourceWrapper.getId();
        if (originalSourceNodeOrderId == updatedSourceNodeOrderId) {
            return false;
        }
        TreeSet<WSignalsTableElement> childrenWrappers = null;
        if (sourceParentGroupWrapper == null) {
            WCanvas canvas = this.dragSourceListener.getCanvas();
            if (canvas == null) {
                return false;
            }
            WViewport viewport = canvas.getViewport();
            childrenWrappers = viewport.getSignalsTableElements();
        } else {
            childrenWrappers = ((WSignalsTableGroup)sourceParentGroupWrapper).getChildElements();
        }
        if (childrenWrappers == null || childrenWrappers.isEmpty()) {
            return false;
        }
        if (originalSourceNodeOrderId < updatedSourceNodeOrderId) {
            this.dragAndDropInsideGroupMoveSourceDown(sourceWrapper, childrenWrappers, originalSourceNodeOrderId, updatedSourceNodeOrderId);
        } else {
            this.dragAndDropInsideGroupMoveSourceUp(sourceWrapper, childrenWrappers, originalSourceNodeOrderId, updatedSourceNodeOrderId);
        }
        return true;
    }

    private void dragAndDropInsideGroupMoveSourceDown(WSignalsTableElement sourceWrapper, TreeSet<WSignalsTableElement> childrenWrappers, int originalSourceNodeOrderId, int updatedSourceNodeOrderId) {
        Iterator<WSignalsTableElement> childrenIterator = childrenWrappers.iterator();
        while (childrenIterator.hasNext()) {
            WSignalsTableElement child = childrenIterator.next();
            int childNodeOrderId = child.getId();
            if (childNodeOrderId == originalSourceNodeOrderId) {
                childrenIterator.remove();
                continue;
            }
            if (childNodeOrderId > originalSourceNodeOrderId && childNodeOrderId < updatedSourceNodeOrderId) {
                child.setId(childNodeOrderId - 1);
                continue;
            }
            if (childNodeOrderId >= updatedSourceNodeOrderId) break;
        }
        sourceWrapper.setId(--updatedSourceNodeOrderId);
        childrenWrappers.add(sourceWrapper);
    }

    private void dragAndDropInsideGroupMoveSourceUp(WSignalsTableElement sourceWrapper, TreeSet<WSignalsTableElement> childrenWrappers, int originalSourceNodeOrderId, int updatedSourceNodeOrderId) {
        Iterator<WSignalsTableElement> childrenIterator = childrenWrappers.iterator();
        while (childrenIterator.hasNext()) {
            WSignalsTableElement child = childrenIterator.next();
            int childNodeOrderId = child.getId();
            if (childNodeOrderId < updatedSourceNodeOrderId) continue;
            if (childNodeOrderId >= updatedSourceNodeOrderId && childNodeOrderId < originalSourceNodeOrderId) {
                child.setId(childNodeOrderId + 1);
                continue;
            }
            if (childNodeOrderId != originalSourceNodeOrderId) continue;
            childrenIterator.remove();
            break;
        }
        sourceWrapper.setId(updatedSourceNodeOrderId);
        childrenWrappers.add(sourceWrapper);
    }

    private void dragAndDropBetweenGroups(WSignalsTableElement sourceWrapper, WSignalsTableElement sourceParentGroupWrapper, WSignalsTableElement targetParentGroupWrapper, int updatedSourceNodeOrderId) {
        TreeSet<WSignalsTableElement> childrenWrappers = ((WSignalsTableGroup)sourceParentGroupWrapper).getChildElements();
        int sourceNodeOrderId = sourceWrapper.getId();
        DVTVCDUtils.removeSignalsTableElement(childrenWrappers, sourceNodeOrderId);
        childrenWrappers = ((WSignalsTableGroup)targetParentGroupWrapper).getChildElements();
        for (WSignalsTableElement child : childrenWrappers) {
            int childNodeOrderId = child.getId();
            if (childNodeOrderId < updatedSourceNodeOrderId) continue;
            child.setId(childNodeOrderId + 1);
        }
        sourceWrapper.setId(updatedSourceNodeOrderId);
        childrenWrappers.add(sourceWrapper);
    }

    private void dragAndDropInsideGroupFromOutsideGroup(WSignalsTableElement sourceWrapper, WSignalsTableElement targetParentGroupWrapper, int updatedSourceNodeOrderId) {
        WCanvas canvas = this.dragSourceListener.getCanvas();
        if (canvas == null) {
            return;
        }
        WViewport viewport = canvas.getViewport();
        TreeSet<WSignalsTableElement> childrenWrappers = viewport.getSignalsTableElements();
        if (childrenWrappers == null || childrenWrappers.isEmpty()) {
            return;
        }
        int sourceNodeOrderId = sourceWrapper.getId();
        DVTVCDUtils.removeSignalsTableElement(childrenWrappers, sourceNodeOrderId);
        TreeSet<WSignalsTableElement> targetChildren = ((WSignalsTableGroup)targetParentGroupWrapper).getChildElements();
        sourceWrapper.setId(updatedSourceNodeOrderId);
        DVTVCDUtils.addSignalsTableElement(targetChildren, sourceWrapper);
    }

    private void dragAndDropOutsideGroupFromInsideGroup(WSignalsTableElement sourceWrapper, WSignalsTableElement sourceParentGroupWrapper, int updatedSourceNodeOrderId) {
        WCanvas canvas = this.dragSourceListener.getCanvas();
        if (canvas == null) {
            return;
        }
        TreeSet<WSignalsTableElement> childrenWrappers = ((WSignalsTableGroup)sourceParentGroupWrapper).getChildElements();
        if (childrenWrappers == null || childrenWrappers.isEmpty()) {
            return;
        }
        int sourceNodeOrderId = sourceWrapper.getId();
        DVTVCDUtils.removeSignalsTableElement(childrenWrappers, sourceNodeOrderId);
        WViewport viewport = canvas.getViewport();
        TreeSet<WSignalsTableElement> rootChildrenWrappers = viewport.getSignalsTableElements();
        if (rootChildrenWrappers == null || rootChildrenWrappers.isEmpty()) {
            return;
        }
        sourceWrapper.setId(updatedSourceNodeOrderId);
        DVTVCDUtils.addSignalsTableElement(rootChildrenWrappers, sourceWrapper);
    }
}

