/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave;

import org.eclipse.core.resources.IProject;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.diagrams.wave.DWaveformDiagram;
import ro.amiq.dvt.diagrams.wave.WaveDiagramEditor;
import ro.amiq.dvt.diagrams.wave.WaveDiagramEditorInput;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.waveviewer.DVTVCDParser;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.ui.waveviewer.DVTWaveViewIDEFactory;
import ro.amiq.dvt.ui.waveviewer.FSTReader;

public class DWaveformEditorFactory {
    private static DWaveformEditorFactory INSTANCE;
    private static final Object SYNC_OBJECT;
    private DWaveformDiagram diagram;

    static {
        SYNC_OBJECT = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DWaveformEditorFactory getInstance() {
        if (INSTANCE == null) {
            Object object = SYNC_OBJECT;
            synchronized (object) {
                INSTANCE = new DWaveformEditorFactory();
            }
        }
        return INSTANCE;
    }

    public DWaveformEditorFactory() {
    }

    public DWaveformEditorFactory(DWaveformDiagram diagram) {
        this.diagram = diagram;
    }

    public DWaveformEditorFactory newWaveformDiagram(DVTVCDParser vcdParser) {
        return new DWaveformEditorFactory(new DWaveformDiagram(vcdParser));
    }

    public void openEditor() {
        DVTVCDParser parser = this.diagram.getVcdParser();
        if (parser instanceof FSTReader) {
            this.open(this.createEditorInput(((FSTReader)parser).getDstFilePath()));
            return;
        }
        this.open(this.createEditorInput(parser.getVcdFilePath()));
    }

    private void open(WaveDiagramEditorInput input) {
        try {
            IEditorReference[] editorReferences;
            if (input == null) {
                return;
            }
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench == null) {
                return;
            }
            IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
            if (activeWorkbenchWindow == null) {
                return;
            }
            IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
            if (activePage == null) {
                return;
            }
            boolean updateInput = false;
            IEditorReference[] iEditorReferenceArray = editorReferences = activePage.getEditorReferences();
            int n = editorReferences.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference editorReference = iEditorReferenceArray[n2];
                if (editorReference.getEditorInput().equals(input)) {
                    activePage.closeEditor(editorReference.getEditor(false), false);
                    updateInput = true;
                }
                ++n2;
            }
            IEditorPart openEditor = activePage.openEditor((IEditorInput)input, "ro.amiq.dvt.diagrams.wave", true, 0);
            if (updateInput) {
                IProject lastSelectedProject = DVTVCDUtils.getInstance().getLastSelectedProject();
                if (lastSelectedProject == null || !lastSelectedProject.exists()) {
                    return;
                }
                DVTWaveViewIDEFactory.getInstance().setInputWaveEditor(lastSelectedProject, (WaveDiagramEditor)openEditor);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public WaveDiagramEditorInput createEditorInput(String filePath) {
        WaveDiagramEditorInput waveDiagramEditorInput = new WaveDiagramEditorInput(filePath, null);
        waveDiagramEditorInput.setDiagram(this.diagram);
        return waveDiagramEditorInput;
    }
}

