/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import ro.amiq.dvt.ui.waveviewer.DVTVCDSignalWrapper;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.ui.waveviewer.DVTVCDVarClockInfo;
import ro.amiq.dvt.ui.waveviewer.DVTVCDVarModificationByTime;
import ro.amiq.dvt.ui.waveviewer.DVTVarModifQueue;
import ro.amiq.dvt.ui.waveviewer.TimeChangeWrapper;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableSignal;

public class EdgesMetrics {
    private long cursorsLowTime;
    private long cursorsHighTime;
    private String timeUnit;
    private int signalBitwidth;
    private long nofEdges;
    private long nofPosedges;
    private long nofNegedges;
    private long timeHigh;
    private long timeLow;
    private DVTVCDSignalWrapper signalWrapper;
    private WSignalsTableSignal signalsTableSignal;

    public EdgesMetrics(long cursorsLowTime, long cursorsHighTime, String timeUnit, int signalBitwidth, DVTVCDSignalWrapper signalWrapper, WSignalsTableSignal signalsTableSignal) {
        this.cursorsLowTime = cursorsLowTime;
        this.cursorsHighTime = cursorsHighTime;
        this.timeUnit = timeUnit;
        this.signalBitwidth = signalBitwidth;
        this.signalWrapper = signalWrapper;
        this.signalsTableSignal = signalsTableSignal;
        this.nofEdges = 0L;
        this.nofPosedges = 0L;
        this.nofNegedges = 0L;
        this.timeHigh = 0L;
        this.timeLow = 0L;
    }

    public List<DVTVCDVarModificationByTime> getPrevModifs(List<DVTVCDVarModificationByTime> filteredSignals, long time) {
        if (filteredSignals.isEmpty()) {
            return filteredSignals;
        }
        List<DVTVCDVarModificationByTime> prevModifs = filteredSignals.stream().filter(signal -> signal.getTime() <= time).collect(Collectors.toList());
        filteredSignals.removeAll(prevModifs);
        return prevModifs;
    }

    public void computeMetrics() {
        Iterable<DVTVCDVarModificationByTime> signalModifsByTime = this.signalWrapper.getVarModificationByTime();
        TreeMap<Long, DVTVCDVarClockInfo> clockInfoByStartTimes = this.signalWrapper.getClockInfoByStartTimes();
        ArrayList<DVTVCDVarModificationByTime> filteredVarModifs = new ArrayList<DVTVCDVarModificationByTime>();
        DVTVarModifQueue<DVTVCDVarModificationByTime> varModifsFromFST = this.signalWrapper.getVarModifsFromFST();
        if (varModifsFromFST != null) {
            signalModifsByTime = varModifsFromFST;
            ((DVTVarModifQueue)signalModifsByTime).setStartTime((int)this.cursorsLowTime);
        }
        for (DVTVCDVarModificationByTime varModif : signalModifsByTime) {
            if (varModif.getTime() > this.cursorsHighTime) break;
            if (varModif.getTime() <= this.cursorsLowTime) continue;
            filteredVarModifs.add(varModif);
        }
        String firstValue = DVTVCDUtils.getSignalValueAtTime(this.signalWrapper, this.cursorsLowTime);
        String lastValue = DVTVCDUtils.getSignalValueAtTime(this.signalWrapper, this.cursorsHighTime);
        filteredVarModifs.add(new DVTVCDVarModificationByTime(new TimeChangeWrapper(this.cursorsHighTime, 0L), lastValue));
        filteredVarModifs.add(0, new DVTVCDVarModificationByTime(new TimeChangeWrapper(this.cursorsLowTime, 0L), firstValue));
        boolean clockEnding = false;
        for (Map.Entry<Long, DVTVCDVarClockInfo> entry : clockInfoByStartTimes.entrySet()) {
            String value;
            DVTVCDVarClockInfo varClockInfo = entry.getValue();
            long clockStartTime = varClockInfo.getStartTime();
            long clockEndTime = varClockInfo.getEndTime();
            if (!(clockStartTime <= this.cursorsHighTime && clockStartTime >= this.cursorsLowTime || clockEndTime <= this.cursorsHighTime && clockEndTime >= this.cursorsLowTime || clockStartTime <= this.cursorsLowTime && clockEndTime >= this.cursorsHighTime)) continue;
            long clockIntervalStartTime = this.cursorsLowTime;
            if (clockStartTime > this.cursorsLowTime) {
                clockIntervalStartTime = clockStartTime;
            }
            long clockIntervalEndTime = this.cursorsHighTime;
            if (clockEndTime < this.cursorsHighTime) {
                clockIntervalEndTime = clockEndTime;
            }
            this.computeMetrics(varClockInfo, clockIntervalStartTime, clockIntervalEndTime);
            List<DVTVCDVarModificationByTime> prevModifs = this.getPrevModifs(filteredVarModifs, clockIntervalStartTime);
            if (clockIntervalStartTime != this.cursorsLowTime) {
                value = Long.toString(varClockInfo.getValueAtTime(clockIntervalStartTime));
                DVTVCDVarModificationByTime clockInfLimit = new DVTVCDVarModificationByTime(new TimeChangeWrapper(clockIntervalStartTime, 0L), value);
                prevModifs.add(clockInfLimit);
                this.computeMetrics(prevModifs);
            }
            if (clockIntervalEndTime != this.cursorsHighTime) {
                value = Long.toString(varClockInfo.getValueAtTime(clockIntervalEndTime));
                DVTVCDVarModificationByTime clockSupLimit = new DVTVCDVarModificationByTime(new TimeChangeWrapper(clockIntervalEndTime, 0L), value);
                filteredVarModifs.add(0, clockSupLimit);
            }
            if (clockIntervalEndTime != this.cursorsHighTime) continue;
            clockEnding = true;
            break;
        }
        if (!clockEnding) {
            this.computeMetrics(filteredVarModifs);
        }
    }

    public void computeMetrics(DVTVCDVarClockInfo varClockInfo, long cursorsLowTime, long cursorsHighTime) {
        long valueAtStartTime = varClockInfo.getValueAtTime(cursorsLowTime);
        long valueAtEndTime = varClockInfo.getValueAtTime(cursorsHighTime);
        long nextTimeChangeStart = varClockInfo.getNextTimeChange(cursorsLowTime);
        long nextTimeChangeEnd = varClockInfo.getNextTimeChange(cursorsHighTime);
        long changeInterval = varClockInfo.getChangeInterval();
        long nofEdges = (cursorsHighTime - nextTimeChangeStart) / changeInterval + 1L;
        if (nofEdges == 1L && valueAtStartTime == valueAtEndTime) {
            nofEdges = 0L;
        }
        long nofPosedges = (nofEdges + 1L - valueAtStartTime) / 2L;
        long nofNegedges = nofEdges - nofPosedges;
        long perfectPeriodsTime = (nextTimeChangeEnd - nextTimeChangeStart) / changeInterval;
        long timeHigh = (valueAtStartTime == 1L ? perfectPeriodsTime / 2L : (perfectPeriodsTime + 1L) / 2L) * changeInterval;
        long timeLow = perfectPeriodsTime * changeInterval - timeHigh;
        long startDiff = nextTimeChangeStart - cursorsLowTime;
        long endDiff = nextTimeChangeEnd - cursorsHighTime;
        if (valueAtStartTime == 1L) {
            timeHigh += startDiff;
        } else {
            timeLow += startDiff;
        }
        if (valueAtEndTime == 1L) {
            timeHigh -= endDiff;
        } else {
            timeLow -= endDiff;
        }
        this.nofEdges += nofEdges;
        this.nofNegedges += nofNegedges;
        this.nofPosedges += nofPosedges;
        this.timeHigh += timeHigh;
        this.timeLow += timeLow;
    }

    public void computeMetrics(List<DVTVCDVarModificationByTime> signalModifsByTime) {
        if (signalModifsByTime == null || signalModifsByTime.size() < 2) {
            return;
        }
        if (signalModifsByTime.size() == 2) {
            String secondModifValue;
            DVTVCDVarModificationByTime firstModif = signalModifsByTime.get(0);
            DVTVCDVarModificationByTime secondModif = signalModifsByTime.get(1);
            String firstModifValue = firstModif.computeValueForTableSignal(this.signalsTableSignal, this.signalWrapper);
            if (firstModifValue.equals(secondModifValue = secondModif.computeValueForTableSignal(this.signalsTableSignal, this.signalWrapper))) {
                long firstModifTime = firstModif.getTime();
                long secondModifTime = secondModif.getTime();
                if (this.cursorsLowTime >= firstModifTime && this.cursorsHighTime < secondModifTime) {
                    long deltaTime = this.cursorsHighTime - this.cursorsLowTime;
                    if ("1".equals(firstModifValue)) {
                        this.timeHigh += deltaTime;
                    } else {
                        this.timeLow += deltaTime;
                    }
                    return;
                }
            }
        }
        DVTVCDVarModificationByTime prevModif = signalModifsByTime.get(0);
        int i = 1;
        while (i < signalModifsByTime.size()) {
            DVTVCDVarModificationByTime signalModif = signalModifsByTime.get(i);
            this.updateEdgesMetrics(prevModif, signalModif);
            prevModif = signalModif;
            ++i;
        }
    }

    private void updateEdgesMetrics(DVTVCDVarModificationByTime prevSignalModif, DVTVCDVarModificationByTime signalModif) {
        String modifValue = signalModif.computeValueForTableSignal(this.signalsTableSignal, this.signalWrapper);
        String prevModifValue = prevSignalModif.computeValueForTableSignal(this.signalsTableSignal, this.signalWrapper);
        long prevModifTime = prevSignalModif.getTime();
        long modifTime = signalModif.getTime();
        if ("1".equals(prevModifValue)) {
            this.timeHigh += this.getDeltaTime(modifTime, prevModifTime);
        }
        if ("0".equals(prevModifValue)) {
            this.timeLow += this.getDeltaTime(modifTime, prevModifTime);
        }
        if (prevModifValue.equals(modifValue)) {
            return;
        }
        if (modifTime <= this.cursorsHighTime) {
            ++this.nofEdges;
        }
        if (this.signalBitwidth > 1) {
            return;
        }
        if ("1".equals(modifValue) && modifTime <= this.cursorsHighTime) {
            ++this.nofPosedges;
        } else if ("0".equals(modifValue) && modifTime <= this.cursorsHighTime) {
            ++this.nofNegedges;
        }
    }

    private long getDeltaTime(long modifTime, long prevModifTime) {
        if (prevModifTime < this.cursorsLowTime) {
            return modifTime - this.cursorsLowTime;
        }
        if (modifTime > this.cursorsHighTime) {
            return this.cursorsHighTime - prevModifTime;
        }
        return modifTime - prevModifTime;
    }

    public long getCursorsLowTime() {
        return this.cursorsLowTime;
    }

    public long getCursorsHighTime() {
        return this.cursorsHighTime;
    }

    public String getTimeUnit() {
        return this.timeUnit;
    }

    public int getSignalBitwidth() {
        return this.signalBitwidth;
    }

    public String getDutyCycle() {
        if (this.signalBitwidth > 1) {
            return "Metric not applicable";
        }
        return String.valueOf(String.format("%.2f", (double)this.timeHigh * 100.0 / (double)(this.timeHigh + this.timeLow))) + "%";
    }

    public long getNofEdges() {
        return this.nofEdges;
    }

    public String getNofPosedges() {
        if (this.signalBitwidth > 1) {
            return "Metric not applicable";
        }
        return String.valueOf(this.nofPosedges);
    }

    public String getNofNegedges() {
        if (this.signalBitwidth > 1) {
            return "Metric not applicable";
        }
        return String.valueOf(this.nofNegedges);
    }

    public String getTimeHigh() {
        if (this.signalBitwidth > 1) {
            return "Metric not applicable";
        }
        return String.valueOf(String.valueOf(this.timeHigh)) + this.timeUnit;
    }

    public String getTimeLow() {
        if (this.signalBitwidth > 1) {
            return "Metric not applicable";
        }
        return String.valueOf(String.valueOf(this.timeLow)) + this.timeUnit;
    }
}

