/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave;

import java.util.List;
import java.util.TreeSet;
import ro.amiq.dvt.diagrams.wave.draw.WCanvas;
import ro.amiq.dvt.diagrams.wave.draw.WViewport;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableElement;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableGroup;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableMultiBitChildSignal;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableSeparator;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableSingleBitChildSignal;

public interface IDWaveSignalsGroup {
    default public WSignalsTableGroup createOrEditGroupSignalsAction(TreeSet<WSignalsTableElement> selectedElements) {
        String selectedGroupName = this.getSelectedGroupName();
        if (selectedGroupName == null) {
            return null;
        }
        WCanvas canvas = this.getCanvas();
        if (canvas == null) {
            return null;
        }
        WViewport viewport = canvas.getViewport();
        TreeSet<WSignalsTableElement> signalsTableNodes = viewport.getSignalsTableElements();
        if (signalsTableNodes == null) {
            return null;
        }
        WSignalsTableGroup group = DVTVCDUtils.getExistingGroup(selectedGroupName, signalsTableNodes);
        if (group == null && "default".equals(selectedGroupName)) {
            group = DVTVCDUtils.createNewDefaultGroup(signalsTableNodes, canvas);
        }
        if (group == null) {
            return null;
        }
        this.updateGroupChildElements(group, selectedElements);
        viewport.addSignalsTableNode(group);
        if (viewport.getPrimaryCursor() != null) {
            viewport.renderAndUpdateTableValues();
        }
        return group;
    }

    default public String renameGroupAction(TreeSet<WSignalsTableElement> selectedElements, WSignalsTableGroup selectedGroup) {
        String newGroupName = this.getNewGroupName();
        if (newGroupName != null && !newGroupName.isEmpty()) {
            selectedGroup.setName(newGroupName);
        }
        this.updateGroupChildElements(selectedGroup, selectedElements);
        return newGroupName;
    }

    default public void moveElementsToDifferentGroup(List<WSignalsTableElement> elementsToMove) {
        String targetGroupName = this.getSelectedGroupName();
        if (targetGroupName == null) {
            return;
        }
        WCanvas canvas = this.getCanvas();
        if (canvas == null) {
            return;
        }
        WViewport viewport = canvas.getViewport();
        TreeSet<WSignalsTableElement> signalsTableNodes = viewport.getSignalsTableElements();
        if (signalsTableNodes == null) {
            return;
        }
        WSignalsTableGroup targetGroup = this.getGroup(targetGroupName, signalsTableNodes);
        this.moveElementsToGroup(targetGroup, elementsToMove, viewport);
    }

    default public void moveElementsToGroup(WSignalsTableGroup targetGroup, List<WSignalsTableElement> elementsToMove, WViewport viewport) {
        if (targetGroup == null) {
            return;
        }
        TreeSet<WSignalsTableElement> targetGroupChildren = targetGroup.getChildElements();
        int nodeOrderId = targetGroupChildren.size();
        for (WSignalsTableElement element : elementsToMove) {
            WSignalsTableGroup elementParentGroup;
            if (element instanceof WSignalsTableMultiBitChildSignal || element instanceof WSignalsTableSingleBitChildSignal || (elementParentGroup = DVTVCDUtils.getParentGroup(element)) == null && !(element instanceof WSignalsTableSeparator) || elementParentGroup != null && targetGroup.getName().equals(elementParentGroup.getName())) continue;
            viewport.removeSignalsTableElement(element.getTreePath());
            element.setId(nodeOrderId);
            targetGroupChildren.add(element);
            ++nodeOrderId;
        }
        TreeSet<WSignalsTableElement> signalsTableNodes = viewport.getSignalsTableElements();
        if (signalsTableNodes.contains(targetGroup)) {
            return;
        }
        viewport.addSignalsTableNode(targetGroup);
    }

    default public WSignalsTableGroup createNewGroup(TreeSet<WSignalsTableElement> signalsTableElements, int nodeOrderIDInTable) {
        WCanvas canvas = this.getCanvas();
        if (canvas == null) {
            return null;
        }
        String newGroupName = this.getNewGroupName();
        if (newGroupName == null || newGroupName.isEmpty()) {
            return null;
        }
        for (WSignalsTableElement node : signalsTableElements) {
            if (node.getId() < nodeOrderIDInTable) continue;
            node.setId(node.getId() + 1);
        }
        WSignalsTableGroup group = new WSignalsTableGroup(nodeOrderIDInTable, newGroupName, null, null);
        WViewport viewport = canvas.getViewport();
        viewport.addSignalsTableNode(group);
        return group;
    }

    default public WSignalsTableGroup addNewGroupAtPosition(String position) {
        WSignalsTableGroup targetGroupWrapper;
        String targetGroupName;
        WCanvas canvas = this.getCanvas();
        if (canvas == null) {
            return null;
        }
        WViewport viewport = canvas.getViewport();
        int nodeOrderId = -1;
        if (position.startsWith("To top")) {
            nodeOrderId = 0;
        }
        if (position.startsWith("To bottom")) {
            nodeOrderId = viewport.getSignalsTableSize();
        }
        if (position.startsWith("Before")) {
            targetGroupName = position.split(" ")[1];
            targetGroupWrapper = DVTVCDUtils.getExistingGroup(targetGroupName, viewport.getSignalsTableElements());
            nodeOrderId = targetGroupWrapper.getId();
        }
        if (position.startsWith("After")) {
            targetGroupName = position.split(" ")[1];
            targetGroupWrapper = DVTVCDUtils.getExistingGroup(targetGroupName, viewport.getSignalsTableElements());
            nodeOrderId = targetGroupWrapper.getId() + 1;
        }
        if (nodeOrderId == -1) {
            return null;
        }
        WSignalsTableGroup newGroup = this.createNewGroup(viewport.getSignalsTableElements(), nodeOrderId);
        return newGroup;
    }

    default public void updateGroupChildElements(WSignalsTableGroup group, TreeSet<WSignalsTableElement> selectedElements) {
        TreeSet<WSignalsTableElement> childElements = group.getChildElements();
        childElements.clear();
        childElements.addAll(selectedElements);
    }

    public String getNewGroupName();

    public String getSelectedGroupName();

    public WCanvas getCanvas();

    public WSignalsTableGroup getGroup(String var1, TreeSet<WSignalsTableElement> var2);
}

