/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeMap;
import ro.amiq.dvt.diagrams.wave.WaveViewerSignalTableView;
import ro.amiq.dvt.diagrams.wave.draw.WCanvas;
import ro.amiq.dvt.diagrams.wave.draw.WCursor;
import ro.amiq.dvt.diagrams.wave.draw.WViewport;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTree;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.waveviewer.DVTVCDModel;
import ro.amiq.dvt.ui.waveviewer.DVTVCDParser;
import ro.amiq.dvt.ui.waveviewer.DVTVCDSignalWrapper;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.ui.waveviewer.DVTVCDVarClockInfo;
import ro.amiq.dvt.ui.waveviewer.DVTVCDVarModificationByTime;
import ro.amiq.dvt.ui.waveviewer.DVTVarModifQueue;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableElement;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableSignal;

public interface IJumpToEdgeAction {
    default public void jumpToEdge(WaveViewerSignalTableView signalsView) {
        long firstTimeFromVcd;
        WCanvas canvas = signalsView.getCanvas();
        if (canvas == null) {
            return;
        }
        DVTVCDParser vcdParser = canvas.getProvider();
        WViewport viewport = canvas.getViewport();
        if (vcdParser == null || viewport == null) {
            return;
        }
        DVTVCDModel model = vcdParser.getVcdModel();
        if (model == null) {
            return;
        }
        LazyTree lazyTree = signalsView.getLazyTree();
        List<TreePath> selections = lazyTree.getSelections();
        if (selections == null || selections.size() != 1) {
            return;
        }
        WSignalsTableElement selectedElement = DVTVCDUtils.getSignalsTableElement(selections.get(0));
        if (!(selectedElement instanceof WSignalsTableSignal)) {
            return;
        }
        LinkedHashMap<String, DVTVCDSignalWrapper> variablesByID = model.getSignalsByModelId();
        if (variablesByID == null || variablesByID.isEmpty()) {
            return;
        }
        DVTVCDSignalWrapper selectedSignal = variablesByID.get(((WSignalsTableSignal)selectedElement).getVcdId());
        if (selectedSignal == null) {
            return;
        }
        WCursor cursor = viewport.getPrimaryCursor();
        long cursorTime = cursor.getTime();
        if (cursorTime < (firstTimeFromVcd = vcdParser.getFirstTimeFromVcd())) {
            viewport.updatePrimaryCursorAtFixedTime(firstTimeFromVcd);
            viewport.panToTime(firstTimeFromVcd);
            return;
        }
        TreeMap<Long, DVTVCDVarClockInfo> clockInfoByStartTimes = selectedSignal.getClockInfoByStartTimes();
        Iterable<DVTVCDVarModificationByTime> varModificationByTime = selectedSignal.getVarModificationByTime();
        DVTVarModifQueue<DVTVCDVarModificationByTime> varModifsFromFST = selectedSignal.getVarModifsFromFST();
        if (varModifsFromFST != null) {
            varModifsFromFST.setStartTime((int)cursorTime);
            varModificationByTime = varModifsFromFST;
        }
        long initialDiagramLowerTimeLimit = vcdParser.getDiagramLowerTimeLimit();
        long initialDiagramUpperTimeLimit = vcdParser.getDiagramUpperTimeLimit();
        long edgeTime = -1L;
        if ("Next Change".equals(this.getActionType())) {
            edgeTime = DVTVCDUtils.getNextEdge(clockInfoByStartTimes, varModificationByTime, cursorTime, vcdParser, viewport, selectedSignal, selectedElement);
        } else if ("Prev Change".equals(this.getActionType())) {
            edgeTime = DVTVCDUtils.getPrevEdge(clockInfoByStartTimes, varModificationByTime, cursorTime, vcdParser, viewport, selectedSignal, selectedElement);
        }
        if (edgeTime == -2L) {
            vcdParser.setDiagramTimeLimits(initialDiagramLowerTimeLimit, initialDiagramUpperTimeLimit);
            vcdParser.updateModel();
            this.notifyTimeout();
            return;
        }
        if (edgeTime == -1L) {
            vcdParser.setDiagramTimeLimits(initialDiagramLowerTimeLimit, initialDiagramUpperTimeLimit);
            vcdParser.updateModel();
            return;
        }
        viewport.updatePrimaryCursorAtFixedTime(edgeTime);
        if (initialDiagramLowerTimeLimit < edgeTime && edgeTime < initialDiagramUpperTimeLimit) {
            return;
        }
        viewport.panToTime(edgeTime);
    }

    public String getActionType();

    public void notifyTimeout();
}

