/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import ro.amiq.dvt.diagrams.wave.IJumpToEdgeAction;
import ro.amiq.dvt.diagrams.wave.WaveViewerSignalTableView;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;

public class JumpToEdgeAction
extends Action
implements IJumpToEdgeAction {
    private WaveViewerSignalTableView signalsView;

    public JumpToEdgeAction(WaveViewerSignalTableView signalsView, String label) {
        super(label);
        this.signalsView = signalsView;
        if ("Next Change".equals(label)) {
            this.setToolTipText("Next Change\t( Ctrl+] )");
            this.setImageDescriptor(DVTImages.ARROW_LEFT_RIGHT_IMG);
            this.setAccelerator(262237);
        } else if ("Prev Change".equals(label)) {
            this.setToolTipText("Prev Change\t( Ctrl+[ )");
            this.setImageDescriptor(DVTImages.ARROW_RIGHT_LEFT_IMG);
            this.setAccelerator(262235);
        }
    }

    public void run() {
        if (!DVTVCDUtils.getInstance().hasLicense(this.signalsView.getCanvas())) {
            return;
        }
        this.jumpToEdge(this.signalsView);
    }

    @Override
    public String getActionType() {
        return this.getText();
    }

    @Override
    public void notifyTimeout() {
        Display.getDefault().asyncExec(() -> {
            Shell activeShell = Display.getDefault().getActiveShell();
            MessageDialog.open((int)4, (Shell)activeShell, (String)"Jump To Change", (String)"Jump To Change canceled due to time out!", (int)32);
        });
    }
}

