/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.diagrams.wave.WaveDiagramEditor;
import ro.amiq.dvt.diagrams.wave.WaveViewerDesignHierarchyView;
import ro.amiq.dvt.diagrams.wave.WaveViewerLeftSignalsPanelView;
import ro.amiq.dvt.diagrams.wave.WaveViewerSignalTableView;
import ro.amiq.dvt.diagrams.wave.draw.WCanvas;
import ro.amiq.dvt.diagrams.wave.draw.WViewport;
import ro.amiq.dvt.diagrams.wave.draw.render.swt.WSWTRenderer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.waveviewer.DVTVCDConfigFilesEngine;
import ro.amiq.dvt.ui.waveviewer.DVTVCDModel;
import ro.amiq.dvt.ui.waveviewer.DVTVCDParser;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.ui.waveviewer.FSTReader;
import ro.amiq.dvt.ui.waveviewer.VCD2FST;
import ro.amiq.dvt.ui.waveviewer.WaveViewerGenerationError;
import ro.amiq.dvt.utils.DVTFileUtils;

public class RefreshAction
extends Action {
    private WCanvas canvas;

    public RefreshAction(WCanvas canvas) {
        super("Refresh Waveform Viewer", 1);
        this.setDescription("Refresh Waveform Viewer");
        this.setToolTipText("Refresh Waveform Viewer");
        this.setImageDescriptor(DVTImages.REFRESH);
        this.canvas = canvas;
    }

    public boolean checkFileExists(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            return true;
        }
        MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "File not found!", null, "The vcd file path does not exist: " + filePath, 2, new String[]{"OK"}, 0);
        dialog.open();
        return false;
    }

    public void run() {
        if (!DVTVCDUtils.getInstance().hasLicense(this.canvas)) {
            return;
        }
        final DVTVCDParser parser = this.canvas.getProvider();
        this.canvas.getViewport().setToolBarActionEnabled(RefreshAction.class, false);
        if (parser instanceof FSTReader) {
            String configFilePath;
            Runnable callbackFunction;
            VCD2FST vcd2fstJob;
            FSTReader fstReader = (FSTReader)parser;
            final boolean hasIncompleteHierarchy = fstReader.hasIncompleteHierarchy();
            Set<WaveViewerGenerationError> generationErrors = parser.getGenerationErrors();
            if (generationErrors == null) {
                return;
            }
            if (!generationErrors.isEmpty() && !hasIncompleteHierarchy) {
                return;
            }
            final String dstFilePath = fstReader.getDstFilePath();
            final String vcdFilePath = String.valueOf(dstFilePath.substring(0, dstFilePath.lastIndexOf(46))) + "." + "vcd";
            if (!this.checkFileExists(dstFilePath)) {
                parser.setGenerationErrors(EnumSet.of(WaveViewerGenerationError.DST_FILE_NOT_FOUND));
                return;
            }
            if (!this.checkFileExists(vcdFilePath)) {
                return;
            }
            if (!hasIncompleteHierarchy) {
                DVTVCDConfigFilesEngine.INSTANCE.exportDefaultConfig(parser.getViewport());
            }
            if ((vcd2fstJob = new VCD2FST("Refresh DST file", vcdFilePath, dstFilePath, callbackFunction = () -> this.lambda$0(parser, dstFilePath, vcdFilePath, configFilePath = parser.getConfigFilePath(), generationErrors))).getVCDDateTimeString().equals(fstReader.getDateTimeString())) {
                Job refreshJob = new Job("Refresh DST"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected IStatus run(IProgressMonitor monitor) {
                        DVTVCDParser dVTVCDParser;
                        IStatus iStatus;
                        WaveDiagramEditor waveEditor;
                        block22: {
                            block21: {
                                vcd2fstJob.refresh(monitor);
                                DVTVCDModel model = new DVTVCDModel();
                                FSTReader newReader = new FSTReader(parser.getProject(), dstFilePath, vcdFilePath, configFilePath, model);
                                newReader.setRefresh(true);
                                newReader.parseInitial();
                                newReader.setViewport(parser.getViewport());
                                RefreshAction.this.canvas.setProvider(newReader);
                                RefreshAction.this.canvas.getSignalsTableView().getWaveEditor().parser = newReader;
                                if (hasIncompleteHierarchy) break block21;
                                IStatus iStatus2 = Status.OK_STATUS;
                                DVTVCDParser dVTVCDParser2 = parser;
                                synchronized (dVTVCDParser2) {
                                    parser.deepClean();
                                }
                                vcd2fstJob.deepClean();
                                RefreshAction.this.canvas.getViewport().setToolBarActionEnabled(RefreshAction.class, true);
                                ObjectionManager.getInstance().clear(Objection.WAVEFORM_VIEWER_REFRESH);
                                return iStatus2;
                            }
                            WaveViewerSignalTableView signalsTableView = RefreshAction.this.canvas.getSignalsTableView();
                            waveEditor = signalsTableView.getWaveEditor();
                            if (Files.exists(Path.of(configFilePath, new String[0]), new LinkOption[0])) break block22;
                            RefreshAction.this.canvas.getRenderer().render();
                            IStatus iStatus3 = Status.OK_STATUS;
                            DVTVCDParser dVTVCDParser3 = parser;
                            synchronized (dVTVCDParser3) {
                                parser.deepClean();
                            }
                            vcd2fstJob.deepClean();
                            RefreshAction.this.canvas.getViewport().setToolBarActionEnabled(RefreshAction.class, true);
                            ObjectionManager.getInstance().clear(Objection.WAVEFORM_VIEWER_REFRESH);
                            return iStatus3;
                        }
                        try {
                            String cfgJsonString = DVTFileUtils.getInstance().readFileContent(new File(configFilePath));
                            DVTVCDConfigFilesEngine.INSTANCE.deserializeSignalsTableElements(waveEditor, RefreshAction.this.canvas, cfgJsonString);
                            iStatus = Status.OK_STATUS;
                            dVTVCDParser = parser;
                        }
                        catch (IOException e) {
                            DVTVCDParser dVTVCDParser4;
                            IStatus iStatus4;
                            try {
                                DVTLogger.INSTANCE.logError((Throwable)e);
                                iStatus4 = Status.CANCEL_STATUS;
                                dVTVCDParser4 = parser;
                            }
                            catch (Throwable throwable) {
                                DVTVCDParser dVTVCDParser5 = parser;
                                synchronized (dVTVCDParser5) {
                                    parser.deepClean();
                                }
                                vcd2fstJob.deepClean();
                                RefreshAction.this.canvas.getViewport().setToolBarActionEnabled(RefreshAction.class, true);
                                ObjectionManager.getInstance().clear(Objection.WAVEFORM_VIEWER_REFRESH);
                                throw throwable;
                            }
                            synchronized (dVTVCDParser4) {
                                parser.deepClean();
                            }
                            vcd2fstJob.deepClean();
                            RefreshAction.this.canvas.getViewport().setToolBarActionEnabled(RefreshAction.class, true);
                            ObjectionManager.getInstance().clear(Objection.WAVEFORM_VIEWER_REFRESH);
                            return iStatus4;
                        }
                        synchronized (dVTVCDParser) {
                            parser.deepClean();
                        }
                        vcd2fstJob.deepClean();
                        RefreshAction.this.canvas.getViewport().setToolBarActionEnabled(RefreshAction.class, true);
                        ObjectionManager.getInstance().clear(Objection.WAVEFORM_VIEWER_REFRESH);
                        return iStatus;
                    }
                };
                refreshJob.schedule();
                return;
            }
            Job reloadJob = new Job("Refresh DST"){

                protected IStatus run(IProgressMonitor monitor) {
                    if (!DVTVCDUtils.existsTimeInVcd(RefreshAction.this.canvas, vcdFilePath, monitor)) {
                        return Status.CANCEL_STATUS;
                    }
                    vcd2fstJob.setUser(false);
                    vcd2fstJob.schedule();
                    return Status.OK_STATUS;
                }
            };
            reloadJob.setUser(false);
            reloadJob.schedule();
        } else {
            parser.refreshClean();
            parser.parseInitial();
            this.canvas.getViewport().setToolBarActionEnabled(RefreshAction.class, true);
        }
        WSWTRenderer renderer = this.canvas.getRenderer();
        renderer.render();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$0(DVTVCDParser dVTVCDParser, String string, String string2, String string3, Set set) {
        FSTReader fstParser;
        FSTReader fSTReader = fstParser = new FSTReader(dVTVCDParser.getProject(), string, string2, string3, new DVTVCDModel());
        synchronized (fSTReader) {
            WViewport viewport = dVTVCDParser.getViewport();
            fstParser.setViewport(viewport);
            fstParser.parseInitial();
            fstParser.setGenerationErrors(set);
            fstParser.setRefresh(true);
            viewport.setToolBarActionEnabled(RefreshAction.class, true);
            this.canvas.setProvider(fstParser);
            WaveViewerSignalTableView signalsTableView = this.canvas.getSignalsTableView();
            WaveDiagramEditor waveEditor = signalsTableView.getWaveEditor();
            waveEditor.parser = fstParser;
            WaveViewerDesignHierarchyView dhView = signalsTableView.getDHView();
            if (dhView != null) {
                dhView.resetTreeState();
                WaveViewerLeftSignalsPanelView leftPanelView = dhView.getLeftPanelView();
                if (leftPanelView != null) {
                    leftPanelView.setModel(null);
                    leftPanelView.updateUsingTreePath(null, null);
                }
            }
            dVTVCDParser.deepClean();
            String cfgJsonString = DVTFileUtils.getInstance().readFileContent(new File(string3));
            DVTVCDConfigFilesEngine.INSTANCE.deserializeSignalsTableElements(waveEditor, this.canvas, cfgJsonString);
            ObjectionManager.getInstance().clear(Objection.WAVEFORM_VIEWER_REFRESH);
        }
    }
}

