/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave;

import java.util.TreeSet;
import ro.amiq.dvt.ui.waveviewer.DVTVCDSignalWrapper;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableElement;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableGroup;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableMultiBitChildSignal;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableMultiBitSignal;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableSeparator;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableSignal;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableSingleBitChildSignal;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableSingleBitSignal;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableStructSignal;
import ro.amiq.dvt.ui.waveviewer.WStructMetadata;

public enum WSignalsTableElementsFactory {
    INSTANCE;


    public WSignalsTableSignal createSignal(int signalId, DVTVCDSignalWrapper signalWrapper) {
        WStructMetadata structMetadata = signalWrapper.getStructMetadata();
        int signalBitWidth = Integer.parseInt(signalWrapper.getBitWidth());
        if (structMetadata != null && structMetadata.isEnum()) {
            return this.createStruct(signalId, signalWrapper, structMetadata, signalBitWidth);
        }
        if (signalBitWidth == 1) {
            return WSignalsTableSingleBitSignal.of(signalId, signalWrapper);
        }
        if (structMetadata != null) {
            return this.createStruct(signalId, signalWrapper, structMetadata, signalBitWidth);
        }
        if (signalBitWidth > 1) {
            return WSignalsTableMultiBitSignal.of(signalId, signalWrapper);
        }
        return null;
    }

    private WSignalsTableSignal createStruct(int signalId, DVTVCDSignalWrapper signalWrapper, WStructMetadata structMetadata, int signalBitWidth) {
        int structBitWidth = structMetadata.getBitWidth();
        if (signalBitWidth == structBitWidth) {
            return WSignalsTableStructSignal.of(signalId, signalWrapper);
        }
        TreeSet<WSignalsTableElement> childSignals = new TreeSet<WSignalsTableElement>(WSignalsTableElement.ELEMENTS_COMPARATOR);
        int noChildren = signalBitWidth / structBitWidth;
        if (signalWrapper.isBigEndian()) {
            int i = 0;
            while (i < noChildren) {
                childSignals.add(WSignalsTableStructSignal.of(i, signalWrapper, i));
                ++i;
            }
        } else {
            int i = noChildren - 1;
            while (i >= 0) {
                childSignals.add(WSignalsTableStructSignal.of(noChildren - i - 1, signalWrapper, i));
                --i;
            }
        }
        return WSignalsTableMultiBitSignal.of(signalId, signalWrapper, childSignals);
    }

    public WSignalsTableElement createCopyOf(WSignalsTableElement signalsTableElement) {
        if (signalsTableElement instanceof WSignalsTableGroup) {
            return new WSignalsTableGroup((WSignalsTableGroup)signalsTableElement);
        }
        if (signalsTableElement instanceof WSignalsTableSeparator) {
            return new WSignalsTableSeparator((WSignalsTableSeparator)signalsTableElement);
        }
        if (signalsTableElement instanceof WSignalsTableSingleBitChildSignal) {
            return new WSignalsTableSingleBitChildSignal((WSignalsTableSingleBitChildSignal)signalsTableElement);
        }
        if (signalsTableElement instanceof WSignalsTableMultiBitChildSignal) {
            return new WSignalsTableMultiBitChildSignal((WSignalsTableMultiBitChildSignal)signalsTableElement);
        }
        if (signalsTableElement instanceof WSignalsTableSingleBitSignal) {
            return new WSignalsTableSingleBitSignal((WSignalsTableSingleBitSignal)signalsTableElement);
        }
        if (signalsTableElement instanceof WSignalsTableStructSignal) {
            return new WSignalsTableStructSignal((WSignalsTableStructSignal)signalsTableElement);
        }
        if (signalsTableElement instanceof WSignalsTableMultiBitSignal) {
            return new WSignalsTableMultiBitSignal((WSignalsTableMultiBitSignal)signalsTableElement);
        }
        return null;
    }
}

