/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.diagrams.wave.DWaveSignalTableDragSourceEffect;
import ro.amiq.dvt.diagrams.wave.DWaveSignalTableDragSourceListener;
import ro.amiq.dvt.diagrams.wave.DWaveSignalTableDropTargetListener;
import ro.amiq.dvt.diagrams.wave.DWaveformDiagram;
import ro.amiq.dvt.diagrams.wave.JumpToEdgeAction;
import ro.amiq.dvt.diagrams.wave.RefreshAction;
import ro.amiq.dvt.diagrams.wave.WaveDiagramEditorCommon;
import ro.amiq.dvt.diagrams.wave.WaveDiagramEditorInput;
import ro.amiq.dvt.diagrams.wave.WaveViewerCountEdgesAction;
import ro.amiq.dvt.diagrams.wave.WaveViewerDesignHierarchyView;
import ro.amiq.dvt.diagrams.wave.WaveViewerExportConfigAction;
import ro.amiq.dvt.diagrams.wave.WaveViewerFactoryInput;
import ro.amiq.dvt.diagrams.wave.WaveViewerFitToCanvasAction;
import ro.amiq.dvt.diagrams.wave.WaveViewerImportConfigAction;
import ro.amiq.dvt.diagrams.wave.WaveViewerJumpToTimeAction;
import ro.amiq.dvt.diagrams.wave.WaveViewerShowHideDHViewAction;
import ro.amiq.dvt.diagrams.wave.WaveViewerSignalTableView;
import ro.amiq.dvt.diagrams.wave.WaveViewerZoomToFitCursorsAction;
import ro.amiq.dvt.diagrams.wave.WaveformViewerLogViewerAction;
import ro.amiq.dvt.diagrams.wave.draw.WCanvas;
import ro.amiq.dvt.diagrams.wave.draw.WHorizontalCanvasSlider;
import ro.amiq.dvt.draw.DCanvas;
import ro.amiq.dvt.draw.obj.base.DGroup;
import ro.amiq.dvt.draw.obj.primitive.DText;
import ro.amiq.dvt.draw.utils.FontFactory;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTree;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTreeSliderSeparatorSide;
import ro.amiq.dvt.ui.views.lazy.views.DVTLazyViewUtils;
import ro.amiq.dvt.ui.waveviewer.DVTVCDModel;
import ro.amiq.dvt.ui.waveviewer.DVTVCDParser;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.ui.waveviewer.DVTWaveViewIDEFactory;
import ro.amiq.dvt.ui.waveviewer.FSTReader;
import ro.amiq.dvt.ui.waveviewer.VCD2FST;
import ro.amiq.dvt.utils.BaseUtils;
import ro.amiq.dvt.utils.StoppableJob;

public class WaveDiagramEditor
extends WaveDiagramEditorCommon {
    private StoppableJob updateJob;
    protected ListenerList<ISelectionChangedListener> selectionChangedListeners = new ListenerList(1);
    private Tree tree;
    private SashForm signalsAndDiagramSash;
    private Composite selectedSignalsComposite;
    private Composite dhSignalsViewComposite;
    private Shell dhSignalsViewDialogShell;
    private WaveViewerDesignHierarchyView dhSignalsView;
    private int dhWeight;
    private Point dhDialogSize;
    private ToolBarManager topMgr;
    private ToolBarManager bottomMgr;
    private ToolBar topTb;
    private ToolBar bottomTb;
    private WaveViewerFactoryInput setInputAction;
    private WaveViewerShowHideDHViewAction dhAction;
    private static final int DH_DIALOG_INITIAL_HEIGHT = 500;
    private KeyListener nextChangeKeyListener;
    private KeyListener prevChangeKeyListener;
    private RefreshAction refreshAction;

    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        site.setSelectionProvider((ISelectionProvider)this);
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    public void createPartControl(Composite parent) {
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(0, 0).applyTo(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        this.createVerticalToolbar(parent);
        this.signalsAndDiagramSash = new SashForm(parent, 67844);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.signalsAndDiagramSash);
        GridLayoutFactory.fillDefaults().spacing(0, 0).margins(0, 0).applyTo((Composite)this.signalsAndDiagramSash);
        this.selectedSignalsComposite = new Composite((Composite)this.signalsAndDiagramSash, 4);
        GridLayoutFactory.fillDefaults().numColumns(1).spacing(0, 0).applyTo(this.selectedSignalsComposite);
        Composite composite = new Composite((Composite)this.signalsAndDiagramSash, 0);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(composite);
        if (!DVTPlugin.getDefault().collect().c()) {
            this.displayLicenseNotAvailable(composite);
            return;
        }
        IEditorInput editorInput = this.getEditorInput();
        if (!(editorInput instanceof WaveDiagramEditorInput)) {
            this.displayDiagramGenerationFailed(composite);
            return;
        }
        DWaveformDiagram diagram = ((WaveDiagramEditorInput)editorInput).getDiagram();
        if (diagram == null) {
            this.displayDiagramGenerationFailed(composite);
            return;
        }
        DVTVCDParser vcdParser = diagram.getVcdParser();
        if (vcdParser == null) {
            this.displayDiagramGenerationFailed(composite);
            return;
        }
        this.signalsAndDiagramSash.setWeights(new int[]{250, 750});
        this.dhWeight = 210;
        WHorizontalCanvasSlider horizontalSlider = new WHorizontalCanvasSlider(composite, LazyTreeSliderSeparatorSide.DOWN);
        Composite canvasParentComposite = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().applyTo(canvasParentComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)canvasParentComposite);
        this.canvas = new WCanvas(canvasParentComposite, vcdParser, horizontalSlider);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.canvas);
        horizontalSlider.setCanvas((WCanvas)this.canvas);
        this.createSignalsView();
        this.fillToolbars();
        this.initConfigData();
        this.setInputAction.activateOnFirstOpenedVcd();
        this.canvas.addKeyListener(this.nextChangeKeyListener);
        this.canvas.addKeyListener(this.prevChangeKeyListener);
        this.signalsView.addTreeKeyListener(this.nextChangeKeyListener);
        this.signalsView.addTreeKeyListener(this.prevChangeKeyListener);
        this.canvas.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                LazyTree lazyTree = WaveDiagramEditor.this.signalsView.getLazyTree();
                if (lazyTree == null) {
                    return;
                }
                KeyListener setSelectionUsingKeysListener = lazyTree.getSetSelectionUsingKeysListener();
                if (setSelectionUsingKeysListener == null) {
                    return;
                }
                setSelectionUsingKeysListener.keyPressed(e);
            }
        });
    }

    private void fillToolbars() {
        WCanvas canvas = (WCanvas)this.getCanvas();
        if (this.setInputAction == null) {
            this.setInputAction = new WaveViewerFactoryInput(this);
        }
        this.topMgr.add((IAction)this.setInputAction);
        this.topMgr.add((IContributionItem)new Separator());
        this.refreshAction = new RefreshAction(canvas);
        if (!(this.parser instanceof FSTReader) && !DVTVCDUtils.DVT_DISABLE_DST_CONVERSION) {
            this.refreshAction.setEnabled(false);
        }
        this.topMgr.add((IAction)this.refreshAction);
        this.topMgr.add((IAction)new WaveViewerImportConfigAction(canvas, this.signalsView));
        this.topMgr.add((IAction)new WaveViewerExportConfigAction(canvas));
        this.topMgr.add((IContributionItem)new Separator());
        this.topMgr.add((IAction)new WaveViewerCountEdgesAction(this.signalsView));
        this.topMgr.add((IAction)new WaveViewerZoomToFitCursorsAction(canvas));
        this.topMgr.add((IAction)new WaveViewerFitToCanvasAction(canvas));
        this.topMgr.add((IAction)new WaveViewerJumpToTimeAction(canvas));
        final JumpToEdgeAction prevChangeAction = new JumpToEdgeAction(this.signalsView, "Prev Change");
        this.topMgr.add((IAction)prevChangeAction);
        this.prevChangeKeyListener = new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if ((e.stateMask & 0x40000) == 0 || e.keyCode != 91) {
                    return;
                }
                prevChangeAction.run();
            }
        };
        final JumpToEdgeAction nextChangeAction = new JumpToEdgeAction(this.signalsView, "Next Change");
        this.topMgr.add((IAction)nextChangeAction);
        this.nextChangeKeyListener = new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if ((e.stateMask & 0x40000) == 0 || e.keyCode != 93) {
                    return;
                }
                nextChangeAction.run();
            }
        };
        WaveformViewerLogViewerAction logViewerAction = new WaveformViewerLogViewerAction(canvas);
        this.topMgr.add((IAction)logViewerAction);
        DVTVCDUtils.getInstance().updateLogViewerActionButton(canvas);
        this.topMgr.add((IContributionItem)new Separator());
        this.dhAction = new WaveViewerShowHideDHViewAction(this);
        this.bottomMgr.add((IAction)this.dhAction);
        this.bottomMgr.update(true);
        this.topMgr.update(true);
        this.topTb.addListener(5, e -> {
            ToolItem item = this.topTb.getItem(new Point(e.x, e.y));
            if (item != null && item.getData() instanceof ActionContributionItem && ((ActionContributionItem)item.getData()).getAction() instanceof WaveViewerFactoryInput) {
                item.setToolTipText(this.setInputAction.getToolTipText());
            }
        });
    }

    public void triggerRefresh() {
        this.refreshAction.run();
    }

    private void createVerticalToolbar(Composite parent) {
        Composite side = new Composite(parent, 0);
        GridData sideGD = new GridData(1, 4, false, true);
        side.setLayoutData((Object)sideGD);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        gl.verticalSpacing = 0;
        side.setLayout((Layout)gl);
        this.topMgr = new ToolBarManager(8405632);
        this.topTb = this.topMgr.createControl(side);
        this.topTb.setLayoutData((Object)new GridData(1, 1, true, false));
        this.bottomMgr = new ToolBarManager(8406528);
        this.bottomTb = this.bottomMgr.createControl(side);
        this.bottomTb.setLayoutData((Object)new GridData(0x1000008, 0x1000008, false, true));
    }

    public void showDHSignalsView() {
        if (this.dhSignalsView == null) {
            this.dhSignalsView = new WaveViewerDesignHierarchyView(this.signalsView);
            this.signalsView.setDhView(this.dhSignalsView);
        }
        this.dhSignalsView.setIsClosed(false);
        this.dhSignalsView.saveTreeState();
        if (this.dhSignalsView.isDetached()) {
            this.dhSignalsViewDialogShell = this.openDHSignalsViewInDialog((Composite)this.signalsAndDiagramSash);
            return;
        }
        int[] oldWeights = this.signalsAndDiagramSash.getWeights();
        this.dhSignalsViewComposite = new Composite((Composite)this.signalsAndDiagramSash, 16);
        this.dhSignalsViewComposite.setLayout((Layout)DVTLazyViewUtils.LAYOUT);
        GridLayoutFactory.fillDefaults().numColumns(1).spacing(0, 0).applyTo(this.dhSignalsViewComposite);
        this.dhSignalsViewComposite.moveAbove(null);
        this.dhSignalsView.initAndShow(this.dhSignalsViewComposite);
        this.dhSignalsViewComposite.layout();
        this.signalsAndDiagramSash.setWeights(new int[]{this.dhWeight, oldWeights[0], oldWeights[1] - this.dhWeight});
        this.signalsAndDiagramSash.layout();
        if (this.dhDialogSize != null) {
            return;
        }
        this.dhSignalsViewComposite.pack();
        this.dhDialogSize = this.dhSignalsViewComposite.getSize();
        if (this.dhDialogSize == null) {
            return;
        }
        this.dhDialogSize.y = 500;
    }

    public void closeDHSignalsSidePanel() {
        if (this.signalsAndDiagramSash.isDisposed()) {
            return;
        }
        int[] oldWeights = this.signalsAndDiagramSash.getWeights();
        if (this.dhSignalsViewComposite != null) {
            this.dhSignalsViewComposite.dispose();
        }
        this.dhSignalsViewComposite = null;
        this.dhWeight = oldWeights[0];
        this.signalsAndDiagramSash.setWeights(new int[]{oldWeights[1], oldWeights[0] + oldWeights[2]});
        this.signalsAndDiagramSash.layout();
    }

    public void closeDHSignalsDialog() {
        if (this.dhSignalsViewDialogShell == null) {
            return;
        }
        this.dhSignalsViewDialogShell.close();
        this.dhSignalsViewDialogShell = null;
    }

    public void closeDHSignalsView() {
        if (this.dhSignalsView == null) {
            return;
        }
        this.dhSignalsView.saveTreeState();
        if (!this.dhSignalsView.isDetached()) {
            this.closeDHSignalsSidePanel();
        }
        this.closeDHSignalsDialog();
        this.dhSignalsView.clear();
        this.dhSignalsView.setIsClosed(true);
    }

    public Shell openDHSignalsViewInDialog(Composite parentComposite) {
        Shell shell = new Shell(parentComposite.getShell(), 1264);
        GridLayoutFactory.fillDefaults().applyTo((Composite)shell);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, true).applyTo((Control)shell);
        if (this.dhDialogSize == null) {
            shell.pack();
        } else {
            shell.setSize(this.dhDialogSize);
        }
        this.dhSignalsView.initAndShow((Composite)shell);
        shell.addListener(21, e -> {
            this.dhDialogSize = this.dhSignalsViewDialogShell.getSize();
            if (this.dhSignalsView.isDetached() && this.dhAction != null) {
                this.dhAction.uncheckToolbarButton();
            }
        });
        shell.setText("Design Panel");
        shell.open();
        return shell;
    }

    @Override
    protected void createSignalsView() {
        this.signalsView = new WaveViewerSignalTableView(this);
        ((WCanvas)this.canvas).setSignalsTableView(this.signalsView);
        this.signalsView.createPartControl(this.selectedSignalsComposite);
        this.tree = this.signalsView.getLazyTree().getTree();
        this.tree.setLinesVisible(true);
        this.tree.setHeaderVisible(false);
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        int operations = 2;
        DragSource source = new DragSource((Control)this.tree, operations);
        source.setTransfer(types);
        DWaveSignalTableDragSourceListener dragSourceListener = new DWaveSignalTableDragSourceListener(this.signalsView, (WCanvas)this.canvas);
        source.addDragListener((DragSourceListener)dragSourceListener);
        DWaveSignalTableDragSourceEffect dragSourceEffect = new DWaveSignalTableDragSourceEffect(this.tree);
        source.setDragSourceEffect((DragSourceEffect)dragSourceEffect);
        DropTarget target = new DropTarget((Control)this.tree, operations);
        target.setTransfer(types);
        DWaveSignalTableDropTargetListener dropTargetListener = new DWaveSignalTableDropTargetListener(this.signalsView, dragSourceListener);
        target.addDropListener((DropTargetListener)dropTargetListener);
        this.signalsView.update();
    }

    private void displayDiagramGenerationFailed(Composite composite) {
        this.canvas = new DCanvas(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.canvas);
        StoppableJob updateJob = new StoppableJob("Could not generate diagram!"){

            @Override
            protected IStatus stoppableRun(IProgressMonitor monitor) {
                DGroup multiLineText = DText.createCenteredMultiline("Could not generate diagram!", FontFactory.getInstance().getFontData("Sans", 32, 0));
                ((DCanvas)WaveDiagramEditor.this.canvas).setContent(multiLineText);
                return Status.OK_STATUS;
            }
        };
        updateJob.schedule();
    }

    private void displayLicenseNotAvailable(Composite composite) {
        this.signalsAndDiagramSash.setWeights(new int[]{0, 1});
        this.canvas = new DCanvas(composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.canvas);
        StoppableJob updateJob = new StoppableJob("License not available"){

            @Override
            protected IStatus stoppableRun(IProgressMonitor monitor) {
                FontData fontData = FontFactory.getInstance().getFontData("Sans", 20, 0);
                String messageString = "License not available." + System.lineSeparator() + "Reopen the editor after checking-out a license.";
                DGroup multiLineText = DText.createCenteredMultiline(messageString, fontData);
                ((DCanvas)WaveDiagramEditor.this.canvas).setContent(multiLineText);
                return Status.OK_STATUS;
            }
        };
        updateJob.schedule();
    }

    @Override
    public void dispose() {
        if (this.updateJob != null) {
            this.updateJob.cancel();
        }
        if (this.vcd2fstJob != null) {
            this.vcd2fstJob.cancel();
        }
        this.exportDefaultConfig();
        WaveDiagramEditorInput waveformDiagramEditorInput = this.getInput();
        if (waveformDiagramEditorInput == null) {
            return;
        }
        waveformDiagramEditorInput.deepClean();
        waveformDiagramEditorInput = null;
        DVTWaveViewIDEFactory.getInstance().clearInput(this);
        this.selectionChangedListeners.clear();
        this.selectionChangedListeners = null;
        this.currentSelection = null;
        if (this.parser != null) {
            this.parser.deepClean();
        }
        this.closeDHSignalsDialog();
        if (this.dhSignalsView != null) {
            this.dhSignalsView.deepClean();
        }
        this.dhSignalsView = null;
        if (this.signalsView != null) {
            this.signalsView.dispose();
        }
        this.signalsView = null;
        super.dispose();
    }

    public void setFocus() {
        this.canvas.setFocus();
    }

    protected boolean canvasReady() {
        return this.canvas != null && !this.canvas.isDisposed();
    }

    public WaveDiagramEditorInput getInput() {
        return (WaveDiagramEditorInput)this.getEditorInput();
    }

    protected void setInput(IEditorInput input) {
        WaveDiagramEditorInput diagramEditorInput = null;
        if (input instanceof WaveDiagramEditorInput) {
            diagramEditorInput = (WaveDiagramEditorInput)input;
        } else {
            diagramEditorInput = (WaveDiagramEditorInput)input.getAdapter(WaveDiagramEditorInput.class);
            if (diagramEditorInput != null) {
                diagramEditorInput.initDiagram();
            }
        }
        if (diagramEditorInput == null) {
            diagramEditorInput = new WaveDiagramEditorInput(null, null);
            this.setInputWithNotify((IEditorInput)diagramEditorInput);
            return;
        }
        this.setInputWithNotify((IEditorInput)diagramEditorInput);
        DWaveformDiagram diagram = diagramEditorInput.getDiagram();
        if (diagram == null) {
            return;
        }
        this.parser = diagram.getVcdParser();
        if (this.parser == null) {
            return;
        }
        if (this.parser instanceof FSTReader) {
            String dstFilePath = ((FSTReader)this.parser).getDstFilePath();
            if (dstFilePath == null || dstFilePath.isEmpty()) {
                return;
            }
            this.setPartName(BaseUtils.getFileName(dstFilePath));
            return;
        }
        String vcdFilePath = this.parser.getVcdFilePath();
        if (vcdFilePath == null || vcdFilePath.isEmpty()) {
            return;
        }
        this.setPartName(BaseUtils.getFileName(vcdFilePath));
        if (!this.parser.getGenerationErrors().isEmpty()) {
            return;
        }
        if (!DVTVCDUtils.DVT_DISABLE_DST_CONVERSION) {
            String fstFilePath = String.valueOf(vcdFilePath.substring(0, vcdFilePath.lastIndexOf(46))) + "." + "dst";
            Runnable callbackFunction = () -> {
                FSTReader fstParser;
                String configFilePath = this.parser.getConfigFilePath();
                IProject project = this.parser.getProject();
                FSTReader fSTReader = fstParser = new FSTReader(project, fstFilePath, vcdFilePath, configFilePath, new DVTVCDModel());
                synchronized (fSTReader) {
                    fstParser.setViewport(this.parser.getViewport());
                    ((DVTVCDParser)fstParser).parseInitial();
                    fstParser.setGenerationErrors(this.parser.getGenerationErrors());
                    Object object = this.getParserSwapSyncObject();
                    synchronized (object) {
                        DVTLogger.INSTANCE.logDebug("Waveform Viewer Parser Swap: Started");
                        diagram.setParser(fstParser);
                        this.parser.getViewport().getCanvas().setProvider(fstParser);
                        this.parser.deepClean();
                        this.parser = fstParser;
                        this.vcd2fstJob = null;
                        fstParser.getViewport().setToolBarActionEnabled(RefreshAction.class, true);
                        DVTLogger.INSTANCE.logDebug("Waveform Viewer Parser Swap: Finished");
                        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                        if (workspaceRoot == null) {
                            return;
                        }
                        IFile fstFile = workspaceRoot.getFileForLocation((IPath)new Path(fstFilePath));
                        IFile configFile = workspaceRoot.getFileForLocation((IPath)new Path(configFilePath));
                        try {
                            if (fstFile != null) {
                                fstFile.refreshLocal(0, null);
                            }
                            if (configFile != null) {
                                configFile.refreshLocal(0, null);
                            }
                        }
                        catch (CoreException e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                        }
                    }
                }
            };
            this.vcd2fstJob = new VCD2FST("Convert VCD to DST", vcdFilePath, fstFilePath, callbackFunction);
            this.vcd2fstJob.setUser(false);
            this.vcd2fstJob.schedule();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public DVTVCDParser getParser() {
        return this.parser;
    }

    @Override
    public WaveViewerSignalTableView getSignalsTable() {
        return this.signalsView;
    }

    public WaveViewerDesignHierarchyView testGetDHSignalsView() {
        if (TestHelper.isTestMode()) {
            return this.dhSignalsView;
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IResource.class) {
            return this.getEditorInput().getAdapter(IResource.class);
        }
        return super.getAdapter(adapter);
    }

    public ToolBarManager getTopMgr() {
        return this.topMgr;
    }

    public WaveViewerFactoryInput getWaveViewerFactoryInputAction() {
        return this.setInputAction;
    }
}

