/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave;

import java.io.File;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import ro.amiq.dvt.diagrams.editor.DDiagramEditorSelection;
import ro.amiq.dvt.diagrams.netlist.model.NLPort;
import ro.amiq.dvt.diagrams.wave.WaveViewerSignalTableView;
import ro.amiq.dvt.diagrams.wave.draw.WCanvas;
import ro.amiq.dvt.diagrams.wave.draw.WCursor;
import ro.amiq.dvt.diagrams.wave.draw.WViewport;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.waveviewer.DVTVCDConfigFilesEngine;
import ro.amiq.dvt.ui.waveviewer.DVTVCDModel;
import ro.amiq.dvt.ui.waveviewer.DVTVCDParser;
import ro.amiq.dvt.ui.waveviewer.DVTVCDSignalWrapper;
import ro.amiq.dvt.ui.waveviewer.DVTWaveViewIDEFactory;
import ro.amiq.dvt.ui.waveviewer.FSTReader;
import ro.amiq.dvt.ui.waveviewer.VCD2FST;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableElement;
import ro.amiq.dvt.ui.waveviewer.WStructMetadata;
import ro.amiq.dvt.ui.waveviewer.WaveformViewerSchematicDiagramUtils;
import ro.amiq.dvt.utils.DVTFileUtils;

public abstract class WaveDiagramEditorCommon
extends EditorPart
implements ISelectionProvider {
    public static final String ID = "ro.amiq.dvt.diagrams.wave";
    protected VCD2FST vcd2fstJob;
    protected DVTVCDParser parser;
    protected DDiagramEditorSelection currentSelection = new DDiagramEditorSelection();
    protected Canvas canvas;
    protected Comparator<WSignalsTableElement> elementsComparator = (o1, o2) -> o1.getId() - o2.getId();
    protected WaveViewerSignalTableView signalsView;
    private final Object parserSwapSyncObject = new Object();
    private HashMap<String, HashSet<NLPort>> schematicDiagramPortsToLoad = new HashMap();
    private HashSet<NLPort> schematicDiagramPortsToLoadNotFound = new HashSet();
    private final Object schematicDiagramPortsLoadSyncObject = new Object();

    public abstract void init(IEditorSite var1, IEditorInput var2) throws PartInitException;

    protected abstract void createSignalsView();

    protected void initConfigData() {
        String configFilePath = this.parser.getConfigFilePath();
        if (configFilePath == null || configFilePath.isEmpty()) {
            return;
        }
        String cfgJsonString = DVTFileUtils.getInstance().readFileContent(new File(configFilePath));
        if (cfgJsonString.isEmpty()) {
            return;
        }
        DVTVCDConfigFilesEngine.INSTANCE.deserializeSignalsTableElements(this, (WCanvas)this.canvas, cfgJsonString);
    }

    protected void exportDefaultConfig() {
        if (!(this.canvas instanceof WCanvas)) {
            return;
        }
        WCanvas wCanvas = (WCanvas)this.canvas;
        WViewport viewport = wCanvas.getViewport();
        if (viewport == null) {
            return;
        }
        DVTVCDParser parser = wCanvas.getProvider();
        if (parser == null) {
            return;
        }
        DVTVCDConfigFilesEngine.INSTANCE.exportDefaultConfig(viewport);
    }

    public ISelection getSelection() {
        return this.currentSelection;
    }

    public void setSelection(ISelection selection) {
        DVTLogger.INSTANCE.logError((Throwable)new UnsupportedOperationException());
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public boolean isDirty() {
        return false;
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public String getVCDPath() {
        if (this.parser == null) {
            return null;
        }
        if (this.parser instanceof FSTReader) {
            return ((FSTReader)this.parser).getDstFilePath();
        }
        return this.parser.getVcdFilePath();
    }

    public int hashCode() {
        return Objects.hash(this.getEditorInput());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        WaveDiagramEditorCommon other = (WaveDiagramEditorCommon)((Object)obj);
        return Objects.equals(this.getEditorInput(), other.getEditorInput());
    }

    public Object getParserSwapSyncObject() {
        return this.parserSwapSyncObject;
    }

    abstract WaveViewerSignalTableView getSignalsTable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSchematicDiagramPortToLoad(NLPort nlPort, DVTVCDSignalWrapper signalWrapper) {
        Object object = this.schematicDiagramPortsLoadSyncObject;
        synchronized (object) {
            if (this.schematicDiagramPortsToLoad == null || this.schematicDiagramPortsToLoadNotFound == null) {
                return;
            }
            if (signalWrapper == null) {
                this.schematicDiagramPortsToLoadNotFound.add(nlPort);
                return;
            }
            String signalId = signalWrapper.getVarID();
            if (signalId == null) {
                this.schematicDiagramPortsToLoadNotFound.add(nlPort);
                return;
            }
            HashSet<NLPort> nlPortsOfSignalId = this.schematicDiagramPortsToLoad.get(signalId);
            if (nlPortsOfSignalId == null) {
                nlPortsOfSignalId = new HashSet();
                this.schematicDiagramPortsToLoad.put(signalId, nlPortsOfSignalId);
            }
            nlPortsOfSignalId.add(nlPort);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSchematicDiagramPorts() {
        if (!(this.canvas instanceof WCanvas)) {
            return;
        }
        WViewport viewport = ((WCanvas)this.canvas).getViewport();
        if (viewport == null) {
            return;
        }
        WCursor primaryCursor = viewport.getPrimaryCursor();
        if (primaryCursor == null) {
            return;
        }
        if (this.parser == null) {
            return;
        }
        DVTVCDModel vcdModel = this.parser.getVcdModel();
        if (vcdModel == null) {
            return;
        }
        LinkedHashMap<String, DVTVCDSignalWrapper> signalsByModelId = vcdModel.getSignalsByModelId();
        if (signalsByModelId == null || signalsByModelId.isEmpty()) {
            return;
        }
        Object object = this.schematicDiagramPortsLoadSyncObject;
        synchronized (object) {
            if (this.schematicDiagramPortsToLoad == null || this.schematicDiagramPortsToLoadNotFound == null) {
                return;
            }
            this.parser.addSignalsToModel(this.schematicDiagramPortsToLoad.keySet());
            long time = primaryCursor.getTime();
            for (Map.Entry<String, HashSet<NLPort>> entry : this.schematicDiagramPortsToLoad.entrySet()) {
                HashSet<NLPort> nlPorts = entry.getValue();
                if (nlPorts == null || nlPorts.isEmpty()) continue;
                if (time == -100L || time < 0L) {
                    this.setNLPortsValuesNotAvailable(nlPorts);
                    continue;
                }
                String signalId = entry.getKey();
                if (signalId == null || signalId.isEmpty()) {
                    this.setNLPortsValuesNotAvailable(nlPorts);
                    continue;
                }
                DVTVCDSignalWrapper signalWrapper = signalsByModelId.get(signalId);
                if (signalWrapper == null) {
                    this.setNLPortsValuesNotAvailable(nlPorts);
                    continue;
                }
                WStructMetadata signalStructMetadata = signalWrapper.getStructMetadata();
                for (NLPort nlPort : nlPorts) {
                    String portNameWithHierarchicalAccess;
                    if (nlPort == null || (portNameWithHierarchicalAccess = DVTWaveViewIDEFactory.getInstance().getNLPortNameWithHierarchicalAccess(nlPort)) == null) continue;
                    String nlPortWaveformValue = null;
                    nlPortWaveformValue = portNameWithHierarchicalAccess.contains(".") && signalStructMetadata != null ? WaveformViewerSchematicDiagramUtils.getStructChildSignalValueAtTime(portNameWithHierarchicalAccess, signalWrapper, time) : WaveformViewerSchematicDiagramUtils.getSignalValueAtTime(signalWrapper, time);
                    if (nlPortWaveformValue == null) {
                        nlPort.setWaveformValue("[N/A]");
                        continue;
                    }
                    nlPort.setWaveformValue(nlPortWaveformValue);
                }
            }
            this.schematicDiagramPortsToLoad.clear();
            this.setNLPortsValuesNotAvailable(this.schematicDiagramPortsToLoadNotFound);
            this.schematicDiagramPortsToLoadNotFound.clear();
        }
    }

    private void setNLPortsValuesNotAvailable(HashSet<NLPort> nlPorts) {
        for (NLPort nlPort : nlPorts) {
            if (nlPort == null) continue;
            nlPort.setWaveformValue("[N/A]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.schematicDiagramPortsLoadSyncObject;
        synchronized (object) {
            if (this.schematicDiagramPortsToLoad != null) {
                this.schematicDiagramPortsToLoad.clear();
                this.schematicDiagramPortsToLoad = null;
            }
            if (this.schematicDiagramPortsToLoadNotFound != null) {
                this.schematicDiagramPortsToLoadNotFound.clear();
                this.schematicDiagramPortsToLoadNotFound = null;
            }
        }
        super.dispose();
    }
}

