/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave;

import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.editors.text.ILocationProvider;
import ro.amiq.dvt.diagrams.wave.DWaveformDiagram;
import ro.amiq.dvt.ui.waveviewer.DVTVCDConfigFilesEngine;
import ro.amiq.dvt.ui.waveviewer.DVTVCDModel;
import ro.amiq.dvt.ui.waveviewer.DVTVCDParser;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtilsCommon;
import ro.amiq.dvt.ui.waveviewer.FSTReader;

public class WaveDiagramEditorInput
implements IFileEditorInput {
    private String filePath;
    private final IProject project;
    private DWaveformDiagram diagram;

    public WaveDiagramEditorInput(String filePath, IProject project) {
        this.filePath = filePath;
        this.project = project;
    }

    public void initDiagram() {
        DVTVCDModel vcdModel = new DVTVCDModel();
        String configFilePath = null;
        if (this.filePath.endsWith("wcfg")) {
            configFilePath = this.filePath;
            this.filePath = DVTVCDConfigFilesEngine.INSTANCE.extractFilePathFromConfig(configFilePath, DVTVCDUtilsCommon.WaveFileFormat.ALL_TYPES);
            if (this.filePath == null) {
                new MessageDialog(Display.getCurrent().getActiveShell(), "No existing file", null, "Could not find any specified Waveform Viewer source files (vcd/dst)!", 1, new String[]{IDialogConstants.OK_LABEL}, 0).open();
                return;
            }
        }
        DVTVCDParser vcdParser = null;
        if (this.filePath.endsWith("dst")) {
            String vcdFilePath = DVTVCDConfigFilesEngine.INSTANCE.extractFilePathFromConfig(configFilePath, DVTVCDUtilsCommon.WaveFileFormat.VCD);
            vcdParser = new FSTReader(this.project, this.filePath, vcdFilePath, configFilePath, vcdModel);
        } else {
            vcdParser = new DVTVCDParser(this.project, this.filePath, configFilePath, vcdModel);
        }
        vcdParser.parseInitial();
        this.diagram = new DWaveformDiagram(vcdParser);
    }

    public String getName() {
        if (this.diagram == null) {
            return "Could not generate diagram!";
        }
        return this.diagram.getName();
    }

    public String getToolTipText() {
        if (this.diagram == null) {
            return "Could not generate diagram!";
        }
        return this.filePath;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (ILocationProvider.class.equals((Object)adapter)) {
            return this;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public DWaveformDiagram getDiagram() {
        return this.diagram;
    }

    public void setDiagram(DWaveformDiagram diagram) {
        this.diagram = diagram;
    }

    public void deepClean() {
        if (this.diagram == null) {
            return;
        }
        this.diagram.deepClean();
        this.diagram = null;
    }

    public IStorage getStorage() throws CoreException {
        Path location;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = root.getFileForLocation((IPath)(location = new Path(this.filePath)));
        if (file != null) {
            return file;
        }
        return root.getFile((IPath)location);
    }

    public IFile getFile() {
        Path location;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = root.getFileForLocation((IPath)(location = new Path(this.filePath)));
        if (file != null) {
            return file;
        }
        return root.getFile((IPath)location);
    }

    public int hashCode() {
        return Objects.hash(this.filePath);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WaveDiagramEditorInput other = (WaveDiagramEditorInput)obj;
        return Objects.equals(this.filePath, other.filePath);
    }
}

