/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave;

import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import ro.amiq.dvt.diagrams.wave.WaveDiagramEditorInput;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;

public class WaveDiagramEditorInputAdapter
implements IAdapterFactory {
    private static final Class<?>[] ADAPTER_LIST = new Class[]{WaveDiagramEditorInput.class};

    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        if (!(adaptableObject instanceof FileEditorInput) && !(adaptableObject instanceof FileStoreEditorInput)) {
            return null;
        }
        if (adapterType != WaveDiagramEditorInput.class) {
            return null;
        }
        String fileName = null;
        String filePath = null;
        if (adaptableObject instanceof FileEditorInput) {
            fileName = ((FileEditorInput)adaptableObject).getName();
            IPath path = ((FileEditorInput)adaptableObject).getPath();
            if (path == null) {
                return null;
            }
            filePath = path.toOSString();
        } else if (adaptableObject instanceof FileStoreEditorInput) {
            fileName = ((FileStoreEditorInput)adaptableObject).getName();
            URI uri = ((FileStoreEditorInput)adaptableObject).getURI();
            String string = filePath = uri != null ? uri.getPath() : null;
        }
        if (!DVTVCDUtils.isValidFileExtension(fileName)) {
            return null;
        }
        if (filePath == null) {
            return null;
        }
        IProject project = this.getProject(adaptableObject);
        return (T)new WaveDiagramEditorInput(filePath, project);
    }

    private IProject getProject(Object adaptableObject) {
        if (!(adaptableObject instanceof FileEditorInput)) {
            return null;
        }
        IFile file = ((FileEditorInput)adaptableObject).getFile();
        if (file == null) {
            return null;
        }
        return file.getProject();
    }

    public Class<?>[] getAdapterList() {
        return ADAPTER_LIST;
    }
}

