/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import ro.amiq.dvt.diagrams.wave.IDWaveSignalsGroup;
import ro.amiq.dvt.diagrams.wave.WaveViewerDesignHierarchyView;
import ro.amiq.dvt.diagrams.wave.WaveViewerNewGroupNameTextArea;
import ro.amiq.dvt.diagrams.wave.WaveViewerSignalTableView;
import ro.amiq.dvt.diagrams.wave.draw.WCanvas;
import ro.amiq.dvt.diagrams.wave.draw.WViewport;
import ro.amiq.dvt.ui.views.DVTPopupDialog;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTree;
import ro.amiq.dvt.ui.views.lazy.tree.MultipleSelectionTreeIterator;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeAction;
import ro.amiq.dvt.ui.views.lazy.tree.commands.LazyTreeSetMultipleSelectionActionArguments;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableElement;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableGroup;

public class WaveViewerAddNewGroupDialog
extends DVTPopupDialog
implements IDWaveSignalsGroup {
    private static final String ID = "Add New Group";
    private static final String CHOOSE_POSITION_LABEL = "Choose Position";
    private static final String ADD_TO_TOP_LABEL = "To top";
    private static final String ADD_TO_BOTTOM_LABEL = "To bottom";
    private static final String BEFORE_LABEL = "Before ";
    private static final String AFTER_LABEL = "After ";
    private static final int DIALOG_AREA_WIDTH = 350;
    private static final int DIALOG_AREA_HEIGHT = 375;
    private WCanvas canvas;
    private WaveViewerSignalTableView signalsView;
    private WSignalsTableElement selectedGroupInTable;
    private Composite contentsComposite;
    private Button okButton;
    private WaveViewerNewGroupNameTextArea newGroupNameTextArea;
    private int newGroupNodeOrderIDInTable;
    private KeyListener enterKeyListener;

    public WaveViewerAddNewGroupDialog(WCanvas canvas, WaveViewerSignalTableView signalsView, int shellStyle, boolean takeFocusOnOpen, boolean persistSize, boolean persistLocation, boolean showDialogMenu, boolean showPersistActions, String titleText, String infoText) {
        super(canvas.getShell(), shellStyle, takeFocusOnOpen, persistSize, persistLocation, showDialogMenu, showPersistActions, titleText, infoText);
        this.canvas = canvas;
        this.signalsView = signalsView;
        this.setSelectedGroupToSignalsTableSelection();
        this.enterKeyListener = new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                if (event.keyCode == 13 || event.keyCode == 0x1000050) {
                    WaveViewerAddNewGroupDialog.this.okButtonAction();
                }
            }
        };
    }

    protected Control createDialogArea(Composite parent) {
        this.contentsComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).hint(350, 375).applyTo((Control)this.contentsComposite);
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(5, 20).applyTo(this.contentsComposite);
        this.createAddNewGroupArea();
        this.createChoosePositionArea();
        this.createButtonsArea();
        Dialog.applyDialogFont((Control)this.contentsComposite);
        this.getShell().setText(ID);
        Text newGroupText = this.newGroupNameTextArea.getNewGroupText();
        newGroupText.setText("");
        newGroupText.requestLayout();
        newGroupText.addKeyListener(this.enterKeyListener);
        this.newGroupNameTextArea.getNewGroupText().addModifyListener(e -> this.newGroupNameTextArea.validateNewGroupText(this.okButton));
        return this.contentsComposite;
    }

    protected void createAddNewGroupArea() {
        Group addNewGroupComposite = new Group(this.contentsComposite, 16);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)addNewGroupComposite);
        GridLayoutFactory.fillDefaults().margins(10, 10).numColumns(1).applyTo((Composite)addNewGroupComposite);
        addNewGroupComposite.setText(ID);
        this.newGroupNameTextArea = new WaveViewerNewGroupNameTextArea(this.canvas, (Composite)addNewGroupComposite);
    }

    private void createChoosePositionArea() {
        WViewport viewport;
        Group positionGroup = new Group(this.contentsComposite, 16);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)positionGroup);
        GridLayoutFactory.fillDefaults().margins(10, 10).numColumns(1).applyTo((Composite)positionGroup);
        positionGroup.setText(CHOOSE_POSITION_LABEL);
        Button toTopButton = this.addButton(positionGroup, ADD_TO_TOP_LABEL, 0);
        toTopButton.setSelection(true);
        this.newGroupNodeOrderIDInTable = 0;
        if (this.selectedGroupInTable != null) {
            int selectedGroupNodeOrderIDInTable = this.selectedGroupInTable.getId();
            String selectedGroupName = this.selectedGroupInTable.getName();
            this.addButton(positionGroup, BEFORE_LABEL + selectedGroupName, selectedGroupNodeOrderIDInTable);
            this.addButton(positionGroup, AFTER_LABEL + selectedGroupName, selectedGroupNodeOrderIDInTable + 1);
        }
        if ((viewport = this.canvas.getViewport()) == null) {
            return;
        }
        TreeSet<WSignalsTableElement> signalsTableNodes = viewport.getSignalsTableElements();
        if (signalsTableNodes == null) {
            return;
        }
        int signalsTableSize = signalsTableNodes.size();
        this.addButton(positionGroup, ADD_TO_BOTTOM_LABEL, signalsTableSize);
    }

    private Button addButton(Group group, String label, final int newNodeOrderIDInTable) {
        Button button = new Button((Composite)group, 16);
        button.setText(label);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WaveViewerAddNewGroupDialog.this.newGroupNodeOrderIDInTable = newNodeOrderIDInTable;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        button.addKeyListener(this.enterKeyListener);
        return button;
    }

    protected void createButtonsArea() {
        Composite buttonsComposite = new Composite(this.contentsComposite, 0);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000008).grab(false, true).applyTo((Control)buttonsComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(true).applyTo(buttonsComposite);
        Button cancelbutton = new Button(buttonsComposite, 8);
        GridDataFactory.fillDefaults().applyTo((Control)cancelbutton);
        cancelbutton.setText("Cancel");
        cancelbutton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WaveViewerAddNewGroupDialog.this.close();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.okButton = new Button(buttonsComposite, 8);
        GridDataFactory.fillDefaults().applyTo((Control)this.okButton);
        this.okButton.setText("OK");
        this.okButton.setEnabled(false);
        this.okButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WaveViewerAddNewGroupDialog.this.okButtonAction();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void okButtonAction() {
        WViewport viewport = this.canvas.getViewport();
        TreeSet<WSignalsTableElement> signalsTableNodes = viewport.getSignalsTableElements();
        if (signalsTableNodes == null) {
            return;
        }
        WSignalsTableGroup group = this.createNewGroup(signalsTableNodes, this.newGroupNodeOrderIDInTable);
        DVTVCDUtils.refreshWaveViewer(this.signalsView, this.canvas);
        if (group == null) {
            return;
        }
        if (group.getTreePath() == null) {
            TreePath child = TreePath.child(TreePath.TOP_DUMMY_TREE_PATH, group.getName(), this.newGroupNodeOrderIDInTable, DVTVCDUtils.CHILDREN_COMPARATOR);
            group.setTreePath(child);
            child.setElement(group);
        }
        Display.getDefault().asyncExec(() -> {
            TreePath groupTreePath = group.getTreePath();
            MultipleSelectionTreeIterator treeIterator = (MultipleSelectionTreeIterator)this.signalsView.getLazyTree().getTreeIterator();
            treeIterator.setStartTreePath(groupTreePath);
            ArrayList<TreePath> selection = new ArrayList<TreePath>();
            selection.add(groupTreePath);
            treeIterator.setSelections(selection);
            treeIterator.setLastSelection(groupTreePath);
            this.signalsView.getLazyTree().doAction(LazyTreeAction.SET_MULTIPLE_SELECTION, new LazyTreeSetMultipleSelectionActionArguments(selection, null));
            WaveViewerDesignHierarchyView dhView = this.signalsView.getDHView();
            if (dhView == null) {
                return;
            }
            dhView.updateOnCreateNewGroup(groupTreePath);
        });
        this.close();
    }

    private void setSelectedGroupToSignalsTableSelection() {
        LazyTree lazyTree = this.signalsView.getLazyTree();
        if (lazyTree == null) {
            return;
        }
        List<TreePath> selections = lazyTree.getSelections();
        if (selections == null || selections.isEmpty()) {
            return;
        }
        WSignalsTableElement selection = (WSignalsTableElement)selections.get(0).getElement();
        if (selection == null) {
            return;
        }
        this.selectedGroupInTable = selection instanceof WSignalsTableGroup ? selection : DVTVCDUtils.getParentGroup(selection);
    }

    @Override
    protected String getId() {
        return ID;
    }

    @Override
    public String getNewGroupName() {
        return this.newGroupNameTextArea.getNewGroupText().getText();
    }

    @Override
    public String getSelectedGroupName() {
        return null;
    }

    @Override
    public WCanvas getCanvas() {
        return this.canvas;
    }

    @Override
    public WSignalsTableGroup getGroup(String selectedGroupName, TreeSet<WSignalsTableElement> signalsTableNodes) {
        return null;
    }
}

