/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Shell;
import ro.amiq.dvt.diagrams.wave.draw.WCanvas;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.ui.waveviewer.ISignalsTableExpandableElement;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableElement;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableMultiBitSignal;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableSignal;

public class WaveViewerChangeColorAction
extends Action {
    private String label;
    private WCanvas canvas;
    private List<WSignalsTableElement> selectedElements;
    Shell activeShell;

    public WaveViewerChangeColorAction(WCanvas canvas, String label, List<WSignalsTableElement> selectedElements, Shell activeShell) {
        super(label);
        this.canvas = canvas;
        this.label = label;
        this.selectedElements = selectedElements;
        this.activeShell = activeShell;
    }

    public void run() {
        if (!DVTVCDUtils.getInstance().hasLicense(this.canvas)) {
            return;
        }
        ColorDialog colorDialog = new ColorDialog(this.activeShell);
        RGB newColor = colorDialog.open();
        if (newColor == null || this.selectedElements == null) {
            return;
        }
        for (WSignalsTableElement selectedElement : this.selectedElements) {
            if (selectedElement == null) continue;
            if (selectedElement instanceof ISignalsTableExpandableElement) {
                this.changeExpandableElementColor(selectedElement, newColor);
                continue;
            }
            this.changeElementColor(selectedElement, newColor);
        }
        DVTVCDUtils.refreshWaveDiagram(this.canvas);
    }

    public void changeExpandableElementColor(WSignalsTableElement selectedElement, RGB newGroupColor) {
        this.changeElementColor(selectedElement, newGroupColor);
        List<WSignalsTableElement> childElements = ((ISignalsTableExpandableElement)((Object)selectedElement)).getAllChildElementsInDepth();
        if (childElements == null || childElements.isEmpty()) {
            return;
        }
        for (WSignalsTableElement childElement : childElements) {
            if (childElement == null) continue;
            this.changeElementColor(childElement, newGroupColor);
        }
    }

    public void changeElementColor(WSignalsTableElement selectedElement, RGB newColor) {
        if ("Background Color".equals(this.label)) {
            selectedElement.setBackgroundColor(newColor);
            return;
        }
        if (!(selectedElement instanceof WSignalsTableSignal)) {
            return;
        }
        if ("Waves Color".equals(this.label)) {
            ((WSignalsTableSignal)selectedElement).setWaveColor(newColor);
            return;
        }
        if (!(selectedElement instanceof WSignalsTableMultiBitSignal)) {
            return;
        }
        if ("Text Color".equals(this.label)) {
            ((WSignalsTableMultiBitSignal)selectedElement).setTextColor(newColor);
        }
    }
}

