/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave;

import java.util.List;
import org.eclipse.jface.action.Action;
import ro.amiq.dvt.diagrams.wave.WaveViewerSignalTableView;
import ro.amiq.dvt.diagrams.wave.draw.WCanvas;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.ui.waveviewer.ISignalsTableExpandableElement;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableElement;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableMultiBitSignal;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableStructSignal;

public class WaveViewerChangeSignalRadixAction
extends Action {
    private WCanvas canvas;
    private WaveViewerSignalTableView signalsTableView;
    private String base;
    private List<WSignalsTableElement> selectedElements;

    public WaveViewerChangeSignalRadixAction(WaveViewerSignalTableView signalsTableView, WCanvas canvas, String label, String base, List<WSignalsTableElement> selectedElements) {
        super(label);
        this.canvas = canvas;
        this.signalsTableView = signalsTableView;
        this.base = base;
        this.selectedElements = selectedElements;
    }

    public void run() {
        if (!DVTVCDUtils.getInstance().hasLicense(this.canvas)) {
            return;
        }
        if (this.selectedElements == null || this.selectedElements.isEmpty()) {
            return;
        }
        for (WSignalsTableElement selectedElement : this.selectedElements) {
            List<WSignalsTableElement> childElements;
            boolean isRadixChanged = this.changeElementeRadix(selectedElement);
            if (!isRadixChanged || !(selectedElement instanceof ISignalsTableExpandableElement) || (childElements = ((ISignalsTableExpandableElement)((Object)selectedElement)).getAllChildElementsInDepth()) == null || childElements.isEmpty()) continue;
            for (WSignalsTableElement childElement : childElements) {
                if (childElement == null) continue;
                this.changeElementeRadix(childElement);
            }
        }
        this.signalsTableView.updateLabelsAndDiagram(this.canvas);
    }

    private boolean changeElementeRadix(WSignalsTableElement selectedElement) {
        if (!(selectedElement instanceof WSignalsTableMultiBitSignal)) {
            return false;
        }
        WSignalsTableMultiBitSignal multiBitSignal = (WSignalsTableMultiBitSignal)selectedElement;
        if ("real".equals(multiBitSignal.getType())) {
            return false;
        }
        if (!(!"ENUM".equals(this.base) || multiBitSignal instanceof WSignalsTableStructSignal var3_4 && structSignal.isEnum())) {
            return false;
        }
        String signalBase = multiBitSignal.getBase();
        if (this.base.equals(signalBase)) {
            return false;
        }
        multiBitSignal.setBase(this.base);
        return true;
    }
}

