/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ILabelProvider;
import ro.amiq.dvt.diagrams.wave.WaveViewerSignalTableLabelProvider;
import ro.amiq.dvt.diagrams.wave.WaveViewerSignalTableView;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableElement;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.Utils;

public class WaveViewerCopySignalPathAction
extends Action {
    private WaveViewerSignalTableView signalsView;

    public WaveViewerCopySignalPathAction(WaveViewerSignalTableView signalsView) {
        super("Copy Hierarchy Path", 1);
        this.setDescription("Copy Hierarchy Path");
        this.setToolTipText("Copy Hierarchy Path");
        this.signalsView = signalsView;
    }

    public void run() {
        if (!DVTVCDUtils.getInstance().hasLicense(this.signalsView.getCanvas())) {
            return;
        }
        List<WSignalsTableElement> selectedElements = this.signalsView.getSelectedElements();
        if (selectedElements == null || selectedElements.isEmpty()) {
            return;
        }
        ILabelProvider labelProvider = this.signalsView.getLabelProvider();
        if (!(labelProvider instanceof WaveViewerSignalTableLabelProvider)) {
            return;
        }
        ArrayList<String> copiedPaths = new ArrayList<String>();
        for (WSignalsTableElement selectedElement : selectedElements) {
            String hierarchyPath = DVTVCDUtils.getSignalPath(selectedElement, true);
            if (hierarchyPath == null || hierarchyPath.isBlank()) continue;
            copiedPaths.add(hierarchyPath);
        }
        Utils.copyToClipboard(DVTStringUtil.join(copiedPaths, System.lineSeparator()), 3);
    }
}

