/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.diagrams.wave;

import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;
import ro.amiq.dvt.diagrams.wave.EdgesMetrics;
import ro.amiq.dvt.diagrams.wave.WaveViewerCountEdgesPopup;
import ro.amiq.dvt.diagrams.wave.WaveViewerSignalTableView;
import ro.amiq.dvt.diagrams.wave.draw.WCanvas;
import ro.amiq.dvt.diagrams.wave.draw.WCursor;
import ro.amiq.dvt.diagrams.wave.draw.WViewport;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.views.lazy.tree.LazyTree;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.waveviewer.DVTVCDModel;
import ro.amiq.dvt.ui.waveviewer.DVTVCDParser;
import ro.amiq.dvt.ui.waveviewer.DVTVCDSignalWrapper;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtilsCommon;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableElement;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableSignal;
import ro.amiq.dvt.ui.waveviewer.WSignalsTableSingleBitChildSignal;

public class WaveViewerCountEdgesAction
extends Action {
    private WaveViewerSignalTableView signalsView;
    private EdgesMetrics edgesMetrics;

    public WaveViewerCountEdgesAction(WaveViewerSignalTableView signalsView) {
        this.signalsView = signalsView;
        this.setToolTipText("Count Edges");
        this.setImageDescriptor(DVTImages.WAVE_COUNT_EDGES);
    }

    protected void startCountingJob() {
        final Display display = Display.getCurrent();
        WCanvas canvas = this.signalsView.getCanvas();
        final WViewport viewport = canvas.getViewport();
        if (viewport == null) {
            return;
        }
        WCursor primaryCursor = viewport.getPrimaryCursor();
        if (primaryCursor == null) {
            return;
        }
        final long primaryCursorTime = primaryCursor.getTime();
        if (primaryCursorTime == -100L) {
            return;
        }
        WCursor secondaryCursor = viewport.getSecondaryCursor();
        if (secondaryCursor == null) {
            return;
        }
        final long secondaryCursorTime = secondaryCursor.getTime();
        if (secondaryCursorTime == -100L) {
            return;
        }
        final DVTVCDParser vcdParser = canvas.getProvider();
        final LazyTree signalsViewTree = this.signalsView.getLazyTree();
        if (signalsViewTree == null) {
            return;
        }
        Job countEdgesJob = this.signalsView.getCountEdgesJob();
        if (countEdgesJob != null) {
            countEdgesJob.cancel();
        }
        countEdgesJob = new Job("Counting Edges"){

            protected IStatus run(IProgressMonitor monitor) {
                if (vcdParser == null) {
                    return Status.CANCEL_STATUS;
                }
                DVTVCDModel vcdModel = vcdParser.getVcdModel();
                if (vcdModel == null) {
                    return Status.CANCEL_STATUS;
                }
                List<TreePath> selections = signalsViewTree.getSelections();
                if (selections == null || selections.isEmpty()) {
                    return Status.CANCEL_STATUS;
                }
                WSignalsTableElement signalsTableElement = DVTVCDUtils.getSignalsTableElement(selections.get(0));
                if (!(signalsTableElement instanceof WSignalsTableSignal var5_6)) {
                    return Status.CANCEL_STATUS;
                }
                LinkedHashMap<String, DVTVCDSignalWrapper> signalsById = vcdModel.getSignalsByModelId();
                if (signalsById == null || signalsById.isEmpty()) {
                    return Status.CANCEL_STATUS;
                }
                String selectionVcdId = ((WSignalsTableSignal)signalsTableElement).getVcdId();
                DVTVCDSignalWrapper selectionSignalWrapper = signalsById.get(selectionVcdId);
                if (selectionSignalWrapper == null) {
                    return Status.CANCEL_STATUS;
                }
                long cursorsLowTime = primaryCursorTime <= secondaryCursorTime ? primaryCursorTime : secondaryCursorTime;
                long cursorsHighTime = primaryCursorTime <= secondaryCursorTime ? secondaryCursorTime : primaryCursorTime;
                long diagramLowerTimeLimit = vcdParser.getDiagramLowerTimeLimit();
                long diagramUpperTimeLimit = vcdParser.getDiagramUpperTimeLimit();
                diagramLowerTimeLimit = cursorsLowTime < diagramLowerTimeLimit ? cursorsLowTime : diagramLowerTimeLimit;
                diagramUpperTimeLimit = cursorsHighTime > diagramUpperTimeLimit ? cursorsHighTime : diagramUpperTimeLimit;
                vcdParser.setDiagramTimeLimits(diagramLowerTimeLimit, diagramUpperTimeLimit);
                vcdParser.updateModel();
                int signalBitwidth = Integer.parseInt(selectionSignalWrapper.getBitWidth());
                if (signalsTableSignal instanceof WSignalsTableSingleBitChildSignal) {
                    signalBitwidth = 1;
                }
                DVTVCDUtilsCommon.TimeScales timescale = viewport.getTimescale();
                String timeUnit = timescale.getName();
                WaveViewerCountEdgesAction.this.edgesMetrics = new EdgesMetrics(cursorsLowTime, cursorsHighTime, timeUnit, signalBitwidth, selectionSignalWrapper, (WSignalsTableSignal)signalsTableSignal);
                WaveViewerCountEdgesAction.this.edgesMetrics.computeMetrics();
                Display.getDefault().asyncExec(() -> {
                    int n = new WaveViewerCountEdgesPopup(display.getActiveShell(), signalsTableElement.getName(), WaveViewerCountEdgesAction.this.edgesMetrics).open();
                });
                return Status.OK_STATUS;
            }
        };
        countEdgesJob.schedule();
    }

    public void run() {
        if (!DVTVCDUtils.getInstance().hasLicense(this.signalsView.getCanvas())) {
            return;
        }
        this.startCountingJob();
    }

    public EdgesMetrics getEdgesMetrics() {
        return this.edgesMetrics;
    }
}

